/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import com.am.activity.interfaces.StringsListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class L10n {
    public static final String MICROEDITION_PLATFORM = "microedition.platform";
    public static final String MICROEDITION_LOCALE = "microedition.locale";
    public static final String DEFAULT_LOCALE = "_en";
    public static final String EN = "en";
    public static final String ES = "es";
    public static final String DE = "de";
    public static final String FR = "fr";
    public static final String PT = "pt";
    public static final String IT = "it";
    public static final String RU = "ru";
    public static final String ZH = "zh";
    public static final String TXT = ".txt";
    private static String pathToFolder = "/text/";
    private static String prefixForFiles = "strings";
    private static String[] strLocale = new String[]{"_en", "_es", "_de", "_ru", "_fr", "_it", "_pt", "_zh"};
    private static String[] strKey = new String[]{"en", "es", "de", "ru", "fr", "it", "pt", "zh"};
    private static String locale;
    private static Hashtable text;
    private static Hashtable listLocale;
    private static Vector stringsObservers;
    public static final String SEPARATOR = "|";
    private static boolean initialized;

    static {
        text = new Hashtable();
        listLocale = new Hashtable();
        stringsObservers = new Vector();
        initialized = false;
    }

    private static void silentInitTextRes() {
        StringBuffer pathToTextFile = new StringBuffer();
        if (locale == null) {
            locale = L10n.identifyLocale();
            System.out.println("Locale is: " + locale);
        }
        pathToTextFile.append(pathToFolder).append(prefixForFiles).append(locale).append(TXT);
        try {
            L10n.initTextRes(pathToTextFile.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            System.err.println("    !!!!NOT FOUND " + pathToTextFile.toString() + " FILE! SET DEFAULT EN!");
            locale = DEFAULT_LOCALE;
            pathToTextFile.delete(0, pathToTextFile.length());
            pathToTextFile.append(pathToFolder).append(prefixForFiles).append(locale).append(TXT);
            try {
                L10n.initTextRes(pathToTextFile.toString());
            }
            catch (UnsupportedEncodingException e1) {
                System.err.println("Unsupported Encoding by files " + pathToTextFile.toString());
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (NullPointerException e1) {
                System.err.println("    !!!!NOT FOUND " + pathToTextFile.toString() + " FILE!");
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        initialized = true;
        L10n.notifyObservers();
    }

    public static void setStringsListener(StringsListener stringsListener) {
        if (!stringsObservers.isEmpty()) {
            if (stringsObservers.contains(stringsListener)) {
                return;
            }
            stringsObservers.addElement(stringsListener);
        } else {
            stringsObservers.addElement(stringsListener);
        }
        System.out.println("stringsObservers " + stringsObservers.size());
    }

    public static void removeStringsListener(StringsListener stringsListener) {
        stringsObservers.removeElement(stringsListener);
    }

    private static void notifyObservers() {
        if (!stringsObservers.isEmpty()) {
            int i = 0;
            while (i < stringsObservers.size()) {
                StringsListener observer = (StringsListener)stringsObservers.elementAt(i);
                observer.refreshStringsRes();
                ++i;
            }
        }
    }

    private static void initTextRes(String filename) throws UnsupportedEncodingException, IOException {
        if (!text.isEmpty()) {
            text.clear();
        }
        new L10n().readFile(filename);
    }

    private static String identifyLocale() {
        String locale;
        if (listLocale.isEmpty()) {
            int i = 0;
            while (i < strLocale.length) {
                listLocale.put(strKey[i], strLocale[i]);
                ++i;
            }
        }
        if ((locale = System.getProperty(MICROEDITION_LOCALE)).length() > 2) {
            locale = locale.substring(0, 2);
        }
        System.out.println("in locale " + locale);
        String result = null;
        Object value = listLocale.get(locale);
        System.out.println("value " + value);
        result = value != null ? (String)value : DEFAULT_LOCALE;
        return result;
    }

    public static void setLocale(String loc) {
        if (listLocale.isEmpty()) {
            int i = 0;
            while (i < strLocale.length) {
                listLocale.put(strKey[i], strLocale[i]);
                ++i;
            }
        }
        System.out.println("Set locale is:" + loc);
        Object value = listLocale.get(loc);
        String string = locale = value != null ? (String)value : DEFAULT_LOCALE;
        if (value == null) {
            System.err.println("    !!!LOCALE IS SET WRONG!!! SET DEFAULT EN!");
        }
        if (!text.isEmpty()) {
            text.clear();
        }
        initialized = false;
        L10n.silentInitTextRes();
    }

    public static void setFolderAndPrefix(String folder, String pref) {
        if (folder.equals(pathToFolder) || pref.equals(prefixForFiles)) {
            return;
        }
        if (!folder.substring(0, 1).equals("/")) {
            folder = "/" + folder;
        }
        if (!folder.substring(folder.length() - 1, folder.length()).equals("/")) {
            folder = String.valueOf(folder) + "/";
        }
        pathToFolder = folder;
        if (pref != null) {
            prefixForFiles = pref;
        }
        initialized = false;
        L10n.silentInitTextRes();
    }

    public static void setFolderAndPrefix(String folder) {
        if (!folder.substring(0, 1).equals("/")) {
            folder = "/" + folder;
        }
        if (!folder.substring(folder.length() - 1, folder.length()).equals("/")) {
            folder = String.valueOf(folder) + "/";
        }
        pathToFolder = folder;
        initialized = false;
    }

    public static String get(String key) {
        if (!initialized) {
            L10n.silentInitTextRes();
        }
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        return result;
    }

    public static String get(String key, StringsListener stringsListener) {
        if (!initialized) {
            L10n.silentInitTextRes();
        }
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        L10n.setStringsListener(stringsListener);
        return result;
    }

    public static int getID() {
        if (!initialized) {
            L10n.silentInitTextRes();
        }
        int id = L10n.isAsha10() ? Integer.parseInt(L10n.get("ASHA1.0 ID")) : (L10n.isAsha11() ? Integer.parseInt(L10n.get("ASHA1.1 ID")) : Integer.parseInt(L10n.get("S40 ID")));
        return id;
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result = this.split(line, SEPARATOR);
            text.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    private static String getPlatform() {
        return System.getProperty(MICROEDITION_PLATFORM);
    }

    private static boolean isAsha10() {
        return L10n.getPlatform().indexOf("Nokia501") >= 0;
    }

    private static boolean isAshaSDK() {
        return L10n.getPlatform().indexOf("Nokia5") >= 0;
    }

    private static boolean isAsha11() {
        return L10n.isAshaSDK() & !L10n.isAsha10();
    }
}

