/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.epicheroes.game;

import com.amediax.epicheroes.content.Res;
import com.amediax.epicheroes.engine.Engine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Enemy {
    public static int BOSS = 101;
    public static int SOLDIER = 102;
    private final int CLASS_ENEMY;
    private boolean dead = false;
    private int dead_frame = 3;
    private int stay_frame = 2;
    private int deadLine = 60;
    private int startLifePoint;
    private int currLifePoint;
    private Sprite spr_enemy;
    private final int width;
    private final int height;
    private int beginPosXLifeLine;
    private int beginPosYLifeLine;
    private int widthLifeLine;
    private int heightPosLifeLine = 5;
    private final int widthStep;

    public Enemy(int classEnemy) {
        this.width = 80;
        this.height = 70;
        this.CLASS_ENEMY = classEnemy;
        if (classEnemy == SOLDIER) {
            this.spr_enemy = new Sprite(Res.IMG_ENEMY, 80, 70);
            this.startLifePoint = 3;
        } else if (classEnemy == BOSS) {
            this.spr_enemy = new Sprite(Res.IMG_ENEMY_BOSS, 80, 70);
            this.startLifePoint = 5;
        }
        this.currLifePoint = this.startLifePoint;
        this.beginPosXLifeLine = 400;
        this.beginPosYLifeLine = 150;
        this.widthStep = Engine.displayWidth == 400 ? 8 : 5;
    }

    public boolean isDeadLine() {
        return this.spr_enemy.getX() <= this.deadLine;
    }

    public boolean isBoss() {
        return this.CLASS_ENEMY == BOSS;
    }

    public void hit() {
        if (--this.currLifePoint == 0) {
            this.spr_enemy.setFrame(this.dead_frame);
            this.dead = true;
        }
    }

    public boolean isDead() {
        return this.dead;
    }

    public void move() {
        if (!this.dead) {
            if (this.spr_enemy.getX() > this.deadLine) {
                if (this.spr_enemy.getFrame() == 0) {
                    this.spr_enemy.setFrame(1);
                } else {
                    this.spr_enemy.setFrame(0);
                }
                this.spr_enemy.setPosition(this.spr_enemy.getX() - this.widthStep, this.spr_enemy.getY());
            } else {
                this.spr_enemy.setFrame(this.stay_frame);
            }
        }
    }

    public void paint(Graphics g) {
        this.spr_enemy.paint(g);
        this.widthLifeLine = 80 * (this.currLifePoint * 100) / this.startLifePoint / 100 - 5;
        this.beginPosXLifeLine = this.spr_enemy.getX();
        g.setColor(65280);
        if (!this.dead) {
            g.fillRect(this.beginPosXLifeLine, this.beginPosYLifeLine, this.widthLifeLine, this.heightPosLifeLine);
        }
    }

    public void setPosition(int x, int y) {
        this.spr_enemy.setPosition(x, y);
        this.beginPosXLifeLine = x + 5;
        this.beginPosYLifeLine = y - 10;
    }

    public Sprite getSpr_enemy() {
        return this.spr_enemy;
    }
}

