/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.components;

import com.am.activity.interfaces.ButtonInterface;
import com.am.activity.main.Activity;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class NewButton
extends Sprite
implements ButtonInterface {
    public static final int BUTTON_PRESSABLE = 1;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    protected Activity activity;
    private String labeltext;
    private int labelColor = 0xFFFFFF;
    private Font labelFont = Font.getFont((int)64, (int)2, (int)16);
    public int buttonID;
    private int xPos;
    private int yPos;
    private int modeButton = 0;
    private int userIndex;
    boolean enabled = true;
    boolean pressed = false;

    public static NewButton createButtonWithImage(Activity view, Image image) {
        return new NewButton(view, image);
    }

    public static NewButton createButtonWithImageAndText(Activity view, Image image, String text) {
        return new NewButton(view, image, text);
    }

    public static NewButton createPressableButton(Activity view, Image image, int widthFrame, int heightFrame) {
        return new NewButton(view, image, widthFrame, heightFrame, 1);
    }

    public static NewButton createButtonWithText(Activity view, String text) {
        Font defFont = Font.getFont((int)64, (int)2, (int)16);
        int ww = defFont.stringWidth(text) + 5;
        int hh = defFont.getHeight() + 6;
        int[] srcMap = new int[ww * hh];
        int i = 0;
        while (i < srcMap.length) {
            srcMap[i] = 0;
            ++i;
        }
        Image destImgNull = Image.createRGBImage((int[])srcMap, (int)ww, (int)hh, (boolean)true);
        return new NewButton(view, destImgNull, text);
    }

    public static NewButton createButtonWithTextOnFon(Activity view, int width, int height, String text, int colorFon, int colorText) {
        Font defFont = Font.getFont((int)64, (int)2, (int)16);
        int ww = width;
        int hh = height;
        Image fon = Image.createImage((int)ww, (int)hh);
        Graphics gFon = fon.getGraphics();
        gFon.setColor(colorFon);
        gFon.fillRect(0, 0, ww, hh);
        gFon.setColor(0);
        gFon.setFont(defFont);
        gFon.drawString(text, 0, 0, 17);
        return new NewButton(view, fon);
    }

    protected NewButton(Activity activity, Image image, String text) {
        super(image);
        this.labeltext = text;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
    }

    protected NewButton(Activity activity, Image image) {
        super(image);
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
    }

    protected NewButton(Activity activity, Image image, String text, int color) {
        super(image);
        this.labelColor = color;
        this.labeltext = text;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
    }

    public NewButton(Activity activity, Image image, int wF, int hF) {
        super(image, wF, hF);
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
    }

    public void setUserIndex(int index) {
        this.userIndex = index;
    }

    public int getUserIndex() {
        return this.userIndex;
    }

    protected NewButton(Activity activity, Image image, int wF, int hF, int modeButton) {
        super(image, wF, hF);
        this.modeButton = modeButton;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
    }

    public boolean pointerPressed(int x, int y) {
        if (this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = true;
            if (this.modeButton == 1) {
                this.setFrame(1);
            }
            this.activity.buttonIsPressed(this.activity.getID(this));
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.pressed && this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = false;
            if (this.modeButton == 1) {
                this.setFrame(0);
            }
            this.activity.buttonIsReleased(this.activity.getID(this));
            return true;
        }
        this.pressed = false;
        if (this.modeButton == 1) {
            this.setFrame(0);
        }
        return false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public final int getID() {
        return this.buttonID;
    }

    private boolean contains(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    public void setText(String text, Font font, int color) {
        this.labeltext = text;
        this.labelColor = color;
        this.labelFont = font;
        this.xPos = this.getX() + this.getWidth() / 2;
        this.yPos = this.getY() + this.getHeight() / 2 - this.labelFont.getHeight() / 2;
    }

    public void setText(String text) {
        this.labeltext = text;
    }

    public void setColorText(int color) {
        this.labelColor = color;
    }

    public void setFontText(Font font) {
        this.labelFont = font;
    }

    public void printText(Graphics g) {
        if (this.isVisible() & this.labeltext != null) {
            g.setColor(this.labelColor);
            g.setFont(this.labelFont);
            this.xPos = this.getX() + this.getWidth() / 2;
            this.yPos = this.getY() + this.getHeight() / 2 - this.labelFont.getHeight() / 2;
            g.drawString(this.labeltext, this.xPos, this.yPos, 17);
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.pressed && this.isVisible()) {
            this.activity.buttonIsDragged(this.activity.getID(this), x, y);
            return true;
        }
        return false;
    }
}

