/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.main;

import com.am.activity.main.Activity;
import javax.microedition.lcdui.game.Layer;

public abstract class ALM
extends Activity {
    public static final int ANCHOR_TOP_LEFT = 1;
    public static final int ANCHOR_TOP_RIGHT = 2;
    public static final int ANCHOR_BOTTOM_RIGHT = 4;
    public static final int ANCHOR_BOTTOM_LEFT = 8;
    public static final int ANCHOR_CENTER_OF_AREA = 16;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1024;
    private static int displayHeight;
    private static int displayWidth;
    private int bottomleft_indent_v = 0;
    private int bottomright_indent_v = 0;
    private int topleft_indent_v = 0;
    private int topright_indent_v = 0;
    private int bottomleft_indent_h = 0;
    private int bottomright_indent_h = 0;
    private int topleft_indent_h = 0;
    private int topright_indent_h = 0;
    private int spacingBetweenButtons = 2;
    private Layer[][] grid;
    private int gridCellHeight;
    private int gridCellWidth;
    private int gridColumns;
    private int gridRows;
    private int leftGridIndent = 0;
    private int rightGridIndent = 0;
    private int topGridIndent = 0;
    private int bottomGridIndent = 0;

    public ALM(int w, int h) {
        super(w, h);
        displayHeight = h;
        displayWidth = w;
    }

    public static final void setDisplaySize(int width, int height) {
        ALM.setDisplayWidth(width);
        ALM.setDisplayHeight(height);
    }

    private static void setDisplayHeight(int displayHeight) {
        ALM.displayHeight = displayHeight;
    }

    private static void setDisplayWidth(int displayWidth) {
        ALM.displayWidth = displayWidth;
    }

    protected static int getDisplayHeight() {
        return displayHeight;
    }

    protected static int getDisplayWidth() {
        return displayWidth;
    }

    public void addToGrid(Layer layer, int index, int anchor) {
        int row = 0;
        block0: while (row < this.gridRows) {
            int column = 0;
            while (column < this.gridColumns) {
                if (this.grid[row][column] == null) {
                    this.grid[row][column] = layer;
                    super.insert(layer, index);
                    ALM.positionLayer(layer, anchor, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
                    break block0;
                }
                ++column;
            }
            ++row;
        }
    }

    public void addToGrid(Layer layer, int index) {
        int row = 0;
        block0: while (row < this.gridRows) {
            int column = 0;
            while (column < this.gridColumns) {
                if (this.grid[row][column] == null) {
                    this.grid[row][column] = layer;
                    super.insert(layer, index);
                    ALM.positionLayer(layer, 16, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
                    break block0;
                }
                ++column;
            }
            ++row;
        }
    }

    public final void append(Layer layer, int anchor) {
        this.positionLayerInThisAlm(layer, anchor);
        super.append(layer);
    }

    public final void initGrid(int columns, int rows) {
        this.grid = new Layer[rows][columns];
        this.gridColumns = columns;
        this.gridRows = rows;
        this.topGridIndent = 0;
        this.bottomGridIndent = 0;
        this.leftGridIndent = 0;
        this.rightGridIndent = 0;
        this.calculateGridParameters();
    }

    public final void initGrid(int columns, int rows, int topIndent, int bottomIndent, int leftIndent, int rightIndent) {
        this.grid = new Layer[rows][columns];
        this.gridColumns = columns;
        this.gridRows = rows;
        this.topGridIndent = topIndent;
        this.bottomGridIndent = bottomIndent;
        this.leftGridIndent = leftIndent;
        this.rightGridIndent = rightIndent;
        this.calculateGridParameters();
    }

    public final void insert(Layer layer, int index, int anchor) {
        this.positionLayerInThisAlm(layer, anchor);
        super.insert(layer, index);
    }

    public final void insertToGrid(Layer layer, int column, int row, int index, int anchor) {
        this.grid[row][column] = layer;
        super.insert(layer, index);
        ALM.positionLayer(layer, anchor, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
    }

    public final void insertToGrid(Layer layer, int column, int row, int index) {
        this.grid[row][column] = layer;
        super.insert(layer, index);
        ALM.positionLayer(layer, 16, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
    }

    private final void calculateGridParameters() {
        this.gridCellWidth = (ALM.getDisplayWidth() - this.leftGridIndent - this.rightGridIndent) / this.gridColumns;
        this.gridCellHeight = (ALM.getDisplayHeight() - this.topGridIndent - this.bottomGridIndent) / this.gridRows;
    }

    private final void positionLayerInThisAlm(Layer layer, int anchor) {
        if (anchor < 0) {
            throw new IllegalArgumentException("wrong anchor: must be between 0 and 4");
        }
        switch (anchor) {
            case 1: {
                layer.setPosition(this.topleft_indent_h + this.spacingBetweenButtons, this.spacingBetweenButtons);
                this.topleft_indent_h += layer.getWidth() + this.spacingBetweenButtons;
                break;
            }
            case 2: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.topright_indent_h - this.spacingBetweenButtons, this.spacingBetweenButtons);
                this.topright_indent_h += layer.getWidth() + this.spacingBetweenButtons;
                break;
            }
            case 4: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.bottomright_indent_h - this.spacingBetweenButtons, ALM.getDisplayHeight() - layer.getHeight() - this.spacingBetweenButtons);
                this.bottomright_indent_h += layer.getWidth() + this.spacingBetweenButtons;
                break;
            }
            case 8: {
                layer.setPosition(this.bottomleft_indent_h + this.spacingBetweenButtons, ALM.getDisplayHeight() - layer.getHeight() - this.spacingBetweenButtons);
                this.bottomleft_indent_h += layer.getWidth() + this.spacingBetweenButtons;
                break;
            }
            case 1025: {
                layer.setPosition(this.spacingBetweenButtons, this.topleft_indent_v + this.spacingBetweenButtons);
                this.topleft_indent_v += layer.getHeight() + this.spacingBetweenButtons;
                break;
            }
            case 1026: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.spacingBetweenButtons, this.spacingBetweenButtons + this.topright_indent_v);
                this.topright_indent_v += layer.getHeight() + this.spacingBetweenButtons;
                break;
            }
            case 1028: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.spacingBetweenButtons, ALM.getDisplayHeight() - layer.getHeight() - this.spacingBetweenButtons - this.bottomright_indent_v);
                this.bottomright_indent_v += layer.getHeight() + this.spacingBetweenButtons;
                break;
            }
            case 1032: {
                layer.setPosition(this.spacingBetweenButtons, ALM.getDisplayHeight() - layer.getHeight() - this.spacingBetweenButtons - this.bottomleft_indent_v);
                this.bottomleft_indent_v += layer.getHeight() + this.spacingBetweenButtons;
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong anchor: " + anchor);
            }
        }
    }

    public static final void positionLayer(Layer layer, int anchor, int x, int y, int width, int height) {
        switch (anchor) {
            case 1: {
                layer.setPosition(x, y);
                break;
            }
            case 2: {
                layer.setPosition(x + width - layer.getWidth(), y);
                break;
            }
            case 4: {
                layer.setPosition(x + width - layer.getWidth(), y + height - layer.getHeight());
                break;
            }
            case 8: {
                layer.setPosition(x, y + height - layer.getHeight());
                break;
            }
            case 16: {
                layer.setPosition(x + (width - layer.getWidth()) / 2, y + (height - layer.getHeight()) / 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong anchor: " + anchor);
            }
        }
    }

    public static final void positionLayer(Layer layer, int anchor) {
        ALM.positionLayer(layer, anchor, 0, 0, ALM.getDisplayWidth(), ALM.getDisplayHeight());
    }

    protected final int getGridCellHeight() {
        return this.gridCellHeight;
    }

    protected final int getGridCellWidth() {
        return this.gridCellWidth;
    }
}

