/*
 * Decompiled with CFR 0.152.
 */
package com.am.blockapplib.main;

import com.am.asha_inapp.Payment;
import com.am.blockapplib.main.BlockerListener;
import com.am.blockapplib.utils.BalSettings;
import com.am.blockapplib.utils.BalTime;
import com.am.blockapplib.utils.BalUiSettings;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class BlockerView
implements ItemCommandListener {
    private Payment paymentMgr;
    private Timer timer;
    private Timer timerShowCancel;
    private MIDlet appMidlet;
    private Form blockForm;
    private Displayable oldDisplay;
    private Command buyCommand;
    private Command cancelCommand;
    private StringItem buyBtn;
    private StringItem cancelBtn;
    private StringItem countDownString;
    private long blockTime;
    private TimerTask blockTask;
    private TimerTask showCancelTask;
    private int showCancelPeriod;
    private boolean initialized;
    private BlockerListener listener;
    private long oldBlockTime;
    private boolean enabled = true;
    private int curCancelTime;
    private static final String PRODUCT_NAME = "BLOCKER";

    public BlockerView(MIDlet midlet, Payment payMgr) {
        this.appMidlet = midlet;
        this.paymentMgr = payMgr;
    }

    public void init() {
        this.enabled = BalSettings.getString("BLOCKER_ENABLED").toUpperCase().equals("TRUE");
        if (!this.enabled) {
            return;
        }
        if (!this.paymentMgr.isPaid(PRODUCT_NAME)) {
            this.initialized = false;
            BalTime enabledTime = BalSettings.getTime("BLOCK_TIME");
            if (enabledTime.toSeconds() == 0) {
                enabledTime = new BalTime("0:0:40");
            }
            this.setBlockTime(enabledTime.toSeconds());
            this.recreateBlockTimer();
            BalTime showCancelTime = BalSettings.getTime("CLOSE_BTN_ENABLE_PERIOD");
            int secs = showCancelTime.getSeconds() == 0 ? 5 : showCancelTime.getSeconds();
            this.setShowCancelPeriod(secs * 1000);
        } else if (this.listener != null) {
            this.listener.onAppUnlock();
        }
    }

    public boolean isPurchased() {
        if (!this.enabled) {
            return true;
        }
        return this.paymentMgr.isPaid(PRODUCT_NAME);
    }

    public void initForm() {
        this.blockForm = new Form(BalUiSettings.getString("BLOCKER_TITLE"));
        String message = BalUiSettings.getString("BLOCKER_MESSAGE");
        this.blockForm.append(String.valueOf(message) + "\n");
        this.buyBtn = new StringItem("", BalUiSettings.getString("BLOCKER_BUY_BTN_TEXT"), 2);
        this.buyBtn.setFont(BalUiSettings.getFont("BLOCKER_BUY_BTN_FONT"));
        this.buyCommand = new Command("Buy command", 8, 1);
        this.buyBtn.setDefaultCommand(this.buyCommand);
        this.buyBtn.setItemCommandListener((ItemCommandListener)this);
        this.blockForm.append((Item)this.buyBtn);
        this.cancelBtn = new StringItem("", BalUiSettings.getString("BLOCKER_CANCEL_BTN_TEXT"), 2);
        this.cancelBtn.setFont(BalUiSettings.getFont("BLOCKER_CANCEL_BTN_FONT"));
        this.cancelCommand = new Command("Cancel Command", 8, 1);
        this.cancelBtn.setDefaultCommand(this.cancelCommand);
        this.cancelBtn.setItemCommandListener((ItemCommandListener)this);
        this.initialized = true;
        this.curCancelTime = this.getShowCancelPeriod() / 1000;
        this.countDownString = new StringItem("", new BalTime(this.curCancelTime).toString());
        this.countDownString.setFont(BalUiSettings.getFont("BLOCKER_CANCEL_BTN_FONT"));
        this.countDownString.setLayout(3);
        this.blockForm.append((Item)this.countDownString);
    }

    public void recreateBlockTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Display.getDisplay((MIDlet)BlockerView.this.appMidlet).getCurrent() != BlockerView.this.blockForm && !BlockerView.this.paymentMgr.isPaid(BlockerView.PRODUCT_NAME)) {
                    BlockerView.this.oldDisplay = Display.getDisplay((MIDlet)BlockerView.this.appMidlet).getCurrent();
                    if (!BlockerView.this.initialized) {
                        BlockerView.this.initForm();
                    }
                    if (BlockerView.this.listener != null) {
                        BlockerView.this.listener.onBlockerShow();
                    }
                    Display.getDisplay((MIDlet)BlockerView.this.appMidlet).setCurrent((Displayable)BlockerView.this.blockForm);
                    if (BlockerView.this.blockForm.size() == 2) {
                        BlockerView.this.blockForm.append((Item)BlockerView.this.countDownString);
                    }
                    if (BlockerView.this.blockForm.size() == 4) {
                        BlockerView.this.blockForm.delete(3);
                    }
                    BlockerView.this.recreateCancelTimer();
                    BlockerView.this.timer.cancel();
                } else if (BlockerView.this.paymentMgr.isPaid(BlockerView.PRODUCT_NAME)) {
                    BlockerView.this.timer.cancel();
                    if (BlockerView.this.listener != null) {
                        BlockerView.this.listener.onAppUnlock();
                    }
                }
            }
        }, this.getBlockTime(), this.getBlockTime());
    }

    public void recreateCancelTimer() {
        this.timerShowCancel = new Timer();
        this.timerShowCancel.schedule(new TimerTask(){

            public void run() {
                if (Display.getDisplay((MIDlet)BlockerView.this.appMidlet).getCurrent() == BlockerView.this.blockForm && !BlockerView.this.paymentMgr.isPaid(BlockerView.PRODUCT_NAME)) {
                    BlockerView blockerView = BlockerView.this;
                    blockerView.curCancelTime = blockerView.curCancelTime - 1;
                    if (BlockerView.this.curCancelTime == 0) {
                        BlockerView.this.blockForm.append((Item)BlockerView.this.cancelBtn);
                        BlockerView.this.curCancelTime = BlockerView.this.getShowCancelPeriod() / 1000;
                        BlockerView.this.countDownString.setText(new BalTime(BlockerView.this.curCancelTime).toString());
                        BlockerView.this.blockForm.delete(2);
                        BlockerView.this.timerShowCancel.cancel();
                        return;
                    }
                    BlockerView.this.countDownString.setText(new BalTime(BlockerView.this.curCancelTime).toString());
                }
            }
        }, 1500L, 1600L);
    }

    public void setBlockerListener(BlockerListener l) {
        this.listener = l;
    }

    public void commandAction(Command cmd, Item item) {
        if (cmd == this.buyCommand) {
            if (this.listener != null) {
                this.listener.onBlockerHide();
            }
            Display.getDisplay((MIDlet)this.appMidlet).setCurrent(this.oldDisplay);
            this.paymentMgr.purchaseProduct(PRODUCT_NAME);
            if (this.blockForm.size() < 3) {
                this.blockForm.append((Item)this.cancelBtn);
            }
        } else if (cmd == this.cancelCommand) {
            this.blockForm.delete(2);
            this.curCancelTime = this.getShowCancelPeriod() / 1000;
            if (this.listener != null) {
                this.listener.onBlockerHide();
            }
            Display.getDisplay((MIDlet)this.appMidlet).setCurrent(this.oldDisplay);
            this.recreateBlockTimer();
        }
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime * 1000L;
        if (this.timer != null && this.blockTask != null) {
            this.recreateBlockTimer();
        }
    }

    public int getShowCancelPeriod() {
        return this.showCancelPeriod;
    }

    public void setShowCancelPeriod(int showCancelPeriod) {
        this.showCancelPeriod = showCancelPeriod;
        this.recreateCancelTimer();
    }
}

