/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.epicheroes.engine;

import com.am.activity.interfaces.ActivityInterface;
import com.am.activity.interfaces.ActivityListener;
import com.am.activity.tools.AudioManager;
import com.am.ashamidlet.AshaMidlet;
import com.am.ashamidlet.Settings;
import com.am.blockapplib.main.BlockerListener;
import com.am.resad.Ad;
import com.am.resad.BannerSprite;
import com.amediax.epicheroes.content.Res;
import com.amediax.epicheroes.main.Main;
import com.amediax.epicheroes.views.AboutView;
import com.amediax.epicheroes.views.EndGameView;
import com.amediax.epicheroes.views.GameView;
import com.amediax.epicheroes.views.HelpView;
import com.amediax.epicheroes.views.MenuView;
import com.amediax.epicheroes.views.PauseView;
import com.ittop.utils.RMSWorker;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class Engine
extends GameCanvas
implements CommandListener,
ActivityListener,
BlockerListener {
    private Ad ad;
    private BannerSprite bannerSprite;
    private final boolean SHOW_BANNER = Settings.get("BLOCKER_ENABLED").equals("TRUE");
    public static final int EVENT_SHOW_MENU = 101;
    public static final int EVENT_SHOW_ABOUT = 102;
    public static final int EVENT_SHOW_HELP = 103;
    public static final int EVENT_SHOW_PAUSE = 104;
    public static final int EVENT_START_NEW_GAME = 105;
    public static final int EVENT_RESUME_GAME = 106;
    public static final int EVENT_SHOW_END_GAME = 107;
    public static final int EVENT_EXIT = 333;
    public static long INTERVAL = 100L;
    private static Main mainMIDlet;
    public static int displayWidth;
    public static int displayHeight;
    private Graphics g;
    private ActivityInterface currentView;
    private ActivityInterface menuView;
    private ActivityInterface aboutView;
    private ActivityInterface helpView;
    private ActivityInterface gameView;
    private ActivityInterface pauseView;
    private ActivityInterface endGameView;
    private Command backCommand;
    private GameThread gameThread;
    private static Engine instance;
    public static boolean enableMusic;
    public static AudioManager audioManager;
    private static final String STORAGE_NAME = "ArcheryTournament";
    public static RMSWorker rmsw;
    public static int bestResult;

    public Engine(Main mainMIDlet) {
        super(true);
        Engine.mainMIDlet = mainMIDlet;
        this.setFullScreenMode(true);
        this.calculateDisplayVariables();
        Res.init(displayWidth, displayHeight);
        AshaMidlet.getInstance().blocker.setBlockerListener(this);
    }

    public void startApp() {
        Display.getDisplay((MIDlet)mainMIDlet).setCurrent((Displayable)this);
        this.gameThread.requestStart();
        this.handleEvent(101);
    }

    public void pauseApp() {
        this.gameThread.requestPause();
    }

    public void resumeApp() {
        this.gameThread.requestStart();
    }

    public void exitApp() {
        this.gameThread.requestStop();
        mainMIDlet.exitApp();
    }

    public void handleEvent(int event) {
        switch (event) {
            case 333: {
                this.exitApp();
                break;
            }
            case 102: {
                this.changeView(this.aboutView);
                break;
            }
            case 103: {
                this.changeView(this.helpView);
                break;
            }
            case 101: {
                this.changeView(this.menuView);
                break;
            }
            case 105: {
                ((GameView)this.gameView).startNewGame();
                this.changeView(this.gameView);
                break;
            }
            case 106: {
                this.changeView(this.gameView);
                break;
            }
            case 104: {
                this.changeView(this.pauseView);
                break;
            }
            case 107: {
                this.changeView(this.endGameView);
            }
        }
    }

    public void init() {
        instance = this;
        this.gameThread = new GameThread();
        enableMusic = false;
        audioManager = AudioManager.getInstance();
        bestResult = rmsw.read();
        if (this.isShowBanner()) {
            this.ad = Ad.createInstance(mainMIDlet, displayWidth, displayHeight, this.SHOW_BANNER);
            this.bannerSprite = this.ad.createBannerSprite(0, "center", "top");
        }
        if (this.backCommand == null) {
            this.backCommand = new Command("Back", 2, 1);
            this.addCommand(this.backCommand);
            this.setCommandListener(this);
        }
        if (this.gameView == null) {
            this.gameView = new GameView(displayWidth, displayHeight);
            this.gameView.initResources();
        }
        if (this.helpView == null) {
            this.helpView = new HelpView(displayWidth, displayHeight);
            this.helpView.initResources();
        }
        if (this.aboutView == null) {
            this.aboutView = new AboutView(displayWidth, displayHeight);
            this.aboutView.initResources();
        }
        if (this.menuView == null) {
            this.menuView = new MenuView(displayWidth, displayHeight);
            this.menuView.initResources();
        }
        if (this.pauseView == null) {
            this.pauseView = new PauseView(displayWidth, displayHeight);
            this.pauseView.initResources();
        }
        if (this.endGameView == null) {
            this.endGameView = new EndGameView(displayWidth, displayHeight);
            this.endGameView.initResources();
        }
    }

    public void paint(Graphics g) {
        if (this.currentView != null) {
            this.currentView.paint(g, 0, 0);
        }
        if (this.isShowBanner() && this.bannerSprite != null) {
            this.bannerSprite.paint(g);
        }
    }

    protected void hideNotify() {
        this.pauseApp();
        Engine.turnOffMusic();
    }

    protected void showNotify() {
        this.resumeApp();
    }

    private void changeView(ActivityInterface targetView) {
        this.currentView = targetView;
        if (this.currentView != null) {
            this.currentView.refreshResources();
        }
    }

    public void render() {
        this.g = this.getGraphics();
        this.paint(this.g);
        this.flushGraphics();
    }

    protected void pointerPressed(int x, int y) {
        this.currentView.pointerPressed(x, y);
        if (this.isShowBanner()) {
            this.bannerSprite.touchDown(x, y);
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        this.currentView.pointerReleased(x, y);
        if (this.isShowBanner() && this.bannerSprite.touchUp(x, y)) {
            this.pauseApp();
            this.ad.openLink();
        }
    }

    protected void pointerDragged(int x, int y) {
        this.currentView.pointerDragged(x, y);
    }

    private void calculateDisplayVariables() {
        this.g = this.getGraphics();
        displayHeight = this.getHeight();
        displayWidth = this.getWidth();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            if (this.currentView == this.menuView) {
                this.exitApp();
            } else if (this.currentView == this.pauseView || this.currentView == this.endGameView) {
                this.handleEvent(101);
            } else if (this.currentView == this.gameView) {
                this.handleEvent(104);
            } else {
                this.handleEvent(101);
            }
        }
    }

    public void changeState(int i) {
    }

    public static Engine getInstance() {
        return instance;
    }

    public static void turnOnMusic() {
        if (!enableMusic) {
            enableMusic = true;
            audioManager.loopSample(Res.SND_MUSIC_PATH);
        }
    }

    public static void turnOffMusic() {
        if (enableMusic) {
            enableMusic = false;
            audioManager.stopPlayer(Res.SND_MUSIC_PATH);
        }
    }

    public static void switchMusic() {
        if (enableMusic) {
            Engine.turnOffMusic();
        } else {
            Engine.turnOnMusic();
        }
    }

    public boolean isShowBanner() {
        return this.SHOW_BANNER;
    }

    public void onAppUnlock() {
        System.out.println("onAppUnlock");
        Ad.getInstance().setEnabled(false);
    }

    public void onBlockerShow() {
        System.out.println("onBlockerShow");
        this.handleEvent(104);
    }

    public void onBlockerHide() {
        System.out.println("onBlockerHide");
        this.resumeApp();
    }

    static {
        rmsw = new RMSWorker(STORAGE_NAME);
        bestResult = 0;
    }

    class GameThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("Run start");
            long time = 0L;
            while (!this.stop) {
                try {
                    if (this.pause) {
                        GameThread gameThread = this;
                        synchronized (gameThread) {
                            this.wait();
                            continue;
                        }
                    }
                    time = System.currentTimeMillis();
                    Engine.this.render();
                    time = INTERVAL - (System.currentTimeMillis() - time);
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

