/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.utils;

import com.ittop.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImageHelper {
    public static ImageHelper self;

    private ImageHelper() {
    }

    public static ImageHelper getInstance() {
        if (self == null) {
            self = new ImageHelper();
        }
        return self;
    }

    public Image loadImage(String imgPath) {
        Log.log("ImageHelper.loadImage()");
        Image image = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(imgPath);
            image = Image.createImage((InputStream)in);
        }
        catch (IOException ex) {
            System.out.println("ImageLoader failed to load image: " + imgPath + " " + ex.getMessage());
        }
        return image;
    }

    public Image loadImage(String imagepath, int width, int height) throws RuntimeException {
        Log.log("ImageHelper.loadImage()");
        return ImageHelper.scaleImage(this.loadImage(imagepath), width, height);
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        Log.log("ImageHelper.scaleImage()");
        Image scaledImage = original;
        int originalWidth = original.getWidth();
        if (originalWidth <= newWidth) {
            scaledImage = ImageHelper.pixelMixing(original, newWidth, newHeight);
        } else if (originalWidth > newWidth) {
            scaledImage = ImageHelper.bilinearInterpolation(original, newWidth, newHeight);
        }
        return scaledImage;
    }

    private static Image pixelMixing(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        for (int newX = 0; newX <= newWidth; ++newX) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        for (int newX = 0; newX < newWidth; ++newX) {
            oXStartWidth[newX] = 16 - oX16[newX] % 16;
            oXEndWidth[newX] = oX16[newX + 1] % 16;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        for (int newY = 0; newY <= newHeight; ++newY) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
        }
        for (int newY = 0; newY < newHeight; ++newY) {
            int oY16Start = oY16[newY];
            int oY16End = oY16[newY + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            for (int newX = 0; newX < newWidth; ++newX) {
                int oX16Start = oX16[newX];
                int oX16End = oX16[newX + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = oYStart; j <= oYEnd; ++j) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight == 0) continue;
                    for (int i = oXStart; i <= oXEnd; ++i) {
                        int areaWidth = 16;
                        if (oXStart == oXEnd) {
                            areaWidth = oX16End - oX16Start;
                        } else if (i == oXStart) {
                            areaWidth = oXStartWidth[newX];
                        } else if (i == oXEnd) {
                            areaWidth = oXEndWidth[newX];
                        }
                        if (areaWidth == 0) continue;
                        int area = areaWidth * areaHeight;
                        outArea += area;
                        int argb = rawInput[i + j * original.getWidth()];
                        int a = argb >>> 24;
                        if (a == 0) continue;
                        area = a * area;
                        outColorArea += area;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += area * r;
                        outGreen += area * g;
                        outBlue += area * b;
                    }
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private static Image bilinearInterpolation(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth];
        int max = oWidth - 1 << 4;
        for (int newX = 0; newX < newWidth; ++newX) {
            oX16[newX] = (((newX << 1) + 1) * oWidth << 3) / newWidth - 8;
            if (oX16[newX] < 0) {
                oX16[newX] = 0;
                continue;
            }
            if (oX16[newX] <= max) continue;
            oX16[newX] = max;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight];
        max = oHeight - 1 << 4;
        for (int newY = 0; newY < newHeight; ++newY) {
            oY16[newY] = (((newY << 1) + 1) * oHeight << 3) / newHeight - 8;
            if (oY16[newY] < 0) {
                oY16[newY] = 0;
                continue;
            }
            if (oY16[newY] <= max) continue;
            oY16[newY] = max;
        }
        int[] oX = new int[2];
        int[] oY = new int[2];
        int[] wX = new int[2];
        int[] wY = new int[2];
        for (int newY = 0; newY < newHeight; ++newY) {
            oY[0] = oY16[newY] >>> 4;
            wY[1] = oY16[newY] & 0xF;
            wY[0] = 16 - wY[1];
            oY[1] = wY[1] == 0 ? oY[0] : oY[0] + 1;
            for (int newX = 0; newX < newWidth; ++newX) {
                oX[0] = oX16[newX] >>> 4;
                wX[1] = oX16[newX] & 0xF;
                wX[0] = 16 - wX[1];
                oX[1] = wX[1] == 0 ? oX[0] : oX[0] + 1;
                int outWeight = 0;
                int outColorWeight = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < 2; ++i) {
                        if (wY[j] == 0 || wX[i] == 0) continue;
                        int w = wX[i] * wY[j];
                        outWeight += w;
                        int argb = rawInput[oX[i] + oY[j] * original.getWidth()];
                        int a = argb >>> 24;
                        if (a == 0) continue;
                        w = a * w;
                        outColorWeight += w;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += w * r;
                        outGreen += w * g;
                        outBlue += w * b;
                    }
                }
                if (outColorWeight > 0) {
                    outAlpha = outColorWeight / outWeight;
                    outRed /= outColorWeight;
                    outGreen /= outColorWeight;
                    outBlue /= outColorWeight;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }
}

