/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.utils;

import com.ittop.utils.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSWorker {
    private String storageName;

    public RMSWorker(String storageName) {
        Log.log("RMSWorker()");
        this.storageName = storageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int currentLevel) {
        Log.log("RMSWorker.writeLevel()");
        RecordStore store = null;
        ByteArrayOutputStream b = null;
        FilterOutputStream d = null;
        try {
            store = RecordStore.openRecordStore((String)this.storageName, (boolean)true);
            b = new ByteArrayOutputStream();
            d = new DataOutputStream(b);
            ((DataOutputStream)d).writeInt(currentLevel);
            byte[] storeData = b.toByteArray();
            if (store.getNumRecords() == 0) {
                store.addRecord(storeData, 0, storeData.length);
            } else {
                store.setRecord(1, storeData, 0, storeData.length);
            }
        }
        catch (IOException ex) {
            System.err.println("RMSWorker: Writed error!");
            System.out.println(ex.getMessage());
        }
        catch (RecordStoreException ex) {
            System.err.println("RMSWorker: Record store error!");
            System.out.println(ex.getMessage());
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (b != null) {
                try {
                    b.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Log.log("RMSWorker.readLevel()");
        int currentLevel = 0;
        RecordStore store = null;
        ByteArrayInputStream b = null;
        FilterInputStream d = null;
        try {
            store = RecordStore.openRecordStore((String)this.storageName, (boolean)false);
            byte[] dataStore = store.getRecord(1);
            b = new ByteArrayInputStream(dataStore);
            d = new DataInputStream(b);
            currentLevel = ((DataInputStream)d).readInt();
        }
        catch (RecordStoreNotFoundException ex) {
            System.err.println("RMSWorker: Record store not found!");
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            System.err.println("RMSWorker: Error read!");
            System.out.println(ex.getMessage());
            int n = 0;
            return n;
        }
        catch (RecordStoreException ex) {
            System.err.println("RMSWorker: Record store error!");
            System.out.println(ex.getMessage());
            int n = 0;
            return n;
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (b != null) {
                try {
                    b.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return currentLevel;
    }
}

