/*
 * Decompiled with CFR 0.152.
 */
public class RMS
implements GameConstants {
    public static final boolean CHEAT_MODE = true;
    static String SAVE_GAME_NAME = "PvZ";
    static final int SAVE_DATA_BUFFER_SIZE = 4096;
    static byte[] SOFT_SAVE_DATA_BUFFER = new byte[4096];

    static boolean init() {
        boolean bl = RMS.hardLoad(SAVE_GAME_NAME, SOFT_SAVE_DATA_BUFFER);
        if (bl) {
            RMS.loadGameData(false);
        }
        return bl;
    }

    static void softSave(boolean bl) {
        System.out.println("RMS.softSave.  saveoptionsOnly: " + bl);
        Util.writeRMSBytesFromInt(SOFT_SAVE_DATA_BUFFER, Text.m_nCurrLang);
        Util.writeRMSBytesFromBoolean(SOFT_SAVE_DATA_BUFFER, Audio.IsAudioEnabled());
        Util.writeRMSBytesFromLong(SOFT_SAVE_DATA_BUFFER, AlmanacScreenMenu.seedsUnlocked);
        Util.writeRMSBytesFromLong(SOFT_SAVE_DATA_BUFFER, AlmanacScreenMenu.zombiesUnlocked);
        if (GameController.m_nLevel > 49) {
            GameController.m_nLevel = 0;
        }
        Util.writeRMSBytesFromInt(SOFT_SAVE_DATA_BUFFER, GameController.m_nLevel);
        Util.writeRMSBytesFromInt(SOFT_SAVE_DATA_BUFFER, ScoreController.m_nScore);
        Util.writeRMSBytesFromLong(SOFT_SAVE_DATA_BUFFER, GFHint.m_lHintsDisplayed);
        Util.writeRMSBytesFromBoolean(SOFT_SAVE_DATA_BUFFER, AwardScreen.isTrophyEarned);
        System.out.println("Save size: " + Util.m_nRMSPos);
        Util.m_nRMSPos = 0;
    }

    static void hardSave(String string, byte[] byArray) {
        System.out.println("RMS.hard save");
        SaveLoad.SaveRecordStore(string, byArray, 0, byArray.length);
    }

    static boolean hardLoad(String string, byte[] byArray) {
        byte[] byArray2 = SaveLoad.LoadRecordStore(string);
        if (byArray2 != null) {
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[i] = byArray2[i];
            }
            return true;
        }
        return false;
    }

    static void loadGameData(boolean bl) {
        int n;
        System.out.println("RMS.loadGameData");
        Text.m_nCurrLang = Util.readRMSBytesAsInt(SOFT_SAVE_DATA_BUFFER);
        Audio.EnableAudio(Util.readRMSBytesAsBoolean(SOFT_SAVE_DATA_BUFFER));
        AlmanacScreenMenu.seedsUnlocked = Util.readRMSBytesAsLong(SOFT_SAVE_DATA_BUFFER);
        if (AlmanacScreenMenu.seedsUnlocked <= 0L) {
            AlmanacScreenMenu.seedsUnlocked = 8L;
        }
        int n2 = 0;
        for (n = 0; n < 31; ++n) {
            if ((AlmanacScreenMenu.seedsUnlocked & 1L << n) == 0L) continue;
            SeedPicker.UNLOCKED_SEED_TYPES[n2] = n;
            ++n2;
        }
        SeedPicker.m_nUnlockedSeedsCount = 0;
        for (n = 0; n < 31; ++n) {
            if (SeedPicker.UNLOCKED_SEED_TYPES[n] == -1) continue;
            ++SeedPicker.m_nUnlockedSeedsCount;
        }
        AlmanacScreenMenu.zombiesUnlocked = Util.readRMSBytesAsLong(SOFT_SAVE_DATA_BUFFER);
        if (AlmanacScreenMenu.zombiesUnlocked <= 0L) {
            AlmanacScreenMenu.zombiesUnlocked = 1L;
        }
        GameController.m_nLevel = Util.readRMSBytesAsInt(SOFT_SAVE_DATA_BUFFER);
        ScoreController.m_nScore = Util.readRMSBytesAsInt(SOFT_SAVE_DATA_BUFFER);
        GFHint.m_lHintsDisplayed = Util.readRMSBytesAsLong(SOFT_SAVE_DATA_BUFFER);
        AwardScreen.isTrophyEarned = Util.readRMSBytesAsBoolean(SOFT_SAVE_DATA_BUFFER);
        Util.m_nRMSPos = 0;
    }

    static void resetGame(boolean bl) {
        System.out.println("RMS.resetGame");
        ScoreController.init();
        GameController.m_nLevel = 0;
        ScoreController.m_nScore = 0;
        ScoreController.m_nCurrentScoreTotal = 0;
        Util.resetArray(SeedPicker.UNLOCKED_SEED_TYPES, -1);
        AlmanacScreenMenu.seedsUnlocked = 8L;
        if (bl) {
            AlmanacScreenMenu.zombiesUnlocked = 1L;
            AwardScreen.isTrophyEarned = false;
        }
        SeedPicker.unlockSeed(3);
        SeedPicker.m_nUnlockedSeedsCount = 1;
        RMS.softSave(false);
        RMS.hardSave(SAVE_GAME_NAME, SOFT_SAVE_DATA_BUFFER);
    }
}

