/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import mpp.font.GraphicFont;

public class HFont
extends GraphicFont {
    static RealioCanvas myCanvas;
    private static final byte bLF = 10;
    private static final byte bCR = 13;
    private static final byte bSPACE = 32;
    private static int[][] colors;
    private int lineSpace;
    private static final int HFONT_CANSCROLLUP = 0x200000;
    private static final int HFONT_CANSCROLLDOWN = 0x400000;
    private int extra_vert;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int clipR;
    private int clipB;

    public HFont(String fontName) throws IOException, Exception {
        super(fontName);
        this.lineSpace = super.getHeight();
    }

    public HFont(String fontName, int[][] colors) throws IOException, Exception {
        super(fontName);
        HFont.colors = colors;
        this.lineSpace = super.getHeight();
    }

    public int doLinebreaks(byte[] text, int width) {
        int error = 0;
        try {
            if (text == null) {
                return 0;
            }
            int breaks = 0;
            int ch = 0;
            int prev = 0;
            int space = 0;
            int line = 0;
            int len = text.length;
            if (len > 0) {
                do {
                    if (text[ch] != 13) continue;
                    text[ch] = 32;
                } while (++ch < len);
            }
            ch = 0;
            error = 2;
            while (ch < len) {
                line = 0;
                while (line < width && ch < len && text[ch] != 10) {
                    line += this.charWidth((char)text[ch]);
                    if (text[ch] == 32 || text[ch] == 95) {
                        if (line < width) {
                            space = ch;
                        } else {
                            space = ch;
                            break;
                        }
                    }
                    ++ch;
                }
                error = 3;
                if (line >= width && space < len && space > prev) {
                    text[space] = 13;
                    ch = space;
                }
                prev = ch++;
                ++breaks;
            }
            return breaks;
        }
        catch (Exception e) {
            System.out.println("er=" + error);
            e.printStackTrace();
            return 0;
        }
    }

    int drawStringWrapped(Graphics g, String string, int x, int y, int width, int align) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        byte[] b = this.getFromString(string);
        this.doLinebreaks(b, width);
        return this.drawText(g, b, x, y, width, -1, 0, align);
    }

    public int getHeight() {
        return this.lineSpace + this.extra_vert;
    }

    int drawText(Graphics g, byte[] text, int x, int y, int width, int height, int vscroll, int anchor) {
        boolean isFirsLine;
        int ch;
        int pos = 0;
        int len = text.length;
        int nowx = x;
        int nowy = y;
        int canscroll = 0;
        int vertspace = this.lineSpace + this.extra_vert;
        int maxw = 0;
        if (pos >= len) {
            return 0;
        }
        if (anchor == 0) {
            anchor = 20;
        }
        if ((anchor & 0x60) != 0) {
            nowy -= this.getHeight();
        } else if ((anchor & 2) != 0) {
            nowy -= this.getHeight() >> 1;
        }
        y = nowy;
        nowy -= vscroll;
        this.saveClip(g);
        if (width > 0) {
            nowx = (anchor & 8) != 0 ? x - width : ((anchor & 1) != 0 ? x - (width >> 1) : x);
            if (height > 0) {
                this.mergeClip(g, nowx, y, width, height);
            } else {
                this.mergeClip(g, nowx, y, width, this.clipH);
            }
        } else {
            nowx = (anchor & 8) != 0 ? x - this.clipW : ((anchor & 1) != 0 ? x - (this.clipW >> 1) : x);
            if (height > 0) {
                this.mergeClip(g, nowx, y, this.clipW, height);
            }
        }
        this.saveClip(g);
        if (height > 0) {
            if (nowy >= y + height - (vertspace - this.extra_vert)) {
                return 0x200000;
            }
            while (nowy <= y - vertspace) {
                canscroll |= 0x200000;
                do {
                    ch = text[pos++] & 0xFF;
                } while (pos < len && ch != 13 && ch != 10);
                if (pos >= len) {
                    return 0x200000;
                }
                nowy += vertspace;
            }
            if (nowy < y) {
                canscroll |= 0x200000;
            }
        }
        boolean bl = isFirsLine = (anchor & 9) != 0;
        while (pos < len) {
            ch = text[pos] & 0xFF;
            if (isFirsLine || ch < 32) {
                if (isFirsLine || ch == 10 || ch == 13) {
                    if ((anchor & 4) == 0) {
                        int lpos = pos;
                        nowx = this.charWidth((char)ch);
                        while (++lpos < len && text[lpos] != 10 && text[lpos] != 13) {
                            nowx += this.charWidth((char)text[lpos]);
                        }
                        if ((nowx -= this.getCharSpace()) > maxw) {
                            maxw = nowx;
                        }
                        nowx = (anchor & 8) != 0 ? x - nowx : ((anchor & 1) != 0 ? x - (nowx >> 1) : x);
                    } else {
                        if ((nowx -= x) > maxw) {
                            maxw = nowx;
                        }
                        nowx = x;
                    }
                    if (isFirsLine) {
                        isFirsLine = false;
                        continue;
                    }
                    if (height > 0 && (nowy += this.getHeight()) >= y + height) {
                        return canscroll | 0x400000 | height | width << 10;
                    }
                }
            } else if (ch == 32) {
                nowx += this.charWidth(' ');
            } else {
                this.drawChar(g, (char)ch, nowx, nowy, 0);
                nowx += this.charWidth((char)ch);
            }
            ++pos;
        }
        this.restoreClip(g);
        if ((anchor & 4) != 0 && (nowx -= x) > maxw) {
            maxw = nowx;
        }
        if (height > 0 && nowy + vertspace > y + height) {
            return canscroll | 0x400000 | height | maxw << 10;
        }
        return canscroll | nowy + vertspace - y | maxw << 10;
    }

    private void saveClip(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
        this.clipR = this.clipX + this.clipW;
        this.clipB = this.clipY + this.clipH;
    }

    private void restoreClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean mergeClip(Graphics g, int mX, int mY, int mW, int mH) {
        int x = mX;
        int r = mX + mW;
        if (x < this.clipX) {
            x = this.clipX;
        }
        if (r > this.clipR) {
            r = this.clipR;
        }
        if (r <= x) {
            return false;
        }
        int y = mY;
        int b = mY + mH;
        if (y < this.clipY) {
            y = this.clipY;
        }
        if (b > this.clipB) {
            b = this.clipB;
        }
        if (b <= y) {
            return false;
        }
        g.setClip(x, y, r - x, b - y);
        return true;
    }

    byte[] getFromString(String text) {
        return text.getBytes();
    }

    int getLineSpacing() {
        return this.extra_vert;
    }

    public int stringWidth(String str) {
        return super.stringWidth(str);
    }

    int getSubstringIndexForWidth(String str, int maxDesiredWidth) {
        System.out.println("int getSubstringIndexForWidth(String str, int maxDesiredWidth)");
        return super.stringWidth(str);
    }

    int getMaxWidth(byte[] text) {
        int pos;
        int width = 0;
        int maxWidth = 0;
        int len = text.length;
        if (len <= pos) {
            return 0;
        }
        for (pos = 0; pos < len; ++pos) {
            if (text[pos] == 10 || text[pos] == 13) {
                if (maxWidth < width) {
                    maxWidth = width;
                }
                width = 0;
                continue;
            }
            width += this.charWidth((char)text[pos]);
        }
        if (maxWidth < width) {
            maxWidth = width;
        }
        return maxWidth;
    }

    public void setColor(int color) {
        this.setCurrentColor(color);
    }

    void setCurrentColor(int id) {
        System.out.println("setcolor");
        super.setColor(colors[id][1], colors[id][0]);
    }

    void setLineSpacing(int ls) {
        this.extra_vert = ls;
    }
}

