/*
 * Decompiled with CFR 0.152.
 */
import mpp.deviceproperties.Device;

public class KeyMaster
implements Device {
    static final int KEY_NUM0 = 48;
    static final int KEY_NUM1 = 49;
    static final int KEY_NUM2 = 50;
    static final int KEY_NUM3 = 51;
    static final int KEY_NUM4 = 52;
    static final int KEY_NUM5 = 53;
    static final int KEY_NUM6 = 54;
    static final int KEY_NUM7 = 55;
    static final int KEY_NUM8 = 56;
    static final int KEY_NUM9 = 57;
    static final int KEY_STAR = 42;
    static final byte K_NONE = 0;
    static final byte K_FIRE = 1;
    static final byte K_STAR = 2;
    static final byte K_BACK = 3;
    static final byte K_LSOFT = 4;
    static final byte NUM_K = 5;
    public final int KEY_LSOFT;
    public final int KEY_RSOFT;
    public final int KEY_BACK;
    public final int KEY_FIRE;
    public final int KEY_LEFT;
    public final int KEY_RIGHT;
    private final boolean[] KEY = new boolean[5];
    private final boolean[] CEY = new boolean[5];
    private int lastKeyCodePressed = -1;
    private static final int QUEUE_SIZE = 8;
    private final int[] QUEUE_KEY_CODE = new int[8];
    private final boolean[] QUEUE_KEY_DOWN = new boolean[8];
    private final int[] QUEUE_KEY_TIME = new int[8];
    private int QUEUE_INSERT = 0;

    private void pushQueue(int keyCode, int songTime, boolean pressed) {
        if (this.QUEUE_INSERT >= 8) {
            this.popQueue();
        }
        this.QUEUE_KEY_CODE[this.QUEUE_INSERT] = keyCode;
        this.QUEUE_KEY_DOWN[this.QUEUE_INSERT] = pressed;
        this.QUEUE_KEY_TIME[this.QUEUE_INSERT] = songTime;
        ++this.QUEUE_INSERT;
    }

    public void popQueue() {
        for (int i = 0; i < this.QUEUE_INSERT - 1; ++i) {
            this.QUEUE_KEY_CODE[i] = this.QUEUE_KEY_CODE[i + 1];
            this.QUEUE_KEY_DOWN[i] = this.QUEUE_KEY_DOWN[i + 1];
            this.QUEUE_KEY_TIME[i] = this.QUEUE_KEY_TIME[i + 1];
        }
        if (this.QUEUE_INSERT > 0) {
            --this.QUEUE_INSERT;
        }
    }

    public boolean hasNextKeyInQueue() {
        return this.QUEUE_INSERT > 0;
    }

    public int getNextKeyInQueue() {
        return this.QUEUE_KEY_CODE[0];
    }

    public boolean getNextKeyDownInQueue() {
        return this.QUEUE_KEY_DOWN[0];
    }

    public int getNextKeySongTimeInQueue() {
        return this.QUEUE_KEY_TIME[0];
    }

    public void purgeQueue() {
        boolean verbose = false;
        this.QUEUE_INSERT = 0;
    }

    public KeyMaster(int KEY_LSOFT, int KEY_RSOFT, int KEY_BACK, int KEY_FIRE, int KEY_LEFT, int KEY_RIGHT) {
        this.KEY_LSOFT = KEY_RSOFT;
        this.KEY_RSOFT = KEY_LSOFT;
        this.KEY_BACK = KEY_BACK;
        this.KEY_FIRE = KEY_FIRE;
        this.KEY_LEFT = KEY_LEFT;
        this.KEY_RIGHT = KEY_RIGHT;
    }

    public void keyAction(int gameplayMode, int keyCode, int gameAction, int songTime, boolean pressed) {
        int k = this.mapKey(keyCode, gameAction);
        this.KEY[k] = pressed;
        if (pressed) {
            this.lastKeyCodePressed = keyCode;
        }
        this.pushQueue(keyCode, songTime, pressed);
    }

    public int keyCode2noteKeyType(int gameplayMode, int keyCode) {
        switch (gameplayMode) {
            case 0: {
                switch (keyCode) {
                    case 49: 
                    case 52: 
                    case 55: {
                        return 0;
                    }
                    case 50: 
                    case 53: 
                    case 56: {
                        return 1;
                    }
                    case 51: 
                    case 54: 
                    case 57: {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (keyCode) {
                    case 49: 
                    case 52: {
                        return 0;
                    }
                    case 50: 
                    case 53: {
                        return 1;
                    }
                    case 51: 
                    case 54: {
                        return 2;
                    }
                    case 48: 
                    case 55: 
                    case 56: 
                    case 57: {
                        return 3;
                    }
                }
            }
        }
        return -1;
    }

    public int getLastKeyCodePressed() {
        return this.lastKeyCodePressed;
    }

    public void clearLastKeyCodePressed() {
        this.lastKeyCodePressed = -1;
    }

    private int mapKey(int keyCode, int gameAction) {
        if (keyCode == 42) {
            return 2;
        }
        if (keyCode == this.KEY_BACK) {
            return 3;
        }
        if (keyCode == this.KEY_LSOFT) {
            return 4;
        }
        if (keyCode == this.KEY_FIRE) {
            return 1;
        }
        return 0;
    }

    public boolean backClick() {
        return this.click(3);
    }

    public boolean lsoftClick() {
        return this.click(4);
    }

    public boolean starClick() {
        return this.click(2);
    }

    public boolean fireClick() {
        return this.click(1);
    }

    private boolean click(int index) {
        if (index < 0 || index >= 5) {
            return false;
        }
        if (!this.CEY[index]) {
            if (this.KEY[index]) {
                this.CEY[index] = true;
            }
        } else if (!this.KEY[index]) {
            this.CEY[index] = false;
            return true;
        }
        return false;
    }

    public void initGraphicFont() {
    }
}

