/*
 * Decompiled with CFR 0.152.
 */
public final class BCollisionBox {
    private Sprite[] hit = null;
    private Sprite[] drumHit = null;
    public Sprite[] drumEndCaps = null;
    private Sprite[] flame = null;
    private int flameYOffset = 0;
    private Sprite[] drumFlame = null;
    private int drumFlameYOffset = 0;
    private Sprite[] spark = null;
    private int sparkYOffset = 0;
    private Sprite[] lightning = null;
    private int lightningYOffset = 0;
    private int bottom = 0;

    public Object getHitImage(int i) {
        Object image = null;
        Sprite[] hitSprite = null;
        if (this.hit == null) {
            return null;
        }
        hitSprite = this.hit;
        if (i >= this.hit.length && this.drumHit != null) {
            hitSprite = this.drumHit;
            i -= this.hit.length;
        }
        if (i >= 0 && i < hitSprite.length && (image = hitSprite[i].lcduiImage) == null) {
            image = hitSprite[i].image;
        }
        return image;
    }

    public void addHit(String[] imageFileNames, int[][] string, int bottom, int c, int r) {
        this.bottom = bottom;
        if (null == imageFileNames || null == string) {
            return;
        }
        int num = string.length < imageFileNames.length ? string.length : imageFileNames.length;
        this.hit = new Sprite[num];
        for (int i = 0; i < this.hit.length; ++i) {
            this.hit[i] = new Sprite(BImage.CreateColumnByRow(imageFileNames[i], c, r), string[i][2], bottom);
            this.hit[i].setFrame(1);
        }
    }

    public void addDrumHits(String[] imageFileNames, int[][] string, int bottom, int c, int r) {
        this.bottom = bottom;
        if (null == imageFileNames || null == string) {
            return;
        }
        int num = string.length < imageFileNames.length ? string.length : imageFileNames.length;
        this.drumHit = new Sprite[num];
        for (int i = 0; i < this.drumHit.length; ++i) {
            this.drumHit[i] = new Sprite(BImage.CreateColumnByRow(imageFileNames[i], c, r), string[i][2], bottom);
            this.drumHit[i].setFrame(1);
        }
        BImage drumEnds = BImage.CreateColumnByRow("kick_drum_ends", 2, 1);
        if (drumEnds != null) {
            this.drumEndCaps = new Sprite[2];
            this.drumEndCaps[0] = new Sprite(drumEnds, this.drumHit[0].x - this.drumHit[0].image.getImageWidth() / 2 - drumEnds.getImageWidth() / 4, bottom + drumEnds.getImageHeight() / 4 + 1);
            this.drumEndCaps[0].setFrame(0);
            this.drumEndCaps[1] = new Sprite(drumEnds, this.drumHit[this.drumHit.length - 1].x + this.drumHit[0].image.getImageWidth() / 2 + this.drumHit[0].image.getImageWidth() / 4, bottom + drumEnds.getImageHeight() / 4 + 1);
            this.drumEndCaps[1].setFrame(1);
        }
    }

    public void addFlame(BImage img, int numStrings) {
        if (null == img) {
            return;
        }
        this.flame = new Sprite[numStrings];
        for (int i = 0; i < this.flame.length; ++i) {
            this.flame[i] = new Sprite(img, -100, -100);
        }
        this.flameYOffset = img.getImageHeight() / 2;
    }

    public void addDrumFlame(BImage img, int numStrings) {
        if (null == img) {
            return;
        }
        this.drumFlame = new Sprite[numStrings];
        for (int i = 0; i < this.drumFlame.length; ++i) {
            this.drumFlame[i] = new Sprite(img, 100, 100);
        }
        this.drumFlameYOffset = img.getImageHeight();
    }

    public void addSpark(BImage img, int numStrings) {
        if (null == img) {
            return;
        }
        this.spark = new Sprite[numStrings];
        for (int i = 0; i < this.spark.length; ++i) {
            this.spark[i] = new Sprite(img, -100, -100);
            this.spark[i].enabled = false;
        }
        this.sparkYOffset = img.getImageHeight() / 2;
    }

    public void addLightning(BImage img, int numStrings) {
        if (null == img) {
            return;
        }
        this.lightning = new Sprite[numStrings];
        for (int i = 0; i < this.lightning.length; ++i) {
            this.lightning[i] = new Sprite(img, -100, -100);
        }
        this.lightningYOffset = img.getImageHeight() / 2;
    }

    public void playFlame(NoteEvent note) {
        int y;
        int x;
        Sprite h;
        Sprite f;
        int i;
        if (this.flame == null || note == null || this.hit == null) {
            return;
        }
        int lim = this.flame.length < this.hit.length ? this.flame.length : this.hit.length;
        for (i = 0; i < lim; ++i) {
            if (!note.isNoteKeyTypeActive(i)) continue;
            f = this.flame[i];
            h = this.hit[i];
            x = h.x;
            y = h.y - this.flameYOffset;
            f.playCurrentAnim(x, y);
        }
        if (note.isNoteKeyTypeActive(3)) {
            for (i = 0; i < this.drumFlame.length; ++i) {
                f = this.drumFlame[i];
                h = this.drumHit[i];
                x = h.x;
                y = h.y - this.drumFlameYOffset;
                f.playCurrentAnim(x, y);
            }
        }
    }

    public void playSpark(NoteEvent note) {
        if (this.spark == null || note == null || this.hit == null || this.flame == null) {
            return;
        }
        try {
            for (int i = 0; i < this.flame.length; ++i) {
                if (!note.isNoteKeyTypeActive(i)) continue;
                this.spark[i].setPos(this.hit[i].x, this.hit[i].y - this.sparkYOffset);
                this.spark[i].enabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSpark() {
        if (this.spark == null) {
            return;
        }
        for (int i = 0; i < this.spark.length; ++i) {
            this.spark[i].enabled = false;
        }
    }

    public void playLightning(int pos) {
        if (this.lightning == null || this.hit == null) {
            return;
        }
        if (pos < this.lightning.length && pos < this.hit.length) {
            this.lightning[pos].playCurrentAnim(this.hit[pos].x, this.hit[pos].y - this.lightningYOffset);
        }
    }

    public void playHit(int noteKeyType, boolean pressed) {
        if (0 <= noteKeyType && noteKeyType < 3 && null != this.hit && noteKeyType <= this.hit.length) {
            this.hit[noteKeyType].setFrame(pressed ? 1 : 0);
        }
        if (3 == noteKeyType && this.drumHit != null) {
            for (int i = 0; i < this.drumHit.length; ++i) {
                this.drumHit[i].setFrame(pressed ? 0 : 1);
            }
        }
    }

    public void toggleHits(boolean enabled) {
        int i;
        if (null != this.hit) {
            for (i = 0; i < this.hit.length; ++i) {
                this.hit[i].setFrame(enabled ? 0 : 1);
            }
        }
        if (null != this.drumHit) {
            for (i = 0; i < this.drumHit.length; ++i) {
                this.drumHit[i].setFrame(enabled ? 1 : 0);
            }
        }
    }

    public void paint(GraphicsHelper gh, boolean paused) {
        int i;
        if (null != this.drumHit) {
            for (i = 0; i < this.drumHit.length; ++i) {
                this.drumHit[i].paintCurrentFrame(gh);
            }
            if (this.drumEndCaps != null) {
                for (i = 0; i < this.drumEndCaps.length; ++i) {
                    this.drumEndCaps[i].paintCurrentFrame(gh);
                }
            }
        }
        if (null != this.flame) {
            for (i = 0; i < this.drumFlame.length; ++i) {
                this.drumFlame[i].paintCurrentAnim(gh);
            }
        }
        if (null != this.hit) {
            for (i = 0; i < this.hit.length; ++i) {
                this.hit[i].paintCurrentFrame(gh);
            }
        }
        if (paused) {
            return;
        }
        if (null != this.flame) {
            for (i = 0; i < this.flame.length; ++i) {
                this.flame[i].paintCurrentAnim(gh);
            }
        }
        if (null != this.spark) {
            for (i = 0; i < this.spark.length; ++i) {
                this.spark[i].paint(gh);
            }
        }
        if (null != this.lightning) {
            for (i = 0; i < this.lightning.length; ++i) {
                this.lightning[i].paintCurrentAnim(gh);
            }
        }
    }
}

