/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HFont {
    public static RealioCanvas myCanvas = null;
    private static final boolean HFONT_DEBUG = false;
    private static final boolean HFONT_DEBUG_FULL = false;
    private static final boolean NBSP_BEFORE_PUNCTUATION = true;
    private static final String nbspPunctuationMarks = "!?;:@/-";
    private static final int BYTEMASK = 255;
    private static final int CHARMASK = 65535;
    private static final int HFONT_CANSCROLLUP = 0x200000;
    private static final int HFONT_CANSCROLLDOWN = 0x400000;
    private static final int HFONT_HEIGHT = 767;
    private static final int META = 4;
    private static final int META_WIDE_HI = 0;
    private static final int META_WIDE_LO = 1;
    private static final int META_LINES = 2;
    private static final int PNG_foNt = 1718570612;
    private static final int PNG_PLTE = 1347179589;
    private static final int PNG_tRNS = 1951551059;
    private static final int PNG_IEND = 1229278788;
    private static final int int_png_crc_reset = -1;
    private static final int[] int_png_laCRC = new int[256];
    private static final byte bLF = 10;
    private static final byte bCR = 13;
    private static final byte bSPACE = 32;
    private static final byte bXTEND = -128;
    private Image glyphs;
    private int glyphs_std;
    private int glyphs_extra;
    private int glyphs_all;
    private byte[] gwidth;
    private byte[] cwidth;
    private byte[] heights;
    private byte[] offsets;
    private byte[] xpos;
    private byte[] ypos;
    private char[] extend_map = null;
    private int line_spacing;
    private int char_spacing;
    private int chars_extend;
    private int extra_horiz;
    private int extra_vert;
    private int color = 0xFFFFFF;
    private int numShades = 0;
    private int curShade = 0;
    private Image[] fntImage = null;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int clipR;
    private int clipB;
    private static final Object cacheMutex;
    private static final boolean verboseCache = false;
    private static final boolean ENABLE_CACHE = true;
    private static final boolean ENABLE_CACHE_DEBUG = false;
    public static final boolean ENABLE_CACHE_STATISTICS = false;
    private static final int hashBinCount = 23;
    private static int totalNumCacheGets;
    private static int totalNumCacheMisses;
    private static int nextTableID;
    private static int maxCacheEntries;
    private static int maxCacheBytes;
    private static byte[] hashBins;
    private static byte[] linkBinNext;
    private static byte[] linkOrdNext;
    private static byte[] linkOrdPrev;
    private static byte[] tableIDs;
    private static String[] strs;
    private static byte[][] bufs;
    private static byte ordMRU;
    private static byte ordLRU;
    private static byte freeList;
    private static int numCacheEntries;
    private static int numCacheBytes;
    private final int tableID = HFont.cacheGetNextTableID();

    public void setCurrentColor(int index) {
        if (this.fntImage == null) {
            return;
        }
        if (index < 0 || index >= this.fntImage.length) {
            index = 0;
        }
        this.curShade = index;
        this.glyphs = this.fntImage[this.curShade];
    }

    void setHeight(int i) {
        this.line_spacing = i;
    }

    private void generateColors(InputStream is, int[][] colData) throws Exception {
        boolean verbose = false;
        int pal_offset = 0;
        int pal_size = 0;
        byte[] pal_chunk = null;
        byte[] baFile = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        DataInputStream dis = new DataInputStream(is);
        for (int i = 0; i < 8; ++i) {
            dos.writeByte(dis.readByte());
        }
        boolean bEnd = false;
        while (!bEnd) {
            int chunk_size = dis.readInt();
            int chunk_id = dis.readInt();
            boolean bCopy = true;
            switch (chunk_id) {
                case 1229278788: {
                    bEnd = true;
                    break;
                }
                case 1718570612: {
                    break;
                }
                case 1347179589: {
                    pal_offset = baos.size();
                    pal_size = chunk_size;
                    dos.writeInt(chunk_size);
                    dos.writeInt(chunk_id);
                    pal_chunk = new byte[chunk_size];
                    dis.read(pal_chunk, 0, chunk_size);
                    dos.write(pal_chunk, 0, chunk_size);
                    dos.writeInt(dis.readInt());
                    bCopy = false;
                }
            }
            if (!bCopy) continue;
            dos.writeInt(chunk_size);
            dos.writeInt(chunk_id);
            byte[] data = new byte[chunk_size];
            dis.read(data, 0, chunk_size);
            dos.write(data, 0, chunk_size);
            dos.writeInt(dis.readInt());
        }
        baFile = baos.toByteArray();
        is = null;
        dis = null;
        dos = null;
        baos = null;
        this.numShades = colData.length + 1;
        this.fntImage = new Image[this.numShades];
        System.gc();
        long beforeCreation = Runtime.getRuntime().freeMemory();
        this.fntImage[0] = Image.createImage((byte[])baFile, (int)0, (int)baFile.length);
        for (int extra = 0; extra < this.numShades - 1; ++extra) {
            this.recolourPalette(baFile, pal_chunk, pal_offset, pal_size, colData[extra][0], colData[extra][1]);
            this.fntImage[extra + 1] = Image.createImage((byte[])baFile, (int)0, (int)baFile.length);
        }
        System.gc();
        long afterCreation = Runtime.getRuntime().freeMemory();
        this.setCurrentColor(0);
    }

    private void recolourPalette(byte[] pngdata, byte[] paldata, int offset, int size, int colB, int colF) {
        int[] cBase = new int[3];
        int[] cDiff = new int[3];
        cBase[0] = colB >> 16 & 0xFF;
        cBase[1] = colB >> 8 & 0xFF;
        cBase[2] = colB & 0xFF;
        cDiff[0] = (colF >> 16 & 0xFF) - cBase[0];
        cDiff[1] = (colF >> 8 & 0xFF) - cBase[1];
        cDiff[2] = (colF & 0xFF) - cBase[2];
        for (int c = 1; c < size / 3; ++c) {
            int grey = paldata[c * 3];
            if (grey < 0) {
                grey += 256;
            }
            int dest = offset + 8 + c * 3;
            for (int i = 0; i < 3; ++i) {
                int col = cBase[i] + (grey * cDiff[i] >> 8);
                pngdata[dest + i] = (byte)col;
            }
        }
        int png_crc = -1;
        for (int i = offset + 4; i < offset + 8 + size; ++i) {
            byte b = pngdata[i];
            png_crc = int_png_laCRC[(png_crc ^ b) & 0xFF] ^ png_crc >>> 8;
        }
        pngdata[offset + 8 + size] = (byte)((png_crc ^= 0xFFFFFFFF) >> 24);
        pngdata[offset + 9 + size] = (byte)(png_crc >> 16);
        pngdata[offset + 10 + size] = (byte)(png_crc >> 8);
        pngdata[offset + 11 + size] = (byte)png_crc;
    }

    public HFont(String file) {
        boolean verbose = false;
        this.readBin(file);
        try {
            this.glyphs = Image.createImage((String)(file + ".png"));
        }
        catch (Exception e) {
            System.out.println("createImage " + file + " Exception " + e);
        }
    }

    public HFont(String file, int[][] colors) {
        boolean verbose = false;
        long memoryBefore = 0L;
        this.readBin(file);
        try {
            InputStream is = Util.getResourceAsStream(file + ".png");
            if (colors == null) {
                this.glyphs = Image.createImage((InputStream)is);
            } else {
                this.generateColors(is, colors);
            }
            is.close();
            is = null;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void readBin(InputStream in) throws Exception {
        int data = in.read();
        data = in.read();
        data = in.read() & 0xFF;
        this.char_spacing = in.read();
        this.line_spacing = in.read();
        this.glyphs_std = in.read();
        this.glyphs_extra = in.read();
        this.glyphs_all = this.glyphs_std + this.glyphs_extra;
        this.chars_extend = in.read();
        this.extend_map = new char[this.chars_extend << 1];
        byte[] buffer = new byte[this.chars_extend << 2];
        in.read(buffer);
        this.xpos = new byte[this.glyphs_all];
        in.read(this.xpos, 0, this.glyphs_all);
        this.ypos = new byte[this.glyphs_all];
        in.read(this.ypos, 0, this.glyphs_all);
        this.heights = new byte[this.glyphs_all];
        in.read(this.heights, 0, this.glyphs_all);
        this.gwidth = new byte[this.glyphs_all + this.chars_extend];
        in.read(this.gwidth, 0, this.glyphs_all);
        this.offsets = new byte[this.glyphs_all];
        in.read(this.offsets, 0, this.glyphs_all);
        int i = 0;
        int j = this.glyphs_all;
        int br = 0;
        while (i < this.chars_extend << 1) {
            char character = (char)(((buffer[br++] & 0xFF) << 8 | buffer[br++] & 0xFF) & 0xFFFF);
            byte combo1 = buffer[br++];
            byte combo2 = buffer[br++];
            this.gwidth[j++] = (byte)(Math.max(this.getWidth(combo1), this.getWidth(combo2)) - this.char_spacing & 0xFF);
            this.extend_map[i++] = character;
            this.extend_map[i++] = (char)(((combo1 & 0xFF) << 8 | combo2 & 0xFF) & 0xFFFF);
        }
        int lim = 128 + this.glyphs_extra + this.chars_extend;
        this.cwidth = new byte[255];
        for (i = 32; i < lim; ++i) {
            this.cwidth[i] = (byte)(this.getWidth((byte)i) & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBin(String file) {
        InputStream in = null;
        try {
            RealioCanvas.showLoadingIcon(true);
            in = Util.getResourceAsStream(file + ".hf");
            this.readBin(in);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        in = null;
        RealioCanvas.showLoadingIcon(false);
    }

    public void setColor(int clr) {
        this.color = clr;
    }

    public byte[] getFromString(String s) {
        byte[] b = null;
        b = HFont.cacheGet(this.tableID, s);
        if (b != null) {
            return b;
        }
        int len = s.length();
        char[] c = new char[len];
        b = new byte[len + 4];
        if (s == null) {
            return null;
        }
        s.getChars(0, len, c, 0);
        block0: for (int i = 0; i < len; ++i) {
            if (c[i] < '\u0080') {
                if (c[i] >= 32 + this.glyphs_std) continue;
                b[i + 4] = (byte)(c[i] & 0x7F);
                continue;
            }
            c[i] = (char)(0xC080 | c[i] << 2 & 0x1F00 | c[i] & 0x3F);
            boolean lost = true;
            for (int j = 0; j < this.chars_extend << 1; j += 2) {
                if (c[i] != this.extend_map[j]) continue;
                b[i + 4] = (byte)(-128 + (j >> 1) + this.glyphs_extra);
                lost = false;
                continue block0;
            }
        }
        HFont.cachePut(this.tableID, s, b);
        return b;
    }

    public static void logCacheStatistics() {
    }

    private int getWidth(byte b) {
        if (b - 32 >= this.gwidth.length) {
            return 0;
        }
        if (0 <= b && b < 32) {
            return 0;
        }
        if ((b & 0xFFFFFF80) == 0) {
            return this.gwidth[b - 32] + this.char_spacing;
        }
        return this.gwidth[(b ^ 0xFFFFFF80) + this.glyphs_std] + this.char_spacing;
    }

    private int getWidth(byte[] string) {
        return this.getWidth(string, string.length - 4);
    }

    private int getWidth(byte[] string, int length) {
        int pos;
        int width = 0;
        if (pos >= (length += 4)) {
            return 0;
        }
        for (pos = 4; pos < length && string[pos] != 10 && string[pos] != 13; ++pos) {
            width += this.cwidth[string[pos] & 0xFF] + this.extra_horiz;
        }
        return width - (this.char_spacing + this.extra_horiz);
    }

    public int getSubstringIndexForWidth(String string, int allowableWidth) {
        char ch;
        int currentLength;
        int currentWidth = 0;
        int maxLength = string.length();
        for (currentLength = 0; currentLength < maxLength && (ch = string.charAt(currentLength)) != '\n' && ch != '\r' && (currentWidth += this.cwidth[ch & 0xFF] + this.extra_horiz) < allowableWidth; ++currentLength) {
        }
        return currentLength;
    }

    public int getMaxWidth(byte[] string) {
        int pos = 4;
        int length = string.length;
        if (pos >= length) {
            return 0;
        }
        int width = 0;
        int maxWidth = 0;
        while (pos < length) {
            if (string[pos] == 10 || string[pos] == 13) {
                if (maxWidth < width) {
                    maxWidth = width;
                }
                width = 0;
            } else {
                width += this.cwidth[string[pos] & 0xFF] + this.extra_horiz;
            }
            ++pos;
        }
        if (maxWidth < width) {
            maxWidth = width;
        }
        return maxWidth - (this.char_spacing + this.extra_horiz);
    }

    public int charWidth(char ch_in) {
        int width = this.cwidth[ch_in & 0xFF] + this.extra_horiz;
        return width;
    }

    public int stringWidth(String string) {
        return this.getWidth(this.getFromString(string));
    }

    public int getHeight() {
        return this.line_spacing + this.extra_vert;
    }

    private int getHeight(byte[] string) {
        return this.getHeight(string, string.length - 4);
    }

    private int getHeight(byte[] string, int length) {
        int pos;
        int height = this.line_spacing + this.extra_vert;
        if (pos >= (length += 4)) {
            return 0;
        }
        for (pos = 4; pos < length; ++pos) {
            if (string[pos] != 10 && string[pos] != 13) continue;
            height += this.line_spacing + this.extra_vert;
        }
        return height - this.extra_vert;
    }

    public int setLineSpacing(int ls) {
        this.extra_vert = ls;
        return this.line_spacing + ls;
    }

    public int getLineSpacing() {
        return this.extra_vert;
    }

    public void setCharSpacing(int cs) {
        HFont.cachePurgeTableID(this.tableID);
        this.extra_horiz = cs;
    }

    public int doLinebreaks(byte[] string, int width) {
        if (string == null || string.length <= 4) {
            return 0;
        }
        int breaks = 0;
        int ch = 4;
        int prev = 0;
        int space = 0;
        int line = 0;
        int len = string.length;
        int bwidth = ((string[0] & 0x7F) << 8) + (string[1] & 0xFF);
        if (bwidth == width) {
            return string[2] & 0xFF;
        }
        if (bwidth != 0) {
            do {
                if (string[ch] != 13) continue;
                string[ch] = 32;
            } while (++ch < len);
            ch = 4;
        }
        while (ch < len) {
            line = 0;
            while (line < width && ch < len && string[ch] != 10) {
                line += this.cwidth[string[ch] & 0xFF] + this.extra_horiz;
                if (string[ch] == 32 || string[ch] == 95) {
                    if (line < width) {
                        if (++ch < len) {
                            if (nbspPunctuationMarks.indexOf(string[ch]) != -1) continue;
                            space = ch - 1;
                            continue;
                        }
                    } else {
                        if (ch + 1 < len && nbspPunctuationMarks.indexOf(string[ch + 1]) != -1) {
                            ++ch;
                            continue;
                        }
                        space = ch;
                        break;
                    }
                }
                ++ch;
            }
            if (line >= width && space > prev) {
                string[space] = 13;
                ch = space;
            }
            prev = ch++;
            ++breaks;
        }
        string[0] = (byte)(width >> 8 & 0xFF);
        string[1] = (byte)(width & 0xFF);
        string[2] = (byte)(breaks & 0xFF);
        return breaks;
    }

    public int drawString(Graphics g, String string, int x, int y, int anchor) {
        byte[] b = this.getFromString(string);
        return this.drawText(g, b, x, y, -1, -1, 0, anchor) >> 10 & 0x200;
    }

    public int drawStringWrapped(Graphics g, String string, int x, int y, int w, int anchor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        byte[] b = this.getFromString(string);
        this.doLinebreaks(b, w);
        return this.drawText(g, b, x, y, w, -1, 0, anchor);
    }

    public int drawText(Graphics g, byte[] string, int x, int y, int w, int h, int vscroll, int anchor) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int ret = this.drawText_private(g, string, x, y, w, h, vscroll, anchor);
        g.setClip(cx, cy, cw, ch);
        return ret;
    }

    private final int drawText_private(Graphics g, byte[] string, int x, int y, int w, int h, int vscroll, int anchor) {
        boolean initx;
        int ch;
        int pos = 4;
        int length = string.length;
        int nowx = x;
        int nowy = y;
        int canscroll = 0;
        int vertspace = this.line_spacing + this.extra_vert;
        int maxw = 0;
        if (pos >= length) {
            return 0;
        }
        if (anchor == 0) {
            anchor = 20;
        }
        if ((anchor & 0x60) != 0) {
            nowy -= this.getHeight(string);
        } else if ((anchor & 2) != 0) {
            nowy -= this.getHeight(string) >> 1;
        }
        y = nowy;
        nowy -= vscroll;
        this.saveClip(g);
        if (w > 0) {
            nowx = (anchor & 8) != 0 ? x - w : ((anchor & 1) != 0 ? x - (w >> 1) : x);
            if (h > 0) {
                this.mergeClip(g, nowx, y, w, h);
            } else {
                this.mergeClip(g, nowx, y, w, this.clipH);
            }
        } else {
            nowx = (anchor & 8) != 0 ? x - this.clipW : ((anchor & 1) != 0 ? x - (this.clipW >> 1) : x);
            if (h > 0) {
                this.mergeClip(g, nowx, y, this.clipW, h);
            }
        }
        this.saveClip(g);
        if (h > 0) {
            if (nowy >= y + h - (vertspace - this.extra_vert)) {
                return 0x200000;
            }
            while (nowy <= y - vertspace) {
                canscroll |= 0x200000;
                do {
                    ch = string[pos++] & 0xFF;
                } while (pos < length && ch != 13 && ch != 10);
                if (pos >= length) {
                    return 0x200000;
                }
                nowy += vertspace;
            }
            if (nowy < y) {
                canscroll |= 0x200000;
            }
        }
        boolean bl = initx = (anchor & 9) != 0;
        while (pos < length) {
            ch = string[pos] & 0xFF;
            if (initx || ch < 32) {
                if (initx || ch == 10 || ch == 13) {
                    if ((anchor & 4) == 0) {
                        int lpos = pos;
                        nowx = this.cwidth[string[lpos] & 0xFF] + this.extra_horiz;
                        while (++lpos < length && string[lpos] != 10 && string[lpos] != 13) {
                            nowx += this.cwidth[string[lpos] & 0xFF] + this.extra_horiz;
                        }
                        if ((nowx -= this.char_spacing + this.extra_horiz) > maxw) {
                            maxw = nowx;
                        }
                        nowx = (anchor & 8) != 0 ? x - nowx : ((anchor & 1) != 0 ? x - (nowx >> 1) : x);
                    } else {
                        if ((nowx -= x) > maxw) {
                            maxw = nowx;
                        }
                        nowx = x;
                    }
                    if (initx) {
                        initx = false;
                        continue;
                    }
                    if (h > 0 && (nowy += vertspace) >= y + h) {
                        return canscroll | 0x400000 | h | w << 10;
                    }
                }
            } else if (ch == 32) {
                nowx += this.gwidth[0] + (this.char_spacing + this.extra_horiz);
            } else if (ch < 128) {
                nowx += this.drawGlyph(g, ch - 32, nowx, nowy) + (this.char_spacing + this.extra_horiz);
            } else if ((ch -= 128) < this.glyphs_extra) {
                nowx += this.drawGlyph(g, ch + this.glyphs_std, nowx, nowy) + (this.char_spacing + this.extra_horiz);
            } else {
                ch -= this.glyphs_extra;
                for (int i = 8; i >= 0; i -= 8) {
                    int tch = this.extend_map[(ch << 1) + 1] >> i & 0xFF;
                    if (tch < 32) continue;
                    tch = tch < 128 ? (tch -= 32) : (tch -= 128 - this.glyphs_std);
                    if (tch >= this.glyphs_all) continue;
                    this.drawGlyph(g, tch, nowx + (this.gwidth[this.glyphs_all + ch] - this.gwidth[tch] >> 1), nowy);
                }
                nowx += this.gwidth[this.glyphs_all + ch] + (this.char_spacing + this.extra_horiz);
            }
            ++pos;
        }
        if ((anchor & 4) != 0 && (nowx -= x) > maxw) {
            maxw = nowx;
        }
        if (h > 0 && nowy + vertspace > y + h) {
            return canscroll | 0x400000 | h | maxw << 10;
        }
        return canscroll | nowy + vertspace - y | maxw << 10;
    }

    private int drawGlyph(Graphics g, int glyph, int x, int y) {
        byte w = this.gwidth[glyph];
        byte h = this.heights[glyph];
        int dx = x;
        int dy = y + this.offsets[glyph];
        int sx = this.xpos[glyph] & 0xFF;
        int sy = this.ypos[glyph] & 0xFF;
        g.drawRegion(this.glyphs, sx, sy, (int)w, (int)h, 0, dx, dy, 20);
        this.restoreClip(g);
        return w;
    }

    private void saveClip(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
        this.clipR = this.clipX + this.clipW;
        this.clipB = this.clipY + this.clipH;
    }

    private void restoreClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean mergeClip(Graphics g, int mX, int mY, int mW, int mH) {
        int x = mX;
        int r = mX + mW;
        if (x < this.clipX) {
            x = this.clipX;
        }
        if (r > this.clipR) {
            r = this.clipR;
        }
        if (r <= x) {
            return false;
        }
        int y = mY;
        int b = mY + mH;
        if (y < this.clipY) {
            y = this.clipY;
        }
        if (b > this.clipB) {
            b = this.clipB;
        }
        if (b <= y) {
            return false;
        }
        g.setClip(x, y, r - x, b - y);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cacheDebugUnitTest() {
        boolean verbose = false;
        Object object = cacheMutex;
        synchronized (object) {
            int oldMaxCacheEntries = maxCacheEntries;
            int oldMaxCacheBytes = maxCacheBytes;
            int testCode = 0;
            boolean success = false;
            try {
                int i;
                String[] s;
                int t;
                testCode = 1001;
                HFont.cacheInit(-1, 1024);
                if (4 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1002;
                HFont.cacheInit(0, 1024);
                if (4 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1003;
                HFont.cacheInit(1, 1024);
                if (4 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1004;
                HFont.cacheInit(4, 1024);
                if (4 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1005;
                HFont.cacheInit(5, 1024);
                if (5 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1006;
                HFont.cacheInit(254, 1024);
                if (254 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1007;
                HFont.cacheInit(255, 1024);
                if (255 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 1008;
                HFont.cacheInit(256, 1024);
                if (255 != maxCacheEntries) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2000;
                int maxEntries = 255;
                int maxBytes = 0x100000;
                HFont.cacheInit(255, 0x100000);
                boolean t0 = true;
                String s0 = "Hello, World!";
                byte[] b0 = new byte[]{0, 1, 2};
                testCode = 2001;
                if (null != HFont.cacheGet(1, "Hello, World!")) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2002;
                HFont.cachePut(1, "Hello, World!", b0);
                testCode = 2003;
                if (b0 != HFont.cacheGet(1, "Hello, World!")) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                int t1 = 4;
                String s12 = "Foo";
                byte[] b1 = new byte[]{2, 1, 2};
                testCode = 2004;
                if (null != HFont.cacheGet(4, "Foo")) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2005;
                HFont.cachePut(4, "Foo", b1);
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2006;
                if (b1 != HFont.cacheGet(4, "Foo")) {
                    boolean bl = false;
                    return bl;
                }
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2007;
                if (b0 != HFont.cacheGet(1, "Hello, World!")) {
                    boolean bl = false;
                    return bl;
                }
                testCode = 2008;
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                for (int i2 = 0; i2 < 32; ++i2) {
                    t = 10 + i2;
                    String s2 = "Foo" + i2;
                    byte[] b = new byte[]{HFont.toByte(i2)};
                    testCode = 2100 + i2;
                    if (null != HFont.cacheGet(t, s2)) {
                        boolean bl = false;
                        return bl;
                    }
                    testCode = 2200 + i2;
                    HFont.cachePut(t, s2, b);
                    testCode = 2300 + i2;
                    if (b != HFont.cacheGet(t, s2)) {
                        boolean bl = false;
                        return bl;
                    }
                    testCode = 2300 + i2;
                    if (HFont.cacheDebugCheckInvariants()) continue;
                    boolean bl = false;
                    return bl;
                }
                testCode = 3000;
                maxEntries = 16;
                maxBytes = 1024;
                HFont.cacheInit(16, 1024);
                for (int i3 = 0; i3 < 48; ++i3) {
                    int t2 = 10 + i3;
                    s = "Foo" + i3;
                    byte[] b12 = new byte[]{HFont.toByte(i3)};
                    testCode = 3100 + i3;
                    if (null != HFont.cacheGet(t2, (String)s)) {
                        boolean s12 = false;
                        return s12;
                    }
                    testCode = 3200 + i3;
                    HFont.cachePut(t2, (String)s, b12);
                    testCode = 3300 + i3;
                    if (b12 != HFont.cacheGet(t2, (String)s)) {
                        boolean s12 = false;
                        return s12;
                    }
                    byte[] b2 = new byte[]{HFont.toByte(10 + i3)};
                    testCode = 3400 + i3;
                    HFont.cachePut(t2, (String)s, b2);
                    testCode = 3500 + i3;
                    if (b2 != HFont.cacheGet(t2, (String)s)) {
                        boolean t3 = false;
                        return t3;
                    }
                    testCode = 3600 + i3;
                    if (!HFont.cacheDebugCheckInvariants()) {
                        boolean t3 = false;
                        return t3;
                    }
                    if (numCacheEntries > 16) {
                        boolean t3 = false;
                        return t3;
                    }
                    if (numCacheBytes <= 1024) continue;
                    boolean t3 = false;
                    return t3;
                }
                testCode = 40000;
                maxEntries = 16;
                maxBytes = 8192;
                HFont.cacheInit(16, 8192);
                int arrSize = 20;
                int t4 = 17;
                s = new String[20];
                byte[][] b = new byte[20][];
                for (i = 0; i < 20; ++i) {
                    s[i] = "x" + i;
                    b[i] = new byte[]{HFont.toByte(i)};
                }
                for (i = 0; i < 20; ++i) {
                    int j;
                    testCode = 40000 + 100 * (i + 1);
                    if (null != HFont.cacheGet(17, s[i])) {
                        boolean t3 = false;
                        return t3;
                    }
                    HFont.cachePut(17, s[i], b[i]);
                    if (b[i] != HFont.cacheGet(17, s[i])) {
                        boolean t3 = false;
                        return t3;
                    }
                    if (!HFont.cacheDebugCheckInvariants()) {
                        boolean t3 = false;
                        return t3;
                    }
                    for (j = 0; j < i; ++j) {
                        testCode = 40000 + 100 * (i + 1) + (j + 1);
                        byte[] bx = HFont.cacheGet(17, s[j]);
                        if (null == bx || bx == b[j]) continue;
                        t = 0;
                        return t != 0;
                    }
                    if (numCacheEntries > 16) {
                        j = 0;
                        return j != 0;
                    }
                    if (numCacheBytes <= 8192) continue;
                    j = 0;
                    return j != 0;
                }
                testCode = 50000;
                maxEntries = 17;
                maxBytes = 0x100000;
                HFont.cacheInit(17, 0x100000);
                arrSize = 11;
                int[] t2 = new int[11];
                s = new String[11];
                b = new byte[11][];
                for (i = 0; i < 11; ++i) {
                    t2[i] = i % 3;
                    s[i] = "x" + i;
                    b[i] = new byte[]{HFont.toByte(i)};
                }
                for (i = 0; i < 11; ++i) {
                    testCode = 51000 + i;
                    HFont.cachePut(t2[i], s[i], b[i]);
                }
                for (i = 0; i < 11; ++i) {
                    testCode = 52000 + i;
                    byte[] bx = HFont.cacheGet(t2[i], s[i]);
                    if (null == bx || bx == b[i]) continue;
                    boolean t5 = false;
                    return t5;
                }
                testCode = 53000;
                int tableID_purged = 2;
                HFont.cachePurgeTableID(2);
                for (int i4 = 0; i4 < 11; ++i4) {
                    boolean bl;
                    testCode = 54000 + i4;
                    byte[] bx = HFont.cacheGet(t2[i4], s[i4]);
                    if (null != bx && bx != b[i4]) {
                        bl = false;
                        return bl;
                    }
                    testCode = 55000 + i4;
                    if (null == bx || 2 != t2[i4]) continue;
                    bl = false;
                    return bl;
                }
                testCode = 56000;
                if (!HFont.cacheDebugCheckInvariants()) {
                    boolean bl = false;
                    return bl;
                }
                success = true;
                return success;
            }
            catch (Throwable t) {}
            finally {
                try {
                    HFont.cacheInit(oldMaxCacheEntries, oldMaxCacheBytes);
                }
                catch (Throwable t) {}
                return success;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheInit(int maxNumCacheEntries, int maxNumCacheBytes) {
        boolean verbose = false;
        int num = maxNumCacheEntries < 4 ? 4 : (maxNumCacheEntries > 255 ? 255 : maxNumCacheEntries);
        byte[] newHashBins = new byte[23];
        byte[] newLinkBinNext = new byte[num + 1];
        byte[] newLinkOrdNext = new byte[num + 1];
        byte[] newLinkOrdPrev = new byte[num + 1];
        byte[] newTableIDs = new byte[num + 1];
        String[] newStrs = new String[num + 1];
        byte[][] newBufs = new byte[num + 1][];
        Object object = cacheMutex;
        synchronized (object) {
            maxCacheEntries = num;
            maxCacheBytes = maxNumCacheBytes;
            hashBins = newHashBins;
            linkBinNext = newLinkBinNext;
            linkOrdNext = newLinkOrdNext;
            linkOrdPrev = newLinkOrdPrev;
            tableIDs = newTableIDs;
            strs = newStrs;
            bufs = newBufs;
            ordMRU = 0;
            ordLRU = 0;
            freeList = 0;
            if (num > 0) {
                freeList = HFont.toByte(1);
                for (int i = 1; i < linkBinNext.length - 1; ++i) {
                    HFont.linkBinNext[i] = HFont.toByte(i + 1);
                }
            }
            numCacheEntries = 0;
            numCacheBytes = 0;
        }
    }

    public static void cachePurge() {
        boolean verbose = false;
        HFont.cacheInit(maxCacheEntries, maxCacheBytes);
    }

    private static void cachePurgeTableID(int tableID) {
        boolean verbose = false;
        for (int i = 0; i < tableIDs.length; ++i) {
            if (tableID != tableIDs[i]) continue;
            HFont.cachePurgeIdx(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cacheGetNextTableID() {
        boolean verbose = false;
        Object object = cacheMutex;
        synchronized (object) {
            int result = nextTableID++;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] cacheGet(int tableID, String str) {
        byte[] results;
        boolean verbose = false;
        int hash = HFont.cacheHash(tableID, str);
        Object object = cacheMutex;
        synchronized (object) {
            String s;
            byte t;
            int cell = 0;
            cell = HFont.toInt(hashBins[hash]);
            while (cell != 0 && !HFont.cacheEquals(tableID, str, t = tableIDs[cell], s = strs[cell])) {
                cell = HFont.toInt(linkBinNext[cell]);
            }
            if (0 == cell) {
                return null;
            }
            HFont.cacheTouch(cell);
            results = bufs[cell];
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cachePut(int tableID, String str, byte[] buf) {
        boolean verbose = false;
        if (tableID <= 0 || null == str || null == buf) {
            return;
        }
        int hash = HFont.cacheHash(tableID, str);
        Object object = cacheMutex;
        synchronized (object) {
            String s;
            byte t;
            int cell = 0;
            cell = HFont.toInt(hashBins[hash]);
            while (cell != 0 && !HFont.cacheEquals(tableID, str, t = tableIDs[cell], s = strs[cell])) {
                cell = HFont.toInt(linkBinNext[cell]);
            }
            if (0 == cell) {
                if (0 == freeList && !HFont.cachePurgeOne()) {
                    return;
                }
                cell = HFont.toInt(freeList);
                freeList = linkBinNext[cell];
                HFont.linkBinNext[cell] = hashBins[hash];
                HFont.hashBins[hash] = HFont.toByte(cell);
            } else {
                --numCacheEntries;
                if (null != strs[cell]) {
                    numCacheBytes -= 2 * strs[cell].length();
                }
                if (null != bufs[cell]) {
                    numCacheBytes -= bufs[cell].length;
                }
            }
            HFont.tableIDs[cell] = HFont.toByte(tableID);
            HFont.strs[cell] = str;
            HFont.bufs[cell] = buf;
            ++numCacheEntries;
            numCacheBytes += 2 * str.length();
            numCacheBytes += buf.length;
            HFont.cacheTouch(cell);
            while ((numCacheBytes > maxCacheBytes || numCacheEntries > maxCacheEntries) && HFont.cachePurgeOne()) {
            }
        }
    }

    private static int cacheHash(int tableID, String str) {
        boolean verbose = false;
        int raw = str.hashCode() ^ tableID;
        int hash = (Integer.MAX_VALUE & raw) % 23;
        return hash;
    }

    private static boolean cacheEquals(int tableID_A, String str_A, int tableID_B, String str_B) {
        return tableID_A == tableID_B && str_A.equals(str_B);
    }

    private static void cacheTouch(int cell) {
        boolean verbose = false;
        if (ordMRU == cell) {
            return;
        }
        int prev = HFont.toInt(linkOrdPrev[cell]);
        int next = HFont.toInt(linkOrdNext[cell]);
        if (0 != prev) {
            HFont.linkOrdNext[prev] = HFont.toByte(next);
        }
        if (0 != next) {
            HFont.linkOrdPrev[next] = HFont.toByte(prev);
        }
        if (0 != ordMRU) {
            HFont.linkOrdPrev[HFont.ordMRU] = HFont.toByte(cell);
        }
        HFont.linkOrdPrev[cell] = 0;
        HFont.linkOrdNext[cell] = ordMRU;
        ordMRU = HFont.toByte(cell);
        if (cell == ordLRU) {
            ordLRU = HFont.toByte(prev);
        }
        if (0 == ordLRU) {
            ordLRU = HFont.toByte(cell);
        }
    }

    private static boolean cachePurgeOne() {
        boolean verbose = false;
        if (0 == ordLRU) {
            return false;
        }
        HFont.cachePurgeIdx(ordLRU);
        return true;
    }

    private static void cachePurgeIdx(int cell) {
        int prev;
        boolean verbose = false;
        int tableID = HFont.toInt(tableIDs[cell]);
        String str = strs[cell];
        byte[] buf = bufs[cell];
        int hash = HFont.cacheHash(tableID, str);
        HFont.tableIDs[cell] = 0;
        HFont.strs[cell] = null;
        HFont.bufs[cell] = null;
        if (HFont.toInt(hashBins[hash]) == cell) {
            HFont.hashBins[hash] = linkBinNext[cell];
        } else {
            prev = HFont.toInt(hashBins[hash]);
            int c = HFont.toInt(linkBinNext[prev]);
            while (c != 0) {
                if (c == cell) {
                    HFont.linkBinNext[prev] = linkBinNext[c];
                    break;
                }
                prev = c;
                c = HFont.toInt(linkBinNext[prev]);
            }
        }
        prev = linkOrdPrev[cell];
        byte next = linkOrdNext[cell];
        if (0 != prev) {
            HFont.linkOrdNext[prev] = next;
        }
        if (0 != next) {
            HFont.linkOrdPrev[next] = prev;
        }
        if (HFont.toByte(cell) == ordLRU) {
            ordLRU = (byte)prev;
        }
        if (HFont.toByte(cell) == ordMRU) {
            ordMRU = next;
        }
        HFont.linkOrdNext[cell] = 0;
        HFont.linkOrdPrev[cell] = 0;
        HFont.linkBinNext[cell] = freeList;
        freeList = HFont.toByte(cell);
        --numCacheEntries;
        if (null != str) {
            numCacheBytes -= 2 * str.length();
        }
        if (null != buf) {
            numCacheBytes -= 1 * buf.length;
        }
    }

    private static boolean cacheDebugCheckInvariants() {
        int h;
        boolean verbose = false;
        if (0 == nextTableID || HFont.toInt(HFont.toByte(nextTableID)) != nextTableID) {
            return false;
        }
        if (null == hashBins || hashBins.length != 23) {
            return false;
        }
        if (null == linkBinNext || linkBinNext.length != maxCacheEntries + 1) {
            return false;
        }
        if (null == linkOrdNext || linkOrdNext.length != maxCacheEntries + 1) {
            return false;
        }
        if (null == linkOrdPrev || linkOrdPrev.length != maxCacheEntries + 1) {
            return false;
        }
        if (null == tableIDs || tableIDs.length != maxCacheEntries + 1) {
            return false;
        }
        if (null == strs || strs.length != maxCacheEntries + 1) {
            return false;
        }
        if (null == bufs || bufs.length != maxCacheEntries + 1) {
            return false;
        }
        if (0 == ordMRU != (0 == ordLRU)) {
            return false;
        }
        if (!HFont.cacheDebugIsAcyclic(HFont.toByte(1), new byte[]{0, 2, 3, 4, 0})) {
            return false;
        }
        if (HFont.cacheDebugIsAcyclic(HFont.toByte(1), new byte[]{0, 2, 3, 4, 3})) {
            return false;
        }
        if (!HFont.cacheDebugIsAcyclic(ordMRU, linkOrdNext)) {
            return false;
        }
        if (!HFont.cacheDebugIsAcyclic(ordLRU, linkOrdPrev)) {
            return false;
        }
        if (!HFont.cacheDebugIsAcyclic(freeList, linkBinNext)) {
            return false;
        }
        for (int h2 = 0; h2 < hashBins.length; ++h2) {
            if (HFont.cacheDebugIsAcyclic(hashBins[h2], linkBinNext)) continue;
            return false;
        }
        if (0 != ordMRU && 0 != linkOrdPrev[ordMRU]) {
            return false;
        }
        if (0 != ordLRU && 0 != linkOrdNext[ordLRU]) {
            return false;
        }
        for (int i = 0; i < linkOrdPrev.length; ++i) {
            if (0 != linkOrdPrev[i] && linkOrdNext[linkOrdPrev[i]] != i) {
                return false;
            }
            if (0 == linkOrdNext[i] || linkOrdPrev[linkOrdNext[i]] == i) continue;
            return false;
        }
        int[] reachable = new int[linkBinNext.length];
        int i = HFont.toInt(freeList);
        while (i != 0) {
            int n = i;
            reachable[n] = reachable[n] + 1;
            i = HFont.toInt(linkBinNext[i]);
        }
        i = HFont.toInt(ordMRU);
        while (i != 0) {
            int n = i;
            reachable[n] = reachable[n] + 10;
            i = HFont.toInt(linkOrdNext[i]);
        }
        i = HFont.toInt(ordLRU);
        while (i != 0) {
            int n = i;
            reachable[n] = reachable[n] + 100;
            i = HFont.toInt(linkOrdPrev[i]);
        }
        for (h = 0; h < hashBins.length; ++h) {
            int i2 = HFont.toInt(hashBins[h]);
            while (i2 != 0) {
                int n = i2;
                reachable[n] = reachable[n] + 1000;
                i2 = HFont.toInt(linkBinNext[i2]);
            }
        }
        if (0 != reachable[0]) {
            return false;
        }
        for (i = 1; i < reachable.length; ++i) {
            if (1 == reachable[i] || 1110 == reachable[i]) continue;
            return false;
        }
        i = HFont.toInt(freeList);
        while (i != 0) {
            if (null != strs[i]) {
                return false;
            }
            if (null != bufs[i]) {
                return false;
            }
            if (0 != tableIDs[i]) {
                return false;
            }
            if (0 != linkOrdPrev[i]) {
                return false;
            }
            if (0 != linkOrdNext[i]) {
                return false;
            }
            if (HFont.toInt(ordMRU) == i) {
                return false;
            }
            if (HFont.toInt(ordLRU) == i) {
                return false;
            }
            i = HFont.toInt(linkBinNext[i]);
        }
        i = HFont.toInt(ordMRU);
        while (i != 0) {
            if (null == strs[i]) {
                return false;
            }
            if (null == bufs[i]) {
                return false;
            }
            if (0 == tableIDs[i]) {
                return false;
            }
            i = HFont.toInt(linkOrdNext[i]);
        }
        for (i = 0; i < strs.length; ++i) {
            if (null == strs[i]) continue;
            int hash = HFont.cacheHash(tableIDs[i], strs[i]);
            int cell = 0;
            cell = HFont.toInt(hashBins[hash]);
            while (0 != cell && cell != i) {
                cell = HFont.toInt(linkBinNext[cell]);
            }
            if (0 != cell) continue;
            return false;
        }
        for (h = 0; h < 23; ++h) {
            int cell = HFont.toInt(hashBins[h]);
            while (0 != cell) {
                int hash = HFont.cacheHash(tableIDs[cell], strs[cell]);
                if (h != hash) {
                    return false;
                }
                cell = HFont.toInt(linkBinNext[cell]);
            }
        }
        for (i = 0; i < strs.length; ++i) {
            if (null == strs[i]) continue;
            if (!HFont.cacheEquals(tableIDs[i], strs[i], tableIDs[i], strs[i])) {
                return false;
            }
            for (int j = 0; j < strs.length; ++j) {
                if (i == j || null == strs[j] || !HFont.cacheEquals(tableIDs[i], strs[i], tableIDs[j], strs[j])) continue;
                return false;
            }
        }
        int numEntries = 0;
        int numBytes = 0;
        for (int i3 = 0; i3 < strs.length; ++i3) {
            if (null == strs[i3]) continue;
            ++numEntries;
            numBytes += 2 * strs[i3].length();
            numBytes += bufs[i3].length;
        }
        return numEntries == numCacheEntries && numBytes == numCacheBytes;
    }

    private static boolean cacheDebugIsAcyclic(byte head, byte[] links) {
        boolean verbose = false;
        if (0 == head) {
            return true;
        }
        int a = HFont.toInt(head);
        int b = HFont.toInt(links[a]);
        while (a != b) {
            if (0 == b) {
                return true;
            }
            if (a == (b = HFont.toInt(links[b]))) {
                return false;
            }
            if (0 == b) {
                return true;
            }
            a = HFont.toInt(links[a]);
            b = HFont.toInt(links[b]);
        }
        return false;
    }

    private static int toInt(byte b) {
        return 0xFF & b;
    }

    private static byte toByte(int i) {
        byte b = (byte)i;
        return b;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int j = i;
            for (int k = 0; k < 8; ++k) {
                if ((j & 1) != 0) {
                    j = 0xEDB88320 ^ j >>> 1;
                    continue;
                }
                j >>>= 1;
            }
            HFont.int_png_laCRC[i] = j;
        }
        cacheMutex = new Object();
        totalNumCacheGets = 0;
        totalNumCacheMisses = 0;
        nextTableID = 1;
        maxCacheEntries = 0;
        maxCacheBytes = 0;
        hashBins = null;
        linkBinNext = null;
        linkOrdNext = null;
        linkOrdPrev = null;
        tableIDs = null;
        strs = null;
        bufs = null;
        ordMRU = 0;
        ordLRU = 0;
        freeList = 0;
        numCacheEntries = 0;
        numCacheBytes = 0;
        HFont.cacheInit(16, 2048);
    }
}

