/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Util {
    public static RealioCanvas myCanvas = null;
    private static long lastTime = System.currentTimeMillis();
    private static char whoAmI = '\u0000';
    static final boolean silence = false;
    private static final Class resourceGetter = new Object().getClass();
    private static final String[] resRoots = new String[]{"", "/"};
    private static int resRootID = 0;
    public static int numClipsEverCreated = 0;
    private static MIDlet myMidlet = null;
    private static Hashtable myDps = null;
    private static final Random random = new Random();
    public static boolean IS_WATCHDOG_ENABLED = false;
    public static int WATCHDOG_LIMIT_MS = 15000;
    public static long WATCHDOG_VALUE = -1L;

    public static void out(Object s) {
        boolean timing = false;
        if ('\u0000' == whoAmI) {
            whoAmI = (char)(65 + Util.rnd(0, 25));
        }
        System.out.print(whoAmI);
        System.out.print(": ");
        System.out.print(s);
        System.out.println();
    }

    public static void out(String prefix, Hashtable table) {
        Enumeration en = table.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object val = table.get(key);
            Util.out(prefix + key + " ==> " + val);
        }
    }

    public static void out(String prefix, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object val = vector.elementAt(i);
            Util.out(prefix + i + " ==> " + val);
        }
    }

    public static String getStringParam(String key) {
        String jarval;
        if (null != myMidlet && null != (jarval = myMidlet.getAppProperty(key))) {
            return jarval;
        }
        if (null != myDps) {
            Object dpsval = myDps.get(key);
            if (null == dpsval) {
                return null;
            }
            if (dpsval instanceof String) {
                return (String)dpsval;
            }
        }
        return null;
    }

    public static String getStringParam(String key, String defVal) {
        String str = Util.getStringParam(key);
        if (str != null) {
            return str;
        }
        return defVal;
    }

    public static boolean getBooleanParam(String key, boolean defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return !"false".equals(val);
    }

    public static byte getByteParam(String key, byte defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return Byte.parseByte(val);
    }

    public static short getShortParam(String key, short defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return Short.parseShort(val);
    }

    public static char getCharParam(String key, char defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return val.charAt(0);
    }

    public static int getIntParam(String key, int defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return Integer.parseInt(val);
    }

    public static long getLongParam(String key, long defVal) {
        String val = Util.getStringParam(key);
        if (null == val) {
            return defVal;
        }
        return Long.parseLong(val);
    }

    public static InputStream getResourceAsStream(String resName) {
        boolean verbose = false;
        int numResRoots = resRoots.length;
        int myResRootID = resRootID;
        for (int i = 0; i < numResRoots; ++i) {
            int rrID = (i + myResRootID) % numResRoots;
            String rr = resRoots[rrID] + resName;
            InputStream result = resourceGetter.getResourceAsStream(rr);
            if (null == result) continue;
            resRootID = rrID;
            return result;
        }
        return null;
    }

    public static Image createImage(String resName) {
        boolean verbose = false;
        RealioCanvas.showLoadingIcon(true);
        int numResRoots = resRoots.length;
        int myResRootID = resRootID;
        for (int i = 0; i < numResRoots; ++i) {
            int rrID = (i + myResRootID) % numResRoots;
            String rr = resRoots[rrID] + resName;
            try {
                Image image = Image.createImage((String)rr);
                resRootID = rrID;
                RealioCanvas.showLoadingIcon(false);
                return image;
            }
            catch (IOException ignore) {
                continue;
            }
        }
        RealioCanvas.showLoadingIcon(false);
        return null;
    }

    public void setCanvas(RealioCanvas c) {
        myCanvas = c;
    }

    public static Image createImage(int w, int h) {
        boolean verbose = false;
        Image result = Image.createImage((int)w, (int)h);
        return result;
    }

    public static Vector magicSplit(String str, char delimiter) {
        String s;
        String t;
        Vector<String> result = new Vector<String>();
        if (null == str) {
            return result;
        }
        int len = str.length();
        int lastUnAddedPos = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c != delimiter) continue;
            String s2 = str.substring(lastUnAddedPos, i);
            String t2 = s2.trim();
            if (t2.length() > 0) {
                result.addElement(t2);
            }
            lastUnAddedPos = i + 1;
        }
        if (lastUnAddedPos < len - 1 && (t = (s = str.substring(lastUnAddedPos, len)).trim()).length() > 0) {
            result.addElement(t);
        }
        return result;
    }

    public static int fraction2int(int numerator, int denominator) {
        long num = numerator;
        return (int)(0xFFFFFFFFFFFFFFFFL & (num << 8) / (long)denominator);
    }

    public static int int2numerator(int representation) {
        return 0xFFFFFF & representation >>> 8;
    }

    public static int int2denominator(int representation) {
        return 256;
    }

    public static void setMIDlet(MIDlet midlet) {
        myMidlet = midlet;
    }

    public static MIDlet getMIDlet() {
        return myMidlet;
    }

    public static void setDpsTable(Hashtable dps) {
        myDps = dps;
    }

    public static int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int croll(int val, int min, int max) {
        if (val < min) {
            return max;
        }
        if (val > max) {
            return min;
        }
        return val;
    }

    public static int rnd(int max) {
        return (random.nextInt() & Integer.MAX_VALUE) % (max + 1);
    }

    public static int rnd(int min, int max) {
        return min + Util.rnd(max - min);
    }

    public static void maybeGC() {
        System.gc();
    }

    public static int PERCENT(int x, int y, int r) {
        return Util.MUL(Util.DIV(x, y), r);
    }

    public static int PERCENT(int x, int y) {
        return Util.PERCENT(x, y, 100);
    }

    public static int MUL(int x, int y) {
        return (int)((long)x * (long)y >> 16);
    }

    public static int DIV(int x, int y) {
        if (y == 0) {
            return 0;
        }
        long z = (long)x << 32;
        return (int)(z / (long)y >> 16);
    }

    public static String parseUTF(String text) {
        if (text.indexOf("\\u") >= 0) {
            StringBuffer s = new StringBuffer(text);
            int i = 0;
            char[] utf = new char[4];
            do {
                if (s.charAt(i++) != '\\' || s.charAt(i) != 'u') continue;
                s.getChars(i + 1, i + 5, utf, 0);
                s.setCharAt(i - 1, (char)Integer.parseInt(new String(utf), 16));
                s.delete(i, i + 5);
            } while (i < s.length());
            String r = s.toString();
            if (r != null && r.length() > 16) {
                r = r.substring(0, 16);
            }
            return r;
        }
        return text;
    }

    public static void setupWatchdog() {
        int wdLimit = Util.getIntParam("HO-WATCHDOG", 0);
        if (wdLimit > 0) {
            IS_WATCHDOG_ENABLED = true;
            WATCHDOG_LIMIT_MS = wdLimit;
        }
    }

    public static void tick() {
        if (!IS_WATCHDOG_ENABLED) {
            return;
        }
        long currTime = System.currentTimeMillis();
        if (WATCHDOG_VALUE < 0L) {
            WATCHDOG_VALUE = currTime;
            return;
        }
        if (currTime - WATCHDOG_VALUE >= (long)WATCHDOG_LIMIT_MS) {
            RealioCanvas.getInstance().pause();
            RealioCanvas.getInstance().resume();
        }
        WATCHDOG_VALUE = currTime;
    }

    public static void resetWatchdog() {
        WATCHDOG_VALUE = -1L;
    }

    public static String shortenName(String name, HFont font, int maxDesiredWidth) {
        boolean verbose = false;
        int nameWidth = font.stringWidth(name);
        if (maxDesiredWidth < nameWidth) {
            int substringIndex = font.getSubstringIndexForWidth(name, maxDesiredWidth -= font.stringWidth("..."));
            name = name.substring(0, substringIndex) + "...";
        }
        return name;
    }

    public static void dis_bais_unitTest(StringBuffer buf) {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6};
        if (buf.length() > 0) {
            buf.append("\n\n");
        }
        buf.append("BAIS: ");
        Util.is_unitTest(new ByteArrayInputStream(data), buf);
        if (buf.length() > 0) {
            buf.append("\n\n");
        }
        buf.append("DIS(BAIS): ");
        Util.is_unitTest(new DataInputStream(new ByteArrayInputStream(data)), buf);
    }

    public static void is_unitTest(InputStream in, StringBuffer buf) {
        if (in.markSupported()) {
            buf.append(" M");
        } else {
            buf.append("!M");
        }
        buf.append(" ");
        try {
            in.mark(Integer.MAX_VALUE);
            buf.append("1+");
        }
        catch (Throwable t) {
            buf.append("1-");
        }
        buf.append(" ");
        try {
            in.reset();
            buf.append("2+");
        }
        catch (Throwable t) {
            buf.append("2-");
        }
        buf.append(" ");
        try {
            in.close();
            buf.append("3+");
        }
        catch (Throwable t) {
            buf.append("3-");
        }
        buf.append(" ");
        try {
            in.mark(Integer.MAX_VALUE);
            buf.append("4+");
        }
        catch (Throwable t) {
            buf.append("4-");
        }
        buf.append(" ");
        try {
            in.reset();
            buf.append("5+");
        }
        catch (Throwable t) {
            buf.append("5-");
        }
    }

    public static int measureLargestContiguousFreeBlock() {
        boolean verbose = false;
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        int num = (int)(2L * freeMemory);
        int step = num / 128;
        if (step <= 0) {
            return 0;
        }
        while (num > 0) {
            try {
                byte[] buf = new byte[num];
                if (buf != null) {
                    return num;
                }
            }
            catch (OutOfMemoryError e) {
                // empty catch block
            }
            num -= step;
        }
        return 0;
    }
}

