/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.game;

import com.slg.j2me.game.FrontEnd;
import com.slg.j2me.game.GameApp;
import com.slg.j2me.game.GameEffects;
import com.slg.j2me.game.GameLogic;
import com.slg.j2me.game.GameScreen;
import com.slg.j2me.game.MapScreen;
import com.slg.j2me.game.ShopScreen;
import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.GfxUtils;
import com.slg.j2me.lib.gfx.ImageSet;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.layout.CellLayout;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.gui.layout.TextLayout;
import com.slg.j2me.lib.gui.layout.TextScrollLayout;
import com.slg.j2me.lib.snd.SoundBank;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.util.CSVLoader;
import com.slg.j2me.lib.util.MultiLingual;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class GameSequence
extends CellLayout {
    public static int competition = 0;
    public static int day = 0;
    public static int playerCash = 0;
    public static final int cCompetitionIdAmateur = 0;
    public static final int cCompetitionIdSuperBass = 1;
    public static final int cCompetitionIdKingOfLake = 2;
    public static final int cCompetitionIdFourthComp = 3;
    public static final int cCompetitionIdFifthComp = 4;
    public static final int cCompetitionNum = 5;
    public static final int cNumDays = 3;
    public static Image imgCompScreen = null;
    private static TextLayout textTitle;
    public static TextScrollLayout layoutInfo;
    private static TextLayout textInfo;
    private static BitmapFont font;
    private static BitmapFont smallfont;
    public static boolean gameInProgress;
    public static int screenPage;
    public static final int cScreenWelcome = 0;
    public static final int cScreenCompIntro = 1;
    public static final int cScreenDayIntro = 2;
    public static final int cScreenResultSummary = 3;
    public static final int cScreenFinalWeighInIntro = 4;
    public static final int cScreenFinalWeighIn = 5;
    public static final int cScreenCompSummary = 6;
    public static final int cScreenGameOver = 7;
    public static final int cScreenGameComplete = 8;
    private static final String[] cScreenNames;
    public static final int[][] cTimeLimit;
    private static final int[][] cFishPopulation;
    private static final int[][] cFishAmount;
    public static final short[][][] cCompetitors;
    public static final int[] cPlayersInRound;
    public static final int[] cPositionToAdvance;
    public static final int[] cFishAllowed;
    public static final int[] cCashPerPound;
    public static final int[] cCashPerPosition;
    public static int[][] playersThrough;
    private static int bestCatch;
    private static int avgCatch;
    private static int totalFishCaught;
    private static int totalWeight;
    private static int cutOffCatch;
    private static int playerPlace;
    private static int prizeMoney;

    public static boolean isGameInProgress() {
        return gameInProgress;
    }

    public static String cCompetitionNames(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(329) + "";
            }
            case 1: {
                return "" + MultiLingual.get(330) + "";
            }
            case 2: {
                return "" + MultiLingual.get(331) + "";
            }
            case 3: {
                return "" + MultiLingual.get(332) + "";
            }
            case 4: {
                return "" + MultiLingual.get(333) + "";
            }
        }
        return "";
    }

    public static String cCompetitionNamesA(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(334) + "";
            }
            case 1: {
                return "" + MultiLingual.get(335) + "";
            }
            case 2: {
                return "" + MultiLingual.get(336) + "";
            }
            case 3: {
                return "" + MultiLingual.get(337) + "";
            }
            case 4: {
                return "" + MultiLingual.get(338) + "";
            }
        }
        return "";
    }

    public static String cCompetitionNamesB(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(339) + "";
            }
            case 1: {
                return "" + MultiLingual.get(340) + "";
            }
            case 2: {
                return "" + MultiLingual.get(341) + "";
            }
            case 3: {
                return "" + MultiLingual.get(342) + "";
            }
            case 4: {
                return "" + MultiLingual.get(343) + "";
            }
        }
        return "";
    }

    public static String cCompetitionComplete(int i) {
        if (day == 2) {
            if (playerPlace < 25) {
                prizeMoney += cCashPerPosition[playerPlace];
            }
            playerCash += prizeMoney;
        }
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(182) + "" + "\n\n" + "" + MultiLingual.get(370) + ": $" + cCashPerPosition[playerPlace] + "\n\n";
            }
            case 1: {
                return "" + MultiLingual.get(183) + "" + "\n\n" + "" + MultiLingual.get(370) + ": $" + cCashPerPosition[playerPlace] + "\n\n";
            }
            case 2: {
                return "" + MultiLingual.get(184) + "" + "\n\n" + "" + MultiLingual.get(370) + ": $" + cCashPerPosition[playerPlace] + "\n\n";
            }
            case 3: {
                return "" + MultiLingual.get(185) + "" + "\n\n" + "" + MultiLingual.get(370) + ": $" + cCashPerPosition[playerPlace] + "\n\n";
            }
            case 4: {
                return "" + MultiLingual.get(186) + "" + "\n\n";
            }
        }
        return "";
    }

    public static String cPositionText(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(187) + "";
            }
            case 1: {
                return "" + MultiLingual.get(188) + "";
            }
            case 2: {
                return "" + MultiLingual.get(189) + "";
            }
            case 3: {
                return "" + MultiLingual.get(190) + "";
            }
        }
        return "" + (i + 1) + ".";
    }

    public static String strShopKeeperTips(int tip) {
        switch (tip) {
            case 0: {
                return "" + MultiLingual.get(250) + "";
            }
            case 1: {
                return "" + MultiLingual.get(251) + "";
            }
            case 2: {
                return "" + MultiLingual.get(252) + "";
            }
            case 3: {
                return "" + MultiLingual.get(253) + "";
            }
            case 4: {
                return "" + MultiLingual.get(254) + "";
            }
            case 5: {
                return "" + MultiLingual.get(255) + "";
            }
            case 6: {
                return "" + MultiLingual.get(256) + "";
            }
            case 7: {
                return "" + MultiLingual.get(257) + "";
            }
            case 8: {
                return "" + MultiLingual.get(258) + "";
            }
            case 9: {
                return "" + MultiLingual.get(259) + "";
            }
        }
        return "";
    }

    public static int strShopKeeperTipsLength() {
        return 10;
    }

    public static String strShopKeeperSpeech(int i) {
        switch (i) {
            case 0: {
                return "" + MultiLingual.get(260) + "";
            }
            case 1: {
                return "" + MultiLingual.get(261) + "";
            }
            case 2: {
                return "" + MultiLingual.get(262) + "";
            }
            case 3: {
                return "" + MultiLingual.get(263) + "";
            }
            case 4: {
                return "" + MultiLingual.get(264) + "";
            }
            case 5: {
                return "" + MultiLingual.get(265) + "";
            }
            case 6: {
                return "" + MultiLingual.get(266) + "";
            }
            case 7: {
                return "" + MultiLingual.get(267) + "";
            }
            case 8: {
                return "" + MultiLingual.get(268) + "";
            }
            case 9: {
                return "" + MultiLingual.get(269) + "";
            }
            case 10: {
                return "" + MultiLingual.get(270) + "";
            }
            case 11: {
                return "" + MultiLingual.get(271) + "";
            }
            case 12: {
                return "" + MultiLingual.get(272) + "";
            }
            case 13: {
                return "" + MultiLingual.get(273) + "";
            }
        }
        return "";
    }

    public static int strShopKeeperSpeechLength() {
        return 14;
    }

    public static int getCompetitionTimeInSeconds() {
        return cTimeLimit[competition][day];
    }

    public GameSequence() {
        super(2, "GameSequence");
        System.out.println("GameSequence Constructor");
        font = ScreenStack.font;
        smallfont = ScreenStack.fontSmall;
        textTitle = new TextLayout();
        GameSequence.textTitle.iLayoutFlags = 1;
        layoutInfo = new TextScrollLayout();
        textInfo = GameSequence.layoutInfo.textLayout;
        GameSequence.textInfo.iLayoutFlags = 3;
        this.loadCompetitionData();
        this.addBasicControls();
    }

    public void setupSound() {
        boolean bLoop;
        int tune = -1;
        switch (screenPage) {
            case 7: {
                tune = 2;
                break;
            }
            case 6: 
            case 8: {
                tune = 1;
                break;
            }
            default: {
                tune = 0;
            }
        }
        boolean bl = bLoop = tune == -1 ? false : GameApp.tuneLoop[tune];
        if (FrontEnd.sound && !BaseScreen.pauseDialogShown && SoundBank.currentSound != tune) {
            if (tune == 1) {
                if (GameApp.playWon) {
                    SoundBank.play(0, tune, bLoop, 0);
                    GameApp.playWon = false;
                }
            } else {
                SoundBank.play(0, tune, bLoop, 0);
                GameApp.playWon = true;
            }
        }
    }

    private void loadCompetitionData() {
        Vector _lStatData = new Vector();
        String[] _headings = CSVLoader.loadCSV("/competitors.bin", _lStatData);
        for (int i = 0; i < _headings.length; ++i) {
            if (_headings[i].compareTo("1_Day1") == 0) {
                GameSequence.cCompetitors[0][0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[0][0] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[0][0] != null with msg: Error loading 1_Day1 into cCompetitors[0][0]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[359]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("1_Day2") == 0) {
                GameSequence.cCompetitors[0][1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[0][1] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[0][1] != null with msg: Error loading 1_Day2 into cCompetitors[0][1]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[360]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("1_Day3") == 0) {
                GameSequence.cCompetitors[0][2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[0][2] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[0][2] != null with msg: Error loading 1_Day3 into cCompetitors[0][2]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[361]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("2_Day1") == 0) {
                GameSequence.cCompetitors[1][0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[1][0] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[1][0] != null with msg: Error loading 2_Day1 into cCompetitors[1][0]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[364]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("2_Day2") == 0) {
                GameSequence.cCompetitors[1][1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[1][1] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[1][1] != null with msg: Error loading 2_Day2 into cCompetitors[1][1]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[365]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("2_Day3") == 0) {
                GameSequence.cCompetitors[1][2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[1][2] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[1][2] != null with msg: Error loading 2_Day3 into cCompetitors[1][2]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[366]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("3_Day1") == 0) {
                GameSequence.cCompetitors[2][0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[2][0] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[2][0] != null with msg: Error loading 3_Day1 into cCompetitors[2][0]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[369]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("3_Day2") == 0) {
                GameSequence.cCompetitors[2][1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[2][1] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[2][1] != null with msg: Error loading 3_Day2 into cCompetitors[2][1]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[370]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("3_Day3") == 0) {
                GameSequence.cCompetitors[2][2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[2][2] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[2][2] != null with msg: Error loading 3_Day3 into cCompetitors[2][2]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[371]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("4_Day1") == 0) {
                GameSequence.cCompetitors[3][0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[3][0] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[3][0] != null with msg: Error loading 4_Day1 into cCompetitors[3][0]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[374]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("4_Day2") == 0) {
                GameSequence.cCompetitors[3][1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[3][1] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[3][1] != null with msg: Error loading 4_Day2 into cCompetitors[3][1]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[375]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("4_Day3") == 0) {
                GameSequence.cCompetitors[3][2] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[3][2] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[3][2] != null with msg: Error loading 4_Day3 into cCompetitors[3][2]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[376]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("5_Day1") == 0) {
                GameSequence.cCompetitors[4][0] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[4][0] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[4][0] != null with msg: Error loading 5_Day1 into cCompetitors[4][0]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[379]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("5_Day2") == 0) {
                GameSequence.cCompetitors[4][1] = CSVLoader.getCSVShortArray(_lStatData, i);
                if (cCompetitors[4][1] != null) continue;
                System.out.println("Assertion Failure: cCompetitors[4][1] != null with msg: Error loading 5_Day2 into cCompetitors[4][1]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[380]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (_headings[i].compareTo("5_Day3") != 0) continue;
            GameSequence.cCompetitors[4][2] = CSVLoader.getCSVShortArray(_lStatData, i);
            if (cCompetitors[4][2] != null) continue;
            System.out.println("Assertion Failure: cCompetitors[4][2] != null with msg: Error loading 5_Day3 into cCompetitors[4][2]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[381]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _lStatData.removeAllElements();
        for (int i = 0; i < 5; ++i) {
            System.out.println("Checking Competition : " + i);
            for (int day = 0; day < cPlayersInRound.length; ++day) {
                if (cCompetitors[i][day].length != 10) {
                    System.out.println("Assertion Failure: cCompetitors[i][day].length == GameLogic.cMaxFishermenTypes with msg: comp: " + i + " day " + day + " length is incorrect: " + cCompetitors[i][day].length + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java" + "[" + 390 + "]");
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int sum = 0;
                for (int c = 0; c < cCompetitors[i][day].length; c = (int)((short)(c + 1))) {
                    sum += cCompetitors[i][day][c];
                }
                if (sum == cPlayersInRound[day] - 1) continue;
                System.out.println("Assertion Failure: sum == (cPlayersInRound[day]-1) with msg: Day has invalid competitor info, it should be equal to " + (cPlayersInRound[0] - 1) + " not " + sum + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java" + "[" + 396 + "]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addBasicControls() {
        this.setRow(0, 1, 1);
        this.setRow(1, 1, 10);
        this.setCell(0, 0, textTitle, 1, 0);
        this.setCell(1, 0, layoutInfo, 1, 0);
        FrontEnd.instance.menuButtons = 2;
    }

    public static void newGame() {
        System.out.println("GameSequence newGame()");
        day = 0;
        competition = 0;
        screenPage = 0;
        playerCash = 0;
        gameInProgress = false;
        MapScreen.lockDefaultLocations();
        ShopScreen.resetInventory();
        System.out.println("GameSequence newGame() END");
    }

    public static void gameOver(boolean disqualified) {
        screenPage = 3;
    }

    public static void weighInOver(int place) {
        System.out.println("weighInOver-placed: " + place);
        playerPlace = place;
        screenPage = playerPlace <= 2 ? 6 : 7;
    }

    public String getDayName() {
        switch (day) {
            case 0: {
                return "" + MultiLingual.get(344) + "";
            }
            case 1: {
                return "" + MultiLingual.get(345) + "";
            }
            case 2: {
                return "" + MultiLingual.get(346) + "";
            }
        }
        return "Error";
    }

    public void open() {
        System.out.println("GameSequence.open()");
        imgCompScreen = ImageSet.loadImage("/competition-screen.png");
        if (screenPage == 0 && day > 0) {
            this.nextScreen(2);
        } else if (screenPage == 0 || screenPage == 7 || screenPage == 6) {
            this.nextScreen(screenPage);
        } else if (screenPage == 3) {
            System.out.println("GameSequence.open() - setting up results");
            textTitle.clearText();
            textTitle.formatText(font, this.getDayName());
            this.nextScreen(3);
        }
        GameSequence.textTitle.clipRect.x0 = 0;
        GameSequence.textInfo.clipRect.x0 = 0;
        this.layout();
        super.open();
        ScreenStack.doTransition(textTitle, 20, 250, 200);
        ScreenStack.doTransition(textInfo, 17, 400, 500);
    }

    public void close() {
        System.out.println("GameSequence.close()");
        imgCompScreen = null;
        if (textInfo != null) {
            textInfo.clearText();
        }
        super.close();
    }

    public void layout() {
        super.layout();
    }

    public void paint(Graphics g) {
        boolean bTrophy = this.isOnCompCompleteScreen();
        if (imgCompScreen == null || bTrophy) {
            g.setColor(0);
            g.fillRect(0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        }
        if (bTrophy) {
            GameScreen.gameEffects.drawTrophyBackground(g);
            FrontEnd.gfxMenuTitle.drawImage(g, 0, BaseScreen.displayWidth - FrontEnd.gfxMenuTitle.getRectWidth(0) >> 1, BaseScreen.getScaledY(8));
            GameEffects.drawConfetti(g, FrontEnd.gfxConfetti);
        } else if (imgCompScreen != null) {
            g.drawImage(imgCompScreen, 0, 0, 0x10 | 4);
            GfxUtils.drawCrossHatch(g, 0, 0, 0, BaseScreen.displayWidth, BaseScreen.displayHeight);
        }
        super.paint(g);
    }

    public void process() {
        boolean bHitFire = ScreenLayout.keysDown(32768);
        boolean bHitBack = ScreenLayout.keysDown(65536);
        this.setupSound();
        switch (screenPage) {
            case 0: {
                if (!bHitFire) break;
                this.nextScreen(1);
                break;
            }
            case 1: {
                if (!bHitFire) break;
                this.nextScreen(2);
                break;
            }
            case 6: {
                if (!bHitFire) break;
                day = 0;
                if (++competition != 5) {
                    MapScreen.unlockAreaForCompetition(competition);
                    FrontEnd.instance.updateCompTitle();
                    GameApp.autoSave();
                    this.nextScreen(1);
                    break;
                }
                this.nextScreen(8);
                break;
            }
            case 3: {
                if (!bHitFire) break;
                if (day == 2) {
                    if (GameLogic.getFishCount(GameLogic.competitorFish[0]) > 0) {
                        this.nextScreen(5);
                        break;
                    }
                    gameInProgress = false;
                    this.nextScreen(7);
                    break;
                }
                if (playerPlace <= cPositionToAdvance[day] && GameLogic.getFishCount(GameLogic.competitorFish[0]) > 0) {
                    ++day;
                    GameApp.autoSave();
                    this.nextScreen(2);
                    break;
                }
                gameInProgress = false;
                this.nextScreen(7);
                break;
            }
            case 2: {
                if (!bHitFire) break;
                this.startNextGame(false);
                break;
            }
            case 7: {
                if (!bHitFire) break;
                this.startNextGame(true);
                break;
            }
            case 8: {
                if (!bHitFire) break;
                bestCatch = 0;
                avgCatch = 0;
                totalFishCaught = 0;
                totalWeight = 0;
                cutOffCatch = 0;
                playerPlace = 0;
                prizeMoney = 0;
                FrontEnd.kempyAvailable = true;
                GameApp.autoSave();
                GameApp.deleteStore(0);
                FrontEnd.gameCompleted = true;
                FrontEnd.bAllowCreditsSkip = false;
                gameInProgress = false;
                GameApp.frontEnd.popScreenUntil(FrontEnd.menuMain, null);
                GameApp.frontEnd.pushScreen(FrontEnd.textCredits, false);
                break;
            }
            case 4: {
                if (!bHitFire) break;
                this.nextScreen(5);
            }
        }
        if (bHitFire || bHitBack) {
            BaseScreen.resetKeys();
        }
    }

    private void nextScreen(int screen) {
        System.out.println("nextScreen() - " + cScreenNames[screen]);
        switch (screen) {
            case 0: {
                String intro = "";
                switch (competition) {
                    case 0: {
                        intro = "" + MultiLingual.get(348) + "";
                        break;
                    }
                    case 1: {
                        intro = "" + MultiLingual.get(349) + "";
                        break;
                    }
                    case 2: {
                        intro = "" + MultiLingual.get(350) + "";
                    }
                }
                this.setBasicScreen(this.getDayName(), intro, 3);
                break;
            }
            case 1: {
                this.setupCompIntro();
                break;
            }
            case 2: {
                String intro = "";
                intro = day == 0 ? "" + MultiLingual.get(360) + ": " + " " + MultiLingual.get(361) + "\n" : "" + MultiLingual.get(363) + "\n";
                this.setBasicScreen(this.getDayName(), intro, 2);
                break;
            }
            case 3: {
                this.setupGameResult();
                break;
            }
            case 4: {
                this.setBasicScreen("" + MultiLingual.get(358) + "", "" + MultiLingual.get(325) + "\n\n" + MultiLingual.get(326) + "\n\n" + MultiLingual.get(327) + "\n", 2);
                break;
            }
            case 5: {
                this.setupFinalWeighIn();
                break;
            }
            case 6: {
                GameEffects.initConfetti();
                this.setupCompSummary();
                break;
            }
            case 7: {
                gameInProgress = false;
                this.setupGameOver();
                break;
            }
            case 8: {
                this.setupGameComplete();
            }
        }
        this.layout();
        screenPage = screen;
        BaseScreen.resetKeys();
    }

    public static int getNumDays() {
        return 3;
    }

    public void startNextGame(boolean _continue) {
        Application.setAppLoading();
        System.out.println("startNextGame() - day " + day);
        try {
            GameApp.gameScreen.newGame();
            GameLogic.initCompetitors(cPlayersInRound[day], cCompetitors[competition][day], cFishAllowed[day]);
            GameScreen.gameTime = cTimeLimit[competition][day] * 1000;
            GameApp.gameScreen.biggestFishWeight = 0;
            GameScreen.setTickerMessage("");
            gameInProgress = true;
            MapScreen.resetPopulation();
            if (prizeMoney <= 0) {
                GameApp.gameScreen.updateSelectedItems();
                FrontEnd.instance.mapScreen.resetBoat();
                FrontEnd.instance.pushScreen(FrontEnd.instance.mapScreen, true);
            } else {
                FrontEnd.instance.pushScreen(FrontEnd.instance.shopScreen, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupGameResult() {
        System.out.println("setupGameResult() " + day + 1);
        int weight = GameLogic.getFishWeight(GameLogic.competitorFish[0]);
        GameSequence.storeTopFishermen();
        GameSequence.summariseRound();
        textInfo.clearText();
        textInfo.formatText(smallfont, "" + MultiLingual.get(366) + ": " + GameLogic.getFishCount(GameLogic.competitorFish[0]) + " " + MultiLingual.get(367) + "\n" + MultiLingual.get(368) + ": " + GameScreen.getWeightString(weight) + "\n\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(369) + ": " + (playerPlace + 1) + "\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(370) + ": $" + prizeMoney + "\n\n");
        playerCash += prizeMoney;
        textInfo.formatText(smallfont, "" + MultiLingual.get(371) + ": " + GameScreen.getWeightString(bestCatch) + "\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(372) + ": " + GameScreen.getWeightString(cutOffCatch) + "\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(373) + ": " + GameScreen.getWeightString(avgCatch) + "\n");
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setupCompIntro() {
        textTitle.clearText();
        textTitle.formatText(font, GameSequence.cCompetitionNamesA(competition));
        textInfo.clearText();
        String intro = "** " + GameSequence.cCompetitionNamesB(competition) + " **\n\n" + "" + MultiLingual.get(353) + "\n" + "" + MultiLingual.get(354) + " " + cPositionToAdvance[day] + " " + MultiLingual.get(355) + "\n" + "" + MultiLingual.get(356) + "\n\n";
        textInfo.formatText(smallfont, intro);
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setupCompSummary() {
        textInfo.clearText();
        textInfo.formatText(smallfont, GameSequence.cCompetitionComplete(competition) + "\n");
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setupGameComplete() {
        textTitle.clearText();
        textTitle.formatText(font, "" + MultiLingual.get(171) + "");
        textInfo.clearText();
        if (MultiLingual.lang == 0) {
            textInfo.formatText(smallfont, "\nGreat fishing, you've completed");
            textInfo.formatText(smallfont, " BassFishingMania3\n\n");
        } else if (MultiLingual.lang == 0) {
            textInfo.formatText(smallfont, "\nQuel p\u00eacheur\u00a0! Vous avez .");
            textInfo.formatText(smallfont, " termin\u00e9 BassFishingMania3\n\n");
        } else if (MultiLingual.lang == 0) {
            textInfo.formatText(smallfont, "\nOttima pesca. Hai completato ");
            textInfo.formatText(smallfont, " BassFishingMania3.\n\n");
        } else if (MultiLingual.lang == 0) {
            textInfo.formatText(smallfont, "\nTolles Angeln! Du hast ");
            textInfo.formatText(smallfont, " BassFishingMania3 abgeschlossen.\n\n");
        } else if (MultiLingual.lang == 0) {
            textInfo.formatText(smallfont, "\nBuena pesca, has completado ");
            textInfo.formatText(smallfont, " BassFishingMania3\n\n");
        }
        if (!FrontEnd.kempyAvailable) {
            textInfo.formatText(smallfont, "" + MultiLingual.get(174) + "\n\n");
        }
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setupGameOver() {
        textTitle.clearText();
        textTitle.formatText(font, "" + MultiLingual.get(169) + "");
        textInfo.clearText();
        if (day != 2 || GameLogic.getFishCount(GameLogic.competitorFish[0]) == 0) {
            textInfo.formatText(font, GameSequence.cPositionText(playerPlace) + "\n\n");
            textInfo.formatText(smallfont, "\n" + MultiLingual.get(172) + "\n\n");
        }
        textInfo.formatText(smallfont, "" + MultiLingual.get(170) + "\n\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(181) + "\n");
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setupDisqualified() {
        textTitle.clearText();
        textTitle.formatText(font, "" + MultiLingual.get(178) + "");
        textInfo.clearText();
        textInfo.formatText(smallfont, "" + MultiLingual.get(179) + "\n\n\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(180) + "\n\n");
        textInfo.formatText(smallfont, "" + MultiLingual.get(181) + "\n");
        this.layout();
        FrontEnd.instance.menuButtons = 2;
    }

    public void setBasicScreen(String title, String text, int buttons) {
        textTitle.clearText();
        textTitle.formatText(font, title);
        textInfo.clearText();
        textInfo.formatText(smallfont, text);
        this.layout();
        FrontEnd.instance.menuButtons = buttons;
    }

    public void setupFinalWeighIn() {
        GameSequence.storeTopFishermen();
        GameSequence.summariseRound();
        for (int i = 0; i < GameLogic.competitorFish.length - 1; ++i) {
            for (int f = 0; f < GameLogic.competitorFish[i].length - 1; ++f) {
                GameLogic.competitorFish[i][f] = playersThrough[i][f + 1];
            }
        }
        FrontEnd.instance.startWeighIn();
    }

    public void setupArcadeWeighIn() {
        FrontEnd.instance.startWeighIn();
    }

    public boolean isOnCompCompleteScreen() {
        return screenPage == 6 && competition < 5;
    }

    private static void storeTopFishermen() {
        int i;
        int[][] totalCatch = new int[cPlayersInRound[day]][3];
        int heaviest = 0;
        int playerId = 0;
        int currentPlayerThrough = 0;
        int topPlayer = 0;
        for (int c = 0; c < GameLogic.competitorFish.length; ++c) {
            heaviest = GameLogic.getHeaviestFish(GameLogic.competitorFish[c]);
            totalCatch[c][0] = c;
            totalCatch[c][1] = heaviest;
            totalCatch[c][2] = 0;
        }
        GameSequence.playersThrough[currentPlayerThrough][0] = totalCatch[0][0];
        GameSequence.playersThrough[currentPlayerThrough][GameSequence.day + 1] = totalCatch[0][1];
        System.out.println("PLAYER THROUGH:" + playersThrough[currentPlayerThrough][0] + " Catch:" + playersThrough[currentPlayerThrough][1]);
        ++currentPlayerThrough;
        heaviest = 0;
        while (currentPlayerThrough < playersThrough.length - 1) {
            for (i = 1; i < totalCatch.length; ++i) {
                if (totalCatch[i][1] < heaviest || totalCatch[i][2] != 0) continue;
                playerId = totalCatch[i][0];
                heaviest = totalCatch[i][1];
                topPlayer = i;
            }
            totalCatch[topPlayer][2] = 1;
            GameSequence.playersThrough[currentPlayerThrough][0] = playerId;
            GameSequence.playersThrough[currentPlayerThrough][GameSequence.day + 1] = heaviest;
            System.out.println("PLAYER THROUGH:" + playersThrough[currentPlayerThrough][0] + " Catch:" + playersThrough[currentPlayerThrough][1]);
            ++currentPlayerThrough;
            heaviest = 0;
        }
        System.out.println("HEAVIEST FOR PLAYER (SORTED): " + playersThrough[currentPlayerThrough][0] + " is " + playersThrough[currentPlayerThrough][day + 1] + " ounces.");
        for (currentPlayerThrough = 0; currentPlayerThrough < playersThrough.length - 1; ++currentPlayerThrough) {
            for (i = 1; i < 4; ++i) {
                System.out.println("PLAYER: " + playersThrough[currentPlayerThrough][0] + " is " + playersThrough[currentPlayerThrough][i] + " ounces.");
            }
        }
    }

    private static void summariseRound() {
        bestCatch = 0;
        avgCatch = 0;
        totalFishCaught = 0;
        totalWeight = 0;
        cutOffCatch = 0;
        playerPlace = 0;
        prizeMoney = 0;
        int[] totalCatch = new int[cPlayersInRound[day]];
        for (int c = 0; c < GameLogic.competitorFish.length; ++c) {
            int weight;
            totalCatch[c] = weight = GameLogic.getFishWeight(GameLogic.competitorFish[c]);
            totalWeight += weight;
            totalFishCaught += GameLogic.getFishCount(GameLogic.competitorFish[c]);
        }
        int pWeight = GameLogic.getFishWeight(GameLogic.competitorFish[0]);
        prizeMoney = pWeight / 16 * cCashPerPound[competition];
        avgCatch = totalWeight / cPlayersInRound[day];
        GameLogic.SORT_shellSortNC(totalCatch, null, false, null);
        bestCatch = totalCatch[0];
        cutOffCatch = totalCatch[cPlayersInRound[day] / 2 - 1];
        for (int c = 0; c < totalCatch.length; ++c) {
            if (pWeight != totalCatch[c]) continue;
            playerPlace = c;
            break;
        }
        System.out.println("PLAYER PLACE:" + playerPlace);
        System.out.println("PLAYER MONEY:" + prizeMoney);
    }

    public void initFishInCurrentLocation() {
        int i;
        GameScreen.game.initFishInSpot();
        int loc = MapScreen.currentFishingSpot;
        if (MapScreen.fishingSpotPopulated[loc]) {
            GameSequence.restoreFishPopulation(loc);
            return;
        }
        int numFish = GameLogic.randRange(cFishAmount[loc][0], cFishAmount[loc][1] < 18 ? cFishAmount[loc][1] : 18);
        System.out.println("Adding " + numFish + " to the current location");
        int[] fishChances = cFishPopulation[loc];
        int biggestType = 0;
        for (i = fishChances.length - 1; i >= 0; --i) {
            if (fishChances[i] == 0) continue;
            biggestType = i;
            break;
        }
        GameScreen.game.setBiggestFishType(biggestType);
        for (i = 0; i < numFish; ++i) {
            int randomCount = GameLogic.randRange(0, 99);
            int type = 0;
            for (int f = fishChances.length - 1; f >= 0; --f) {
                if (randomCount >= fishChances[f]) continue;
                System.out.println("Adding Fish type: " + GameLogic.cFishNames[f]);
                type = f;
                break;
            }
            if (day < 2 && competition == 0 && type > 3) {
                type = 3;
            }
            GameScreen.game.addFishToSpot(type);
        }
    }

    public static void saveFishPopulation(int loc) {
        if (loc < 0 || loc > 9) {
            System.out.println("Assertion Failure: (loc >= 0) && (loc <= MapScreen.numFishingSpots)\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[1263]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MapScreen.fishingSpotPopulated[loc] = true;
        GameLogic g = GameScreen.game;
        int numFish = 0;
        for (int i = 0; i < g.numFish; ++i) {
            if (g.fishState[i] == 3) continue;
            MapScreen.fishingSpotPopulation[loc][numFish++] = g.fishType[i];
        }
        MapScreen.fishingSpotPopulationSize[loc] = numFish;
    }

    public static void restoreFishPopulation(int loc) {
        if (loc < 0 || loc > 9) {
            System.out.println("Assertion Failure: (loc >= 0) && (loc <= MapScreen.numFishingSpots)\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[1282]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!MapScreen.fishingSpotPopulated[loc]) {
            System.out.println("Assertion Failure: MapScreen.fishingSpotPopulated[loc]\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[1283]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GameLogic g = GameScreen.game;
        int numFish = MapScreen.fishingSpotPopulationSize[loc];
        for (int i = 0; i < numFish; ++i) {
            g.addFishToSpot(MapScreen.fishingSpotPopulation[loc][i]);
        }
        if (g.numFish != numFish) {
            System.out.println("Assertion Failure: g.numFish == numFish\nD:\\FLWBF2_CODE\\FLWBF2_K800\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC\\FLWBF2_SonyEricsson_K800i_v0-3-0_SRC/src/master_code/com/slg/j2me/game/GameSequence.java[1292]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadGame(DataInputStream inputStream) {
        System.out.println("GameSequence.loadGame()");
        GameSequence.newGame();
        try {
            int i;
            competition = inputStream.readInt();
            day = inputStream.readInt();
            playerCash = inputStream.readInt();
            for (i = 0; i < ShopScreen.inventory.length; ++i) {
                for (int j = 0; j < ShopScreen.inventory[i].length; ++j) {
                    ShopScreen.inventory[i][j] = inputStream.readBoolean();
                }
            }
            MapScreen.lockDefaultLocations();
            for (i = 0; i <= competition; ++i) {
                MapScreen.unlockAreaForCompetition(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveGame(DataOutputStream dataStream) {
        System.out.println("GameSequence.saveGame()");
        try {
            dataStream.writeInt(competition);
            dataStream.writeInt(day);
            dataStream.writeInt(playerCash);
            for (int i = 0; i < ShopScreen.inventory.length; ++i) {
                for (int j = 0; j < ShopScreen.inventory[i].length; ++j) {
                    dataStream.writeBoolean(ShopScreen.inventory[i][j]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        gameInProgress = false;
        screenPage = 0;
        cScreenNames = new String[]{"Welcome", "CompIntro", "DayIntro", "ResultSummary", "FinalWeighInINTRO", "FinalWeighIn", "CompSummary", "GameOver", "GameComplete"};
        cTimeLimit = new int[][]{{180, 180, 180, 180}, {180, 180, 180, 180}, {180, 180, 180, 180}, {180, 180, 180, 180}, {180, 180, 180, 180}};
        cFishPopulation = new int[][]{{0, 100, 50, 20, 0}, {0, 100, 80, 40, 0}, {0, 100, 80, 40, 0}, {0, 100, 40, 10, 0}, {100, 40, 10, 0, 0}, {0, 0, 100, 70, 40}, {0, 0, 100, 80, 40}, {0, 0, 100, 90, 70}, {100, 40, 10, 0, 0}};
        cFishAmount = new int[][]{{4, 8}, {6, 8}, {6, 12}, {6, 12}, {5, 12}, {5, 12}, {5, 12}, {5, 12}, {5, 12}};
        cCompetitors = new short[5][3][];
        cPlayersInRound = new int[]{50, 30, 10};
        cPositionToAdvance = new int[]{30, 10, 10};
        cFishAllowed = new int[]{3, 3, 3, 3, 3};
        cCashPerPound = new int[]{5, 5, 5, 5, 5};
        cCashPerPosition = new int[]{1000, 800, 700, 600, 500, 450, 400, 350, 300, 250, 200, 150, 100, 100, 100, 100, 100, 50, 50, 50, 50, 50, 50, 50, 50};
        playersThrough = new int[cPlayersInRound[1]][4];
        bestCatch = 0;
        avgCatch = 0;
        totalFishCaught = 0;
        totalWeight = 0;
        cutOffCatch = 0;
        playerPlace = 0;
        prizeMoney = 0;
    }
}

