/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameObject;
import com.renderedideas.gamemanager.MessageQueue;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.yourgamename.BitmapCacher;
import com.renderedideas.yourgamename.Player;
import com.renderedideas.yourgamename.Target;
import javax.microedition.lcdui.Graphics;

public class GameObjectManager {
    public static ArrayList gameObjectList;
    public static MessageQueue msgQueue;
    public static boolean removeThisObject;
    public static Player player;
    public static Target target;

    public GameObjectManager() {
        gameObjectList = new ArrayList();
        player = new Player();
        target = new Target();
        gameObjectList.addElement(target);
        gameObjectList.addElement(player);
        msgQueue = new MessageQueue();
        GameObjectManager.msgQueue.messageFont = BitmapCacher.gameFont;
    }

    public void updateObjects() {
        for (int i = 0; i < gameObjectList.size(); ++i) {
            GameObject gameObject = (GameObject)gameObjectList.elementAt(i);
            removeThisObject = false;
            gameObject.updateObject();
            if (!removeThisObject) continue;
            gameObjectList.removeElement(gameObject);
            --i;
        }
        msgQueue.update();
        this.detectCollision();
    }

    public void paintObjects(Graphics g2) {
        msgQueue.paint(g2);
    }

    public void detectCollision() {
    }

    public void paintTarget(Graphics g2) {
        target.paintObject(g2);
    }

    public void paintPlayer(Graphics g2) {
        player.paintObject(g2);
    }

    public void deallocate() {
        gameObjectList.removeAllElements();
        GameObjectManager.msgQueue.messageList.removeAllElements();
        GameObjectManager.msgQueue.messageFont = null;
        msgQueue = null;
        player = null;
        target = null;
    }

    static {
        removeThisObject = false;
    }
}

