/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Joint
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private boolean e;
    private float f;
    private FXMatrix g = new FXMatrix();
    private FXVector h = new FXVector();
    private FXVector i = new FXVector();
    private FXVector j = new FXVector();
    private float k = 0.0f;
    private float l;
    private FXVector m = new FXVector();
    private static FXVector n = new FXVector();
    private static FXVector o = new FXVector();
    protected UserData mUserData = null;

    public Joint(Body body, Body body2, FXVector fXVector, FXVector fXVector2, boolean bl) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        this.e = bl;
        if (this.a != null && this.b != null) {
            this.f = FXUtil.wrapAngleFX(this.a.mRotation2FX - this.b.mRotation2FX);
        }
    }

    protected Joint(Joint joint, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = joint.a;
            this.b = joint.b;
        } else {
            this.a = bodyArray[joint.a.mId];
            this.b = bodyArray[joint.b.mId];
        }
        this.c = new FXVector(joint.c);
        this.d = new FXVector(joint.d);
        this.e = joint.e;
        this.f = joint.f;
        if (joint.mUserData != null) {
            this.mUserData = joint.mUserData.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Joint(this, bodyArray);
    }

    private Joint() {
    }

    public static Joint loadJoint(PhysicsFileReader object, Vector vector, UserData userData) {
        Joint joint = new Joint();
        new Joint().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.c = ((PhysicsFileReader)object).nextVector();
        joint.b = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.d = ((PhysicsFileReader)object).nextVector();
        joint.e = ((PhysicsFileReader)object).next() > 0;
        joint.f = FXUtil.wrapAngleFX(joint.a.mRotation2FX - joint.b.mRotation2FX);
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                joint.mUserData = userData.createNewUserData((String)object, 4);
            }
        }
        return joint;
    }

    public void setCollisionLayer(int n) {
        this.a.addCollisionLayer(n);
        this.b.addCollisionLayer(n);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public void setBody1(Body body) {
        this.a = body;
    }

    protected void setBody2(Body body) {
        this.b = body;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public boolean isFixed() {
        return this.e;
    }

    public void precalculate(float f2) {
        float f3 = this.a.getInvMass2FX();
        float f4 = this.b.getInvMass2FX();
        float f5 = this.a.getInvInertia2FX();
        float f6 = this.b.getInvInertia2FX();
        this.a.getRotationMatrix().mult(-this.c.yFX, this.c.xFX, this.h);
        this.b.getRotationMatrix().mult(this.d.yFX, -this.d.xFX, this.i);
        FXVector fXVector = this.h;
        FXVector fXVector2 = this.i;
        this.g.mCol1xFX = (f3 += f4) + (fXVector.xFX * fXVector.xFX * f5 + fXVector2.xFX * fXVector2.xFX * f6);
        this.g.mCol2xFX = this.g.mCol1yFX = fXVector.xFX * fXVector.yFX * f5 + fXVector2.xFX * fXVector2.yFX * f6;
        this.g.mCol2yFX = f3 + (fXVector.yFX * fXVector.yFX * f5 + fXVector2.yFX * fXVector2.yFX * f6);
        this.g.invert();
        this.a.getAbsoluePoint(this.c, n);
        this.b.getAbsoluePoint(this.d, o);
        this.j.assignDiff(o, n);
        this.j.multFX(f2);
        this.j.multFX(0.25f);
        if (this.e) {
            this.l = f5 + f6;
            this.k = FXUtil.angleDiffFX(this.f, FXUtil.wrapAngleFX(this.a.mRotation2FX - this.b.mRotation2FX)) * f2 * 0.75f;
        }
    }

    public boolean applyMomentum(float f2) {
        if (this.e && this.l != 0.0f) {
            f2 = (this.a.mAngularVelocity2FX - this.b.mAngularVelocity2FX - this.k) / this.l;
            this.a.applyTorque(f2);
            this.b.applyTorque(-f2);
        }
        FXVector fXVector = o;
        fXVector.assignFX(this.a.mVelocityFX.xFX - this.h.xFX * this.a.mAngularVelocity2FX - this.b.mVelocityFX.xFX - this.i.xFX * this.b.mAngularVelocity2FX, this.a.mVelocityFX.yFX - this.h.yFX * this.a.mAngularVelocity2FX - this.b.mVelocityFX.yFX - this.i.yFX * this.b.mAngularVelocity2FX);
        fXVector.subtract(this.j);
        fXVector.mult(-1);
        this.g.mult(fXVector, n);
        fXVector = n;
        this.a.applyMomentum(fXVector);
        this.a.applyTorque(fXVector.xFX * this.h.xFX + fXVector.yFX * this.h.yFX);
        this.b.applyTorque(fXVector.xFX * this.i.xFX + fXVector.yFX * this.i.yFX);
        fXVector.mult(-1);
        this.b.applyMomentum(fXVector);
        fXVector.mult(-1);
        this.m.xFX = fXVector.xFX;
        this.m.yFX = fXVector.yFX;
        return fXVector.fastLengthFX() < 0.00390625f;
    }

    public void postStep() {
    }

    public float getImpulseFX() {
        return this.m.lengthFX();
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Joint && ((Joint)constraint).a.equals(this.a) && ((Joint)constraint).b.equals(this.b) && ((Joint)constraint).c.xFX == this.c.xFX && ((Joint)constraint).c.yFX == this.c.yFX && this.isFixed() == ((Joint)constraint).isFixed();
    }

    public void setFixPoint(FXVector fXVector) {
        if (this.a != null) {
            this.c = this.a.getRelativePoint(fXVector);
        }
        if (this.b != null) {
            this.d = this.b.getRelativePoint(fXVector);
        }
        if (this.a != null && this.b != null) {
            this.f = FXUtil.wrapAngleFX(this.a.rotation2FX() - this.b.rotation2FX());
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

