/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameView;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Utility3D;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.Model3D;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Sound;
import com.renderedideas.platform.Storage;
import com.renderedideas.yourgamename.Game;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Transform;

public class GameManager {
    public static GameManager instance;
    public static int screenHeight;
    public static int screenWidth;
    public static boolean soundMixing;
    public static int maxSoundSupported;
    public static GameView currentView;
    public static boolean isUUIDObtained;
    public static String bufferStrUUID;
    public static String UUID;
    public static Graphics3D g3d;
    public static Light light;
    public static Camera cam;
    public static Transform cameraTransform;
    public static float[] cameraPosition;
    public static float[] cameraLookAt;

    public GameManager() {
        instance = this;
        screenWidth = PlatformService.getWidth();
        screenHeight = PlatformService.getHeight();
        maxSoundSupported = Sound.maxSoundSupported("/audio/click.wav");
        soundMixing = PlatformService.isSoundMixingSupported();
        isUUIDObtained = Storage.readData("UUID") != null;
        UUID = Storage.readData("UUID");
    }

    public void update() {
        try {
            if (currentView != null) {
                currentView.update();
            } else {
                Debug.print("Game.update:->currentCanvas null");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void paint(Graphics graphics, float extrapolationFactor) {
        try {
            if (currentView != null) {
                if (g3d != null && currentView instanceof GameView3D) {
                    GameView3D currentView3D = (GameView3D)currentView;
                    currentView3D.paint2D_before(graphics);
                    g3d.bindTarget((Object)graphics, false, 0);
                    g3d.setViewport(0, 0, screenWidth, screenHeight);
                    g3d.setCamera(cam, cameraTransform);
                    currentView3D.paint3D_before(g3d);
                    g3d.releaseTarget();
                    currentView3D.paint2D_after(graphics);
                    g3d.bindTarget((Object)graphics, false, 0);
                    g3d.setViewport(0, 0, screenWidth, screenHeight);
                    g3d.setCamera(cam, cameraTransform);
                    currentView3D.paint3D_after(g3d);
                    g3d.releaseTarget();
                }
                currentView.paint(graphics, extrapolationFactor);
            } else {
                Debug.print("Game.paint:->currentCanvas null");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void pause() {
        if (currentView != null) {
            currentView.pause();
        } else {
            Debug.print("Game.pause:->currentCanvas null");
        }
    }

    public void resume() {
        if (currentView != null) {
            currentView.resume();
        } else {
            Debug.print("Game.resume:->currentCanvas null");
        }
    }

    public void keyPressed(int key) {
        if (currentView != null) {
            currentView.keyPressed(key);
        } else {
            Debug.print("Game.keyPressed:->currentCanvas null");
        }
        this.processUUID(key, key);
    }

    public void keyReleased(int key) {
        if (currentView != null) {
            currentView.keyReleased(key);
        } else {
            Debug.print("Game.keyReleased:->currentCanvas null");
        }
    }

    public void keyRepeated(int key) {
        if (currentView != null) {
            currentView.keyRepeated(key);
        } else {
            Debug.print("Game.keyRepeated:->currentCanvas null");
        }
    }

    public void pointerDragged(int pointerID, int xx, int yy) {
        if (currentView != null) {
            currentView.pointerDragged(pointerID, xx, yy);
        } else {
            Debug.print("Game.pointerDragged:->currentCanvas null");
        }
    }

    public void pointerPressed(int pointerID, int xx, int yy) {
        if (currentView != null) {
            currentView.pointerPressed(pointerID, xx, yy);
        } else {
            Debug.print("Game.pointerPressed:->currentCanvas null");
        }
        this.processUUID(xx, yy);
    }

    public void pointerReleased(int pointerID, int xx, int yy) {
        if (currentView != null) {
            currentView.pointerReleased(pointerID, xx, yy);
        } else {
            Debug.print("Game.pointerReleased:->currentCanvas null");
        }
    }

    public void handleSwipe(int direction) {
        if (currentView != null) {
            currentView.handleSwipe(direction);
        } else {
            Debug.print("Game.handleSwipe:->currentCanvas null");
        }
    }

    public void onBackKey() {
        if (currentView != null) {
            currentView.onBackKey();
        } else {
            Debug.print("Game.onBackKey:->currentCanvas null");
        }
    }

    public void commandAction(Command c2) {
        if (currentView != null) {
            currentView.commandAction(c2);
        } else {
            Debug.print("Game.commandAction:->currentCanvas null");
        }
    }

    public void processUUID(int x, int y) {
        if (!isUUIDObtained) {
            bufferStrUUID = bufferStrUUID + x + y;
        }
        if (!isUUIDObtained && bufferStrUUID.length() > 13) {
            GameManager.generateUUID();
        }
    }

    public static void generateUUID() {
        UUID = PlatformService.getUUID(bufferStrUUID);
        isUUIDObtained = true;
        Storage.saveData("UUID", UUID);
    }

    public static void coinPack1Purchased() {
        String m = "5554co875p45yr234i45gh5546t 56546re353q4nde6656re8857d 45ide06045as4534";
        if (m.equals("A")) {
            return;
        }
    }

    public static void coinPack2Purchased() {
    }

    public static void coinPack3Purchased() {
    }

    public static void setUpM3G() {
        if (g3d != null) {
            return;
        }
        try {
            g3d = Graphics3D.getInstance();
            cameraTransform = new Transform();
            GameManager.loadCamera();
            light = new Light();
            light.setMode(128);
            light.setColor(0xFFFFFF);
            light.setIntensity(10.0f);
            Bitmap.plane = new Model3D("donotdelete/plane/", null, null, null, null, null, true);
            CompositingMode mode = new CompositingMode();
            mode.setBlending(64);
            Bitmap.plane.appearance[0].setCompositingMode(mode);
            ArrayList list = Utility3D.getTrianglesFromStrip(Bitmap.verts, Bitmap.uvs, Bitmap.triangles);
            Bitmap.verts = (short[])list.elementAt(0);
            Bitmap.uvs = (short[])list.elementAt(1);
            Bitmap.triangles = (int[])list.elementAt(2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            PlatformService.errorQuit("An error has occurred. Please restart your phone to play this game.");
        }
    }

    public static void loadCamera() {
        cam = new Camera();
        float left = -screenWidth / 2;
        float right = screenWidth / 2;
        float top = -screenHeight / 2;
        float bottom = screenHeight / 2;
        float far = 1.0f;
        float near = -1.0f;
        Transform projMatrix = Utility3D.createPixelPerfectProjectionMatrix(right, left, top, bottom, far, near);
        projMatrix.postTranslate((float)(-screenWidth / 2), (float)(-screenHeight / 2), 0.0f);
        cam.setGeneric(projMatrix);
    }

    public void startGame() {
        Game.startGame();
    }

    static {
        maxSoundSupported = 1;
        isUUIDObtained = false;
        bufferStrUUID = "";
        UUID = "";
        g3d = null;
        cam = null;
        cameraPosition = Utility3D.getVector(0.0f, 0.0f, 1.0f);
        cameraLookAt = Utility3D.getVector(0.0f, 0.0f, 0.0f);
    }
}

