/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.platform.GameCanvas;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;

public class MyGesture {
    final int MINIMUM_DISTANCE;
    final int TTL;
    int[][] points;
    long[] time;
    int startIndex;
    int endIndex;
    long lastPointAddedTime;
    boolean isSwipeTriggered;

    public MyGesture() {
        this.MINIMUM_DISTANCE = GameMIDlet.instance.gameCanvas.getWidth() / 6;
        this.TTL = 400;
        this.isSwipeTriggered = false;
        this.points = new int[1100][2];
        this.time = new long[1100];
        this.startIndex = 0;
        this.endIndex = -1;
        this.lastPointAddedTime = 0L;
    }

    public void addPoint(int x, int y) {
        if (PlatformService.currentTimeMillis() - this.lastPointAddedTime < 1L) {
            return;
        }
        ++this.endIndex;
        this.points[this.endIndex][0] = x;
        this.points[this.endIndex][1] = y;
        this.time[this.endIndex] = this.lastPointAddedTime = PlatformService.currentTimeMillis();
    }

    public void touchStart() {
        this.isSwipeTriggered = false;
    }

    public void touchRelease() {
        this.process();
        this.startIndex = 0;
        this.endIndex = -1;
        this.lastPointAddedTime = 0L;
    }

    public void process() {
        if (this.isSwipeTriggered) {
            return;
        }
        if (this.endIndex == -1) {
            return;
        }
        if (this.time[this.startIndex] != 0L && PlatformService.currentTimeMillis() - this.time[this.startIndex] > 400L) {
            ++this.startIndex;
            if (this.startIndex > this.endIndex) {
                this.startIndex = 0;
                this.endIndex = -1;
                return;
            }
        }
        int distanceX = this.points[this.startIndex][0] - this.points[this.endIndex][0];
        int distanceY = this.points[this.startIndex][1] - this.points[this.endIndex][1];
        if (Math.abs(distanceX) > Math.abs(distanceY)) {
            if (Math.abs(distanceX) > this.MINIMUM_DISTANCE) {
                if (distanceX > 0) {
                    GameCanvas gameCanvas = GameMIDlet.instance.gameCanvas;
                    GameMIDlet.instance.gameCanvas.getClass();
                    gameCanvas.handleSwipe(118);
                    this.isSwipeTriggered = true;
                    this.startIndex = 0;
                    this.endIndex = -1;
                    this.lastPointAddedTime = 0L;
                } else {
                    GameCanvas gameCanvas = GameMIDlet.instance.gameCanvas;
                    GameMIDlet.instance.gameCanvas.getClass();
                    gameCanvas.handleSwipe(119);
                    this.isSwipeTriggered = true;
                    this.startIndex = 0;
                    this.endIndex = -1;
                    this.lastPointAddedTime = 0L;
                }
            }
        } else if (Math.abs(distanceY) > this.MINIMUM_DISTANCE) {
            if (distanceY > 0) {
                GameCanvas gameCanvas = GameMIDlet.instance.gameCanvas;
                GameMIDlet.instance.gameCanvas.getClass();
                gameCanvas.handleSwipe(120);
                this.isSwipeTriggered = true;
                this.startIndex = 0;
                this.endIndex = -1;
                this.lastPointAddedTime = 0L;
            } else {
                GameCanvas gameCanvas = GameMIDlet.instance.gameCanvas;
                GameMIDlet.instance.gameCanvas.getClass();
                gameCanvas.handleSwipe(121);
                this.isSwipeTriggered = true;
                this.startIndex = 0;
                this.endIndex = -1;
                this.lastPointAddedTime = 0L;
            }
        }
    }
}

