/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.admanager;

import com.renderedideas.admanager.AdData;
import com.renderedideas.platform.DictionaryKeyValue;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Storage;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class AdManager
extends Canvas {
    static AdManager instance;
    static DictionaryKeyValue parameters;
    static DictionaryKeyValue vservParameters;

    public AdManager() {
        instance = this;
        this.setFullScreenMode(true);
        if (!GameMIDlet.iap) {
            this.prepareParameters();
        }
    }

    public static AdData downloadStartAd() {
        if (GameMIDlet.iap) {
            return null;
        }
        parameters.put("adLocation", "start");
        return AdManager.startDownload();
    }

    public static AdData downloadEndAd() {
        if (GameMIDlet.iap) {
            return null;
        }
        parameters.put("adLocation", "end");
        return AdManager.startDownload();
    }

    public static AdData downloadGameplayAd() {
        if (GameMIDlet.iap) {
            return null;
        }
        parameters.put("adLocation", "gameplay");
        return AdManager.startDownload();
    }

    private static AdData startDownload() {
        String url = "http://www.ri-mobile.com/adManager/adapi.php?gaID=" + parameters.get("gaID");
        String responseString = PlatformService.getStringResponseFromServer(url, AdManager.getParametersAsString());
        if (responseString != null) {
            return new AdData(responseString, 1);
        }
        if (vservParameters == null) {
            instance.prepareVservParameters();
        }
        if ((responseString = PlatformService.getStringResponseFromServer(url = "http://a.vserv.mobi/delivery/adapi.php?99be4efb", AdManager.getVservParametersAsString())) != null) {
            if (responseString.length() < 10) {
                return null;
            }
            return new AdData(responseString, 2);
        }
        return null;
    }

    private void prepareParameters() {
        parameters = new DictionaryKeyValue();
        parameters.put("platform", "J2me");
        parameters.put("appName", GameMIDlet.instance.getAppProperty("MIDlet-Name") + "");
        parameters.put("appVersion", GameMIDlet.instance.getAppProperty("MIDlet-Version") + "");
        parameters.put("screenWidth", this.getWidth() + "");
        parameters.put("screenHeight", this.getHeight() + "");
        parameters.put("sessionID", Math.abs(PlatformService.nextInt()) + "");
        parameters.put("scoreUUID", Storage.readData("UUID") + "");
        parameters.put("iap_uid", Storage.readData("iap_uid") + "");
        parameters.put("gaID", GameMIDlet.tracker.session.getUserId() + "");
        parameters.put("isTouch", PlatformService.isTouchSupported() + "");
        parameters.put("uuid", "NULL");
        parameters.put("imei", this.getIMEI() + "");
        parameters.put("imsi", this.getIMSI() + "");
        parameters.put("cellId", this.getCellId());
        parameters.put("mcc", System.getProperty("com.nokia.mid.mcc") + "");
        parameters.put("mnc", System.getProperty("com.nokia.mid.mnc") + "");
        parameters.put("smsc", System.getProperty("wireless.messaging.sms.smsc") + "");
        parameters.put("locale", System.getProperty("microedition.locale") + "");
        parameters.put("lac", this.getLocationAreaCode() + "");
        parameters.put("pimSupport", (System.getProperty("microedition.pim.version") != null) + "");
        parameters.put("isSigned", (GameMIDlet.instance.getAppProperty("MIDlet-Certificate-1-1") != null) + "");
        parameters.put("support3gp", this.isSupport3gp() + "");
        parameters.put("lattitude", PlatformService.getLattitude() + "");
        parameters.put("longitude", PlatformService.getLongitude() + "");
        parameters.put("adLocation", "");
        parameters.put("version", "1");
        parameters.put("customUA", PlatformService.getUserAgent() + "");
    }

    private void prepareVservParameters() {
        vservParameters = new DictionaryKeyValue();
        vservParameters.put("zoneid", "99be4efb");
        vservParameters.put("ua", PlatformService.getUserAgent() + "");
        vservParameters.put("app", "1");
        vservParameters.put("im", this.getIMEI() + "");
        vservParameters.put("sw", this.getWidth() + "");
        vservParameters.put("sh", this.getHeight() + "");
        vservParameters.put("mcc", System.getProperty("com.nokia.mid.mcc") + "");
        vservParameters.put("mnc", System.getProperty("com.nokia.mid.mnc") + "");
        vservParameters.put("ce", parameters.get("cellId"));
        vservParameters.put("smsc", System.getProperty("wireless.messaging.sms.smsc") + "");
        vservParameters.put("mn", GameMIDlet.instance.getAppProperty("MIDlet-Name") + "");
        vservParameters.put("zc", "18");
        vservParameters.put("vs3", this.isSupport3gp() ? "1" : "0");
        vservParameters.put("lc", System.getProperty("microedition.locale") + "");
        vservParameters.put("lac", parameters.get("lac"));
        vservParameters.put("pim", System.getProperty("microedition.pim.version") != null ? "1" : "0");
        vservParameters.put("sg", GameMIDlet.instance.getAppProperty("MIDlet-Certificate-1-1") != null ? "1" : "0");
        vservParameters.put("ts", PlatformService.isTouchSupported() ? "1" : "0");
        vservParameters.put("si", Math.abs(PlatformService.nextInt()) + "");
    }

    private static String getParametersAsString() {
        String values = "";
        Object[] objects = parameters.getAllKeys();
        for (int i = 0; i < objects.length; ++i) {
            String key = (String)objects[i];
            values = values + "&" + key + "=" + parameters.get(key);
        }
        return values;
    }

    private static String getVservParametersAsString() {
        String values = "";
        Object[] objects = vservParameters.getAllKeys();
        for (int i = 0; i < objects.length; ++i) {
            String key = (String)objects[i];
            values = values + "&" + key + "=" + vservParameters.get(key);
        }
        return values;
    }

    public String getIMEI() {
        String out = "";
        try {
            out = System.getProperty("com.imei");
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("phone.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.IMEI");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.mid.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.sonyericsson.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("IMEI");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.motorola.IMEI");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.samsung.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.siemens.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.lge.imei");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("imei");
            }
        }
        catch (Exception e2) {
            return out == null ? "" : out;
        }
        return out == null ? "" : out;
    }

    public String getIMSI() {
        String out = "";
        try {
            out = System.getProperty("IMSI");
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("phone.imsi");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.mid.mobinfo.IMSI");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.mid.imsi");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("IMSI");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("imsi");
            }
        }
        catch (Exception e2) {
            return out == null ? "" : out;
        }
        return out == null ? "" : out;
    }

    public String getCellId() {
        String out = "";
        try {
            out = System.getProperty("phone.cid");
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("CellID");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("Cell-ID");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.mid.cellid");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.sonyericsson.net.cellid");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.samsung.cellid");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.siemens.cellid");
            }
        }
        catch (Exception e2) {
            return out == null ? "" : out;
        }
        return out == null ? "" : out;
    }

    public String getLocationAreaCode() {
        String out = "";
        try {
            out = System.getProperty("phone.lac");
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.nokia.mid.lac");
            }
            if (out == null || out.equals("null") || out.equals("")) {
                out = System.getProperty("com.sonyericsson.net.lac");
            }
        }
        catch (Exception e2) {
            return out == null ? "" : out;
        }
        return out == null ? "" : out;
    }

    boolean isSupport3gp() {
        if (System.getProperty("video.encodings") != null) {
            return System.getProperty("video.encodings").indexOf("video/3gpp") != -1;
        }
        return false;
    }

    static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e2 = 0;
        StringBuffer result = new StringBuffer();
        while ((e2 = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e2));
            result.append(replace);
            s = e2 + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    protected void paint(Graphics g2) {
    }
}

