/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameObjectManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.yourgamename.BitmapCacher;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;
import com.renderedideas.yourgamename.LevelInfo;
import com.renderedideas.yourgamename.Player;
import com.renderedideas.yourgamename.Selector;
import com.renderedideas.yourgamename.SoundManager;
import com.renderedideas.yourgamename.StorageHandler;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class GameplayView
extends GameView3D {
    Bitmap bg;
    Bitmap bgZoomed;
    Bitmap target;
    Bitmap arrowScaleable;
    Bitmap windDirection;
    Bitmap scoreBar;
    Bitmap arrow;
    Point scoreBarPoint;
    Point windDirectionPoint;
    public GameObjectManager gameObjectManager;
    public Point touchPoint;
    Point arrowPosition;
    Point targetPosition;
    Point hitScreenTargetPoint;
    Point arrowStartPoint;
    Point wind;
    GameFont gameFont;
    public static long time;
    public static long arrowAirTime;
    public long holdTime;
    long pointerPressDelay;
    String colorString;
    int R;
    int G;
    int B;
    public static boolean arrowFired;
    public static boolean isPaused;
    public boolean restartButtonPressed;
    float targetLeft;
    float targetRight;
    float targetTop;
    float targetBottom;
    float arrowVelocity;
    float targetDistance;
    float timBarMultiplyer;
    float arrowScaleX;
    float arrowScaleY;
    float arrowFinalScale = 0.01f;
    float arrowScaleSpeed = 0.2f;
    int currentScreen;
    int totalPointsEarned;
    int pointsEarned;
    int totalPointsToClearLevel;
    int lastTargetArroIndex;
    public static int MAX_ARROWS;
    public static int numberOfArrows;
    Bitmap pauseButton;
    Point pauseButtonPoint;
    Point hudScorePoint;
    Point hudNoOfArrowsPoint;
    Bitmap resumeButton;
    Point resumeButtonPoint;
    Bitmap restartButton;
    Point restartButtonPointPausedScreen;
    Bitmap quitButton;
    Point quitButtonPointPausedScreen;
    Bitmap pausedText;
    Point pausedTextPoint;
    Bitmap pausedBase;
    Point pausedBasePoint;
    Bitmap nextButton;
    Point nextButtonPointLevelClear;
    Bitmap levelClearBase;
    Point levelClearBasePoint;
    Point restartButtonPointLevelClear;
    Point quitButtonPointLevelClear;
    Point restartButtonPointGameOverScreen;
    Point quitButtonPointGameOverScreen;
    Bitmap gameOverbase;
    Point gameOverbasePoint;
    Bitmap playAgain;
    Point playAgainPoint;
    Bitmap playerNameButton;
    Point playerNamePoint;
    Bitmap showRank;
    Point showRankPoint;
    Bitmap faceBook;
    Point faceBookPoint;
    Point quitButtonPointEndlessModeGameOver;
    Point gameOverBaseEndlessModePoint;
    Bitmap congratulation;
    Point congratulationPoint;
    Bitmap playFreeMode;
    Point playFreeModePoint;
    Point quitPointCongratulationScreen;
    ArrayList previousTargetPoints;
    public static boolean upKeyPressed;
    public static boolean downKeyPressed;
    public static boolean leftKeyPressed;
    public static boolean rightkeyPressed;
    boolean isRightKeyPressed;
    boolean isLeftKeyPressed;
    boolean isUpkeyPressed;
    boolean isDownKeyPressed;
    private boolean setPlayerNameFlag;
    int maxWind;
    int minWind;
    Point totalPointsEarnedPoint;
    Point highScorePoint;
    float y = 0.07f;
    float x = 0.02f;
    Point touchPointXY = new Point();
    Point diffTouchAndDragXY = new Point();
    public static Point moveXY;
    public static Point movePercentage;
    int arrowFiredXOffset = 14;
    int arrowFiredYOffset = 8;

    public GameplayView() {
        this.ID = Constants.VIEW_ID_GAMEPLAY_VIEW;
        this.currentScreen = 3;
        Debug.print("mode..." + Game.endlessMode);
        this.targetDistance = 10.0f;
        this.arrowVelocity = 8.0f;
        this.totalPointsToClearLevel = LevelInfo.pointsRequiredToClearLevel;
        this.maxWind = LevelInfo.maxWind;
        this.minWind = LevelInfo.minWind;
        Constants.TIME_MAXIMUM_HOLD = LevelInfo.maxHoldTime;
        if (Game.endlessMode) {
            Constants.TIME_MAXIMUM_HOLD = 10000.0f;
            this.maxWind = 6;
            this.minWind = 2;
        }
        BitmapCacher.loadBitmaps();
        this.gameObjectManager = new GameObjectManager();
        this.bg = BitmapCacher.backGround;
        this.gameFont = BitmapCacher.gameFont;
        this.touchPoint = new Point(-1.0f, -1.0f);
        this.holdTime = -1L;
        this.colorString = "00FF00";
        this.R = 0;
        this.G = 255;
        this.B = 0;
        this.targetPosition = new Point(GameManager.screenWidth / 2, GameManager.screenHeight / 2);
        this.arrowPosition = new Point();
        this.hitScreenTargetPoint = new Point();
        this.wind = new Point(0.0f, 0.0f);
        numberOfArrows = MAX_ARROWS;
        this.totalPointsEarned = 0;
        this.pointsEarned = 0;
        arrowAirTime = -1L;
        this.pointerPressDelay = time;
        this.timBarMultiplyer = 1.0f;
        this.target = BitmapCacher.bigTarget;
        this.targetLeft = this.targetPosition.X - (float)(this.target.getWidth() / 2);
        this.targetRight = this.targetPosition.X + (float)(this.target.getWidth() / 2);
        this.targetTop = this.targetPosition.Y - (float)(this.target.getHeight() / 2);
        this.targetBottom = this.targetTop + (float)this.target.getHeight() * 0.651f;
        this.unloadHitScreen();
        arrowFired = false;
        try {
            GameManager.setUpM3G();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.arrowScaleable = BitmapCacher.arrowScaleable;
        this.arrowScaleX = 1.0f;
        this.arrowScaleY = 1.0f;
        this.setWind();
        this.loadGamePlayScreen();
        this.previousTargetPoints = new ArrayList();
        this.lastTargetArroIndex = -1;
        SoundManager.loadSounds();
        Debug.print("Max hold time" + Constants.TIME_MAXIMUM_HOLD);
    }

    public void update() {
        this.updateTime();
        switch (this.currentScreen) {
            case 2: {
                this.updateHitScreen();
                break;
            }
            case 1: {
                this.updateGamePlayScreen();
                break;
            }
            case 6: {
                if (!this.restartButtonPressed) break;
                this.restartGame();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (!this.setPlayerNameFlag) break;
                this.setPlayerNameFlag = false;
                this.setPlayerName();
                break;
            }
        }
        Selector.update();
    }

    private void setPlayerName() {
        Game.playerName = PlatformService.getUserInput("Please Enter the name");
        if (Game.playerName == null) {
            Game.playerName = "Player";
        } else if (Game.playerName.length() > 9) {
            Game.playerName = Game.playerName.substring(0, 9);
        }
        StorageHandler.savePlayerName(Game.playerName);
    }

    public void updateHitScreen() {
        if (isPaused) {
            return;
        }
        this.gameObjectManager.updateObjects();
        if (this.totalPointsToClearLevel < this.totalPointsEarned) {
            // empty if block
        }
    }

    public void updateGamePlayScreen() {
        if (isPaused) {
            return;
        }
        this.gameObjectManager.updateObjects();
        if (this.holdTime > 0L && (float)(time - this.holdTime) > Constants.TIME_MAXIMUM_HOLD) {
            this.fireArrow();
        }
        if (this.holdTime > 0L && !arrowFired) {
            this.setTimeBarColor();
        }
        if (arrowFired && (float)(time - arrowAirTime) > 1000.0f && arrowAirTime > 0L) {
            this.getTargetHitPoint();
        }
        if (arrowAirTime > 0L && (float)(time - arrowAirTime) > 1000.0f) {
            Debug.print("changing screen");
            if (this.pointsEarned < 1 && numberOfArrows <= 0 && (this.totalPointsEarned < this.totalPointsToClearLevel || Game.endlessMode)) {
                Debug.print("changed to gameOver");
                this.pointerPressDelay = time;
                this.unloadGamePlayScreen();
                if (Game.endlessMode) {
                    this.loadGameOverScreenEndlessMode();
                    if (this.totalPointsEarned > Game.highScore) {
                        this.setHighScore();
                    }
                } else {
                    this.loadGameOverScreenArcadeMode();
                }
                this.currentScreen = 4;
            } else if (this.pointsEarned >= 1) {
                this.currentScreen = 2;
                this.unloadGamePlayViewBackground();
                this.loadHitScreen();
                this.pointerPressDelay = time;
                if (Game.endlessMode) {
                    GameObjectManager.msgQueue.addMessage("+" + this.pointsEarned, 1500, new Point(GameManager.screenWidth / 2, GameManager.screenHeight / 2), new Point(0.0f, -1000.0f));
                } else {
                    GameObjectManager.msgQueue.addMessage("HIT", 1500, new Point(GameManager.screenWidth / 2, GameManager.screenHeight / 2), new Point(0.0f, -1000.0f));
                }
                if (this.pointsEarned == Constants.TARGET_POINT_ARRAY[Constants.TARGET_POINT_ARRAY.length - 1]) {
                    GameObjectManager.msgQueue.addMessage("+1 ARROW", 1500, new Point(GameManager.screenWidth / 2, (float)GameManager.screenHeight * 0.6f), new Point(0.0f, -1000.0f));
                }
                if (this.pointsEarned == 32) {
                    GameObjectManager.msgQueue.addMessage("+2 ARROW", 1500, new Point(GameManager.screenWidth / 2, (float)GameManager.screenHeight * 0.6f), new Point(0.0f, -1000.0f));
                }
                this.pointsEarned = 0;
                SoundManager.play(Constants.SOUND_ARROW_HIT);
            } else {
                this.resetGame();
            }
        }
        if (arrowAirTime > -1L) {
            this.arrowScaleX = Utility.lerp(this.arrowScaleX, this.arrowFinalScale, this.arrowScaleSpeed);
            this.arrowScaleY = Utility.lerp(this.arrowScaleY, this.arrowFinalScale, this.arrowScaleSpeed);
        }
        if (arrowAirTime < 0L) {
            if (this.isRightKeyPressed) {
                GameObjectManager.player.movementInKeyPress("right");
            } else if (this.isLeftKeyPressed) {
                GameObjectManager.player.movementInKeyPress("left");
            }
            if (this.isDownKeyPressed) {
                GameObjectManager.player.movementInKeyPress("down");
            } else if (this.isUpkeyPressed) {
                GameObjectManager.player.movementInKeyPress("up");
            }
        }
    }

    private void updateTime() {
        time += 33L;
    }

    public void setTimeBarColor() {
        this.timBarMultiplyer = 1.0f - (float)(time - this.holdTime) / Constants.TIME_MAXIMUM_HOLD;
        if (this.R < 255) {
            this.R += 2;
        } else {
            this.G -= 2;
        }
        if (this.G < 0) {
            this.G = 0;
        }
        if (this.R > 255) {
            this.R = 255;
        }
    }

    public void paint(Graphics g2, float extrapolationFactor) {
        if (this.currentScreen != 1 && this.currentScreen != 2 && this.currentScreen != 3) {
            Selector.paint(g2);
        }
    }

    public void paintWaitScreen(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bg, 0, 0);
        if (PlatformService.isTouchSupported()) {
            Game.commonFont.drawString("Touch To Continue", g2, (int)((float)GameManager.screenWidth * 0.45f - (float)(this.gameFont.stringWidth("Touch To Continue") / 2)), GameManager.screenHeight / 3 - this.gameFont.stringHeight() / 2);
        } else {
            Game.commonFont.drawString("Press Any Key", g2, GameManager.screenWidth / 2 - this.gameFont.stringWidth("Press Any Key") / 2, GameManager.screenHeight / 4 - this.gameFont.stringHeight() / 2);
            Game.commonFont.drawString("To Continue", g2, GameManager.screenWidth / 2 - this.gameFont.stringWidth("To Continue") / 2, (int)((float)GameManager.screenHeight * 0.3f - (float)(this.gameFont.stringHeight() / 2)));
        }
    }

    public void paintHitScreen(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bgZoomed, 0, 0);
        Bitmap.drawBitmap(g2, this.target, (int)(this.targetPosition.X - (float)(this.target.getWidth() / 2)), (int)(this.targetPosition.Y - (float)(this.target.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.arrow, this.roundOff(this.arrowPosition.X - (float)this.arrow.getWidth() * this.x), this.roundOff(this.arrowPosition.Y - (float)this.arrow.getHeight() * this.y));
        this.gameObjectManager.paintObjects(g2);
    }

    public void animateTimeBar(Graphics g2) {
        if (this.holdTime < 0L && !arrowFired) {
            Bitmap.fillColor(g2, (int)((float)this.scoreBar.getWidth() * 0.2089f), (int)((float)this.scoreBar.getHeight() * 0.64f), (int)((float)GameManager.screenWidth * 0.542f), (int)((float)GameManager.screenHeight * 0.02f), 0, 255, 0);
        } else {
            Bitmap.fillColor(g2, (int)((float)this.scoreBar.getWidth() * 0.2089f), (int)((float)this.scoreBar.getHeight() * 0.64f), (int)((float)GameManager.screenWidth * 0.542f * this.timBarMultiplyer), (int)((float)GameManager.screenHeight * 0.02f), this.R, this.G, this.B);
        }
    }

    public void keyPressed(int keyID) {
        if (time - this.pointerPressDelay > 1000L) {
            switch (this.currentScreen) {
                case 1: {
                    if (keyID == 102) {
                        this.onBackKey();
                    }
                    if (keyID == 108 || keyID == 103) {
                        this.pointerPressed(keyID, 0, 0);
                    }
                    if (keyID == 117 || keyID == 109) {
                        if (this.holdTime < 0L) {
                            this.holdTime = time;
                            Player.currentState = 0;
                        }
                        this.isRightKeyPressed = true;
                    } else if (keyID == 116 || keyID == 107) {
                        if (this.holdTime < 0L) {
                            this.holdTime = time;
                            Player.currentState = 0;
                        }
                        this.isLeftKeyPressed = true;
                    }
                    if (keyID == 114 || keyID == 105) {
                        if (this.holdTime < 0L) {
                            this.holdTime = time;
                            Player.currentState = 0;
                        }
                        this.isUpkeyPressed = true;
                        break;
                    }
                    if (keyID != 115 && keyID != 111) break;
                    if (this.holdTime < 0L) {
                        this.holdTime = time;
                        Player.currentState = 0;
                    }
                    this.isDownKeyPressed = true;
                    break;
                }
                case 2: {
                    this.pointerPressed(keyID, (int)Selector.position.X, (int)Selector.position.Y);
                    break;
                }
                case 3: {
                    this.pointerPressed(keyID, (int)Selector.position.X, (int)Selector.position.Y);
                    break;
                }
                case 6: {
                    if (keyID == 102) {
                        this.onBackKey();
                    }
                }
                default: {
                    Selector.keyPressed(keyID);
                    if (keyID != 108 && keyID != 103) break;
                    this.pointerPressed(keyID, (int)Selector.position.X, (int)Selector.position.Y);
                }
            }
        }
    }

    public void keyReleased(int keyID) {
        if (time - this.pointerPressDelay > 1000L) {
            switch (this.currentScreen) {
                case 1: {
                    if (keyID == 108 || keyID == 103) {
                        this.pointerReleased(0, 0, 0);
                    }
                    if (keyID == 117 || keyID == 109) {
                        this.isRightKeyPressed = false;
                    } else if (keyID == 116 || keyID == 107) {
                        this.isLeftKeyPressed = false;
                    }
                    if (keyID == 114 || keyID == 105) {
                        this.isUpkeyPressed = false;
                        break;
                    }
                    if (keyID != 115 && keyID != 111) break;
                    this.isDownKeyPressed = false;
                    break;
                }
                case 3: {
                    this.currentScreen = 1;
                    arrowFired = false;
                    break;
                }
                case 2: {
                    if (this.totalPointsToClearLevel <= this.totalPointsEarned && !Game.endlessMode) {
                        if (LevelInfo.currentLevelID < 30) {
                            this.unloadHitScreen();
                            this.loadGamePlayViewBackground();
                            this.loadLevelClearScreen();
                            this.pointerPressDelay = time;
                            this.currentScreen = 5;
                            LevelInfo.changeAndStoreLevelData(4);
                            break;
                        }
                        this.unloadHitScreen();
                        this.loadCongratulationScreen();
                        this.loadGamePlayViewBackground();
                        this.pointerPressDelay = time;
                        this.currentScreen = 7;
                        break;
                    }
                    if (numberOfArrows <= 0 && (this.totalPointsEarned < this.totalPointsToClearLevel || Game.endlessMode)) {
                        Debug.print("changed to gameOver");
                        this.pointerPressDelay = time;
                        this.unloadGamePlayScreen();
                        if (Game.endlessMode) {
                            this.loadGamePlayViewBackground();
                            this.loadGameOverScreenEndlessMode();
                            if (this.totalPointsEarned > Game.highScore) {
                                this.setHighScore();
                            }
                        } else {
                            this.loadGamePlayViewBackground();
                            this.loadGameOverScreenArcadeMode();
                        }
                        this.currentScreen = 4;
                        break;
                    }
                    this.resetGame();
                    break;
                }
                default: {
                    Selector.keyReleased(keyID);
                    if (keyID != 108 && keyID != 103) break;
                    this.pointerReleased(keyID, (int)Selector.position.X, (int)Selector.position.Y);
                }
            }
        }
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pointerID, int x, int y) {
        if (time - this.pointerPressDelay > 1000L) {
            switch (this.currentScreen) {
                case 1: {
                    this.gamePlayScreenPointerPressed(x, y);
                    break;
                }
                case 2: {
                    this.hitScreenPointerPressed(x, y);
                    break;
                }
                case 3: {
                    this.waitScreenPointerPressed(x, y);
                    break;
                }
                case 6: {
                    this.pauseScreenPointerPressed(x, y);
                    break;
                }
                case 5: {
                    this.levelClearScreenPointerPressed(x, y);
                    break;
                }
                case 4: {
                    if (!Game.endlessMode) {
                        this.gameOverScreenPointerPressedArcadeMode(x, y);
                        break;
                    }
                    this.gameOverScreenPointerPressedEndlessMode(x, y);
                    break;
                }
                case 7: {
                    this.congratulationScreenPointerPressed(x, y);
                }
            }
        }
    }

    public void congratulationScreenPointerPressed(int x, int y) {
        if (this.isButtonPressed(this.quitButton, this.quitPointCongratulationScreen, x, y)) {
            Game.changeView(Constants.VIEW_ID_MENU);
        } else if (this.isButtonPressed(this.playFreeMode, this.playFreeModePoint, x, y)) {
            Game.endlessMode = true;
            Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
            Debug.print("Play Free Mode");
        }
    }

    public void gameOverScreenPointerPressedArcadeMode(int x, int y) {
        if (this.isButtonPressed(this.quitButton, this.quitButtonPointGameOverScreen, x, y)) {
            Game.changeView(Constants.VIEW_ID_MENU);
            Debug.print("Quit");
        } else if (this.isButtonPressed(this.restartButton, this.restartButtonPointGameOverScreen, x, y)) {
            this.restartGame();
        }
    }

    public void gameOverScreenPointerPressedEndlessMode(int x, int y) {
        Debug.print("Endless Mode Pointer Pressed");
        if (this.isButtonPressed(this.playerNameButton, this.playerNamePoint, x, y)) {
            this.setPlayerNameFlag = true;
        } else if (this.isButtonPressed(this.faceBook, this.faceBookPoint, x, y)) {
            PlatformService.openURL("http://www.facebook.com/RenderedIdeas");
        } else if (this.isButtonPressed(this.showRank, this.showRankPoint, x, y)) {
            Game.changeView(Constants.SCORE_VIEW_ID);
        } else if (this.isButtonPressed(this.quitButton, this.quitButtonPointEndlessModeGameOver, x, y)) {
            Game.changeView(Constants.VIEW_ID_MENU);
        } else if (this.isButtonPressed(this.playAgain, this.playAgainPoint, x, y)) {
            this.restartGame();
        }
    }

    public void levelClearScreenPointerPressed(int x, int y) {
        if (this.isButtonPressed(this.nextButton, this.nextButtonPointLevelClear, x, y)) {
            ++LevelInfo.currentLevelID;
            Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
            Debug.print("Next");
        } else if (this.isButtonPressed(this.restartButton, this.restartButtonPointLevelClear, x, y)) {
            this.restartGame();
        } else if (this.isButtonPressed(this.quitButton, this.quitButtonPointLevelClear, x, y)) {
            Game.changeView(Constants.VIEW_ID_MENU);
            Debug.print("Quit");
        }
    }

    public void waitScreenPointerPressed(int x, int y) {
    }

    public void hitScreenPointerPressed(int x, int y) {
    }

    private void pauseScreenPointerPressed(int x, int y) {
        if (this.isButtonPressed(this.resumeButton, this.resumeButtonPoint, x, y)) {
            this.resumeGame();
        } else if (this.isButtonPressed(this.restartButton, this.restartButtonPointPausedScreen, x, y)) {
            this.restartButtonPressed = true;
            Debug.print("Restart");
        } else if (this.isButtonPressed(this.quitButton, this.quitButtonPointPausedScreen, x, y)) {
            Game.changeView(Constants.VIEW_ID_MENU);
            Debug.print("Quit");
        }
    }

    public void gamePlayScreenPointerPressed(int x, int y) {
        if (this.isButtonPressed(this.pauseButton, this.pauseButtonPoint, x, y)) {
            this.pauseGame();
        } else if (this.touchPoint.X < 0.0f && this.touchPoint.Y < 0.0f && !arrowFired) {
            this.touchPoint.X = x;
            this.touchPoint.Y = y;
            this.holdTime = time;
            Player.currentState = 0;
        }
    }

    public void pointerReleased(int pointerID, int x, int y) {
        downKeyPressed = false;
        upKeyPressed = false;
        rightkeyPressed = false;
        leftKeyPressed = false;
        if (time - this.pointerPressDelay > 1000L) {
            if (this.currentScreen == 1) {
                if (Player.currentState == 0) {
                    this.fireArrow();
                } else if (!arrowFired) {
                    Player.currentState = 1;
                    GameObjectManager.player.velocity.X = 0.0f;
                    GameObjectManager.player.velocity.Y = 0.0f;
                    this.touchPoint.X = -1.0f;
                    this.touchPoint.Y = -1.0f;
                    this.holdTime = -1L;
                }
            } else if (this.currentScreen == 2) {
                if (numberOfArrows <= 0 && (this.totalPointsEarned < this.totalPointsToClearLevel || Game.endlessMode)) {
                    Debug.print("changed to gameOver");
                    this.pointerPressDelay = time;
                    this.unloadGamePlayScreen();
                    if (Game.endlessMode) {
                        this.loadGamePlayViewBackground();
                        this.loadGameOverScreenEndlessMode();
                        if (this.totalPointsEarned > Game.highScore) {
                            this.setHighScore();
                        }
                    } else {
                        this.loadGamePlayViewBackground();
                        this.loadGameOverScreenArcadeMode();
                    }
                    this.currentScreen = 4;
                } else if (this.totalPointsToClearLevel <= this.totalPointsEarned && !Game.endlessMode) {
                    if (LevelInfo.currentLevelID < 30) {
                        this.unloadHitScreen();
                        this.loadGamePlayViewBackground();
                        this.loadLevelClearScreen();
                        this.pointerPressDelay = time;
                        LevelInfo.changeAndStoreLevelData(4);
                        this.currentScreen = 5;
                    } else {
                        this.unloadHitScreen();
                        this.loadGamePlayViewBackground();
                        this.loadCongratulationScreen();
                        this.pointerPressDelay = time;
                        this.currentScreen = 7;
                    }
                } else {
                    this.resetGame();
                }
            } else if (this.currentScreen == 3) {
                this.currentScreen = 1;
                arrowFired = false;
            }
        }
    }

    public void resetGame() {
        Debug.print("Reset");
        Player.currentState = 1;
        arrowAirTime = -1L;
        this.currentScreen = 3;
        this.unloadHitScreen();
        this.loadGamePlayViewBackground();
        this.pointerPressDelay = time;
        GameObjectManager.player.resetBowPosition();
        this.arrowScaleY = 1.0f;
        this.arrowScaleX = 1.0f;
        this.setWind();
        this.resetColorsBar();
        this.pointsEarned = 0;
    }

    public void fireArrow() {
        SoundManager.play(Constants.SOUND_ARROW_RELEASE);
        Player.currentState = 2;
        GameObjectManager.player.velocity.X = 0.0f;
        GameObjectManager.player.velocity.Y = 0.0f;
        this.touchPoint.X = -1.0f;
        this.touchPoint.Y = -1.0f;
        this.holdTime = -1L;
        --numberOfArrows;
        arrowFired = true;
        if (arrowAirTime < 0L) {
            arrowAirTime = time;
        }
    }

    public void getTargetHitPoint() {
        Point hitPoint = new Point();
        arrowFired = false;
        hitPoint.X = GameObjectManager.player.target.X + GameObjectManager.player.velocity.X;
        hitPoint.Y = GameObjectManager.player.target.Y + GameObjectManager.player.velocity.Y;
        this.applyWindDeflection(hitPoint);
        this.pointsEarned = GameObjectManager.target.getPoints(hitPoint.X, hitPoint.Y);
        if (Game.endlessMode) {
            this.totalPointsEarned += this.pointsEarned;
        } else if (this.pointsEarned > 0) {
            ++this.totalPointsEarned;
        }
        if (this.pointsEarned == 32) {
            numberOfArrows += 2;
        } else if (this.pointsEarned == Constants.TARGET_POINT_ARRAY[4]) {
            ++numberOfArrows;
        }
        float dx = hitPoint.X - (float)GameObjectManager.target.left;
        float dy = hitPoint.Y - (float)GameObjectManager.target.top;
        if (this.pointsEarned >= 1) {
            this.hitScreenTargetPoint = this.getTransformedCoOrdinates(dx, dy);
            this.arrowPosition = new Point(this.hitScreenTargetPoint.X, this.hitScreenTargetPoint.Y);
        }
    }

    void applyWindDeflection(Point target) {
        float defX = this.wind.X * (this.targetDistance / this.arrowVelocity);
        float defY = this.wind.Y * (this.targetDistance / this.arrowVelocity);
        target.X += defX;
        target.Y += defY;
        Debug.print("defX = " + defX);
        Debug.print("defY = " + defY);
    }

    public void pointerDragged(int pointerID, int x, int y) {
        if (time - this.pointerPressDelay > 1000L && this.touchPoint.X > -1.0f && this.touchPoint.Y > -1.0f) {
            GameObjectManager.player.setVelocity(x, y, (int)this.touchPoint.X, (int)this.touchPoint.Y);
        }
    }

    Point getTransformedCoOrdinates(float x, float y) {
        Point newCoordinates = new Point();
        if (this.pointsEarned == 32) {
            return new Point(this.targetLeft + Math.abs(this.targetLeft - this.targetRight) / 2.0f, this.targetTop + Math.abs(this.targetTop - this.targetBottom) / 2.0f);
        }
        newCoordinates.X = x * 3.0f;
        newCoordinates.Y = y * 3.0f;
        newCoordinates.X += this.targetLeft;
        newCoordinates.Y += this.targetTop;
        return newCoordinates;
    }

    public void onBackKey() {
        if (this.currentScreen == 7) {
            Game.changeView(Constants.VIEW_ID_MENU);
        }
        if (this.currentScreen == 1) {
            this.pauseGame();
        } else {
            this.resumeGame();
        }
    }

    public void handleSwipe(int direction) {
    }

    public void pause() {
    }

    public void resume() {
    }

    void loadHitScreen() {
        BitmapCacher.loadHitScreen();
        this.arrow = BitmapCacher.arrow;
        this.bgZoomed = BitmapCacher.backGroundZoomed;
        this.target = BitmapCacher.bigTarget;
    }

    void unloadHitScreen() {
        BitmapCacher.unloadHitScreen();
        this.arrow = null;
        this.target = null;
        this.bgZoomed = null;
    }

    void unloadGamePlayViewBackground() {
        this.bg = null;
        BitmapCacher.unloadGamePlayScreenBackground();
    }

    void loadGamePlayViewBackground() {
        BitmapCacher.loadGamePlayScreenBackground();
        this.bg = BitmapCacher.backGround;
    }

    void resetColorsBar() {
        this.R = 0;
        this.G = 255;
        this.B = 0;
        this.timBarMultiplyer = 1.0f;
    }

    public void paint2D_before(Graphics g2) {
        switch (this.currentScreen) {
            case 1: {
                Bitmap.drawBitmap(g2, this.bg, 0, 0);
                this.paintGamePlayScreenBefore(g2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void paint3D_before(Graphics3D g2) {
        if (arrowAirTime > -1L && this.arrowScaleX < 0.3f) {
            Bitmap.drawBitmap(g2, this.arrowScaleable, GameObjectManager.player.target.X - (float)this.arrowFiredXOffset * this.arrowScaleX, GameObjectManager.player.target.Y - (float)this.arrowFiredYOffset * this.arrowScaleY, 1.0f, this.arrowScaleX, this.arrowScaleY);
        }
    }

    public void paint2D_after(Graphics g2) {
        switch (this.currentScreen) {
            case 1: {
                this.paintGamePlayScreenAfter(g2);
                break;
            }
            case 2: {
                this.paintHitScreen(g2);
                break;
            }
            case 3: {
                this.paintWaitScreen(g2);
                break;
            }
            case 6: {
                Bitmap.drawBitmap(g2, this.bg, 0, 0);
                this.paintPauseScreen(g2);
                break;
            }
            case 5: {
                Bitmap.drawBitmap(g2, this.bg, 0, 0);
                this.paintLevelClearScreen(g2);
                break;
            }
            case 4: {
                Bitmap.drawBitmap(g2, this.bg, 0, 0);
                if (!Game.endlessMode) {
                    this.paintGameOverScreenArcadeMode(g2);
                    break;
                }
                this.paintGameOverScreenEndlessMode(g2);
                break;
            }
            case 7: {
                Bitmap.drawBitmap(g2, this.bg, 0, 0);
                this.paintCongratulationScreen(g2);
            }
        }
    }

    public void paint3D_after(Graphics3D g2) {
        if (arrowAirTime > -1L && this.arrowScaleX >= 0.3f) {
            Bitmap.drawBitmap(g2, this.arrowScaleable, GameObjectManager.player.target.X - (float)this.arrowFiredXOffset * this.arrowScaleX, GameObjectManager.player.target.Y - (float)this.arrowFiredYOffset * this.arrowScaleY, 1.0f, this.arrowScaleX, this.arrowScaleY);
        }
    }

    public void paintLevelClearScreen(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bg, 0, 0);
        Bitmap.drawBitmap(g2, this.levelClearBase, (int)(this.levelClearBasePoint.X - (float)(this.levelClearBase.getWidth() / 2)), (int)(this.levelClearBasePoint.Y - (float)(this.levelClearBase.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.nextButton, (int)(this.nextButtonPointLevelClear.X - (float)(this.nextButton.getWidth() / 2)), (int)(this.nextButtonPointLevelClear.Y - (float)(this.nextButton.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.restartButton, (int)(this.restartButtonPointLevelClear.X - (float)(this.restartButton.getWidth() / 2)), (int)(this.restartButtonPointLevelClear.Y - (float)(this.restartButton.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.quitButton, (int)(this.quitButtonPointLevelClear.X - (float)(this.quitButton.getWidth() / 2)), (int)(this.quitButtonPointLevelClear.Y - (float)(this.quitButton.getHeight() / 2)));
    }

    public void paintGameOverScreenArcadeMode(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bg, 0, 0);
        Bitmap.drawBitmap(g2, this.gameOverbase, (int)(this.gameOverbasePoint.X - (float)(this.gameOverbase.getWidth() / 2)), (int)(this.gameOverbasePoint.Y - (float)(this.gameOverbase.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.restartButton, (int)(this.restartButtonPointGameOverScreen.X - (float)(this.restartButton.getWidth() / 2)), (int)(this.restartButtonPointGameOverScreen.Y - (float)(this.restartButton.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.quitButton, (int)(this.quitButtonPointGameOverScreen.X - (float)(this.quitButton.getWidth() / 2)), (int)(this.quitButtonPointGameOverScreen.Y - (float)(this.quitButton.getHeight() / 2)));
    }

    public void paintGameOverScreenEndlessMode(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bg, 0, 0);
        Bitmap.drawBitmap(g2, this.gameOverbase, (int)(this.gameOverBaseEndlessModePoint.X - (float)(this.gameOverbase.getWidth() / 2)), (int)(this.gameOverBaseEndlessModePoint.Y - (float)(this.gameOverbase.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.playerNameButton, (int)(this.playerNamePoint.X - (float)(this.playerNameButton.getWidth() / 2)), (int)(this.playerNamePoint.Y - (float)(this.playerNameButton.getHeight() / 2)));
        Game.commonFont.drawString(Game.playerName, g2, (int)this.playerNamePoint.X - Game.commonFont.stringWidth(Game.playerName) / 2, (int)(this.playerNamePoint.Y - (float)(this.playerNameButton.getHeight() / 4)));
        Game.commonFont.drawString(this.totalPointsEarned + "", g2, (int)this.totalPointsEarnedPoint.X, (int)this.totalPointsEarnedPoint.Y);
        Game.commonFont.drawString(Game.highScore + "", g2, (int)this.highScorePoint.X, (int)this.highScorePoint.Y);
        Bitmap.drawBitmap(g2, this.faceBook, (int)(this.faceBookPoint.X - (float)(this.faceBook.getWidth() / 2)), (int)(this.faceBookPoint.Y - (float)(this.faceBook.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.showRank, (int)(this.showRankPoint.X - (float)(this.showRank.getWidth() / 2)), (int)(this.showRankPoint.Y - (float)(this.showRank.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.playAgain, (int)(this.playAgainPoint.X - (float)(this.playAgain.getWidth() / 2)), (int)(this.playAgainPoint.Y - (float)(this.playAgain.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.quitButton, (int)(this.quitButtonPointEndlessModeGameOver.X - (float)(this.quitButton.getWidth() / 2)), (int)(this.quitButtonPointEndlessModeGameOver.Y - (float)(this.quitButton.getHeight() / 2)));
    }

    public void paintPauseScreen(Graphics g2) {
        Bitmap.drawBitmap(g2, this.bg, 0, 0);
        Bitmap.drawBitmap(g2, this.pausedBase, (int)(this.pausedBasePoint.X - (float)(this.pausedBase.getWidth() / 2)), (int)(this.pausedBasePoint.Y - (float)(this.pausedBase.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.pausedText, (int)(this.pausedTextPoint.X - (float)(this.pausedText.getWidth() / 2)), (int)(this.pausedTextPoint.Y - (float)(this.pausedText.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.resumeButton, (int)(this.resumeButtonPoint.X - (float)(this.resumeButton.getWidth() / 2)), (int)(this.resumeButtonPoint.Y - (float)(this.resumeButton.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.restartButton, (int)(this.restartButtonPointPausedScreen.X - (float)(this.restartButton.getWidth() / 2)), (int)(this.restartButtonPointPausedScreen.Y - (float)(this.restartButton.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.quitButton, (int)(this.quitButtonPointPausedScreen.X - (float)(this.quitButton.getWidth() / 2)), (int)(this.quitButtonPointPausedScreen.Y - (float)(this.quitButton.getHeight() / 2)));
    }

    public void paintGamePlayScreenBefore(Graphics g2) {
        try {
            GameObjectManager.target.paintObject(g2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintGamePlayScreenAfter(Graphics g2) {
        try {
            GameObjectManager.player.paintObject(g2);
            this.paintHUD(g2);
            Bitmap.drawBitmap(g2, this.pauseButton, (int)(this.pauseButtonPoint.X - (float)(this.pauseButton.getWidth() / 2)), (int)(this.pauseButtonPoint.Y - (float)(this.pauseButton.getHeight() / 2)));
        }
        catch (Exception e2) {
            Bitmap.drawString(g2, "Error After", 20, (int)((float)GameManager.screenHeight * 0.95f), 255, 255, 255);
        }
    }

    public void paintCongratulationScreen(Graphics g2) {
        Bitmap.drawBitmap(g2, this.congratulation, (int)(this.congratulationPoint.X - (float)(this.congratulation.getWidth() / 2)), (int)(this.congratulationPoint.Y - (float)(this.congratulation.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.playFreeMode, (int)(this.playFreeModePoint.X - (float)(this.playFreeMode.getWidth() / 2)), (int)(this.playFreeModePoint.Y - (float)(this.playFreeMode.getHeight() / 2)));
        Bitmap.drawBitmap(g2, this.quitButton, (int)(this.quitPointCongratulationScreen.X - (float)(this.quitButton.getWidth() / 2)), (int)(this.quitPointCongratulationScreen.Y - (float)(this.quitButton.getHeight() / 2)));
    }

    void paintHUD(Graphics g2) {
        this.animateTimeBar(g2);
        Bitmap.drawBitmap(g2, this.scoreBar, (int)(this.scoreBarPoint.X - (float)(this.scoreBar.getWidth() / 2)), (int)(this.scoreBarPoint.Y - (float)(this.scoreBar.getHeight() / 2)));
        this.paintWindIndicator(g2);
        this.gameFont.drawString("" + numberOfArrows, g2, (int)this.hudNoOfArrowsPoint.X - this.gameFont.stringWidth("" + numberOfArrows) / 2, (int)(this.hudNoOfArrowsPoint.Y - (float)(this.gameFont.stringHeight() / 2)));
        if (!Game.endlessMode) {
            this.gameFont.drawString("" + this.totalPointsEarned + "/" + this.totalPointsToClearLevel, g2, (int)this.hudScorePoint.X - this.gameFont.stringWidth("" + this.totalPointsEarned + "/" + this.totalPointsToClearLevel) / 2, (int)(this.hudScorePoint.Y - (float)(this.gameFont.stringHeight() / 2)));
        } else {
            this.gameFont.drawString("" + this.totalPointsEarned, g2, (int)this.hudScorePoint.X - this.gameFont.stringWidth("" + this.totalPointsEarned) / 2, (int)(this.hudScorePoint.Y - (float)(this.gameFont.stringHeight() / 2)));
        }
    }

    void paintWindIndicator(Graphics g2) {
        if (this.wind.X <= 0.0f) {
            Bitmap.drawBitmap(g2, this.windDirection, (int)this.windDirectionPoint.X - this.windDirection.getWidth() / 2, (int)this.windDirectionPoint.Y - this.windDirection.getHeight() / 2, false);
        } else {
            Bitmap.drawBitmap(g2, this.windDirection, (int)this.windDirectionPoint.X - this.windDirection.getWidth() / 2, (int)this.windDirectionPoint.Y - this.windDirection.getHeight() / 2, true);
        }
        this.gameFont.drawString((Math.abs(this.wind.X) + "").substring(0, 3), g2, (int)this.windDirectionPoint.X - this.gameFont.stringWidth(this.wind.X + "") / 2, (int)(this.windDirectionPoint.Y + (float)this.windDirection.getHeight() * 0.67f - (float)(this.gameFont.stringHeight() / 2)));
    }

    public void setWind() {
        if (this.maxWind <= 0) {
            return;
        }
        float w10 = this.minWind + PlatformService.nextInt(this.maxWind - this.minWind);
        float w1 = PlatformService.nextInt(10);
        this.wind.X = w10 + w1 / 10.0f;
        if (PlatformService.nextInt(2) == 0) {
            Debug.print("Negative Wind");
            this.wind.X *= -1.0f;
        }
    }

    public void deallocate() {
        BitmapCacher.deallocate();
        arrowFired = false;
        isPaused = false;
        this.gameObjectManager.deallocate();
        this.touchPoint = null;
        this.target = null;
        this.arrow = null;
        this.gameFont = null;
        this.arrowScaleable = null;
        this.windDirection = null;
        this.scoreBar = null;
        this.unloadGamePlayScreen();
        this.unloadPauseScreen();
        this.unloadHitScreen();
        this.unloadLevelClearScreen();
        this.unloadGamePlayViewBackground();
        this.unloadGameOverScreenArcadeMode();
        this.unloadGameOverScreenEndlessMode();
        this.unloadCongratulationScreen();
        SoundManager.removeAll();
    }

    boolean isButtonPressed(Bitmap image, Point point, int x, int y) {
        if (image == null || point == null) {
            return false;
        }
        if ((float)x > point.X - (float)(image.getWidth() / 2) && (float)x < point.X + (float)(image.getWidth() / 2) && (float)y < point.Y + (float)(image.getHeight() / 2) && (float)y > point.Y - (float)(image.getHeight() / 2)) {
            Game.playClickSound();
            return true;
        }
        return false;
    }

    boolean isButtonPressed(Bitmap image, Point point, int x, int y, float scaleX, float scaleY) {
        if (image == null || point == null) {
            return false;
        }
        if ((float)x > point.X - (float)(image.getWidth() / 2) - (float)image.getWidth() * scaleX / 2.0f && (float)x < point.X + (float)(image.getWidth() / 2) + (float)image.getWidth() * scaleX / 2.0f && (float)y < point.Y + (float)(image.getHeight() / 2) + (float)image.getHeight() * scaleY / 2.0f && (float)y > point.Y - (float)(image.getHeight() / 2) - (float)image.getHeight() * scaleY / 2.0f) {
            Game.playClickSound();
            return true;
        }
        return false;
    }

    void pauseGame() {
        this.unloadGamePlayScreen();
        this.loadPauseScreen();
        this.currentScreen = 6;
    }

    void resumeGame() {
        this.unloadPauseScreen();
        this.loadGamePlayScreen();
        this.currentScreen = 1;
    }

    void restartGame() {
        this.restartButtonPressed = false;
        Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
    }

    void loadPauseScreen() {
        BitmapCacher.loadPauseScreen();
        this.resumeButton = BitmapCacher.resume;
        this.restartButton = BitmapCacher.restart;
        this.quitButton = BitmapCacher.quit;
        this.pausedText = BitmapCacher.pausedText;
        this.pausedBase = BitmapCacher.pauseBase;
        this.pausedTextPoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.1f);
        this.resumeButtonPoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.35f);
        this.restartButtonPointPausedScreen = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.5f);
        this.quitButtonPointPausedScreen = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.65f);
        this.pausedBasePoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.5f);
    }

    void unloadPauseScreen() {
        this.resumeButton = null;
        this.restartButton = null;
        this.quitButton = null;
        this.pausedText = null;
        this.pausedBase = null;
        BitmapCacher.unloadPauseScreen();
    }

    void loadGamePlayScreen() {
        BitmapCacher.loadGameplayButtons();
        this.pauseButton = BitmapCacher.pauseButton;
        this.windDirection = BitmapCacher.windDirection;
        this.scoreBar = BitmapCacher.scoreBar;
        this.pauseButtonPoint = new Point((float)GameManager.screenWidth * 0.92f, (float)GameManager.screenHeight * 0.05f);
        this.windDirectionPoint = new Point((float)GameManager.screenWidth * 0.1125f, (float)GameManager.screenHeight * 0.05f);
        this.scoreBarPoint = new Point(this.scoreBar.getWidth() / 2, this.scoreBar.getHeight() / 2);
        this.hudScorePoint = new Point((int)((float)GameManager.screenWidth * 0.48f), (int)((float)this.scoreBar.getHeight() * 0.45f));
        this.hudNoOfArrowsPoint = new Point((int)((float)GameManager.screenWidth * 0.73f), (int)((float)this.scoreBar.getHeight() * 0.45f));
        this.hudScorePoint = new Point((int)((float)GameManager.screenWidth * 0.48f), (int)((float)this.scoreBar.getHeight() * 0.45f));
        this.hudNoOfArrowsPoint = new Point((int)((float)GameManager.screenWidth * 0.73f), (int)((float)this.scoreBar.getHeight() * 0.45f));
    }

    void unloadGamePlayScreen() {
        BitmapCacher.unloadGameplayButtons();
        this.pauseButton = null;
        this.windDirection = null;
        this.scoreBar = null;
    }

    void loadLevelClearScreen() {
        BitmapCacher.loadLevelClearSCreen();
        this.nextButton = BitmapCacher.next;
        this.restartButton = BitmapCacher.restart;
        this.quitButton = BitmapCacher.quit;
        this.levelClearBase = BitmapCacher.levelClearBase;
        this.nextButtonPointLevelClear = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.43f);
        this.restartButtonPointLevelClear = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.54f);
        this.quitButtonPointLevelClear = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.65f);
        this.levelClearBasePoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.5f);
    }

    void unloadLevelClearScreen() {
        BitmapCacher.unloadLevelClearSCreen();
        this.nextButton = null;
        this.restartButton = null;
        this.quitButton = null;
    }

    void loadGameOverScreenArcadeMode() {
        BitmapCacher.loadGameOverScreenArcadeMode();
        this.quitButton = BitmapCacher.quit;
        this.restartButton = BitmapCacher.restart;
        this.gameOverbase = BitmapCacher.gameOverBase;
        this.quitButtonPointGameOverScreen = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.55f);
        this.restartButtonPointGameOverScreen = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.45f);
        this.gameOverbasePoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.4f);
    }

    void unloadGameOverScreenArcadeMode() {
        BitmapCacher.unloadGameOverScreenArcadeMode();
        this.quitButton = null;
        this.restartButton = null;
        this.gameOverbase = null;
    }

    void loadGameOverScreenEndlessMode() {
        Debug.print("LoadGAmeOverScreen");
        BitmapCacher.loadGameOverScreenEndlessMode();
        this.quitButton = BitmapCacher.quit;
        this.playAgain = BitmapCacher.playAgain;
        this.playerNameButton = BitmapCacher.playerNameButton;
        this.gameOverbase = BitmapCacher.gameOverBase;
        this.faceBook = BitmapCacher.faceBook;
        this.showRank = BitmapCacher.showRank;
        Debug.print(this.gameOverbase);
        this.gameOverBaseEndlessModePoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.5f);
        this.playAgainPoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.6f);
        this.quitButtonPointEndlessModeGameOver = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.7f);
        this.faceBookPoint = new Point((float)GameManager.screenWidth * 0.65f, (float)GameManager.screenHeight * 0.5f);
        this.showRankPoint = new Point((float)GameManager.screenWidth * 0.35f, (float)GameManager.screenHeight * 0.5f);
        this.playerNamePoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.3f);
        this.totalPointsEarnedPoint = new Point((float)GameManager.screenWidth * 0.4f, (float)GameManager.screenHeight * 0.4f);
        this.highScorePoint = new Point((int)((float)GameManager.screenWidth * 0.8f), (int)((float)GameManager.screenHeight * 0.4f));
    }

    void unloadGameOverScreenEndlessMode() {
        BitmapCacher.unloadGameOverScreenEndlessMode();
        this.quitButton = null;
        this.playAgain = null;
        this.playerNameButton = null;
        this.gameOverbase = null;
        this.faceBook = null;
        this.showRank = null;
    }

    void loadCongratulationScreen() {
        BitmapCacher.loadCongratulationScreen();
        this.congratulation = BitmapCacher.congratulation;
        this.playFreeMode = BitmapCacher.playFreeMode;
        this.quitButton = BitmapCacher.quit;
        this.congratulationPoint = new Point((float)GameManager.screenWidth * 0.5f, (float)GameManager.screenHeight * 0.4f);
        this.playFreeModePoint = new Point((float)GameManager.screenWidth * 0.3f, (float)GameManager.screenHeight * 0.7f);
        this.quitPointCongratulationScreen = new Point((float)GameManager.screenWidth * 0.7f, (float)GameManager.screenHeight * 0.7f);
    }

    void unloadCongratulationScreen() {
        BitmapCacher.unloadCongratulationScreen();
        this.congratulation = null;
        this.playFreeMode = null;
        this.quitButton = null;
    }

    private void setHighScore() {
        Debug.print("saved data" + this.totalPointsEarned);
        StorageHandler.savePlayerScore(this.totalPointsEarned);
        Game.highScore = StorageHandler.getPlayerScore("PLAYER");
    }

    int roundOff(float x) {
        int y = (int)x;
        if ((double)Math.abs((float)y - x) > 0.5) {
            return y + 1;
        }
        return y;
    }

    static {
        MAX_ARROWS = 10;
        moveXY = new Point();
        movePercentage = new Point();
    }
}

