/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Storage;

public class LevelInfo {
    public static final int NO_OF_LEVELS = 30;
    private static StringBuffer strLevelData;
    public static int currentLevelID;
    public static int levelSelected;
    public static int pointsRequiredToClearLevel;
    public static int numberOfArrows;
    public static int maxWind;
    public static int minWind;
    public static int levelBackGround;
    public static int maxHoldTime;

    LevelInfo() {
    }

    static void setLevelInfo(int levelID) {
        Debug.print("SetLevelInfo");
        levelBackGround = PlatformService.nextInt(2);
        if (levelID <= 5) {
            pointsRequiredToClearLevel = 4;
            maxWind = 0;
            minWind = 0;
            maxHoldTime = 15000;
        } else if (levelID <= 10) {
            pointsRequiredToClearLevel = 5;
            maxWind = 2;
            minWind = 1;
            maxHoldTime = 12000;
        } else if (levelID <= 15) {
            pointsRequiredToClearLevel = 6;
            maxWind = 3;
            minWind = 2;
            maxHoldTime = 10000;
        } else if (levelID <= 20) {
            pointsRequiredToClearLevel = 7;
            maxWind = 4;
            minWind = 2;
            maxHoldTime = 10000;
        } else if (levelID <= 25) {
            pointsRequiredToClearLevel = 8;
            maxWind = 5;
            minWind = 2;
            maxHoldTime = 9000;
        } else if (levelID <= 30) {
            pointsRequiredToClearLevel = 9;
            maxWind = 6;
            minWind = 3;
            maxHoldTime = 6000;
        }
    }

    public static void changeAndStoreLevelData(int newNoOfStars) {
        String status = strLevelData.charAt(currentLevelID) + "";
        int currentLevelStatus = Integer.parseInt(status);
        int newLevelstatus = newNoOfStars;
        if (newLevelstatus == 0) {
            newLevelstatus = 5;
        }
        if (currentLevelStatus == 4 || currentLevelStatus == 5 || currentLevelStatus < newNoOfStars) {
            char c2 = (char)(48 + newLevelstatus);
            strLevelData.setCharAt(currentLevelID, c2);
        }
        LevelInfo.unlockLevel(currentLevelID + 1);
        String key = "s" + currentLevelID / 10;
        String value = LevelInfo.getSubStringToSave(currentLevelID);
        Storage.saveData(key, value);
    }

    private static String getSubStringToSave(int levelID) {
        if (levelID >= 0 && levelID <= 9) {
            return strLevelData.toString().substring(0, 10);
        }
        if (levelID >= 10 && levelID <= 19) {
            return strLevelData.toString().substring(10, 20);
        }
        if (levelID >= 20 && levelID <= 29) {
            return strLevelData.toString().substring(20, 30);
        }
        if (levelID >= 30) {
            return strLevelData.toString().substring(30, 31);
        }
        return "";
    }

    private static void unlockLevel(int levelID) {
        if (levelID <= 30 && strLevelData.charAt(levelID) == '0') {
            char c2 = '4';
            strLevelData.setCharAt(levelID, c2);
            if (currentLevelID / 10 != levelID / 10) {
                String keyNextLevel = "s" + levelID / 10;
                String valueNextLevel = LevelInfo.getSubStringToSave(levelID);
                Storage.saveData(keyNextLevel, valueNextLevel);
            }
        }
    }

    public static void retrieveStoredLevelData() {
        if (Storage.readData("s0") == null) {
            Storage.saveData("s0", " 400000000");
        }
        if (Storage.readData("s1") == null) {
            Storage.saveData("s1", "0000000000");
        }
        if (Storage.readData("s2") == null) {
            Storage.saveData("s2", "0000000000");
        }
        if (Storage.readData("s3") == null) {
            Storage.saveData("s3", "0");
        }
        String data = Storage.readData("s0") + Storage.readData("s1") + Storage.readData("s2") + Storage.readData("s3");
        strLevelData = new StringBuffer(data);
    }

    public static byte getLevelStatus(byte levelID) {
        return Byte.parseByte(strLevelData.charAt(levelID) + "");
    }
}

