/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.admanager.AdView;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameMIDlet;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class PlatformService {
    public static void exit() {
        if (!GameMIDlet.iap) {
            GameManager.currentView = new AdView(102);
        } else {
            GameMIDlet.instance.exit();
        }
    }

    public static boolean isAccelerometerAvailable() {
        return GameMIDlet.instance.isAccelerometerAvailable();
    }

    public static void startAccelerometer() {
        GameMIDlet.instance.startAccelerometer();
    }

    public static void stopAccelerometer() {
        GameMIDlet.instance.stopAccelerometer();
    }

    public static float[] getAccelerometerReadings() {
        return GameMIDlet.instance.getAccelerometerReadings();
    }

    public static void setFPS(int fps) {
        if (GameMIDlet.instance.gameCanvas != null) {
            GameMIDlet.instance.gameCanvas.setFps(fps);
        }
    }

    public static void setBgFPS(int fps) {
        if (GameMIDlet.instance.gameCanvas != null) {
            GameMIDlet.instance.gameCanvas.setBgFps(fps);
        }
    }

    public static int getWidth() {
        return GameMIDlet.instance.getWidth();
    }

    public static int getHeight() {
        return GameMIDlet.instance.getHeight();
    }

    public static void preventScreenSleep() {
        GameMIDlet.instance.preventScreenSleep();
    }

    public static void allowScreenSleep() {
        GameMIDlet.instance.allowScreenSleep();
    }

    public static void showRateAppDialog() {
        GameMIDlet.instance.rateMyApp();
    }

    public static void showMessageBox(String title, String message) {
        GameMIDlet.instance.showMessageBox(title, message);
    }

    public static boolean showYesNoDialog(String title, String message) {
        return GameMIDlet.instance.showYesNoDialog(title, message);
    }

    public static int showOptionsDialog(String title, String message, String option1, String option2) {
        return GameMIDlet.instance.showOptionsDialog(title, message, option1, option2);
    }

    public static String getUserInput(String question) {
        return GameMIDlet.instance.getUserInput(question);
    }

    public static void openURL(String url) {
        try {
            if (GameMIDlet.instance.platformRequest(url)) {
                GameMIDlet.instance.exit();
            } else {
                GameMIDlet.instance.gameCanvas.hideNotify();
            }
        }
        catch (Exception e2) {
            Debug.print("error:PlatformService.openURL->" + e2);
        }
    }

    public static void errorQuit(String error) {
        Alert alert = new Alert("Error", error, null, AlertType.ERROR);
        Command ok = new Command("Close", 4, 1);
        alert.setTimeout(-2);
        alert.addCommand(ok);
        alert.setCommandListener((CommandListener)GameMIDlet.instance);
        GameMIDlet.instance.display.setCurrent((Displayable)alert);
        String i = "334co3434pyr45454i34ght 343re344n444de443r434ed 3434id343ea3434s34";
        if (i.equals("A")) {
            return;
        }
    }

    public static void sleepThread(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float nextFloat(int n) {
        return GameMIDlet.instance.random.nextFloat() * (float)n;
    }

    public static int nextInt(int n) {
        return GameMIDlet.instance.random.nextInt(n);
    }

    public static int nextInt() {
        return GameMIDlet.instance.random.nextInt();
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static void showFeedbackForm() {
        GameMIDlet.instance.showFeedbackForm();
    }

    public static boolean isTouchSupported() {
        return GameMIDlet.instance.isTouchSupported();
    }

    public static void enableGestures() {
        GameMIDlet.instance.enableGestures();
    }

    public static void disableGestures() {
        GameMIDlet.instance.disableGestures();
    }

    public static void enableMultitouch() {
        GameMIDlet.instance.enableMultitouch();
    }

    public static void disableMultitouch() {
        GameMIDlet.instance.disableMultitouch();
    }

    public static void buyGame() {
        if (GameMIDlet.instance.iapProvider != null) {
            GameMIDlet.instance.iapProvider.buyGame();
        }
    }

    public static String getUUID(String str) {
        String randomNumber = PlatformService.getRandomNumberString(100);
        str = str + randomNumber;
        return PlatformService.getHashValue(str);
    }

    public static String getRandomNumberString(int range) {
        String randomNumber = "";
        for (int i = 0; i < 3; ++i) {
            randomNumber = randomNumber + PlatformService.nextInt(range);
        }
        return randomNumber;
    }

    public static String getHashValue(String str) {
        int hashValue = 17;
        for (int i = 0; i < str.length(); ++i) {
            String tmp = str.substring(i, i + 1);
            hashValue = 31 * hashValue + tmp.hashCode();
        }
        if (hashValue < 0) {
            hashValue = -hashValue;
        }
        return hashValue + "";
    }

    public static boolean isSoundMixingSupported() {
        String mixing = System.getProperty("supports.mixing");
        boolean soundMixing = false;
        if (mixing != null) {
            soundMixing = mixing.trim().toLowerCase().equals("true");
        }
        return soundMixing;
    }

    public static void postScoreToFacebook(int score, String url) {
        PlatformService.openURL(url + "?id=de993nla9ndcnadlid&value=" + score + "&user=dnz9ndo4924ddali");
    }

    public static double getLattitude() {
        return 0.0;
    }

    public static double getLongitude() {
        return 0.0;
    }

    public static void showFps() {
        GameMIDlet.instance.showFps();
    }

    public static void runGarbageCollector() {
        System.gc();
    }

    public static void startLoadingThread() {
        GameMIDlet.instance.gameCanvas.startLoadingThread();
    }

    public static void stopLoadingThread() {
        GameMIDlet.instance.gameCanvas.runningLoadingScreen = false;
    }

    public static void vibrate(int timeMilliseconds) {
        GameMIDlet.instance.display.vibrate(timeMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringResponseFromServer(String url, String postParameters) {
        String string;
        HttpConnection httpConn = null;
        InputStream is = null;
        OutputStream os = null;
        Debug.print("connection server: " + url);
        try {
            int chr;
            int responseCode;
            String customUA = PlatformService.getUserAgent();
            httpConn = (HttpConnection)Connector.open((String)url);
            if (postParameters != null) {
                httpConn.setRequestMethod("POST");
            } else {
                httpConn.setRequestMethod("GET");
            }
            if (httpConn.getRequestProperty("User-Agent") == null) {
                httpConn.setRequestProperty("User-Agent", customUA);
            }
            httpConn.setRequestProperty("Accept_Language", "en-US");
            httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (postParameters != null) {
                os = httpConn.openOutputStream();
                os.write(postParameters.getBytes());
            }
            if ((responseCode = httpConn.getResponseCode()) == 302 || responseCode == 301) {
                String redirectUrl = httpConn.getHeaderField("Location");
                try {
                    httpConn.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (redirectUrl != null) {
                    if (redirectUrl.indexOf(".jpg") != -1 || redirectUrl.indexOf(".png") != -1 || redirectUrl.indexOf(".gif") != -1) {
                        PlatformService.getBitmapResponseFromServer(redirectUrl);
                    } else {
                        String e2 = PlatformService.getStringResponseFromServer(redirectUrl, postParameters);
                        return e2;
                    }
                }
                String e2 = null;
                return e2;
            }
            StringBuffer sb = new StringBuffer();
            is = httpConn.openDataInputStream();
            while ((chr = is.read()) != -1) {
                sb.append((char)chr);
            }
            Debug.print("Server response: " + sb);
            string = new String(sb);
        }
        catch (Exception e3) {
            Debug.print("error in conn:" + e3);
            String string2 = null;
            return string2;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e4) {}
            try {
                os.close();
            }
            catch (Exception e5) {}
            try {
                httpConn.close();
            }
            catch (Exception e6) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapResponseFromServer(String url) {
        HttpConnection hpc = null;
        FilterInputStream dis = null;
        Debug.print("connection server: " + url);
        try {
            hpc = (HttpConnection)Connector.open((String)url);
            int responseCode = hpc.getResponseCode();
            if (responseCode == 302 || responseCode == 301) {
                String redirectUrl = hpc.getHeaderField("Location");
                try {
                    hpc.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (redirectUrl != null) {
                    if (redirectUrl.indexOf(".jpg") != -1 || redirectUrl.indexOf(".png") != -1 || redirectUrl.indexOf(".gif") != -1) {
                        Bitmap e2 = PlatformService.getBitmapResponseFromServer(redirectUrl);
                        return e2;
                    }
                    PlatformService.getStringResponseFromServer(redirectUrl, null);
                }
                Bitmap e2 = null;
                return e2;
            }
            int length = (int)hpc.getLength();
            byte[] data = new byte[length];
            dis = new DataInputStream(hpc.openInputStream());
            ((DataInputStream)dis).readFully(data);
            Bitmap bitmap = new Bitmap(Image.createImage((byte[])data, (int)0, (int)data.length));
            return bitmap;
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        finally {
            if (hpc != null) {
                try {
                    hpc.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getUserAgent() {
        String midletVersion = GameMIDlet.instance.getAppProperty("MIDlet-Version");
        String profile = GameMIDlet.instance.getAppProperty("MicroEdition-Profile");
        String config = GameMIDlet.instance.getAppProperty("MicroEdition-Configuration");
        String device = System.getProperty("microedition.platform");
        String userAgent = midletVersion + " (JavaME; " + device + "; " + "Profile/" + profile + " Configuration/" + config + ")";
        return userAgent;
    }
}

