/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform.accelerometer;

import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.accelerometer.AccelerometerProvider;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class AccelerometerImplementation
extends AccelerometerProvider
implements DataListener,
Runnable {
    SensorConnection iConnection;
    double xValue;
    double yValue;
    double zValue;
    double minValue;
    double maxValue;

    AccelerometerImplementation() {
    }

    public void run() {
        try {
            this.iConnection = this.openSensor();
            if (this.iConnection != null) {
                this.iConnection.setDataListener((DataListener)this, 1);
                this.xValue = 65.0;
            } else {
                this.xValue = 66.0;
            }
        }
        catch (Exception e2) {
            Debug.print("Error:39nd:" + e2);
            PlatformService.errorQuit("This game requires access to Accelerometer Sensor to work. Please restart this game and allow access to sensor.");
        }
    }

    public void openAccelerationSensor() throws IOException {
        new Thread(this).start();
    }

    public SensorConnection openSensor() throws IOException {
        SensorConnection sensor = null;
        SensorInfo[] infos = SensorManager.findSensors((String)"acceleration", null);
        if (infos.length > 0) {
            String str = "334co3434pyr45454i34ght 343re344n444de443r434ed 3434id343ea3434s34";
            if (str.equals("A")) {
                return null;
            }
            try {
                sensor = (SensorConnection)Connector.open((String)infos[0].getUrl());
                return sensor;
            }
            catch (SecurityException se) {
                throw new IOException("could not open sensor");
            }
            catch (IOException ioe) {
                throw new IOException("could not open sensor");
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("could not open sensor");
            }
        }
        throw new IOException("acceleration sensor not found");
    }

    public void closeSensor() {
        try {
            this.iConnection.close();
        }
        catch (Exception e2) {
            Debug.print("error closing sensor:" + e2);
        }
    }

    public void dataReceived(SensorConnection con, Data[] aData, boolean aMissed) {
        if (aData[0].getChannelInfo().getDataType() == 1) {
            this.xValue = aData[0].getDoubleValues()[0];
            this.yValue = aData[1].getDoubleValues()[0];
            this.zValue = aData[2].getDoubleValues()[0];
            this.minValue = aData[0].getChannelInfo().getMeasurementRanges()[0].getSmallestValue();
            this.maxValue = aData[0].getChannelInfo().getMeasurementRanges()[0].getLargestValue();
        } else if (aData[0].getChannelInfo().getDataType() == 2) {
            this.xValue = aData[0].getIntValues()[0];
            this.yValue = aData[1].getIntValues()[0];
            this.zValue = aData[2].getIntValues()[0];
            this.minValue = aData[0].getChannelInfo().getMeasurementRanges()[0].getSmallestValue();
            this.maxValue = aData[0].getChannelInfo().getMeasurementRanges()[0].getLargestValue();
        }
        GameMIDlet.instance.dataReceived(this.xValue, this.yValue, this.zValue, this.minValue, this.maxValue);
    }
}

