/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.components;

import com.am.activity.interfaces.ButtonInterface;
import com.am.activity.main.Activity;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextArea
implements ButtonInterface {
    private final int DEFAULT_COLOR_TEXT;
    private final int DEFAULT_SCROLL_BAR_WIDTH;
    private final Font DEFAULT_FONT_TEXT = Font.getDefaultFont();
    private Activity activity;
    private String textStr;
    private int startPosX = 0;
    private int startPosY = 0;
    private int areaWidth = 0;
    private int areaHeight = 0;
    private int interline = 5;
    private int textWidth = 0;
    private int textHeight = 0;
    private int minTextHeight = 0;
    private int currentStartY = 0;
    private int currentEndY = 0;
    private int textColor = 0xFFFFFF;
    private Font textFont = this.DEFAULT_FONT_TEXT;
    private String[] text;
    private boolean draggedOn = false;
    private int scrollBarX = 0;
    private int scrollBarY = 0;
    private int scrollBarHeight = 0;
    private int scrollBarWidht = 4;
    private boolean scrollbarVisible;
    private int pressedY;
    private boolean pressed;
    private int maxScrollPosition;
    private int scrollPosition;

    public static TextArea CreateMultiLineText(Activity activity, String text, int width, int height) {
        return new TextArea(activity, text, width, height);
    }

    public static TextArea CreateMultiLineText(Activity activity, String text, int width, int height, int posX, int posY) {
        return new TextArea(activity, text, width, height, posX, posY);
    }

    private TextArea(Activity activity, String text, int width, int height) {
        this.DEFAULT_COLOR_TEXT = 0xFFFFFF;
        this.DEFAULT_SCROLL_BAR_WIDTH = 4;
        this.activity = activity;
        this.areaWidth = width;
        this.areaHeight = height;
        this.textStr = text;
        this.checkParam();
        this.setText(this.textStr);
        activity.addTextField(this);
    }

    private TextArea(Activity activity, String text, int width, int height, int posX, int posY) {
        this.DEFAULT_COLOR_TEXT = 0xFFFFFF;
        this.DEFAULT_SCROLL_BAR_WIDTH = 4;
        activity.addTextField(this);
        this.activity = activity;
        this.areaWidth = width;
        this.areaHeight = height;
        this.startPosX = posX;
        this.currentStartY = this.startPosY = posY;
        this.textStr = text;
        this.checkParam();
        this.setText(this.textStr);
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setText(String text) {
        this.textWidth = this.areaWidth - this.getScrollBarWidht() - 4;
        this.text = TextArea.splitStringByWidth(text, this.textFont, this.textWidth);
        this.textHeight = this.text.length * (this.textFont.getHeight() + this.interline);
        this.minTextHeight = (this.textFont.getHeight() + this.interline) * 2;
        System.out.println("textHeight " + this.textHeight);
        System.out.println("areaHeight " + this.areaHeight);
        if (this.textHeight > this.areaHeight) {
            this.draggedOn = true;
            this.scrollbarVisible = true;
        } else {
            this.draggedOn = false;
            this.scrollbarVisible = false;
        }
        this.scrollBarHeight = this.areaHeight * this.areaHeight / this.textHeight;
        System.out.println("scrollBarHeight " + this.scrollBarHeight);
        this.scrollBarX = this.areaWidth + this.startPosX - this.scrollBarWidht;
        this.scrollBarY = this.startPosY;
    }

    private void checkParam() {
        if (this.areaWidth > this.activity.activityWidth) {
            this.areaWidth = this.activity.activityWidth - 5;
            System.err.println("ERROR! Widht area of text > activityWidth");
        }
        if (this.areaWidth <= 0) {
            this.areaWidth = this.activity.activityWidth - 5;
            System.err.println("ERROR! Widht area of text < = 0 !");
        }
        if (this.areaHeight > this.activity.getActivityHeight()) {
            this.areaHeight = this.activity.activityHeight - 5;
            System.err.println("ERROR! Height area of text > activityHeight");
        }
        if (this.areaHeight <= 0) {
            this.areaHeight = this.activity.activityHeight - 5;
            System.err.println("ERROR! Height area of text < = 0 !");
        }
        if (this.startPosX < 0 || this.startPosY < 0) {
            System.err.println("ERROR! Position by X or Y maybe only more than 0");
            this.startPosX = 0;
            this.startPosY = 0;
        }
        if (this.startPosX > this.activity.activityWidth || this.startPosY > this.activity.activityHeight) {
            System.err.println("ERROR! Position by X or Y maybe only less than screen size");
            this.startPosX = 0;
            this.startPosY = 0;
        }
        System.out.println("textHeight " + this.textHeight);
        System.out.println("areaHeight " + this.areaHeight);
    }

    private static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
            }
        }
        return result;
    }

    private static String[] splitStringByWidth(String stringToSplit, Font font, int width) {
        StringBuffer strBuf = new StringBuffer();
        Vector<String> strResult = new Vector<String>();
        String[] workStr = TextArea.split(stringToSplit, " ");
        strBuf.append(workStr[0]);
        for (int result = 1; result < workStr.length; ++result) {
            if (font.stringWidth(strBuf.toString()) + font.stringWidth(workStr[result]) <= width) {
                strBuf.append(" ").append(workStr[result]);
            } else {
                strResult.addElement(strBuf.toString());
                strBuf.delete(0, strBuf.length());
                strBuf.append(workStr[result]);
            }
            if (!(font.stringWidth(strBuf.toString()) <= width & result == workStr.length - 1)) continue;
            strResult.addElement(strBuf.toString());
            strBuf.delete(0, strBuf.length());
        }
        strBuf.delete(0, strBuf.length());
        String[] var8 = new String[strResult.size()];
        if (strResult.size() > 0) {
            for (int loop = 0; loop < strResult.size(); ++loop) {
                var8[loop] = (String)strResult.elementAt(loop);
            }
        }
        return var8;
    }

    public void paint(Graphics g) {
        g.setColor(this.getTextColor());
        g.setFont(this.getTextFont());
        g.setClip(this.startPosX, this.startPosY, this.areaWidth, this.areaHeight);
        if (this.text != null) {
            for (int i = 0; i < this.text.length; ++i) {
                g.drawString(this.text[i], this.startPosX, this.currentStartY + i * this.textFont.getHeight() + this.interline, 20);
            }
            this.currentEndY = this.currentStartY + this.textHeight - this.interline;
        }
        if (this.scrollbarVisible) {
            g.fillRect(this.scrollBarX, this.scrollBarY, this.scrollBarWidht, this.scrollBarHeight);
        }
        g.setClip(0, 0, this.activity.activityWidth, this.activity.activityHeight);
    }

    public boolean getDraggedIOn() {
        return this.draggedOn;
    }

    public void setDraggedOn(boolean dragggedOn) {
        this.draggedOn = dragggedOn;
    }

    public void setScrollbarVisible(boolean scrollbarVisible) {
        this.scrollbarVisible = scrollbarVisible;
    }

    public boolean pointerPressed(int x, int y) {
        if (x > this.startPosX && x < this.startPosX + this.areaWidth && y > this.startPosY && y < this.areaHeight + this.startPosY) {
            this.pressed = true;
        }
        this.pressedY = y;
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.pressed) {
            this.pressed = false;
        }
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.pressed) {
            this.scroll(y);
        }
        return false;
    }

    private void scroll(int y) {
        if (this.draggedOn) {
            boolean distance = false;
            float delta = (float)Math.abs(this.currentStartY - this.startPosY) / (float)this.textHeight;
            if (y > this.pressedY) {
                int distance1 = Math.abs(this.pressedY - y);
                if (this.currentStartY < this.startPosY) {
                    this.currentStartY += distance1;
                    delta = (float)Math.abs(this.currentStartY - this.startPosY) / (float)this.textHeight;
                    this.scrollBarY = (int)((float)this.startPosY + delta * (float)this.areaHeight);
                } else {
                    this.currentStartY = this.startPosY;
                }
                this.pressedY = y;
            } else {
                int distance1 = Math.abs(this.pressedY - y);
                this.currentEndY = this.currentStartY - distance1 + this.textHeight;
                System.out.println(delta);
                if ((double)delta < 0.7) {
                    this.currentStartY -= distance1;
                    delta = (float)Math.abs(this.currentStartY - this.startPosY) / (float)this.textHeight;
                    this.scrollBarY = (int)((float)this.startPosY + delta * (float)this.areaHeight);
                }
                this.pressedY = y;
            }
        }
    }

    public int getScrollBarWidht() {
        return this.scrollBarWidht;
    }

    public void setScrollBarWidht(int scrollBarWidht) {
        this.scrollBarWidht = scrollBarWidht;
        this.setText(this.textStr);
    }
}

