/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.graphics;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNFont;
import com.creativenorth.io.Stream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CNText {
    public static Vector m_fonts;
    public static int m_currentFont;
    public static String[][] m_strings;
    public static int[] m_widths;
    public static int m_fontHeight;
    public static int m_languageCount;
    public static int m_stringCount;
    private static Graphics m_graphics;
    public static int[] m_stringOffsets;
    public static int[] m_vars;
    public static int[] m_varString;
    public static int[] m_varStart;
    public static int[] m_varEnd;
    public static int[] m_varInsert;
    public static int[] m_varIndex;
    private static int currentVar;
    public static final int VARINSERT_NONE = 0;
    public static final int VARINSERT_INT = 1;
    public static final int VARINSERT_FULLSTRING = 2;
    public static final int VARINSERT_SUBSTRING = 3;
    public static final int VARINSERT_INT_SINGLE = 4;
    public static final String g_dummyString = "#notload#";
    private static String g_path;

    public static void clear() {
    }

    public static void load(String path, int fontCount) throws IOException {
        m_currentFont = 0;
        m_fonts = new Vector();
        for (int i = 0; i < fontCount; ++i) {
            m_fonts.addElement(new CNFont());
            ((CNFont)m_fonts.elementAt(i)).load("/font" + i);
        }
        g_path = path;
        Stream stream = new Stream(g_path, 20000);
        m_vars = new int[stream.readU16()];
        m_varString = new int[m_vars.length];
        m_varStart = new int[m_varString.length];
        m_varEnd = new int[m_varString.length];
        m_varInsert = new int[m_varString.length];
        m_varIndex = new int[m_varString.length];
        currentVar = 0;
        m_languageCount = stream.readU16();
        m_stringCount = stream.readU16();
        m_strings = new String[m_languageCount * m_stringCount][1];
        m_widths = new int[m_strings.length];
        for (int i = 0; i < m_strings.length; ++i) {
            CNText.addWithVars(i, stream.readLongString());
            CNText.recalcWidth(i);
        }
        stream.close();
        stream = null;
        CNText.parseAllVars();
    }

    public static void load(String path, int fontCount, int minimumIndex) throws IOException {
        m_currentFont = 0;
        m_fonts = new Vector();
        for (int i = 0; i < fontCount; ++i) {
            m_fonts.addElement(new CNFont());
            ((CNFont)m_fonts.elementAt(i)).load("/font" + i);
        }
        g_path = path;
        Stream stream = new Stream(g_path, 20000);
        m_vars = new int[stream.readU16()];
        m_varString = new int[m_vars.length];
        m_varStart = new int[m_varString.length];
        m_varEnd = new int[m_varString.length];
        m_varInsert = new int[m_varString.length];
        m_varIndex = new int[m_varString.length];
        currentVar = 0;
        m_languageCount = stream.readU16();
        m_stringCount = stream.readU16();
        m_strings = new String[m_languageCount * m_stringCount][1];
        m_widths = new int[m_strings.length];
        m_stringOffsets = new int[minimumIndex];
        for (int i = 0; i < m_strings.length; ++i) {
            if (i >= minimumIndex) {
                CNText.addWithVars(i, stream.readLongString());
                CNText.recalcWidth(i);
                continue;
            }
            CNText.m_stringOffsets[i] = stream.position();
            stream.skipLongString();
            CNText.m_strings[i] = null;
            CNText.m_widths[i] = 0;
        }
        stream.close();
        stream = null;
        CNText.parseAllVars();
    }

    public static int[] bubblesort(int[] items) {
        boolean sorted = false;
        int l = items.length;
        do {
            sorted = true;
            int i = l;
            while (i-- > 1) {
                if (items[i] >= items[i - 1]) continue;
                int n = i;
                items[n] = items[n] ^ items[i - 1];
                int n2 = i - 1;
                items[n2] = items[n2] ^ items[i];
                int n3 = i;
                items[n3] = items[n3] ^ items[i - 1];
                sorted = false;
            }
        } while (!sorted);
        return items;
    }

    public static void loadOnFly(String path, int[] indices) throws IOException {
        int total = 0;
        int[] temp = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] < 0 || indices[i] >= m_strings.length || m_strings[indices[i]] != null) continue;
            temp[total++] = indices[i];
        }
        if (total < 1) {
            return;
        }
        int[] newindices = new int[total];
        System.arraycopy(newindices, 0, temp, 0, total);
        temp = null;
        if (newindices.length > 1) {
            newindices = CNText.bubblesort(newindices);
        }
        g_path = path;
        Stream stream = new Stream(g_path, 20000);
        for (int i = 0; i < newindices.length; ++i) {
            int prevpos = stream.position();
            int offset = m_stringOffsets[newindices[i]];
            int skip = offset - prevpos;
            stream.skip(skip);
            String read = stream.readLongString();
            CNText.addWithVars(newindices[i], read);
            CNText.recalcWidth(newindices[i]);
        }
        stream.close();
        stream = null;
        CNText.parseAllVars();
    }

    public static void loadOnFly(String path, int index) throws IOException {
        if (index < 0) {
            return;
        }
        if (index >= m_strings.length) {
            return;
        }
        if (m_strings[index] != null) {
            return;
        }
        g_path = path;
        Stream stream = new Stream(g_path, 20000);
        int offset = m_stringOffsets[index];
        stream.skip(offset);
        String read = stream.readLongString();
        CNText.addWithVars(index, read);
        CNText.recalcWidth(index);
        stream.close();
        stream = null;
    }

    private static void addWithVars(int index, String string) {
        String finalString = "";
        char c = 'x';
        boolean varFound = false;
        String number = "";
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '{') {
                varFound = true;
                continue;
            }
            if (c == '}') {
                varFound = false;
                int var = Integer.parseInt(number);
                number = "";
                CNText.m_varStart[CNText.currentVar] = finalString.length();
                CNText.m_varEnd[CNText.currentVar] = finalString.length();
                CNText.m_varString[CNText.currentVar] = index;
                CNText.m_varInsert[CNText.currentVar] = 0;
                CNText.m_varIndex[CNText.currentVar] = var;
                CNText.m_vars[CNText.currentVar] = 0;
                ++currentVar;
                continue;
            }
            if (varFound) {
                number = number + c;
                continue;
            }
            finalString = finalString + c;
        }
        CNText.m_strings[index] = new String[]{finalString};
    }

    public static void setVar(int var, int value, int type) {
        for (int i = 0; i < m_varIndex.length; ++i) {
            if (m_varIndex[i] != var) continue;
            CNText.m_vars[i] = value;
            CNText.m_varInsert[i] = type;
        }
        CNText.parseAllVars();
    }

    public static void setVar(int _var, String _val) {
        for (int i = 0; i < m_varIndex.length; ++i) {
            if (m_varIndex[i] != _var) continue;
            String fullString = CNText.getFullString(m_varString[i]);
            String finalString = fullString.substring(0, m_varStart[i]);
            if (_val != null && _val.length() > 0) {
                finalString = finalString + _val;
            }
            int end = finalString.length();
            if (m_varEnd[i] < fullString.length()) {
                finalString = finalString + fullString.substring(m_varEnd[i]);
            }
            CNText.m_strings[CNText.m_varString[i]] = new String[]{finalString};
            if (m_varEnd[i] != end) {
                int diff = end - m_varEnd[i];
                for (int j = 0; j < m_varString.length; ++j) {
                    if (m_varString[j] != m_varString[i] || m_varStart[j] <= m_varEnd[i]) continue;
                    int n = j;
                    m_varStart[n] = m_varStart[n] + diff;
                    int n2 = j;
                    m_varEnd[n2] = m_varEnd[n2] + diff;
                }
            }
            CNText.m_varEnd[i] = end;
            CNText.m_varInsert[i] = 0;
        }
    }

    public static int getVar(int var) {
        for (int i = 0; i < m_varIndex.length; ++i) {
            if (m_varIndex[i] != var) continue;
            return m_vars[i];
        }
        return 0;
    }

    public static int getVarString(int var) {
        for (int i = 0; i < m_varIndex.length; ++i) {
            if (m_varIndex[i] != var) continue;
            return m_varString[i];
        }
        return 0;
    }

    public static void parseAllVars() {
        String fullString = null;
        String finalString = null;
        block5: for (int i = 0; i < m_varInsert.length; ++i) {
            switch (m_varInsert[i]) {
                case 0: {
                    continue block5;
                }
                case 1: 
                case 4: {
                    int j;
                    int diff;
                    fullString = CNText.getFullString(m_varString[i]);
                    finalString = fullString.substring(0, m_varStart[i]);
                    if (m_varInsert[i] == 1 && m_vars[i] < 10) {
                        finalString = finalString + 0;
                    }
                    finalString = finalString + m_vars[i];
                    int end = finalString.length();
                    if (m_varEnd[i] < fullString.length()) {
                        finalString = finalString + fullString.substring(m_varEnd[i]);
                    }
                    CNText.m_strings[CNText.m_varString[i]] = new String[]{finalString};
                    if (m_varEnd[i] != end) {
                        diff = end - m_varEnd[i];
                        for (j = 0; j < m_varString.length; ++j) {
                            if (m_varString[j] != m_varString[i] || m_varStart[j] <= m_varEnd[i]) continue;
                            int n = j;
                            m_varStart[n] = m_varStart[n] + diff;
                            int n2 = j;
                            m_varEnd[n2] = m_varEnd[n2] + diff;
                        }
                    }
                    CNText.m_varEnd[i] = end;
                    CNText.m_varInsert[i] = 0;
                    continue block5;
                }
                case 2: {
                    int j;
                    int diff;
                    fullString = CNText.getFullString(m_varString[i]);
                    finalString = fullString.substring(0, m_varStart[i]);
                    if (m_vars[i] >= 0) {
                        finalString = finalString + CNText.getFullString(m_vars[i]);
                    }
                    int end = finalString.length();
                    if (m_varEnd[i] < fullString.length()) {
                        finalString = finalString + fullString.substring(m_varEnd[i]);
                    }
                    CNText.m_strings[CNText.m_varString[i]] = new String[]{finalString};
                    if (m_varEnd[i] != end) {
                        diff = end - m_varEnd[i];
                        for (j = 0; j < m_varString.length; ++j) {
                            if (m_varString[j] != m_varString[i] || m_varStart[j] <= m_varEnd[i]) continue;
                            int n = j;
                            m_varStart[n] = m_varStart[n] + diff;
                            int n3 = j;
                            m_varEnd[n3] = m_varEnd[n3] + diff;
                        }
                    }
                    CNText.m_varEnd[i] = end;
                    CNText.m_varInsert[i] = 0;
                    continue block5;
                }
            }
        }
    }

    public static String getFullString(int index) {
        if (m_strings == null) {
            return "#nul#";
        }
        if (index < 0) {
            return "#neg#";
        }
        if (index >= m_strings.length) {
            return "#ovr#";
        }
        String string = "";
        if (m_strings[index] == null) {
            try {
                CNText.loadOnFly(g_path, index);
            }
            catch (Exception e) {
                Log.addExeption("Error reloading string " + index, e);
            }
        }
        for (int i = 0; i < m_strings[index].length; ++i) {
            string = m_strings[index][i] == null ? string + "|" : string + m_strings[index][i];
        }
        return string;
    }

    public static void setGraphics(Graphics graphics) {
        if (m_graphics != null) {
            graphics.setFont(m_graphics.getFont());
        }
        m_graphics = graphics;
    }

    public static int getWidth(String string) {
        return ((CNFont)m_fonts.elementAt(m_currentFont)).getStringWidth(string);
    }

    public static void recalcWidth(int index) {
        if (m_strings[index] == null) {
            return;
        }
        CNText.m_widths[index] = ((CNFont)m_fonts.elementAt(m_currentFont)).getStringWidth(m_strings[index][0].trim());
    }

    public static int recalcNewlines(int index, int width) {
        int i;
        String originalLine = CNText.getFullString(index);
        char c = '\u0000';
        Vector<String> lines = new Vector<String>();
        String word = "";
        String line = "";
        for (i = 0; i < originalLine.length(); ++i) {
            c = originalLine.charAt(i);
            if (i == originalLine.length() - 1) {
                word = word + c;
                c = ' ';
            }
            if (c == ' ') {
                if (((CNFont)m_fonts.elementAt(m_currentFont)).getStringWidth(line + word) > width) {
                    if (i < originalLine.length() - 1) {
                        word = word + ' ';
                    }
                    lines.addElement(line);
                    line = word;
                } else {
                    if (i < originalLine.length() - 1) {
                        word = word + ' ';
                    }
                    line = line + word;
                }
                word = "";
                continue;
            }
            if (c == '|' || c == '\n') {
                if (((CNFont)m_fonts.elementAt(m_currentFont)).getStringWidth(line + word) > width) {
                    lines.addElement(line);
                    lines.addElement(word + '\n');
                } else {
                    lines.addElement(line + word + '\n');
                }
                line = "";
                word = "";
                continue;
            }
            word = word + c;
        }
        lines.addElement(line);
        if (index >= m_strings.length) {
            Log.addWarning("Attempting to use string " + index + " of " + m_strings.length);
            return 0;
        }
        CNText.m_strings[index] = new String[lines.size()];
        for (i = 0; i < m_strings[index].length; ++i) {
            CNText.m_strings[index][i] = (String)lines.elementAt(i);
        }
        return m_strings[index].length;
    }

    public static void drawString(int _index, int _x, int _yoff, int _y, int _h) {
        if (m_strings[_index] == null) {
            try {
                CNText.loadOnFly(g_path, _index);
            }
            catch (Exception e) {
                Log.addExeption("Error reloading string " + _index, e);
            }
        }
        ((CNFont)m_fonts.elementAt(m_currentFont)).drawString(m_strings[_index], _x, _y, 0, m_graphics, _h, _yoff);
    }

    public static void drawString(int index, int x, int y) {
        if (m_strings[index] == null) {
            try {
                CNText.loadOnFly(g_path, index);
            }
            catch (Exception e) {
                Log.addExeption("Error reloading string " + index, e);
            }
        }
        ((CNFont)m_fonts.elementAt(m_currentFont)).drawString(m_strings[index], x, y, 0, m_graphics);
    }

    public static void drawString(String string, int x, int y) {
        ((CNFont)m_fonts.elementAt(m_currentFont)).drawString(string, x, y, 0, m_graphics);
    }

    public static void setColor(int color) {
        m_graphics.setColor(color);
    }

    public static void setFont(int index) {
        if (index < 0 || index > m_fonts.size() - 1) {
            index = 0;
        }
        m_currentFont = index;
        m_fontHeight = ((CNFont)m_fonts.elementAt(m_currentFont)).getCharHeight();
    }

    public static int getHeight(int index) {
        return m_strings[index].length * m_fontHeight;
    }

    public static int getStringID(String string) {
        for (int i = 0; i < m_strings[0].length; ++i) {
            if (m_strings[0][i] != string) continue;
            return i;
        }
        return -1;
    }

    static {
        currentVar = 0;
    }
}

