/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import schoolfriends.Data;
import schoolfriends.SchoolCore;
import schoolfriends.Scripts;
import schoolfriends.graphics.Engine;

public class MultiOptiList
extends ScreenObject {
    public static MultiOptiList me;
    private int SelectedIndex;
    private int highlightedIndex;
    private int TopItem;
    final int VISIBLE_ITEMS;
    final int BAR_HEIGHT;
    final int TEXT_OFFSET_X;
    final int TEXT_OFFSET_Y;
    final int TEXT_DROP;
    final int SEPARATOR_THICKNESS;
    final int SHIFT_BOUNDRY;
    final int SCROLL_SIZE;
    final int SCROLL_SPACER;
    final int ITEM_HEIGHT;
    final int LIST_HEIGHT;
    final int SCROLL_HEIGHT;
    private int m_keyDown = 0;
    final int KEY_NOT_DOWN;
    final int KEY_DOWN;
    final int KEY_UP;
    private int[] m_items;
    int ROW_COUNT;
    int bounceX = 0;
    int bounceStringWidth = 0;
    boolean bounceLeft = true;
    boolean bounceEnabled = false;
    public static final int TEXT_SPACE = 10;
    public static String[] Options;
    public static String pt_option;
    public static int g_selectedOption;

    public MultiOptiList() {
        this.VISIBLE_ITEMS = 4;
        this.BAR_HEIGHT = 17;
        this.TEXT_OFFSET_X = 2;
        this.TEXT_OFFSET_Y = 1;
        this.TEXT_DROP = 4;
        this.SEPARATOR_THICKNESS = 2;
        this.SHIFT_BOUNDRY = 2;
        this.SCROLL_SIZE = 11;
        this.SCROLL_SPACER = 2;
        this.ITEM_HEIGHT = 17;
        this.LIST_HEIGHT = 70;
        this.SCROLL_HEIGHT = 4;
        this.KEY_NOT_DOWN = 0;
        this.KEY_DOWN = 1;
        this.KEY_UP = 2;
        me = this;
        this.SelectedIndex = 0;
        this.highlightedIndex = 0;
        this.TopItem = 0;
    }

    public void load(Stream _stream) throws IOException {
        super.load(_stream);
        this.boundsHeight = 96;
    }

    public void setItems(int[] _items) {
        try {
            CNText.loadOnFly("/text.dat", _items);
        }
        catch (IOException ex) {
            Log.addExeption("Error loading option list strings", ex);
        }
        this.m_items = _items;
        this.SelectedIndex = 0;
    }

    public boolean onKeyDown(int keycode) {
        if (!this.visible) {
            return false;
        }
        if (keycode == 4) {
            if (this.SelectedIndex < this.m_items.length - 1) {
                ++this.SelectedIndex;
            }
            if (this.highlightedIndex < 3 && this.highlightedIndex < this.m_items.length - 1) {
                ++this.highlightedIndex;
            } else if (this.TopItem + this.highlightedIndex < this.m_items.length - 1) {
                ++this.TopItem;
            }
            if (CNText.getWidth(CNText.getFullString(this.m_items[this.SelectedIndex])) > this.boundsWidth) {
                this.bounceEnabled = true;
                this.bounceLeft = true;
                this.bounceX = 0;
                this.bounceStringWidth = CNText.getWidth(CNText.getFullString(this.m_items[this.SelectedIndex]));
            } else {
                this.bounceEnabled = false;
                this.bounceLeft = true;
                this.bounceX = 0;
                this.bounceStringWidth = 0;
            }
            this.m_keyDown = 1;
        }
        if (keycode == 1) {
            if (this.SelectedIndex > 0) {
                --this.SelectedIndex;
            }
            if (this.highlightedIndex > 0) {
                --this.highlightedIndex;
            } else if (this.TopItem > 0) {
                --this.TopItem;
            }
            if (CNText.getWidth(CNText.getFullString(this.m_items[this.SelectedIndex])) > this.boundsWidth) {
                this.bounceEnabled = true;
                this.bounceLeft = true;
                this.bounceX = 0;
                this.bounceStringWidth = CNText.getWidth(CNText.getFullString(this.m_items[this.SelectedIndex]));
            } else {
                this.bounceEnabled = false;
                this.bounceLeft = true;
                this.bounceX = 0;
                this.bounceStringWidth = 0;
            }
            this.m_keyDown = 2;
        }
        if (keycode == 16) {
            this.select();
        }
        if (keycode == 32 || keycode == 64) {
            this.visible = false;
        }
        return true;
    }

    public boolean onKeyUp(int keycode) {
        if (!this.visible) {
            return false;
        }
        this.m_keyDown = 0;
        return true;
    }

    public void select() {
        g_selectedOption = this.SelectedIndex;
        this.hide();
        this.reset();
    }

    private void reset() {
        this.TopItem = 0;
        this.SelectedIndex = 0;
        this.highlightedIndex = 0;
        this.bounceEnabled = false;
        this.bounceLeft = true;
        this.bounceX = 0;
        this.bounceStringWidth = 0;
    }

    public void renderMeDebug(CNGraphics graphics) {
        this.render(graphics);
    }

    public void render(CNGraphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.m_items == null) {
            return;
        }
        int x = this.boundsX;
        int y = this.boundsY;
        int w = this.boundsWidth;
        int h = this.boundsHeight;
        if (this.bounceLeft) {
            ++this.bounceX;
            if (this.bounceStringWidth - this.bounceX + 10 < this.boundsWidth) {
                this.bounceLeft = false;
            }
        } else {
            --this.bounceX;
            if (this.bounceX <= -10) {
                this.bounceLeft = true;
            }
        }
        graphics.setClip(x, y, w, h);
        graphics.setColor(40951);
        graphics.fillRect(x, y, w, h);
        graphics.setColor(7983099);
        graphics.fillRect(x, y, w, 17);
        graphics.setColor(0);
        graphics.drawRect(x, y, w, 17);
        CNText.drawString(Options[0], x + (w - CNText.getWidth(Options[SchoolCore.LanguageIndex]) >> 1), y + 1);
        y += 17;
        if (this.SelectedIndex != 0) {
            if (this.m_keyDown == 2) {
                graphics.setColor(16742656);
            } else {
                graphics.setColor(7983099);
            }
            SchoolCore.me.drawUpArrow(graphics.m_graphics, this.boundsX + (w - 4 >> 1), y + 1, 4);
        }
        graphics.setColor(16742656);
        graphics.fillRect(x, (y += 4) + this.highlightedIndex * 17, w, 17);
        ++x;
        w -= 2;
        h -= 2;
        x += 2;
        ++y;
        for (int i = this.TopItem; i < this.TopItem + 4 && i < this.m_items.length; ++i) {
            graphics.setClip(this.boundsX + 3, y - 1 + 2, this.boundsWidth - 6, 17);
            if (i == this.SelectedIndex) {
                graphics.setColor(0xFFFFFF);
                if (this.bounceEnabled) {
                    CNText.drawString(this.m_items[i], x - this.bounceX, y);
                } else {
                    CNText.drawString(this.m_items[i], x + 1, y);
                }
            } else {
                graphics.setColor(0);
                CNText.drawString(this.m_items[i], x + 1, y);
            }
            y += 17;
        }
        graphics.resetClip();
        if (this.SelectedIndex != this.m_items.length - 1) {
            if (this.m_keyDown == 1) {
                graphics.setColor(16742656);
            } else {
                graphics.setColor(7983099);
            }
            SchoolCore.me.drawDownArrow(graphics.m_graphics, this.boundsX + (this.boundsWidth - 4 >> 1), this.boundsY + this.boundsHeight - 3, 4);
        }
        graphics.setColor(0);
        graphics.drawRect(this.boundsX, this.boundsY + 17 - 1, this.boundsWidth, this.boundsHeight - 17 + 1);
        this.renderDropShadow(graphics.m_graphics);
    }

    public static void ClearDestinationList() {
        Data.destinations.removeAllElements();
    }

    public static void SetDestination(int num, int room, int x, int y, boolean tile) {
        if (room == Engine.g_iCurrentRoomIndex || room < 0 || room >= Data.rooms.length) {
            return;
        }
        Data.Destination d = new Data.Destination(room, x, y, tile);
        Data.destinations.addElement(d);
    }

    public static void AddDestination(int room, int x, int y, boolean tile) {
        if (room == Engine.g_iCurrentRoomIndex || room < 0 || room >= Data.rooms.length) {
            return;
        }
        Data.Destination d = new Data.Destination(room, x, y, tile);
        Data.destinations.addElement(d);
    }

    public static void ShowDestinationList(Scripts.ScriptThread script) {
        Engine.g_iKey = 0;
        int[] items = new int[Data.destinations.size() + 1];
        int i = 0;
        Enumeration e = Data.destinations.elements();
        while (e.hasMoreElements()) {
            Data.Destination d = (Data.Destination)e.nextElement();
            items[i++] = Data.roomnames[d.room];
        }
        items[i] = 78;
        me.setItems(items);
        ScreenObject.show(69);
        g_selectedOption = -1;
        while (g_selectedOption == -1) {
            script.lockme();
        }
        if (g_selectedOption == i) {
            Engine.g_bRepaint = true;
        } else if (g_selectedOption < Data.destinations.size()) {
            Data.Destination chosen = (Data.Destination)Data.destinations.elementAt(g_selectedOption);
            if (!Data.roomlocked[chosen.room]) {
                Engine.MovePlayer(script, chosen.x, chosen.y, chosen.room, false, chosen.tile);
            }
        }
        MultiOptiList.ClearDestinationList();
    }

    public static void AddOption(int txt) {
        Data.options.addElement(new Integer(txt));
    }

    public static int ShowOptionList() {
        Engine.g_iKey = 0;
        int[] options = new int[Data.options.size() + 1];
        Enumeration e = Data.options.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            options[i++] = (Integer)e.nextElement();
        }
        options[i] = 78;
        me.setItems(options);
        me.show();
        return i;
    }

    public static void ShowOptionList(Scripts.ScriptThread script, boolean yet_another_arbritrary_parameter_thanks_for_telling_us_first_guys) {
        int count = MultiOptiList.ShowOptionList();
        g_selectedOption = -1;
        while (g_selectedOption == -1) {
            script.lockme();
        }
        if (g_selectedOption == count) {
            g_selectedOption = -1;
        }
        Engine.g_bRepaint = true;
        Data.options = new Vector();
        System.gc();
    }

    static {
        Options = new String[]{"Options", "Options", "Opzioni", "Optionen", "Opciones", "Op\u00e7\u00f5es"};
        g_selectedOption = -1;
    }
}

