/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.games;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.graphics.CNText;
import java.util.Random;
import javax.microedition.lcdui.Font;
import schoolfriends.games.MiniGame;
import schoolfriends.graphics.Engine;

public class NumberSnake
extends MiniGame {
    protected static final int STATE_START = 0;
    protected static final int STATE_STARTWAIT = 1;
    protected static final int STATE_PLAY = 2;
    protected static final int STATE_DEAD = 3;
    protected static final int STATE_NEXTLEVEL = 4;
    protected static final int STATE_GAMEOVER = 5;
    protected static final int SNAKECOLOUR = 0xAAAAFF;
    protected static final int TARGETCOLOUR = 0xAAAA00;
    protected static final int[] POWERUPCOLS = new int[]{0x44FF44, 0xEEEEEE};
    protected static final int SPEED_SLOWEST = 100;
    protected static final int SPEED_FASTEST = 50;
    protected static final int SPEED_START = 4;
    protected static final int LENGTH_START = 5;
    protected static final int POWERUP_PARAMS = 4;
    protected static final int POWERUP_MINTIME = 500;
    protected static final int POWERUP_MAXTIME = 2000;
    protected static final int POWERUP_MAXCOUNT = 9;
    protected int play_x;
    protected int play_y;
    protected int play_w;
    protected int play_h;
    protected int status_x;
    protected int status_xw;
    protected int status_y;
    protected int status_w;
    protected int status_h;
    protected int target_y;
    protected int block_w;
    protected int block_h;
    protected int board_w;
    protected int board_h;
    protected int message_x;
    protected int message_y;
    protected int message_gap;
    protected int help_x;
    protected int help_y;
    protected int target;
    protected int target_mult;
    protected int total;
    protected int target_min;
    protected int target_max;
    protected int sums_to_go;
    protected SnakeData player;
    protected int[][] powerups;
    protected Random random;
    protected int state;
    protected int level;
    protected int score;
    protected int lives;
    protected int strRef_intro;
    protected int strRef_lives;
    protected int strRef_score;
    protected int strRef_target;
    protected int strRef_total;
    protected int strRef_nextlevel;
    protected int strRef_win;
    protected int strRef_dead;
    protected int strRef_lose;
    protected boolean keypress;
    protected int prev_key;
    protected long poweruptime;
    private static String TXT_LIVES;
    private static String TXT_SCORE;
    private static String TXT_TOTAL;
    private static String TXT_TARGET;

    public NumberSnake(int x, int y, int w, int h, int level, int strintro, int strlives, int strscore, int strtarget, int strtotal, int strnextlevel, int strwin, int strdead, int strlose) {
        super(x, y, w, h);
        h = 290;
        this.status_x = this.play_x = x;
        this.status_w = w;
        this.status_xw = x + w;
        this.status_y = y;
        this.target_y = y + h - 10;
        this.status_h = Font.getDefaultFont().getHeight() + 4;
        this.message_gap = this.status_h - 2;
        this.block_w = 10;
        this.block_h = 10;
        this.board_w = w / this.block_w;
        this.board_h = (h - this.status_h * 2 - 10) / this.block_h;
        this.play_w = this.board_w * this.block_w;
        this.play_h = this.board_h * this.block_h;
        this.play_y = y + (h - this.play_h - 8) / 2;
        this.message_x = x + w / 2;
        this.message_y = y + (h - Font.getDefaultFont().getHeight()) / 2;
        int help_w = Font.getDefaultFont().stringWidth("LONGER") + 4 + this.block_w * 4;
        this.help_x = this.message_x - help_w / 2 + this.block_w * 4;
        this.help_y = this.message_y + this.message_gap;
        this.player = new SnakeData();
        this.random = new Random();
        this.random.setSeed(System.currentTimeMillis());
        this.sums_to_go = level > 0 ? level : -1;
        this.strRef_intro = strintro;
        this.strRef_lives = strlives;
        this.strRef_score = strscore;
        this.strRef_target = strtarget;
        this.strRef_total = strtotal;
        this.strRef_nextlevel = strnextlevel;
        this.strRef_win = strwin;
        this.strRef_dead = strdead;
        this.strRef_lose = strlose;
        TXT_LIVES = CNText.getFullString(this.strRef_lives) + ": ";
        TXT_SCORE = CNText.getFullString(this.strRef_score) + ": ";
        TXT_TARGET = CNText.getFullString(this.strRef_target) + ": ";
        TXT_TOTAL = CNText.getFullString(this.strRef_total) + ": ";
        this.init();
        this.m_bCanEnd = false;
    }

    public void init() {
        this.level = 0;
        this.score = 0;
        this.lives = 3;
        this.state = 0;
        this.target_min = 4;
        this.target_max = 13;
        this.player.length = 1;
        this.player.delay = 100;
    }

    public void start() {
        this.powerups = null;
        this.poweruptime = System.currentTimeMillis() + (long)this.rand(500, 2000);
        this.total = 0;
        this.target = this.rand(Math.max(2, this.target_min - 3), this.target_min);
        this.target_mult = this.rand(Math.max(2, this.target_min - 3), this.target_min);
        if (this.target_min < this.target_max) {
            this.target_min += 2;
        }
        this.spawnPlayer();
        for (int i = 0; i < 9; ++i) {
            this.spawnPowerup();
        }
        this.state = 1;
    }

    private void respawnPlayer() {
        this.total = 0;
        this.player.length = 1;
        this.player.delay = 100;
        this.spawnPlayer();
    }

    private void spawnPlayer() {
        this.player.xs[0] = this.rand(1, this.board_w - 2);
        this.player.ys[0] = this.rand(1, this.board_h - 2);
        this.player.lengthadd = Math.max(5, this.player.length);
        this.player.length = 1;
        this.player.blockindex = 0;
    }

    public int rand(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int m = max;
            max = min;
            min = m;
        }
        return min + Math.abs(this.random.nextInt()) % (max - min + 1);
    }

    public void reset() {
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.keypress = false;
        if (this.m_nGameAction != 0 && this.prev_key != this.m_nGameAction) {
            this.hideMessage();
            this.keypress = true;
        }
        this.prev_key = this.m_nGameAction;
        t = System.currentTimeMillis();
        elapsed = t - this.m_time;
        this.m_time = t;
        switch (this.state) {
            case 0: {
                Engine.ShowMessageUltra(4, null, 87, 0);
                this.target = this.rand(2, this.target_min);
                this.target_mult = this.rand(2, this.target_min);
                if (!this.keypress) break;
                this.start();
                break;
            }
            case 1: {
                this.hideMessage();
                if (!this.keypress || this.m_nGameAction != 8 && this.m_nGameAction != 2 && this.m_nGameAction != 1 && this.m_nGameAction != 4) break;
                this.player.direction = this.m_nGameAction;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.keypress) {
                    if (this.m_nGameAction == 8 || this.m_nGameAction == 2) {
                        if (this.player.direction == 1 || this.player.direction == 4) {
                            this.player.direction = this.m_nGameAction;
                        }
                    } else if (!(this.m_nGameAction != 1 && this.m_nGameAction != 4 || this.player.direction != 8 && this.player.direction != 2)) {
                        this.player.direction = this.m_nGameAction;
                    }
                }
                if (this.player.length <= 0) ** GOTO lbl136
                this.player.timer = (int)((long)this.player.timer + elapsed);
                if (this.player.timer <= this.player.delay) ** GOTO lbl142
                this.player.timer -= this.player.delay;
                nx = this.player.xs[this.player.blockindex];
                ny = this.player.ys[this.player.blockindex];
                if (this.player.direction == 8) {
                    --nx;
                } else if (this.player.direction == 2) {
                    ++nx;
                } else if (this.player.direction == 1) {
                    --ny;
                } else if (this.player.direction == 4) {
                    ++ny;
                }
                next = (this.player.blockindex + 1) % this.player.length;
                collide = nx < 0 || nx >= this.board_w || ny < 0 || ny >= this.board_h;
                for (i = this.player.length - 1; i >= 0; --i) {
                    if (this.player.xs[i] != nx || this.player.ys[i] != ny) continue;
                    this.score = Math.max(0, this.score - 5);
                    collide = true;
                    break;
                }
                if (!collide) ** GOTO lbl67
                if (this.player.lengthadd > 0) {
                    --this.player.lengthadd;
                } else {
                    for (j = next; j < this.player.length - 1; ++j) {
                        this.player.xs[j] = this.player.xs[j + 1];
                        this.player.ys[j] = this.player.ys[j + 1];
                    }
                    if (this.player.blockindex == this.player.length - 1) {
                        --this.player.blockindex;
                    }
                    --this.player.length;
                }
                ** GOTO lbl142
lbl67:
                // 1 sources

                if (this.player.lengthadd > 0) {
                    --this.player.lengthadd;
                    if (this.player.xs.length < this.player.length + 1) {
                        xsnew = new int[this.player.length + 1];
                        ysnew = new int[this.player.length + 1];
                        for (j = 0; j < this.player.length; ++j) {
                            if (j < this.player.blockindex) {
                                xsnew[j] = this.player.xs[j + 1];
                                ysnew[j] = this.player.ys[j + 1];
                                continue;
                            }
                            if (j == this.player.blockindex) {
                                xsnew[j] = nx;
                                ysnew[j] = ny;
                                continue;
                            }
                            xsnew[j] = this.player.xs[j];
                            ysnew[j] = this.player.ys[j];
                        }
                        xsnew[this.player.length] = this.player.xs[0];
                        ysnew[this.player.length] = this.player.ys[0];
                        this.player.xs = xsnew;
                        this.player.ys = ysnew;
                    } else {
                        this.player.xs[this.player.length] = this.player.xs[0];
                        this.player.ys[this.player.length] = this.player.ys[0];
                        for (j = 0; j < this.player.blockindex; ++j) {
                            this.player.xs[j] = this.player.xs[j + 1];
                            this.player.ys[j] = this.player.ys[j + 1];
                        }
                        this.player.xs[this.player.blockindex] = nx;
                        this.player.ys[this.player.blockindex] = ny;
                    }
                    ++this.player.length;
                } else {
                    this.player.xs[next] = nx;
                    this.player.ys[next] = ny;
                    this.player.blockindex = next;
                }
                if (this.powerups == null) ** GOTO lbl142
                for (j = 0; j < this.powerups.length; ++j) {
                    if ((this.powerups[j][0] != nx || ny < this.powerups[j][1] - 1 || ny > this.powerups[j][1] + 1) && (this.powerups[j][1] != ny || nx < this.powerups[j][0] - 1 || nx > this.powerups[j][0] + 1)) continue;
                    if (this.powerups[j][2] == 0) {
                        ++this.player.lengthadd;
                        this.score += 25;
                    } else {
                        this.player.delay = this.player.delay * 7 / 8;
                        if (this.player.delay <= 50) {
                            this.player.delay = 50;
                        }
                        this.score += 75;
                    }
                    this.total += this.powerups[j][3];
                    if (this.total > this.target * this.target_mult) {
                        if (this.lives > 0) {
                            this.state = 3;
                            Engine.ShowMessageUltra(4, null, this.strRef_dead, -1);
                        } else {
                            this.state = 5;
                            Engine.ShowMessageUltra(4, null, this.strRef_lose, -1);
                        }
                    }
                    if (this.powerups.length == 1) {
                        this.powerups = null;
                    } else {
                        powerupnew = new int[this.powerups.length - 1][];
                        for (k = 0; k < this.powerups.length; ++k) {
                            if (k < j) {
                                powerupnew[k] = this.powerups[k];
                                continue;
                            }
                            if (k <= j) continue;
                            powerupnew[k - 1] = this.powerups[k];
                        }
                        this.powerups = powerupnew;
                    }
                    ** GOTO lbl142
                }
                ** GOTO lbl142
lbl136:
                // 1 sources

                if (this.lives > 0) {
                    this.state = 3;
                    Engine.ShowMessageUltra(4, null, this.strRef_dead, -1);
                } else {
                    this.state = 5;
                    Engine.ShowMessageUltra(4, null, this.strRef_lose, -1);
                }
lbl142:
                // 9 sources

                if (this.state != 3 && this.total == this.target * this.target_mult) {
                    this.score += this.target * this.target_mult;
                    --this.sums_to_go;
                    this.state = 4;
                    if (this.sums_to_go != 0) {
                        Engine.ShowMessageUltra(4, null, this.strRef_nextlevel, -1);
                    } else {
                        Engine.ShowMessageUltra(4, null, this.strRef_win, -1);
                    }
                }
                if (t <= this.poweruptime) break;
                this.poweruptime = System.currentTimeMillis() + (long)this.rand(500, 2000);
                if (this.powerups != null) {
                    if (this.powerups.length >= 9) break;
                    this.spawnPowerup();
                    break;
                }
                this.spawnPowerup();
                break;
            }
            case 3: {
                Engine.ShowMessageUltra(4, null, this.strRef_dead, -1);
                if (!this.keypress) break;
                --this.lives;
                this.respawnPlayer();
                this.state = 1;
                this.hideMessage();
                break;
            }
            case 4: {
                if (this.sums_to_go != 0) {
                    Engine.ShowMessageUltra(4, null, this.strRef_nextlevel, -1);
                } else {
                    Engine.ShowMessageUltra(4, null, this.strRef_win, -1);
                }
                this.target = this.rand(2, this.target_min);
                this.target_mult = this.rand(2, this.target_min);
                if (!this.keypress) break;
                ++this.level;
                this.start();
                this.hideMessage();
                break;
            }
            case 5: {
                Engine.ShowMessageUltra(4, null, this.strRef_lose, -1);
                if (!this.keypress) break;
                this.m_bCanEnd = true;
                this.hideMessage();
            }
        }
    }

    public void paint(CNGraphics graphics) {
        graphics.setClip(this.m_nDrawX, this.m_nDrawY, this.m_nDrawW, this.m_nDrawH);
        graphics.setColor(0xFFFFFF);
        CNText.drawString(TXT_LIVES + this.lives, this.status_x + 2, this.status_y + 2);
        CNText.drawString(TXT_SCORE + this.score, this.status_xw - 2 - CNText.getWidth(TXT_SCORE + this.score), this.m_nDrawY + 2);
        CNText.drawString(TXT_TARGET + this.target + " x " + this.target_mult, this.status_x + 2, this.target_y - 2 - 14);
        CNText.drawString(TXT_TOTAL + this.total, this.status_xw - 5 - CNText.getWidth(TXT_TOTAL + this.total), this.target_y - 2 - 14);
        graphics.drawRect(this.play_x, this.play_y, this.play_w, this.play_h);
        switch (this.state) {
            case 0: {
                graphics.m_graphics.drawString(CNText.getFullString(79), this.help_x + 4, this.help_y, 20);
                graphics.drawImage(this.m_images[1], this.help_x - this.block_w * 4, this.help_y + (this.message_gap - this.block_h) / 2, 0);
                break;
            }
            case 1: {
                this.drawSnakes(graphics);
                break;
            }
            case 2: {
                this.drawSnakes(graphics);
                break;
            }
            case 3: {
                this.drawSnakes(graphics);
                break;
            }
            case 4: {
                this.drawSnakes(graphics);
                graphics.setColor(0xFFFFFF);
            }
            case 5: {
                this.drawSnakes(graphics);
            }
        }
    }

    private void drawSnakes(CNGraphics g) {
        if (this.powerups != null) {
            for (int i = 0; i < this.powerups.length; ++i) {
                this.drawPowerup(g, this.play_x + this.block_w * this.powerups[i][0], this.play_y + this.block_h * this.powerups[i][1], this.powerups[i][2], this.powerups[i][3]);
            }
        }
        if (this.player.length < 1) {
            return;
        }
        if (this.m_images != null && this.m_images.length > 2 && this.m_images[1] != null && this.m_images[2] != null) {
            int transform = this.player.direction == 8 ? 0 : (this.player.direction == 1 ? 5 : (this.player.direction == 2 ? 3 : 6));
            g.m_graphics.drawRegion(this.m_images[1].getImage(), 0, 0, this.m_images[1].getWidth(), this.m_images[1].getHeight(), transform, this.play_x + this.block_w * this.player.xs[this.player.blockindex], this.play_y + this.block_h * this.player.ys[this.player.blockindex], 0);
            int end = (this.player.blockindex + 1) % this.player.length;
            int prevend = (end + 1) % this.player.length;
            int i = end;
            while ((i = (i + 1) % this.player.length) != this.player.blockindex) {
                int x = this.player.xs[i];
                int y = this.player.ys[i];
                int dx = this.play_x + this.block_w * x;
                int dy = this.play_y + this.block_h * y;
                int p = i - 1 >= 0 ? i - 1 : this.player.length - 1;
                int n = (i + 1) % this.player.length;
                g.setColor(16753467);
                g.fillRect(dx, dy, this.block_w, this.block_h);
                g.setColor(0);
                if (this.player.xs[p] >= x && this.player.xs[n] >= x) {
                    g.drawLine(dx, dy, dx, dy + this.block_h - 1);
                }
                if (this.player.xs[p] <= x && this.player.xs[n] <= x) {
                    g.drawLine(dx + this.block_w - 1, dy, dx + this.block_w - 1, dy + this.block_h - 1);
                }
                if (this.player.ys[p] >= y && this.player.ys[n] >= y) {
                    g.drawLine(dx, dy, dx + this.block_w - 1, dy);
                }
                if (this.player.ys[p] > y || this.player.ys[n] > y) continue;
                g.drawLine(dx, dy + this.block_h - 1, dx + this.block_w - 1, dy + this.block_h - 1);
            }
            if (this.player.length == 1) {
                return;
            }
            transform = this.player.xs[prevend] < this.player.xs[end] ? 0 : (this.player.ys[prevend] < this.player.ys[end] ? 5 : (this.player.xs[prevend] > this.player.xs[end] ? 3 : 6));
            g.m_graphics.drawRegion(this.m_images[2].getImage(), 0, 0, this.m_images[2].getWidth(), this.m_images[2].getHeight(), transform, this.play_x + this.block_w * this.player.xs[end], this.play_y + this.block_h * this.player.ys[end], 0);
            return;
        }
        g.setColor(0xAAAAFF);
        for (int j = 0; j < this.player.length; ++j) {
            g.fillRect(this.play_x + this.block_w * this.player.xs[j], this.play_y + this.block_h * this.player.ys[j], this.block_w, this.block_h);
        }
    }

    private void drawPowerup(CNGraphics g, int x, int y, int type, int number) {
        g.setColor(POWERUPCOLS[type]);
        if (number > 0) {
            try {
                CNImage img;
                if (this.m_images != null && this.m_images.length >= 8 && (img = this.m_images[6 + type]) != null) {
                    g.m_graphics.drawRegion(img.getImage(), (number - 1) * 12, 0, 12, 12, 0, x + this.block_w / 2 - 6, y + this.block_h / 2 - 6, 0);
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Font f = Font.getDefaultFont();
            char c = (char)(48 + number);
            g.m_graphics.drawString("" + number, x + (this.block_w - f.charWidth(c)) / 2 + 1, y + (this.block_h - f.getHeight()) / 2, 0);
            return;
        }
        g.fillRect(x, y, this.block_w, this.block_h);
    }

    private void spawnPowerup() {
        int y;
        int x;
        if (this.powerups == null) {
            this.powerups = new int[1][4];
        } else {
            int[][] powerupnew = new int[this.powerups.length + 1][4];
            for (int i = 0; i < this.powerups.length; ++i) {
                for (int j = 0; j < 4; ++j) {
                    powerupnew[i][j] = this.powerups[i][j];
                }
            }
            this.powerups = powerupnew;
        }
        int i = this.powerups.length - 1;
        this.powerups[i][2] = this.rand(0, 10) < 8 ? 0 : 1;
        this.powerups[i][3] = this.rand(1, 9);
        this.powerups[i][1] = -99;
        this.powerups[i][0] = -99;
        while (this.collision(x = this.rand(1, this.board_w - 2), y = this.rand(1, this.board_h - 5))) {
        }
        this.powerups[i][0] = x;
        this.powerups[i][1] = y;
    }

    private boolean collision(int x, int y) {
        if (x >= 0 && x < this.board_w && y >= 0 && y < this.board_h) {
            for (int k = this.player.length - 1; k >= 0; --k) {
                if (this.player.xs[k] != x || this.player.ys[k] != y) continue;
                return true;
            }
            int i = this.powerups.length - 1;
            while (i-- > 0) {
                if (this.powerups[i][0] < x - 1 || this.powerups[i][1] < y - 1 || this.powerups[i][0] > x + 1 || this.powerups[i][1] > y + 1) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public int getGPA() {
        return Math.min(this.score / 1000, 5) + 5;
    }

    public int getScore() {
        return this.score;
    }

    private void hideMessage() {
        Engine.hideMessageBox();
    }

    private class SnakeData {
        public int[] xs = new int[1];
        public int[] ys = new int[1];
        public int length;
        public int blockindex;
        public int delay;
        public int timer;
        public int lengthadd;
        public int direction;
    }
}

