/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.loading;

import com.creativenorth.io.Stream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class CNSaveData
extends Stream {
    int recordsCurrentlySetup;
    RecordStore rms;
    public static boolean rmsclear = false;
    ByteArrayOutputStream writeData;

    public int setupRecord() {
        ++this.recordsCurrentlySetup;
        int recordCount = 0;
        try {
            recordCount = this.rms.getNumRecords();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        if (recordCount < this.recordsCurrentlySetup) {
            try {
                this.rms.addRecord(new byte[]{0}, 0, 1);
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        return this.recordsCurrentlySetup;
    }

    public void open(String _store) {
        try {
            this.rms = RecordStore.openRecordStore((String)_store, (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.rms != null) {
                this.rms.closeRecordStore();
            }
            this.rms = null;
            super.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void reset(String _store) {
        try {
            if (this.rms != null) {
                this.rms.closeRecordStore();
                RecordStore.deleteRecordStore((String)_store);
            }
            if (rmsclear) {
                RecordStore.deleteRecordStore((String)_store);
                rmsclear = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean beginRead(int _record) {
        try {
            this.loadStream = null;
            this.dataPosition = 0;
            int recordCount = this.rms.getNumRecords();
            if (recordCount >= _record) {
                this.dataBytes = this.rms.getRecord(_record);
                return this.dataBytes.length > 1;
            }
            this.dataBytes = null;
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void beginWrite() {
        this.dataBytes = null;
        this.writeData = new ByteArrayOutputStream();
    }

    public void endWrite(int _record) {
        try {
            this.rms.setRecord(_record, this.writeData.toByteArray(), 0, this.writeData.size());
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void writeU8(int _val) {
        this.writeData.write(_val & 0xFF);
    }

    public void writeU16(int _val) {
        this.writeData.write(_val >> 8 & 0xFF);
        this.writeData.write(_val & 0xFF);
    }

    public void writeU32(int _val) {
        this.writeU8(_val >> 24 & 0xFF);
        this.writeU8(_val >> 16 & 0xFF);
        this.writeU8(_val >> 8 & 0xFF);
        this.writeU8(_val & 0xFF);
    }

    public void writeS8(int _val) {
        if (_val < 0) {
            _val += 256;
        }
        this.writeU8(_val);
    }

    public void writeS16(int _val) {
        if (_val < 0) {
            _val += 65536;
        }
        this.writeU16(_val);
    }

    public void writeArrayU8(int[] _val) {
        this.writeU16(_val.length);
        int i = _val.length;
        while (i-- > 0) {
            this.writeU8(_val[i]);
        }
    }

    public void writeArrayU16(int[] _val) {
        this.writeU16(_val.length);
        int i = _val.length;
        while (i-- > 0) {
            this.writeU16(_val[i]);
        }
    }

    public void writeArrayS8(int[] _val) {
        this.writeU16(_val.length);
        int i = _val.length;
        while (i-- > 0) {
            this.writeS8(_val[i]);
        }
    }

    public void writeLongString(String _val) {
        this.writeU16(_val.length());
        for (int i = 0; i < _val.length(); ++i) {
            this.writeU8(_val.charAt(i));
        }
    }

    public static interface Storable {
        public void save(CNSaveData var1);

        public void load(CNSaveData var1) throws IOException;
    }
}

