/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.graphics;

import com.creativenorth.graphics.CNImage;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CNFont {
    CNImage font;
    int[] fontMetrics;
    int iLetterHeight;
    public int iLetterSpacing;

    public CNFont() {
    }

    public CNFont(String path) {
        this.load(path);
    }

    public void load(String path) {
        this.load(path, new CNImage(path + ".png"));
    }

    public void load(String path, CNImage image) {
        this.fontMetrics = new int[192];
        try {
            this.font = image;
            InputStream inp = path.getClass().getResourceAsStream(path + ".fnt");
            int version = inp.read();
            this.iLetterHeight = inp.read();
            this.iLetterSpacing = inp.read();
            if (this.iLetterSpacing >= 128) {
                this.iLetterSpacing -= 256;
            }
            for (int i = 0; i < this.fontMetrics.length; i += 2) {
                this.fontMetrics[i] = inp.read();
                this.fontMetrics[i + 1] = (inp.read() << 8) + inp.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fontMetrics[0] = 5;
    }

    public int getCharHeight() {
        return this.iLetterHeight;
    }

    public int getCharWidth(int chr) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return this.fontMetrics[chr];
    }

    public int getCharOffset(int chr) {
        return this.fontMetrics[chr + 1];
    }

    public CNImage getImage() {
        return this.font;
    }

    public int getStringWidth(String text) {
        int pos = 0;
        int c = text.length();
        while (c-- > 0) {
            char ch = text.charAt(c);
            if (ch == '|' || ch == '\n') continue;
            pos += this.getCharWidth(ch - 32 << 1) + this.iLetterSpacing;
        }
        return pos;
    }

    public void drawString(String[] lines, int x, int y, int alignment, Graphics graphics, int _h, int _yoff) {
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            int h = this.iLetterHeight * i - _yoff;
            if (h < 0 || h > _h - this.iLetterHeight) continue;
            this.drawString(lines[i], x, y + h, alignment, graphics);
        }
    }

    public void drawString(String[] lines, int x, int y, int alignment, Graphics graphics) {
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            this.drawString(lines[i], x, y + i * this.iLetterHeight, alignment, graphics);
        }
    }

    public void drawString(String text, int x, int y, int alignment, Graphics graphics) {
        if (text == null) {
            return;
        }
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            x += this.drawChar(ch, x, y, graphics);
        }
    }

    private int drawChar(int ch, int x, int y, Graphics graphics) {
        if (ch == 124 || ch == 10) {
            return 0;
        }
        ch -= 32;
        int w = this.getCharWidth(ch <<= 1);
        if (ch <= 0) {
            return w + this.iLetterSpacing;
        }
        int clipX = graphics.getClipX();
        int clipY = graphics.getClipY();
        int clipW = graphics.getClipWidth();
        int clipH = graphics.getClipHeight();
        graphics.clipRect(x, y, w, this.iLetterHeight);
        graphics.drawImage(this.font.getImage(), x -= this.getCharOffset(ch), y -= (ch >> 6) * this.iLetterHeight, 0);
        graphics.setClip(clipX, clipY, clipW, clipH);
        return w + this.iLetterSpacing;
    }
}

