/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.graphics;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNImage;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CNGraphics {
    public static int SCREEN_HEIGHT = 320;
    public static int SCREEN_WIDTH = 240;
    public static final int TEXT_ALIGN_RIGHT = 0;
    public static final int TEXT_ALIGN_LEFT = 1;
    public static final int TEXT_ALIGN_CENTER = 2;
    public Graphics m_graphics = null;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_VERTICAL = 2;
    public static final int FLIP_BOTH = 3;
    public static final int GRADIENT_RADIAL = 1;
    public static final int GRADIENT_HORIZONTAL = 2;
    public static final int GRADIENT_VERTICAL = 3;

    public void setGraphics(Graphics graphics) {
        this.m_graphics = graphics;
    }

    public void setClip(int x, int y, int w, int h) {
        this.m_graphics.setClip(x, y, w, h);
    }

    public void resetClip() {
        this.m_graphics.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    }

    public void clipRect(int x, int y, int w, int h) {
        this.m_graphics.clipRect(x, y, w, h);
    }

    public int getClipHeight() {
        return this.m_graphics.getClipHeight();
    }

    public int getClipWidth() {
        return this.m_graphics.getClipWidth();
    }

    public int getClipX() {
        return this.m_graphics.getClipX();
    }

    public int getClipY() {
        return this.m_graphics.getClipY();
    }

    public void setColor(int color) {
        this.m_graphics.setColor(color);
    }

    public void drawDot(int x, int y) {
        this.m_graphics.drawLine(x, y, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.m_graphics.drawRect(x, y, w - 1, h - 1);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.m_graphics.fillRect(x, y, w, h);
    }

    public void clear() {
        this.m_graphics.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    }

    public void fillDrawRect(int colBackground, int colForeground, int x, int y, int w, int h) {
        if (colBackground != 0) {
            this.setColor(colBackground);
            this.fillRect(x, y, w, h);
        }
        if (colForeground != 0) {
            this.setColor(colForeground);
            this.drawRect(x, y, w, h);
        }
    }

    public void drawImage(CNImage image, int x, int y, int anchor) {
        if (image != null && this.m_graphics != null) {
            image.reload();
            Image source = image.getImage();
            if (source != null) {
                this.m_graphics.drawImage(source, x, y, anchor);
            }
        }
    }

    public void drawClippedImage(CNImage image, int x, int y, int[] clip) {
        if (image != null && this.m_graphics != null) {
            image.reload();
            Image source = image.getImage();
            if (source != null) {
                this.m_graphics.clipRect(x, y, clip[2], clip[3]);
                this.m_graphics.drawImage(source, x - clip[0], y - clip[1], 0);
            }
        }
    }

    public void CreateScaledImage(Image to, Image from) {
        Graphics gim = to.getGraphics();
        int toW = to.getWidth();
        int toH = to.getHeight();
        int frW = from.getWidth();
        int frH = from.getHeight();
        int[] data = new int[frW * frH];
        from.getRGB(data, 0, frW, 0, 0, frW, frH);
        for (int y = 0; y < toH; ++y) {
            for (int x = 0; x < toW; ++x) {
                gim.setColor(data[y * frH / toH * frW + x * frW / toW]);
                gim.drawLine(x, y, x, y);
            }
        }
        gim = null;
    }

    public void CreateFlippedImage(Image to, Image from, int flip) {
        if (to.getWidth() != from.getWidth() || to.getHeight() != from.getHeight()) {
            return;
        }
        Graphics gim = to.getGraphics();
        int w = to.getWidth();
        int h = to.getHeight();
        int[] data = new int[w * h];
        from.getRGB(data, 0, w, 0, 0, w, h);
        switch (flip) {
            case 1: {
                for (int y = 0; y < h; ++y) {
                    for (int x = w - 1; x >= 0; --x) {
                        gim.setColor(data[y * w + x]);
                        gim.drawLine(x, y, x, y);
                    }
                }
                break;
            }
            case 2: {
                for (int y = h - 1; y >= 0; --y) {
                    for (int x = 0; x < w; ++x) {
                        gim.setColor(data[y * w + x]);
                        gim.drawLine(x, y, x, y);
                    }
                }
                break;
            }
            case 3: {
                for (int y = h - 1; y >= 0; --y) {
                    for (int x = w - 1; x >= 0; --x) {
                        gim.setColor(data[y * w + x]);
                        gim.drawLine(x, y, x, y);
                    }
                }
                break;
            }
        }
        gim = null;
    }

    public Image CreateGradientImage(int width, int height, int type, int colA, int colB, int posX, int posY) {
        Log.addWarning("WARNING: Will not always return an Image, needs to be worked into the CNImage system of reloading");
        Image image = Image.createImage((int)width, (int)height);
        this.CreateGradientImage(image, type, colA, colB, posX, posY);
        return image;
    }

    public void CreateGradientImage(Image image, int type, int colA, int colB, int posX, int posY) {
        Log.addWarning("WARNING: Will not always take an Image, needs to be worked into the CNImage system of reloading");
        Graphics gim = image.getGraphics();
        int h = image.getHeight();
        int w = image.getWidth();
        switch (type) {
            case 1: {
                int rings = w + h + 10;
                int colAr = colA >> 16;
                int colAg = (colA >> 8) % 256;
                int colAb = colA %= 256;
                int colBr = colB >> 16;
                int colBg = (colB >> 8) % 256;
                int colBb = colB %= 256;
                for (int i = rings - 1; i >= 0; --i) {
                    gim.setColor(colAr + (colBr - colAr) * i / rings, colAg + (colBg - colAg) * i / rings, colAb + (colBb - colAb) * i / rings);
                    gim.fillArc(posX - (i >> 1), posY - (i >> 1), i, i, 0, 360);
                }
                break;
            }
            case 2: {
                int colAr = colA >> 16;
                int colAg = (colA >> 8) % 256;
                int colAb = colA %= 256;
                int colBr = colB >> 16;
                int colBg = (colB >> 8) % 256;
                int colBb = colB %= 256;
                for (int i = 0; i < w; ++i) {
                    gim.setColor(colAr + (colBr - colAr) * i / w, colAg + (colBg - colAg) * i / w, colAb + (colBb - colAb) * i / w);
                    gim.drawLine(i, 0, i, h);
                }
                break;
            }
            case 3: {
                int colAr = colA >> 16;
                int colAg = (colA >> 8) % 256;
                int colAb = colA %= 256;
                int colBr = colB >> 16;
                int colBg = (colB >> 8) % 256;
                int colBb = colB %= 256;
                for (int i = 0; i < h; ++i) {
                    gim.setColor(colAr + (colBr - colAr) * i / h, colAg + (colBg - colAg) * i / h, colAb + (colBb - colAb) * i / h);
                    gim.drawLine(0, i, w, i);
                }
                break;
            }
        }
        gim = null;
    }

    public void setColor(int colBackground, int colForeground) {
        Log.addWarning("WARNING: Using depreciated method: void setColor(int colBackground, int colForeground)");
        if (colBackground != 0) {
            this.m_graphics.setColor(colBackground);
        }
        if (colForeground != 0) {
            this.m_graphics.setColor(colForeground);
        }
    }
}

