/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.graphics;

import com.creativenorth.dev.Log;
import com.creativenorth.io.Stream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CNMosaic {
    public static CNMosaic[] mosaics;
    public static final int MOSAIC_LISTARROWS = 0;
    public static final int MOSAIC_MENUITEMS = 1;
    public static final int MOSAIC_MOBILE = 2;
    public static final int MOSAIC_RATINGS = 3;
    public static final int MOSAIC_INGAME = 4;
    public static final int MOSAIC_SMILES = 5;
    Image m_image;
    int m_count;
    int[] m_areas;
    String m_pathImage;

    public CNMosaic(String _pathImage, String _pathData) throws IOException {
        this.m_pathImage = _pathImage;
        Stream stream = new Stream(_pathData);
        int version = stream.readU16();
        this.m_count = stream.readU16();
        this.m_areas = new int[this.m_count * 4];
        for (int i = 0; i < this.m_areas.length; ++i) {
            this.m_areas[i] = stream.readU16();
        }
        if (stream != null) {
            stream.close();
            stream = null;
        }
        this.load();
    }

    public void draw(Graphics _g, int _index, int _x, int _y) {
        try {
            _index <<= 2;
            _g.drawRegion(this.m_image, this.m_areas[_index++], this.m_areas[_index++], this.m_areas[_index++], this.m_areas[_index], 0, _x, _y, 0);
        }
        catch (Exception e) {
            Log.addExeption("Issue drawing a Mosaic part.", e);
        }
    }

    public void draw(Graphics _g, int _index, int _x, int _y, int _a) {
        if (_a == 3) {
            _x -= this.getWidth(_index) >> 1;
            _y -= this.getHeight(_index) >> 1;
        }
        this.draw(_g, _index, _x, _y);
    }

    public int getWidth(int _index) {
        try {
            return this.m_areas[(_index << 2) + 2];
        }
        catch (Exception e) {
            Log.addExeption("Issue getting a Mosaic part width.", e);
            return 0;
        }
    }

    public int getHeight(int _index) {
        try {
            return this.m_areas[(_index << 2) + 3];
        }
        catch (Exception e) {
            Log.addExeption("Issue getting a Mosaic part width.", e);
            return 0;
        }
    }

    public void load() throws IOException {
        this.m_image = Image.createImage((String)this.m_pathImage);
    }

    public void unload() {
        this.m_image = null;
    }

    static {
        try {
            mosaics = new CNMosaic[]{new CNMosaic("/mosaic_0_listarrows.png", "/mosaic_0_listarrows.dat"), new CNMosaic("/mosaic_1_menu_items.png", "/mosaic_1_menu_items.dat"), new CNMosaic("/mosaic_2_mobile.png", "/mosaic_2_mobile.dat"), new CNMosaic("/mosaic_3_ratings.png", "/mosaic_3_ratings.dat"), new CNMosaic("/mosaic_4_ingame.png", "/mosaic_4_ingame.dat"), new CNMosaic("/mosaic_5_smiles.png", "/mosaic_5_smiles.dat")};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

