/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.games;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.graphics.CNText;
import java.util.Random;
import javax.microedition.lcdui.Font;
import schoolfriends.games.MiniGame;
import schoolfriends.graphics.Engine;

public class Snap
extends MiniGame {
    public static final int STATE_STARTSCREEN = 0;
    public static final int STATE_INTRO = 1;
    public static final int STATE_INTRO2 = 2;
    public static final int STATE_PICK = 3;
    public static final int STATE_REVEAL = 4;
    public static final int STATE_SHOW = 5;
    public static final int STATE_HIDE = 6;
    public static final int STATE_WIN = 7;
    public static final int STATE_LOSE = 8;
    public static final int[] COLOR = new int[]{0xFF0000, 65280, 255, 13602560, 65535, 0xFF00FF, 0x8F0000, 36608, 143, 0x2F2F00, 36751, 0x8F008F, 0x8F8F8F, 0xFF8F8F, 0x8FFF8F, 0x8F8FFF};
    public static final int CURCOL = 0;
    public static final int SELCOL = 0xDFDF00;
    protected boolean usingImages = false;
    protected boolean keypress = false;
    protected int strRef_intro;
    protected int strRef_win;
    protected int strRef_lose;
    protected int state;
    protected int prev_key;
    protected int pairs_got = 0;
    protected int score = 0;
    protected int board_x;
    protected int board_y;
    protected int board_w;
    protected int board_h;
    protected int card_w;
    protected int card_h;
    protected int gap_w;
    protected int gap_h;
    protected int max_row_w;
    protected int row_w;
    protected int rows;
    protected int last_row_w;
    protected int card_x;
    protected int card_ygap;
    protected int card_y;
    protected int fixed_pairs;
    protected int current_pairs;
    protected int max_time = 60000;
    protected int max_pair_level;
    protected int[][] board;
    private static final int BOARD_DATA = 2;
    protected static final int CELL_HIDDEN = 0;
    protected static final int CELL_REVEALED = 1;
    protected static final int CELL_CURRENT = 2;
    protected static final long TRANSITION_TIME = 250L;
    protected static final long SHOW_TIME = 500L;
    protected long timer = 0L;
    protected long timerstart = 0L;
    protected long game_timer_start = 0L;
    protected long game_timer = 0L;
    protected long game_time_count = 0L;
    protected long selectiontimerstart = 0L;
    protected long selectiontimer = 0L;
    protected int cursor_x;
    protected int cursor_y;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    public static Font sysfont = Font.getDefaultFont();
    private static String TXT_SCORE;
    final int min_gap = this.m_images == null ? 2 : -1;
    Random rand = new Random();

    public Snap(int x, int y, int w, int h, CNImage[] imgs, int level, int strintro, int strwin, int strlose) {
        super(x, y, w, h);
        this.board = new int[40][2];
        this.setImages(imgs);
        this.strRef_intro = strintro;
        this.strRef_win = strwin;
        this.strRef_lose = strlose;
        this.fixed_pairs = level - 1;
        this.calculateSpace();
        this.reset();
        this.state = 0;
        TXT_SCORE = CNText.getFullString(83) + ": ";
        this.m_bCanEnd = false;
        Engine.ShowMessageUltra(4, null, this.strRef_intro, -1);
    }

    public void setTimeOffset(long _time) {
        this.timer += _time - this.m_time;
        this.timerstart += _time - this.m_time;
        this.game_timer_start += _time - this.m_time;
        this.game_timer += _time - this.m_time;
        this.selectiontimerstart += _time - this.m_time;
        this.selectiontimer += _time - this.m_time;
    }

    public void calculateSpace() {
        this.board_x = this.m_nDrawX + 5;
        this.board_y = this.m_nDrawY + this.m_nDrawH / 12;
        this.board_w = this.m_nDrawW - 9;
        this.board_h = this.m_nDrawH * 15 / 16;
        this.card_w = this.m_images == null ? 43 : this.m_images[1].getImage().getWidth();
        this.card_h = this.m_images == null ? 62 : this.m_images[1].getImage().getHeight();
        this.card_ygap = this.m_images == null ? 0 : -3;
        this.max_row_w = this.board_w / (this.card_w + this.min_gap);
    }

    public void reset() {
        this.score = 0;
        if (this.fixed_pairs == -1) {
            if (this.m_images != null) {
                this.usingImages = true;
                this.max_pair_level = this.m_images.length - 2;
            } else {
                this.usingImages = false;
            }
            this.current_pairs = 0;
        } else {
            this.usingImages = this.m_images != null;
            this.current_pairs = this.fixed_pairs;
            this.max_pair_level = this.fixed_pairs;
        }
        this.current_pairs += 3;
        this.max_time = 60000;
    }

    public void init() {
        int i;
        this.x2 = -1;
        this.x1 = -1;
        this.cursor_y = 0;
        this.cursor_x = 0;
        this.pairs_got = 0;
        this.state = 1;
        this.timerstart = System.currentTimeMillis();
        this.timer = this.timerstart + 3000L;
        this.game_timer_start = this.timerstart;
        this.game_timer = this.timerstart + (long)this.max_time;
        int cards = this.current_pairs * 2;
        boolean[] pairs = new boolean[cards];
        for (i = pairs.length - 1; i >= 0; --i) {
            pairs[i] = false;
        }
        i = cards;
        while (i-- > 0) {
            int index = Math.abs(this.rand.nextInt()) % pairs.length;
            while (pairs[index]) {
                index = (index + 1) % pairs.length;
            }
            pairs[index] = true;
            this.board[i][0] = index % this.current_pairs;
            this.board[i][1] = 0;
        }
        this.row_w = this.max_row_w;
        while (this.row_w > 1) {
            int r = (cards - 1) / this.row_w + 1;
            if (r > this.row_w) {
                ++this.row_w;
                break;
            }
            --this.row_w;
        }
        this.rows = (cards - 1) / this.row_w + 1;
        this.last_row_w = (cards - 1) % this.row_w + 1;
        int h = this.board_h / (this.card_h + this.min_gap + this.card_ygap);
        this.gap_w = Math.min((this.board_w - this.card_w * this.row_w) / (this.row_w - 1) + this.card_w, this.board_w / 8 + this.card_w);
        this.gap_h = Math.min((this.board_h - (this.card_h + this.card_ygap) * this.rows) / (this.rows - 1) + (this.card_h + this.card_ygap), this.board_h / 8 + (this.card_h + this.card_ygap));
        this.card_x = this.board_x + (this.board_w - this.gap_w * (this.row_w - 1) - this.card_w) / 2;
        this.card_y = this.board_y + (this.board_h - this.gap_h * (this.rows - 1) - this.card_h) / 2;
    }

    public void incrementLevel() {
        if (this.current_pairs < this.max_pair_level) {
            ++this.current_pairs;
        } else {
            this.max_time = 9 * this.max_time / 10;
        }
        this.init();
        this.state = 1;
    }

    public void run() {
        this.keypress = false;
        if (this.m_nGameAction != 0 && this.prev_key != this.m_nGameAction) {
            this.keypress = true;
        }
        this.prev_key = this.m_nGameAction;
        this.m_time = System.currentTimeMillis();
        switch (this.state) {
            case 0: {
                Engine.ShowMessageUltra(4, null, this.strRef_intro, -1);
                if (!this.keypress) break;
                this.init();
                this.hideMessage();
                break;
            }
            case 1: {
                this.game_time_count = 0L;
                if (this.m_time <= this.timer) break;
                this.state = 2;
                this.timerstart = System.currentTimeMillis();
                this.timer = this.timerstart + 250L;
                break;
            }
            case 2: {
                this.game_time_count = 0L;
                if (this.m_time <= this.timer) break;
                this.state = 3;
                this.game_timer_start = this.m_time;
                this.game_timer = this.m_time + (long)this.max_time;
                break;
            }
            case 3: {
                this.game_time_count = this.m_time - this.game_timer_start;
                if (!this.keypress) break;
                switch (this.m_nGameAction) {
                    case 8: {
                        if (this.cursor_y < this.rows - 1) {
                            this.cursor_x = (this.cursor_x + this.row_w - 1) % this.row_w;
                            break;
                        }
                        this.cursor_x = (this.cursor_x + this.last_row_w - 1) % this.last_row_w;
                        break;
                    }
                    case 2: {
                        if (this.cursor_y < this.rows - 1) {
                            this.cursor_x = (this.cursor_x + 1) % this.row_w;
                            break;
                        }
                        this.cursor_x = (this.cursor_x + 1) % this.last_row_w;
                        break;
                    }
                    case 1: {
                        if (this.cursor_x < this.last_row_w) {
                            this.cursor_y = (this.cursor_y + this.rows - 1) % this.rows;
                            break;
                        }
                        this.cursor_y = (this.cursor_y + this.rows - 2) % (this.rows - 1);
                        break;
                    }
                    case 4: {
                        if (this.cursor_x < this.last_row_w) {
                            this.cursor_y = (this.cursor_y + 1) % this.rows;
                            break;
                        }
                        this.cursor_y = (this.cursor_y + 1) % (this.rows - 1);
                        break;
                    }
                    case 16: {
                        if (this.board[this.cursor_x + this.cursor_y * this.row_w][1] != 0) break;
                        if (this.x1 == -1) {
                            this.x1 = this.cursor_x;
                            this.y1 = this.cursor_y;
                            this.board[this.x1 + this.y1 * this.row_w][1] = 2;
                            this.selectiontimerstart = this.m_time;
                            this.selectiontimer = this.m_time + 250L;
                            break;
                        }
                        if (this.x1 == this.cursor_x && this.y1 == this.cursor_y) break;
                        this.x2 = this.cursor_x;
                        this.y2 = this.cursor_y;
                        this.state = 4;
                        this.timer = this.m_time + 250L;
                        this.timerstart = this.m_time;
                        this.board[this.x2 + this.y2 * this.row_w][1] = 2;
                    }
                }
                break;
            }
            case 4: {
                this.game_time_count = this.m_time - this.game_timer_start;
                if (this.m_time <= this.timer) break;
                this.timer = this.m_time + 500L;
                this.timerstart = this.m_time;
                if (this.board[this.x1 + this.y1 * this.row_w][0] == this.board[this.x2 + this.y2 * this.row_w][0]) {
                    this.board[this.x1 + this.y1 * this.row_w][1] = 1;
                    this.board[this.x2 + this.y2 * this.row_w][1] = 1;
                    this.x2 = -1;
                    this.x1 = -1;
                    this.score += 10;
                    ++this.pairs_got;
                    if (this.pairs_got == this.current_pairs) {
                        this.score += (int)((long)this.max_time - this.game_time_count) / 500;
                        this.state = 7;
                        Engine.ShowMessageUltra(4, null, this.strRef_win, -1);
                        break;
                    }
                    this.state = 3;
                    break;
                }
                this.state = 5;
                break;
            }
            case 5: {
                this.game_time_count = this.m_time - this.game_timer_start;
                if (this.m_time <= this.timer) break;
                this.timerstart = this.m_time + 500L;
                this.state = 6;
                break;
            }
            case 6: {
                this.game_time_count = this.m_time - this.game_timer_start;
                if (this.m_time <= this.timer) break;
                this.timer = 0L;
                this.board[this.x1 + this.y1 * this.row_w][1] = 0;
                this.board[this.x2 + this.y2 * this.row_w][1] = 0;
                this.x2 = -1;
                this.x1 = -1;
                this.state = 3;
                break;
            }
            case 7: {
                Engine.ShowMessageUltra(4, null, this.strRef_win, -1);
                if (!this.keypress) break;
                if (this.fixed_pairs == -1) {
                    this.incrementLevel();
                } else {
                    this.m_bCanEnd = true;
                }
                this.hideMessage();
                break;
            }
            case 8: {
                Engine.ShowMessageUltra(4, null, this.strRef_lose, -1);
                this.game_time_count = 0L;
                if (!this.keypress) break;
                this.state = 0;
                this.m_bCanEnd = true;
                this.reset();
                this.hideMessage();
            }
        }
        this.m_nPlayerScore = this.score;
        if (this.game_time_count >= (long)this.max_time) {
            this.state = 8;
            Engine.ShowMessageUltra(4, null, this.strRef_lose, -1);
        }
    }

    public void paint(CNGraphics graphics) {
        long time = System.currentTimeMillis();
        graphics.setClip(this.m_nDrawX, this.m_nDrawY, this.m_nDrawW, this.m_nDrawH);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(this.m_nDrawX, this.m_nDrawY, this.m_nDrawW, this.m_nDrawH);
        CNText.drawString(TXT_SCORE + this.score, this.m_nDrawX + this.m_nDrawW - 3 - CNText.getWidth(TXT_SCORE + this.score), this.m_nDrawY + 2);
        if (this.state != 0) {
            int y = this.rows;
            while (y-- > 0) {
                int x;
                int n = x = y == this.rows - 1 ? this.last_row_w : this.row_w;
                while (x-- > 0) {
                    int val = this.board[x + y * this.row_w][0];
                    int status = this.board[x + y * this.row_w][1];
                    int dx = this.card_x + this.gap_w * x;
                    int dy = this.card_y + this.gap_h * y;
                    int cover = 0;
                    if (this.state == 1) {
                        cover = this.card_w;
                    } else if (this.state == 2) {
                        cover = (int)((long)this.card_w * (this.timer - time) / (this.timer - this.timerstart));
                    } else if (status == 2) {
                        if (this.state == 4) {
                            cover = x == this.x1 && y == this.y1 ? Math.min((int)((long)this.card_w * (time - this.selectiontimerstart) / (this.selectiontimer - this.selectiontimerstart)), this.card_w) : (int)((long)this.card_w * (time - this.timerstart) / (this.timer - this.timerstart));
                        } else if (this.state == 5) {
                            cover = this.card_w;
                        } else if (this.state == 6) {
                            cover = (int)((long)this.card_w * (this.timer - time) / (this.timer - this.timerstart));
                        } else if (this.state == 3 && x == this.x1 && y == this.y1) {
                            cover = Math.min((int)((long)this.card_w * (time - this.selectiontimerstart) / (this.selectiontimer - this.selectiontimerstart)), this.card_w);
                        }
                    } else {
                        cover = status == 0 ? 0 : this.card_w;
                    }
                    if (cover > 0) {
                        graphics.setColor(0xFFFFFF);
                        graphics.fillRect(dx, dy, this.card_w, this.card_h);
                        if (this.usingImages) {
                            graphics.drawImage(this.m_images[val + 2], dx + this.card_w / 2, dy + this.card_h / 2, 3);
                        } else {
                            graphics.setColor(COLOR[val]);
                            if (val % 2 == 0) {
                                graphics.fillRect(dx + this.card_w / 4, dy + this.card_h / 4, this.card_w / 2, this.card_h / 2);
                            } else {
                                graphics.m_graphics.fillTriangle(dx + this.card_w / 2, dy + this.card_h / 4, dx + this.card_w / 4, dy + this.card_h * 3 / 4, dx + this.card_w * 3 / 4, dy + this.card_h * 3 / 4);
                            }
                        }
                    }
                    if (cover < this.card_w) {
                        graphics.setClip(dx + cover, dy, this.card_w - cover, this.card_h);
                        if (this.usingImages) {
                            CNImage img = this.m_images[1];
                            int maxx = dx + this.card_w;
                            int maxy = dy + this.card_h;
                            for (int xx = dx; xx < maxx; xx += img.getWidth()) {
                                for (int yy = dy; yy < maxy; yy += img.getHeight()) {
                                    graphics.drawImage(img, xx, yy, 0);
                                }
                            }
                        } else {
                            graphics.setColor(0xFF0000);
                            graphics.fillRect(dx, dy, this.card_w, this.card_h);
                        }
                        graphics.setClip(this.m_nDrawX, this.m_nDrawY, this.m_nDrawW, this.m_nDrawH);
                    }
                    if (this.cursor_x == x && this.cursor_y == y) {
                        graphics.setColor(0);
                        graphics.drawRect(dx - 2, dy - 2, this.card_w + 4, this.card_h + 4);
                    }
                    if (status != 2) continue;
                    graphics.setColor(0xDFDF00);
                    graphics.drawRect(dx, dy, this.card_w, this.card_h);
                }
            }
            graphics.setColor(0xFFFFCF);
            y = (this.m_nDrawY + this.board_y - 10) / 2;
            graphics.drawRect(this.m_nDrawX + 4, y, this.m_nDrawW / 2 + 4, 10);
            graphics.fillRect(this.m_nDrawX + 6, y + 2, (int)((long)this.m_nDrawW * ((long)this.max_time - this.game_time_count) / (long)(this.max_time * 2)), 6);
        }
        if (this.state == 7) {
            // empty if block
        }
        if (this.state == 8) {
            // empty if block
        }
    }

    public int getGPA() {
        return Math.min(this.score / 1000, 5) + 5;
    }

    public int getScore() {
        return this.score;
    }

    private void hideMessage() {
        Engine.hideMessageBox();
    }
}

