/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.loading;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.gui.Menu;
import com.creativenorth.io.Stream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import schoolfriends.Data;
import schoolfriends.SchoolCore;
import schoolfriends.Scripts;
import schoolfriends.games.MiniGame;
import schoolfriends.graphics.Engine;
import schoolfriends.graphics.Render;
import schoolfriends.menu.MenuScripts;

public class LoadingRequirement {
    public static final int LOAD_INIT = 0;
    public static final int LOAD_DATA = 1;
    public static final int LOAD_TILES = 2;
    public static final int LOAD_PARTLISTS = 3;
    public static final int LOAD_ROOMS_SIM = 4;
    public static final int LOAD_MASTEROBJECTS = 5;
    public static final int LOAD_CHARACTERS = 6;
    public static final int LOAD_ANIMATIONS = 7;
    public static final int LOAD_PALETTES = 8;
    public static final int LOAD_DATA_FINISH = 9;
    public static final int LOAD_FINISH = 10;
    public static final int LOAD_IMAGES = 11;
    public static final int LOAD_ROOM = 12;
    public boolean m_bLoadData;
    public CNImage[] m_aImages;
    public Data.RequiredAnimation[] m_aAnims;
    public int m_nRoom = -1;
    public static int m_nByteTotal;
    private int m_nImage = 0;
    private int m_nImageCount = 0;
    private static int m_nProgress;
    private static int m_nProgressOffset;
    private static int m_nTiledataStartOffset;
    private static int m_nTiledataOffset;
    private static int attrib_count;
    private static int palindexcount;
    public static int m_nRoomLoop;
    private Stream is = null;
    private static boolean m_bLoaded;
    private int m_nLoadingState = 0;
    private static int[] m_nRoomOffsets;
    private static int[] m_nAnimationOffsets;
    private int[] m_nStates = new int[0];

    public LoadingRequirement() {
        this.m_bLoadData = true;
        this.m_nLoadingState = 0;
        this.setupStates();
    }

    public LoadingRequirement(int room) {
        this.m_bLoadData = !m_bLoaded;
        this.m_nRoom = room;
        this.m_nLoadingState = 0;
        this.setupStates();
    }

    public void setupStates() {
        this.m_nStates = this.m_bLoadData ? (this.m_nRoom == -1 ? new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11} : new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}) : new int[]{0, 12, 10, 11};
        m_nProgress = 0;
    }

    private Stream getFile(String _path) {
        return new Stream(_path);
    }

    private Stream getFile(String _path, int _maxSize) {
        return new Stream(_path, _maxSize);
    }

    public boolean loadSector() {
        try {
            switch (this.m_nStates[this.m_nLoadingState]) {
                case 0: {
                    SchoolCore.me.menuScripts.unloadAllImages();
                    this.LoadInit();
                    ++this.m_nLoadingState;
                    break;
                }
                case 1: {
                    Engine.loadSounds();
                    this.LoadData();
                    ++this.m_nLoadingState;
                    break;
                }
                case 2: {
                    this.LoadData_Tiles(this.is);
                    ++this.m_nLoadingState;
                    break;
                }
                case 3: {
                    this.LoadData_Partlists(this.is);
                    m_nProgressOffset = m_nProgress;
                    this.is.close();
                    this.is = this.getFile("/data2.turd");
                    this.LoadData_Preprooms(this.is);
                    this.m_nLoadingState += 2;
                    break;
                }
                case 4: {
                    ++this.m_nLoadingState;
                    break;
                }
                case 5: {
                    this.is.close();
                    this.is = this.getFile("/data3.turd");
                    this.LoadData_MasterObjects(this.is);
                    ++this.m_nLoadingState;
                    break;
                }
                case 6: {
                    this.LoadData_Characters(this.is);
                    ++this.m_nLoadingState;
                    break;
                }
                case 7: {
                    try {
                        this.is.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.is = this.getFile("/data5.turd", 20000);
                    this.LoadData_Animations(this.is);
                    ++this.m_nLoadingState;
                    break;
                }
                case 8: {
                    try {
                        this.is.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.is = this.getFile("/data6.turd");
                    this.LoadData_Palettes(this.is);
                    ++this.m_nLoadingState;
                    break;
                }
                case 9: {
                    m_bLoaded = true;
                    SchoolCore.me.gameSetupDebug();
                    ++this.m_nLoadingState;
                    break;
                }
                case 10: {
                    this.LoadFinish();
                    ++this.m_nLoadingState;
                    break;
                }
                case 11: {
                    return !this.LoadImage();
                }
                case 12: {
                    this.LoadData_SingleRoomRealNew();
                    this.LoadData_TilesCurrentlyRequired();
                    ++this.m_nLoadingState;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Loading data failed: " + e);
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public int getState() {
        return this.m_nLoadingState;
    }

    public int getMaxStates() {
        return this.m_nStates.length;
    }

    public int getStateProgress() {
        if (this.m_nStates[this.m_nLoadingState] == 4) {
            return 100 * m_nRoomLoop / m_nRoomOffsets.length;
        }
        if (this.m_nStates[this.m_nLoadingState] == 11) {
            return this.m_nImageCount > 0 ? 100 * this.m_nImage / this.m_nImageCount : 0;
        }
        return 0;
    }

    private void LoadFinish() {
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        System.gc();
        this.m_nImageCount = 0;
        if (this.m_nRoom == -1 || Data.rooms == null || this.m_nRoom >= Data.rooms.length) {
            return;
        }
        if (Engine.me == null) {
            Engine.me = new Engine();
        }
        Engine.SetRoom(this.m_nRoom);
        if (this.m_aImages == null) {
            this.m_aImages = Engine.getNeededImages(this.m_nRoom);
        } else {
            CNImage[] temp = Engine.getNeededImages(this.m_nRoom);
            CNImage[] prev = this.m_aImages;
            this.m_aImages = new CNImage[temp.length + prev.length];
            System.arraycopy(prev, 0, this.m_aImages, 0, temp.length);
            System.arraycopy(temp, 0, this.m_aImages, temp.length, prev.length);
            prev = null;
            temp = null;
            System.gc();
        }
        this.m_aAnims = Engine.getRequiredAnimations(this.m_nRoom);
        if (this.m_aImages != null) {
            this.m_nImageCount += this.m_aImages.length;
        }
        if (this.m_aAnims != null) {
            this.m_nImageCount += this.m_aAnims.length;
        }
    }

    public void LoadInit() {
        SchoolCore.freeRasteredCharacters();
        SchoolCore.freePaletteshiftedElements();
        SchoolCore.freeAllTiles();
        System.gc();
        if (Menu.m_iPrevMenu != 14 && Menu.m_iPrevMenu != 30 && Engine.g_currentroom != null) {
            MenuScripts.savedata = false;
            SchoolCore.me.autosave();
        }
        if (MiniGame.snakegfx == null) {
            MiniGame.snakegfx = new CNImage[]{new CNImage("/back.png"), new CNImage("/PencilFront.png"), new CNImage("/End.png"), new CNImage("/Middle.png"), new CNImage("/Corner.png"), new CNImage("/Corner2.png"), new CNImage("/NumbersPurple24w.png"), new CNImage("/NumbersOrange24w.png")};
        }
        if (Data.shadow == null) {
            Data.shadow = new CNImage("/shadow.png");
        }
    }

    public boolean LoadImage() {
        if (this.m_aImages != null && this.m_nImage < this.m_aImages.length) {
            if (this.m_aImages[this.m_nImage] != null) {
                this.m_aImages[this.m_nImage].reload();
            }
            ++this.m_nImage;
            return true;
        }
        if (this.m_aAnims != null && this.m_nImage < this.m_nImageCount) {
            try {
                int gfx = this.m_aAnims[this.m_nImage - this.m_aImages.length].mchr;
                int anim = this.m_aAnims[this.m_nImage - this.m_aImages.length].anim;
                Data.MasterCharacter mchr = Data.mchrs[gfx];
                LoadingRequirement.VerifyAnimation(anim);
                if (mchr.frames == null) {
                    mchr.frames = new Data.Tile[Data.frames.length][];
                }
                if (mchr.frames[anim] == null) {
                    mchr.frames[anim] = new Data.Tile[Data.frames[anim].length];
                }
                for (int i = Data.frames[anim].length - 1; i >= 0; --i) {
                    if (mchr.frames[anim][i] != null && mchr.frames[anim][i].img != null) continue;
                    if (Runtime.getRuntime().freeMemory() < 500L) {
                        SchoolCore.freePaletteshiftedElements();
                        System.gc();
                    }
                    if (Runtime.getRuntime().freeMemory() < 500L) continue;
                    mchr.frames[anim][i] = new Data.Tile();
                    Render.rasterSprite(null, anim, i, mchr.partsets, mchr.palindices, mchr.frames[anim][i], gfx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.m_nImage;
            return true;
        }
        return false;
    }

    public void LoadData() throws Exception {
        this.is = this.getFile("/data1.turd");
        m_nByteTotal = this.is.available();
        int version = this.ReadShort(this.is);
        Data.tile_w = this.ReadByte(this.is);
        Data.tile_w_half = Data.tile_w / 2;
        if (Data.tile_w < 1) {
            throw new Exception("Data file error: 0 tile width");
        }
        Data.tile_h = this.ReadByte(this.is);
        Data.tile_h_half = Data.tile_h / 2;
        if (Data.tile_h < 1) {
            throw new Exception("Data file error: 0 tile height");
        }
    }

    public void LoadData_Palettes(Stream is) throws IOException {
        int j;
        int i;
        int colcount = this.ReadShort(is);
        int palcount = this.ReadByte(is);
        if (colcount > 0) {
            Data.palettes = new Data.Palette[colcount];
        }
        Graphics g = SchoolCore.me.getGraphics();
        for (int i2 = 0; i2 < colcount; ++i2) {
            int col;
            Data.palettes[i2] = new Data.Palette();
            Data.palettes[i2].index = this.ReadByte(is);
            Data.palettes[i2].colour = col = (this.ReadByte(is) << 16) + (this.ReadByte(is) << 8) + this.ReadByte(is);
            Data.palettes[i2].row = this.ReadShort(is);
        }
        int palrowcount = this.ReadShort(is);
        int[][] palrows = new int[palrowcount][];
        for (i = 0; i < palrowcount; ++i) {
            int rowlen = this.ReadByte(is);
            palrows[i] = new int[rowlen];
            for (j = 0; j < rowlen; ++j) {
                palrows[i][j] = 0xFF000000 | g.getDisplayColor((this.ReadByte(is) << 16) + (this.ReadByte(is) << 8) + this.ReadByte(is));
            }
        }
        for (i = 0; i < colcount; ++i) {
            int r = Data.palettes[i].row;
            if (palrows[r].length == palcount) {
                Data.palettes[i].colours = palrows[r];
                continue;
            }
            Data.palettes[i].colours = new int[palcount];
            j = palrows[r].length - 1;
            while (j-- > 0) {
                Data.palettes[i].colours[j] = palrows[r][j];
            }
            for (j = palrows[r].length; j < palcount; ++j) {
                Data.palettes[i].colours[j] = Data.palettes[i].colour;
            }
        }
    }

    public void LoadData_Animations(Stream is) throws IOException {
        int offset = m_nProgress;
        int anim_count = this.ReadByte(is);
        if (anim_count > 0) {
            Data.frames = new Data.Frame[anim_count][];
        }
        m_nAnimationOffsets = new int[anim_count];
        for (int i = 0; i < anim_count; ++i) {
            LoadingRequirement.m_nAnimationOffsets[i] = m_nProgress - offset;
            int frame_count = this.ReadByte(is);
            for (int j = 0; j < frame_count; ++j) {
                this.SkipBytes(is, 2);
                this.SkipBytes(is, this.ReadByte(is) * 7);
            }
        }
    }

    public void LoadData_Characters(Stream is) throws IOException {
        attrib_count = this.ReadByte(is);
        palindexcount = this.ReadByte(is);
        is.close();
        is = this.getFile("/data4.turd");
        int offset = m_nProgress;
        int chr_count = this.ReadByte(is);
        Data.mchrs = new Data.MasterCharacter[chr_count];
        Data.MasterCharacter mc = null;
        for (int i = 0; i < chr_count; ++i) {
            int j;
            Data.mchrs[i] = mc = new Data.MasterCharacter(i);
            mc.ingamename = this.ReadShort(is);
            if (attrib_count > 0) {
                mc.attributes = new int[attrib_count];
            }
            for (int j2 = 0; j2 < attrib_count; ++j2) {
                mc.attributes[j2] = this.ReadShort(is);
            }
            int script_count = this.ReadByte(is);
            if (script_count > 0) {
                mc.scripts = new Data.AssignedScript[script_count];
            }
            for (j = 0; j < script_count; ++j) {
                mc.scripts[j] = new Data.AssignedScript();
                mc.scripts[j].script = this.ReadShort(is);
                mc.scripts[j].trigger = this.ReadByte(is);
            }
            if (Data.partlists.length > 0) {
                mc.partsets = new int[Data.partlists.length];
                for (j = 0; j < Data.partlists.length; ++j) {
                    mc.partsets[j] = this.ReadByte(is);
                }
            }
            mc.palindices = new int[palindexcount];
            for (j = 0; j < palindexcount; ++j) {
                mc.palindices[j] = this.ReadByte(is);
            }
            mc.memory = new int[Data.MEMORY_LENGTH];
            for (j = 0; j < mc.memory.length; ++j) {
                mc.memory[j] = -1;
            }
            mc.memoryPointer = 0;
        }
        Data.playerCharacter = Data.mchrs[0];
    }

    public void LoadData_MasterObjects(Stream is) throws IOException {
        int mobj_count = this.ReadShort(is);
        if (mobj_count > 0) {
            Data.mobjs = new int[mobj_count];
        }
        for (int a = 0; a < mobj_count; ++a) {
            Data.mobjs[a] = this.ReadShort(is);
            this.ReadShort(is);
            int script_count = this.ReadByte(is);
            this.SkipBytes(is, 3 * script_count);
        }
    }

    public void LoadData_SingleRoomSimNew() throws IOException, Exception {
        int a = m_nRoomLoop;
        LoadingRequirement.m_nRoomOffsets[a] = m_nProgress - m_nProgressOffset;
        if (Data.rooms == null) {
            Data.rooms = new Data.Room[m_nRoomOffsets.length];
        }
        Data.rooms[a] = new Data.Room();
        Data.roomnames[a] = Data.rooms[a].name = this.ReadShort(this.is);
        Data.rooms[a].sound = this.ReadByte(this.is);
        int floor_w = this.ReadByte(this.is);
        if (floor_w < 1) {
            throw new Exception("Data file error: Room " + a + " 0 width");
        }
        int floor_h = this.ReadByte(this.is);
        if (floor_h < 1) {
            throw new Exception("Data file error: Room " + a + " 0 height");
        }
        for (int y = 0; y < floor_h; ++y) {
            for (int x = 0; x < floor_w; ++x) {
                this.ReadShort(this.is);
            }
        }
        int wall_count = this.ReadShort(this.is);
        for (int b = 0; b < wall_count; ++b) {
            this.ReadShort(this.is);
            this.ReadShort(this.is);
            this.ReadShort(this.is);
        }
        int obj_count = this.ReadShort(this.is);
        if (obj_count > 0) {
            Data.rooms[a].objs = new Data.PlacedObject[obj_count];
        }
        for (int b = 0; b < obj_count; ++b) {
            int temp;
            Data.rooms[a].objs[b] = new Data.PlacedObject();
            Data.rooms[a].objs[b].frame = (int)System.currentTimeMillis() % 5;
            int x = this.ReadShort(this.is);
            int y = this.ReadShort(this.is);
            Data.rooms[a].objs[b].x = Render.tileToWorldX(x, y);
            Data.rooms[a].objs[b].y = Render.tileToWorldY(x, y);
            Data.rooms[a].objs[b].z = this.ReadByte(this.is);
            Data.rooms[a].objs[b].depth_fix = this.ReadSByte(this.is);
            int type_n_flags = this.ReadByte(this.is);
            Data.rooms[a].objs[b].type = (type_n_flags & 1) == 1;
            Data.rooms[a].objs[b].left = (type_n_flags & 2) == 2 ^ Data.rooms[a].objs[b].type;
            Data.rooms[a].objs[b].day = (type_n_flags & 8) == 8;
            boolean bl = Data.rooms[a].objs[b].night = (type_n_flags & 0x10) == 16;
            if (Data.rooms[a].objs[b].type) {
                Data.rooms[a].objs[b].x += Data.tile_w_half;
            }
            Data.rooms[a].objs[b].gfx = temp = this.ReadShort(this.is);
            Data.rooms[a].objs[b].chr_anim = Data.rooms[a].objs[b].idle_anim = this.ReadShort(this.is);
            Data.rooms[a].objs[b].ingamename = this.ReadShort(this.is);
            Data.rooms[a].objs[b].sel_x = this.ReadSByte(this.is);
            Data.rooms[a].objs[b].sel_y = this.ReadSByte(this.is);
            int script_count = this.ReadByte(this.is);
            if (script_count > 0) {
                Data.rooms[a].objs[b].scripts = new Data.AssignedScript[script_count];
            }
            for (int c = 0; c < script_count; ++c) {
                Data.rooms[a].objs[b].scripts[c] = new Data.AssignedScript();
                Data.rooms[a].objs[b].scripts[c].script = this.ReadShort(this.is);
                Data.rooms[a].objs[b].scripts[c].trigger = this.ReadByte(this.is);
            }
        }
        int numberOfShadows = this.ReadByte(this.is);
        for (int i = 0; i < numberOfShadows; ++i) {
            int x1 = this.ReadShort(this.is);
            int y1 = this.ReadShort(this.is);
            int x2 = this.ReadShort(this.is);
            int y2 = this.ReadShort(this.is);
            int x3 = this.ReadShort(this.is);
            int y3 = this.ReadShort(this.is);
            int colindex = this.ReadByte(this.is);
            if (this.ReadByte(this.is) != 1) continue;
        }
        int numberOfColours = this.ReadByte(this.is);
        for (int i = 0; i < numberOfColours; ++i) {
            int red = this.ReadByte(this.is);
            int green = this.ReadByte(this.is);
            int blue = this.ReadByte(this.is);
        }
        Data.rooms[a].spawnX = this.ReadShort(this.is);
        Data.rooms[a].spawnY = this.ReadShort(this.is);
    }

    public void LoadData_SingleRoomRealNew() throws IOException, Exception {
        if (this.m_nRoom < 0) {
            return;
        }
        int a = this.m_nRoom;
        if (Data.rooms == null) {
            Data.rooms = new Data.Room[m_nRoomOffsets.length];
        }
        if (Data.rooms[a] != null) {
            // empty if block
        }
        Data.rooms[a] = new Data.Room();
        Data.Room r = Data.rooms[a];
        this.is = this.getFile("/data-room" + a + ".turd");
        r.name = Data.roomnames[a];
        r.sound = this.ReadByte(this.is);
        int floor_w = this.ReadByte(this.is);
        if (floor_w < 1) {
            throw new Exception("Data file error: Room " + a + ", " + floor_w + " width");
        }
        int floor_h = this.ReadByte(this.is);
        if (floor_h < 1) {
            throw new Exception("Data file error: Room " + a + " " + floor_h + " height");
        }
        r.tileCountX = floor_w;
        r.tileCountY = floor_h;
        r.floor = new int[floor_h][floor_w];
        int t = 0;
        for (int y = 0; y < floor_h; ++y) {
            for (int x = 0; x < floor_w; ++x) {
                r.floor[y][x] = t = this.ReadShort(this.is);
                LoadingRequirement.VerifyTile(t);
            }
        }
        int wall_count = this.ReadShort(this.is);
        r.walls = new Data.Wall[wall_count];
        for (int b = 0; b < wall_count; ++b) {
            r.walls[b] = new Data.Wall();
            r.walls[b].x = this.ReadShort(this.is);
            r.walls[b].y = this.ReadShort(this.is);
            r.walls[b].tile = t = this.ReadShort(this.is);
            LoadingRequirement.VerifyTile(t);
        }
        int obj_count = this.ReadShort(this.is);
        r.objs = new Data.PlacedObject[obj_count];
        for (int b = 0; b < obj_count; ++b) {
            int temp;
            r.objs[b] = new Data.PlacedObject();
            r.objs[b].frame = (int)System.currentTimeMillis() % 5;
            int x = this.ReadShort(this.is);
            int y = this.ReadShort(this.is);
            r.objs[b].x = Render.tileToWorldX(x, y);
            r.objs[b].y = Render.tileToWorldY(x, y);
            r.objs[b].z = this.ReadByte(this.is);
            r.objs[b].depth_fix = this.ReadSByte(this.is);
            int type_n_flags = this.ReadByte(this.is);
            r.objs[b].type = (type_n_flags & 1) == 1;
            r.objs[b].left = (type_n_flags & 2) == 2 ^ r.objs[b].type;
            r.objs[b].day = (type_n_flags & 8) == 8;
            r.objs[b].night = (type_n_flags & 0x10) == 16;
            r.objs[b].gfx = temp = this.ReadShort(this.is);
            if (r.objs[b].type) {
                r.objs[b].x += Data.tile_w_half;
            } else {
                LoadingRequirement.VerifyTile(Data.mobjs[temp]);
            }
            r.objs[b].chr_anim = r.objs[b].idle_anim = this.ReadShort(this.is);
            r.objs[b].ingamename = this.ReadShort(this.is);
            r.objs[b].sel_x = this.ReadSByte(this.is);
            r.objs[b].sel_y = this.ReadSByte(this.is);
            int script_count = this.ReadByte(this.is);
            if (script_count <= 0) continue;
            r.objs[b].scripts = new Data.AssignedScript[script_count];
            for (int c = 0; c < script_count; ++c) {
                r.objs[b].scripts[c] = new Data.AssignedScript();
                r.objs[b].scripts[c].script = this.ReadShort(this.is);
                r.objs[b].scripts[c].trigger = this.ReadByte(this.is);
            }
        }
        int numberOfShadows = this.ReadByte(this.is);
        r.shadowPoints = new Vector();
        for (int i = 0; i < numberOfShadows; ++i) {
            int x1 = this.ReadShort(this.is);
            int y1 = this.ReadShort(this.is);
            int x2 = this.ReadShort(this.is);
            int y2 = this.ReadShort(this.is);
            int x3 = this.ReadShort(this.is);
            int y3 = this.ReadShort(this.is);
            int colindex = this.ReadByte(this.is);
            Data.CNPoint[] m_points = new Data.CNPoint[]{new Data.CNPoint(x1, y1), new Data.CNPoint(x2, y2), new Data.CNPoint(x3, y3)};
            Data.CNPoly tmpPoly = new Data.CNPoly(m_points);
            tmpPoly.colourIndex = colindex;
            if (this.ReadByte(this.is) == 1) {
                tmpPoly.m_wall = true;
            }
            r.shadowPoints.addElement(tmpPoly);
        }
        int numberOfColours = this.ReadByte(this.is);
        Data.CNColour[] m_colours = new Data.CNColour[numberOfColours];
        for (int i = 0; i < numberOfColours; ++i) {
            int red = this.ReadByte(this.is);
            int green = this.ReadByte(this.is);
            int blue = this.ReadByte(this.is);
            m_colours[i] = new Data.CNColour(red, green, blue);
        }
        r.spawnX = this.ReadShort(this.is);
        r.spawnY = this.ReadShort(this.is);
        r.colours = m_colours;
        Data.rooms[a] = r;
        this.is.close();
        this.is = null;
    }

    public static void VerifyTile(int t) {
        if (t != 0 && t != Short.MAX_VALUE) {
            if (Data.tiles[t = Math.abs(t) - 1] == null) {
                Data.tiles[t] = new Data.Tile();
            }
            if (Data.tiles[t].img == null) {
                Data.tiles[t].img = t < 10 ? new CNImage("/00" + t + ".png") : (t < 100 ? new CNImage("/0" + t + ".png") : new CNImage("/" + t + ".png"));
            }
        }
    }

    public static void VerifyAnimation(int anim) {
        if (Data.frames == null) {
            return;
        }
        if (Data.frames[anim] != null) {
            return;
        }
        try {
            Data.Frame f = null;
            Data.FrameElement fe = null;
            Stream stream = new Stream("/data5.turd", 20000);
            stream.skip(m_nAnimationOffsets[anim]);
            int frame_count = stream.readU8();
            if (frame_count > 0) {
                Data.frames[anim] = new Data.Frame[frame_count];
            }
            for (int j = 0; j < frame_count; ++j) {
                Data.frames[anim][j] = f = new Data.Frame(stream.readS16() * 20);
                int element_count = stream.readU8();
                if (element_count > 0) {
                    f.elements = new Data.FrameElement[element_count];
                }
                for (int k = 0; k < element_count; ++k) {
                    f.elements[k] = fe = new Data.FrameElement();
                    fe.partlist = stream.readU8();
                    fe.part = stream.readU8();
                    fe.x = stream.readS16();
                    fe.y = stream.readS16();
                    fe.flags = stream.readU8();
                }
            }
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int LoadData_Preprooms(Stream is) throws IOException, Exception {
        int room_count = this.ReadByte(is);
        if (room_count < 1) {
            throw new Exception("Data file error: 0 rooms");
        }
        Data.roomnames = new int[room_count];
        Data.roomlocked = new boolean[room_count];
        Data.rooms = new Data.Room[room_count];
        for (int i = 0; i < room_count; ++i) {
            Data.rooms[i] = new Data.Room();
            Data.rooms[i].name = Data.roomnames[i] = this.ReadShort(is);
        }
        return room_count;
    }

    public void LoadData_Partlists(Stream is) throws IOException {
        int partlist_count = this.ReadByte(is);
        Data.partlists = new Data.Tile[partlist_count][][];
        Data.manifest = new Data.Tile[18];
        if (partlist_count > 0) {
            for (int i = 0; i < partlist_count; ++i) {
                int partset_count = this.ReadByte(is);
                if (partset_count > 0) {
                    Data.partlists[i] = new Data.Tile[partset_count][];
                    for (int j = 0; j < partset_count; ++j) {
                        int partset_tile_count = this.ReadByte(is);
                        Data.partlists[i][j] = new Data.Tile[partset_tile_count];
                        for (int k = 0; k < partset_tile_count; ++k) {
                            int flags = this.ReadByte(is);
                            if ((flags & 1) != 0) continue;
                            int index = (flags & 0x20) == 0 ? this.ReadByte(is) : this.ReadShort(is);
                            if (Data.manifest[index] == null) {
                                Data.manifest[index] = new Data.Tile();
                                Data.manifest[index].img = new CNImage("/p" + (index < 100 ? "0" : "") + (index < 10 ? "0" : "") + index + ".png");
                            }
                            Data.partlists[i][j][k] = Data.manifest[index];
                        }
                    }
                }
                Log.endBlock();
            }
        }
    }

    public void LoadData_Tiles(Stream is) throws Exception {
        int tile_count = this.ReadShort(is);
        if (tile_count < 1) {
            throw new Exception("Data file error: 0 tiles");
        }
        m_nTiledataStartOffset = m_nProgress;
        Data.tiles = new Data.Tile[tile_count];
        this.SkipBytes(is, 2 * tile_count);
    }

    private void LoadData_TilesCurrentlyRequired() throws Exception {
        try {
            int max_tile;
            this.is = this.getFile("/data1.turd");
            m_nByteTotal = this.is.available();
            this.is.skip(m_nTiledataStartOffset);
            for (max_tile = Data.tiles.length; max_tile > 0 && Data.tiles[max_tile - 1] == null; --max_tile) {
            }
            for (int a = 0; a < max_tile; ++a) {
                if (Data.tiles[a] != null) {
                    Data.tiles[a].img = a < 10 ? new CNImage("/00" + a + ".png") : (a < 100 ? new CNImage("/0" + a + ".png") : new CNImage("/" + a + ".png"));
                    Data.tiles[a].hotspot_x = this.ReadSByte(this.is);
                    Data.tiles[a].hotspot_y = this.ReadSByte(this.is);
                    continue;
                }
                this.ReadSByte(this.is);
                this.ReadSByte(this.is);
            }
            this.is.close();
            this.is = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void splitmanifest(int m, CNImage img) {
        img.reload();
        for (int i = 1; i < Scripts.MANIFEST_WORLD_LOCATIONS.length / 5; ++i) {
            if (Scripts.MANIFEST_WORLD_LOCATIONS[i * 5] != m) continue;
            int x = Scripts.MANIFEST_WORLD_LOCATIONS[i * 5 + 1];
            int y = Scripts.MANIFEST_WORLD_LOCATIONS[i * 5 + 2];
            int w = Scripts.MANIFEST_WORLD_LOCATIONS[i * 5 + 3];
            int h = Scripts.MANIFEST_WORLD_LOCATIONS[i * 5 + 4];
            try {
                Image cutout = Image.createImage((Image)img.getImage(), (int)x, (int)y, (int)w, (int)h, (int)0);
                Data.tiles[i - 1].img = new CNImage(cutout);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private int ReadByte(Stream is) throws IOException {
        this.updateStreamProgress(1);
        return is.readU8();
    }

    private int ReadSByte(Stream is) throws IOException {
        this.updateStreamProgress(1);
        return is.readS8();
    }

    private int ReadShort(Stream is) throws IOException {
        this.updateStreamProgress(2);
        return is.readS16();
    }

    private void SkipBytes(Stream is, int count) throws IOException {
        this.updateStreamProgress(count);
        is.skip(count);
    }

    private void updateStreamProgress(int nBytesRead) {
        m_nProgress += nBytesRead;
    }

    private int logbyte(int byt) {
        return byt;
    }

    static {
        m_nProgress = 0;
        m_nProgressOffset = 0;
        m_nTiledataStartOffset = 0;
        m_nTiledataOffset = 0;
        m_nRoomLoop = 0;
        m_bLoaded = false;
    }

    public static class ImageRequirements {
        public CNImage img;
        public int flags;
        public int[] palindices;
    }
}

