/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Services.CFontInfo;

public class CBinaryFile {
    public byte[] data;
    public int pointer;
    boolean bUnicode;

    public CBinaryFile(byte[] byArray, boolean bl) {
        this.data = byArray;
        this.pointer = 0;
        this.bUnicode = bl;
    }

    public void adjustTo8() {
        if ((this.pointer & 7) != 0) {
            this.pointer += 8 - (this.pointer & 7);
        }
    }

    public void setUnicode(boolean bl) {
        this.bUnicode = bl;
    }

    public void read(byte[] byArray) {
        int n = byArray.length;
        if (this.pointer + n <= this.data.length) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.data[this.pointer + i];
            }
            this.pointer += n;
            return;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
        }
    }

    public void skipBytes(int n) {
        if (this.pointer + n <= this.data.length) {
            this.pointer += n;
        }
    }

    public int getFilePointer() {
        return this.pointer;
    }

    public void seek(int n) {
        if (n <= this.data.length) {
            this.pointer = n;
        }
    }

    public byte readByte() {
        if (this.pointer + 1 <= this.data.length) {
            return this.data[this.pointer++];
        }
        return 0;
    }

    public short readShort() {
        if (this.pointer + 2 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            return (short)(n2 * 256 + n);
        }
        return 0;
    }

    public int readInt() {
        if (this.pointer + 4 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            int n3 = this.data[this.pointer++] & 0xFF;
            int n4 = this.data[this.pointer++] & 0xFF;
            return n4 * 0x1000000 + n3 * 65536 + n2 * 256 + n;
        }
        return 0;
    }

    public int readColor() {
        if (this.pointer + 4 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            int n3 = this.data[this.pointer++] & 0xFF;
            ++this.pointer;
            return n * 65536 + n2 * 256 + n3;
        }
        return 0;
    }

    public char readChar() {
        if (this.pointer + 2 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            return (char)(n2 * 256 + n);
        }
        return '\u0000';
    }

    public void readChar(char[] cArray) {
        if (this.pointer + cArray.length * 2 <= this.data.length) {
            for (int i = 0; i < cArray.length; ++i) {
                int n = this.data[this.pointer++] & 0xFF;
                int n2 = this.data[this.pointer++] & 0xFF;
                cArray[i] = (char)(n2 * 256 + n);
            }
        }
    }

    public String readString(int n) {
        int n2;
        if (!this.bUnicode) {
            int n3;
            byte[] byArray = new byte[n];
            this.read(byArray);
            for (n3 = 0; n3 < n && byArray[n3] != 0; ++n3) {
            }
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = byArray[i];
            }
            return new String(byArray2);
        }
        char[] cArray = new char[n];
        this.readChar(cArray);
        for (n2 = 0; n2 < n && cArray[n2] != '\u0000'; ++n2) {
        }
        char[] cArray2 = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[i];
        }
        return new String(cArray2);
    }

    public String readString() {
        char c;
        int n = this.getFilePointer();
        if (!this.bUnicode) {
            byte by;
            while ((by = this.readByte()) != 0) {
            }
            int n2 = this.getFilePointer();
            this.seek(n);
            if (n2 - n - 1 > 0) {
                byte[] byArray = new byte[n2 - n - 1];
                this.read(byArray);
                this.skipBytes(1);
                return new String(byArray);
            }
            this.skipBytes(1);
            return "";
        }
        while ((c = this.readChar()) != '\u0000') {
        }
        int n3 = this.getFilePointer();
        this.seek(n);
        if (n3 - n - 2 > 0) {
            int n4 = (n3 - n - 2) / 2;
            char[] cArray = new char[n4];
            this.readChar(cArray);
            this.skipBytes(2);
            return new String(cArray);
        }
        this.skipBytes(2);
        return "";
    }

    public CFontInfo readLogFont() {
        CFontInfo cFontInfo = new CFontInfo();
        cFontInfo.lfHeight = this.readInt();
        if (cFontInfo.lfHeight < 0) {
            cFontInfo.lfHeight = -cFontInfo.lfHeight;
        }
        this.skipBytes(12);
        cFontInfo.lfWeight = this.readInt();
        cFontInfo.lfItalic = this.readByte();
        cFontInfo.lfUnderline = this.readByte();
        cFontInfo.lfStrikeOut = this.readByte();
        this.skipBytes(5);
        cFontInfo.lfFaceName = this.readString(32);
        return cFontInfo;
    }

    public CFontInfo readLogFont16() {
        CFontInfo cFontInfo = new CFontInfo();
        cFontInfo.lfHeight = this.readShort();
        if (cFontInfo.lfHeight < 0) {
            cFontInfo.lfHeight = -cFontInfo.lfHeight;
        }
        this.skipBytes(6);
        cFontInfo.lfWeight = this.readShort();
        cFontInfo.lfItalic = this.readByte();
        cFontInfo.lfUnderline = this.readByte();
        cFontInfo.lfStrikeOut = this.readByte();
        this.skipBytes(5);
        boolean bl = this.bUnicode;
        this.bUnicode = false;
        cFontInfo.lfFaceName = this.readString(32);
        this.bUnicode = bl;
        return cFontInfo;
    }

    public void skipString() {
        if (!this.bUnicode) {
            byte by;
            while ((by = this.readByte()) != 0) {
            }
        } else {
            char c;
            while ((c = this.readChar()) != '\u0000') {
            }
        }
    }
}

