/*
 * Decompiled with CFR 0.152.
 */
package Animations;

import Animations.CAnimDir;
import Banks.IEnum;
import Services.CFile;

public class CAnim {
    public static final short ANIMID_STOP = 0;
    public static final short ANIMID_WALK = 1;
    public static final short ANIMID_RUN = 2;
    public static final short ANIMID_APPEAR = 3;
    public static final short ANIMID_DISAPPEAR = 4;
    public static final short ANIMID_BOUNCE = 5;
    public static final short ANIMID_SHOOT = 6;
    public static final short ANIMID_JUMP = 7;
    public static final short ANIMID_FALL = 8;
    public static final short ANIMID_CLIMB = 9;
    public static final short ANIMID_CROUCH = 10;
    public static final short ANIMID_UNCROUCH = 11;
    public static final short ANIMID_USER1 = 12;
    public static final byte[] tableAnimTwoSpeeds = new byte[]{0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public CAnimDir[] anDirs;
    public byte[] anTrigo;
    public byte[] anAntiTrigo;

    public void load(CFile cFile) {
        int n;
        long l = cFile.getFilePointer();
        short[] sArray = new short[32];
        for (n = 0; n < 32; ++n) {
            sArray[n] = cFile.readAShort();
        }
        this.anDirs = new CAnimDir[32];
        this.anTrigo = new byte[32];
        this.anAntiTrigo = new byte[32];
        for (n = 0; n < 32; ++n) {
            this.anDirs[n] = null;
            this.anTrigo[n] = 0;
            this.anAntiTrigo[n] = 0;
            if (sArray[n] == 0) continue;
            this.anDirs[n] = new CAnimDir();
            cFile.seek(l + (long)sArray[n]);
            this.anDirs[n].load(cFile);
        }
    }

    public void enumElements(IEnum iEnum) {
        for (int i = 0; i < 32; ++i) {
            if (this.anDirs[i] == null) continue;
            this.anDirs[i].enumElements(iEnum);
        }
    }

    public void approximate(int n) {
        for (int i = 0; i < 32; ++i) {
            if (this.anDirs[i] == null) {
                int n2 = 0;
                int n3 = i + 1;
                while (n2 < 32) {
                    if (this.anDirs[n3 &= 0x1F] != null) {
                        this.anTrigo[i] = (byte)n3;
                        break;
                    }
                    ++n2;
                    ++n3;
                }
                int n4 = 0;
                int n5 = i - 1;
                while (n4 < 32) {
                    if (this.anDirs[n5 &= 0x1F] != null) {
                        this.anAntiTrigo[i] = (byte)n5;
                        break;
                    }
                    ++n4;
                    --n5;
                }
                if (n3 == n5 || n2 < n4) {
                    int n6 = i;
                    this.anTrigo[n6] = (byte)(this.anTrigo[n6] | 0x40);
                    continue;
                }
                if (n4 >= n2) continue;
                int n7 = i;
                this.anAntiTrigo[n7] = (byte)(this.anAntiTrigo[n7] | 0x40);
                continue;
            }
            if (n >= 16 || tableAnimTwoSpeeds[n] != 0) continue;
            this.anDirs[i].adMinSpeed = this.anDirs[i].adMaxSpeed;
        }
    }
}

