/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Application.CRunApp;
import Banks.CImage;
import Banks.IEnum;
import Services.CFile;
import javax.microedition.lcdui.Image;

public class CImageBank
implements IEnum {
    public CRunApp app;
    CFile file;
    public CImage[] images;
    public int nHandlesReel;
    public int nHandlesTotal;
    public int nImages;
    int[] offsetsToImage;
    short[] handleToIndex;
    short[] useCount;

    public CImageBank(CRunApp cRunApp) {
        this.app = cRunApp;
    }

    public void preLoad(CFile cFile) {
        this.file = cFile;
        this.nHandlesReel = this.file.readAShort();
        this.offsetsToImage = new int[this.nHandlesReel];
        int n = this.file.readAShort();
        CImage cImage = new CImage();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)this.file.getFilePointer();
            cImage.loadHandle(this.file);
            this.offsetsToImage[cImage.handle] = n2;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.handleToIndex = null;
        this.nHandlesTotal = this.nHandlesReel;
        this.nImages = 0;
        this.images = null;
    }

    public CImage getImageFromHandle(short s) {
        if (s >= 0 && s < this.nHandlesTotal && this.handleToIndex[s] != -1) {
            return this.images[this.handleToIndex[s]];
        }
        return null;
    }

    public CImage getImageFromIndex(short s) {
        if (s >= 0 && s < this.nImages) {
            return this.images[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CFile cFile) {
        int n;
        this.nImages = 0;
        for (n = 0; n < this.nHandlesReel; ++n) {
            if (this.useCount[n] == 0) continue;
            ++this.nImages;
        }
        int n2 = 0;
        CImage[] cImageArray = new CImage[this.nImages];
        byte[] byArray = new byte[this.nImages];
        int n3 = 0;
        for (int i = 0; i < this.nHandlesReel; ++i) {
            if (this.useCount[i] == 0) continue;
            if (this.images != null && this.handleToIndex[i] != -1 && this.images[this.handleToIndex[i]] != null) {
                cImageArray[n3] = this.images[this.handleToIndex[i]];
                cImageArray[n3].useCount = this.useCount[i];
            } else {
                cImageArray[n3] = new CImage();
                cFile.seek(this.offsetsToImage[i]);
                cImageArray[n3].load(cFile);
                cImageArray[n3].useCount = this.useCount[i];
                byArray[n3] = 1;
                ++n2;
            }
            ++n3;
        }
        this.images = cImageArray;
        this.handleToIndex = new short[this.nHandlesReel];
        for (n = 0; n < this.nHandlesReel; ++n) {
            this.handleToIndex[n] = -1;
        }
        for (n = 0; n < this.nImages; ++n) {
            this.handleToIndex[this.images[n].handle] = (short)n;
        }
        this.nHandlesTotal = this.nHandlesReel;
        this.resetToLoad();
    }

    public void delImage(short s) {
        CImage cImage = this.getImageFromHandle(s);
        if (cImage != null) {
            cImage.useCount = (short)(cImage.useCount - 1);
            if (cImage.useCount <= 0) {
                for (int i = 0; i < this.nImages; ++i) {
                    if (this.images[i] != cImage) continue;
                    this.images[i] = null;
                    this.handleToIndex[s] = -1;
                    break;
                }
            }
        }
    }

    public short addImageCompare(Image image, short s, short s2, short s3, short s4) {
        int[] nArray = null;
        for (int i = 0; i < this.nImages; ++i) {
            if (this.images[i].xSpot != s || this.images[i].ySpot != s2 || this.images[i].xAP != s3 || this.images[i].yAP != s4) continue;
            int n = image.getWidth();
            int n2 = image.getHeight();
            if (n != this.images[i].img.getWidth() || n2 != this.images[i].img.getHeight()) continue;
            if (nArray == null) {
                nArray = new int[n * n2];
                image.getRGB(nArray, 0, n, 0, 0, n, n2);
            }
            int[] nArray2 = new int[n * n2];
            this.images[i].img.getRGB(nArray2, 0, n, 0, 0, n, n2);
            boolean bl = true;
            block1: for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    if (nArray[j * n + k] == nArray2[j * n + k]) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (!bl) continue;
            this.images[i].useCount = (short)(this.images[i].useCount + 1);
            return this.images[i].handle;
        }
        return this.addImage(image, s, s2, s3, s4, (short)1);
    }

    public short addImage(Image image, short s, short s2, short s3, short s4, short s5) {
        int n;
        int n2;
        short s6 = -1;
        for (n2 = this.nHandlesReel; n2 < this.nHandlesTotal; ++n2) {
            if (this.handleToIndex[n2] != -1) continue;
            s6 = (short)n2;
            break;
        }
        if (s6 == -1) {
            short[] sArray = new short[this.nHandlesTotal + 10];
            for (n2 = 0; n2 < this.nHandlesTotal; ++n2) {
                sArray[n2] = this.handleToIndex[n2];
            }
            while (n2 < this.nHandlesTotal + 10) {
                sArray[n2] = -1;
                ++n2;
            }
            s6 = (short)this.nHandlesTotal;
            this.nHandlesTotal += 10;
            this.handleToIndex = sArray;
        }
        int n3 = -1;
        for (n = 0; n < this.nImages; ++n) {
            if (this.images[n] != null) continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            CImage[] cImageArray = new CImage[this.nImages + 10];
            for (n = 0; n < this.nImages; ++n) {
                cImageArray[n] = this.images[n];
            }
            while (n < this.nImages + 10) {
                cImageArray[n] = null;
                ++n;
            }
            n3 = this.nImages;
            this.nImages += 10;
            this.images = cImageArray;
        }
        this.handleToIndex[s6] = (short)n3;
        this.images[n3] = new CImage();
        this.images[n3].handle = s6;
        this.images[n3].img = image;
        this.images[n3].xSpot = s;
        this.images[n3].ySpot = s2;
        this.images[n3].xAP = s3;
        this.images[n3].yAP = s4;
        this.images[n3].useCount = s5;
        this.images[n3].width = (short)image.getWidth();
        this.images[n3].height = (short)image.getHeight();
        return s6;
    }

    public void loadImageList(short[] sArray) {
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] < 0 || sArray[i] >= this.nHandlesTotal || this.offsetsToImage[sArray[i]] == 0) continue;
            if (this.getImageFromHandle(sArray[i]) == null) {
                int n2;
                int n3 = -1;
                for (n2 = 0; n2 < this.nImages; ++n2) {
                    if (this.images[n2] != null) continue;
                    n3 = n2;
                    break;
                }
                if (n3 == -1) {
                    CImage[] cImageArray = new CImage[this.nImages + 10];
                    for (n2 = 0; n2 < this.nImages; ++n2) {
                        cImageArray[n2] = this.images[n2];
                    }
                    while (n2 < this.nImages + 10) {
                        cImageArray[n2] = null;
                        ++n2;
                    }
                    n3 = this.nImages;
                    this.nImages += 10;
                    this.images = cImageArray;
                }
                this.handleToIndex[sArray[i]] = (short)n3;
                this.images[n3] = new CImage();
                this.images[n3].useCount = 1;
                this.file.seek(this.offsetsToImage[sArray[i]]);
                this.images[n3].load(this.file);
                ++n;
                continue;
            }
            this.getImageFromHandle((short)sArray[i]).useCount = (short)(this.getImageFromHandle((short)sArray[i]).useCount + 1);
        }
    }

    public CImage getImageInfoEx(short s, int n, float f, float f2) {
        CImage cImage = new CImage();
        CImage cImage2 = this.getImageFromHandle(s);
        if (cImage2 != null) {
            cImage.width = cImage2.width;
            cImage.height = cImage2.height;
            cImage.xSpot = cImage2.xSpot;
            cImage.ySpot = cImage2.ySpot;
            cImage.xAP = cImage2.xAP;
            cImage.yAP = cImage2.yAP;
            return cImage;
        }
        return null;
    }
}

