/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Application.CSoundPlayer;
import Banks.CSound;
import Banks.IEnum;
import Services.CFile;

public class CSoundBank
implements IEnum {
    public CSound[] sounds = null;
    public int nHandlesReel;
    public int nSounds;
    short[] handleToIndex;
    short[] useCount;
    CSoundPlayer sPlayer;

    public CSoundBank(CSoundPlayer cSoundPlayer) {
        this.sPlayer = cSoundPlayer;
    }

    public void preLoad(CFile cFile) {
        this.nHandlesReel = cFile.readAShort();
        this.handleToIndex = new short[this.nHandlesReel];
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.handleToIndex[i] = -1;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.nSounds = 0;
        this.sounds = null;
    }

    public CSound getSoundFromHandle(short s) {
        if (this.sounds != null && s >= 0 && s < this.nHandlesReel && this.handleToIndex[s] != -1) {
            return this.sounds[this.handleToIndex[s]];
        }
        return null;
    }

    public CSound getSoundFromIndex(short s) {
        if (this.sounds != null && s >= 0 && s < this.nSounds) {
            return this.sounds[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CSoundPlayer cSoundPlayer) {
        int n;
        if (this.sounds != null) {
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] != 0 || this.handleToIndex[n] == -1 || this.sounds[this.handleToIndex[n]] == null) continue;
                this.sounds[this.handleToIndex[n]].close();
                this.sounds[this.handleToIndex[n]] = null;
                this.handleToIndex[n] = -1;
            }
        }
        if (cSoundPlayer.bWAVSupported) {
            this.nSounds = 0;
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] == 0) continue;
                ++this.nSounds;
            }
            CSound[] cSoundArray = new CSound[this.nSounds];
            int n2 = 0;
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] == 0) continue;
                if (this.sounds != null && this.handleToIndex[n] != -1 && this.sounds[this.handleToIndex[n]] != null) {
                    cSoundArray[n2] = this.sounds[this.handleToIndex[n]];
                    this.handleToIndex[n] = (short)n2;
                } else {
                    cSoundArray[n2] = new CSound(cSoundPlayer);
                    cSoundArray[n2].load((short)n);
                    this.handleToIndex[n] = (short)n2;
                }
                ++n2;
            }
            this.sounds = cSoundArray;
        }
        this.resetToLoad();
    }

    public void closeAllSounds() {
        if (this.sounds != null) {
            for (int i = 0; i < this.nHandlesReel; ++i) {
                if (this.handleToIndex[i] == -1 || this.sounds[this.handleToIndex[i]] == null) continue;
                this.sounds[this.handleToIndex[i]].close();
                this.sounds[this.handleToIndex[i]] = null;
                this.handleToIndex[i] = -1;
            }
        }
    }
}

