/*
 * Decompiled with CFR 0.152.
 */
package bluegammon;

import bluegammon.Audio;
import bluegammon.BluegammonMIDlet;
import bluegammon.Device;
import bluegammon.Resources;
import bluegammon.RmsFacade;
import bluegammon.gui.MenuCanvas;
import bluegammon.gui.PopupCanvas;
import bluegammon.gui.StringInputHandler;
import bluegammon.gui.popup.Popup;
import bluegammon.gui.popup.PopupListener;
import bluegammon.io.BackgammonConnection;
import bluegammon.io.Handshake;
import bluegammon.io.PlayerListenerProxy;
import bluegammon.logic.BoardMediator;
import bluegammon.logic.GameRecord;
import bluegammon.logic.LocalPlayer;
import bluegammon.logic.Player;
import bluegammon.logic.RemotePlayer;
import bluegammon.logic.Rules;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;

public class Bluegammon
implements PopupListener,
CommandListener {
    protected static PopupCanvas m_currentCanvas;
    protected static PopupListener m_popupListener;
    protected static Popup m_popupCache;
    protected static TextBox m_textBox;
    protected static StringInputHandler m_inputHandler;
    protected static BackgammonConnection m_remoteConnection;
    protected static Bluegammon m_inst;
    public static final int DEVICE_ID = 0;
    public static final int PLAYER_NAME = 1;
    public static final int HAS_SAVED_LOCAL_GAME = 2;
    public static final int SAVED_GAME_DATA = 3;
    public static final int BLACK_PREFERRED = 4;
    public static final int AUDIO_OFF = 5;
    public static final int VIBRA_OFF = 6;
    public static final int RULES_PREFERRED = 7;
    public static final int GAMERECORDS_SIZE = 16;
    public static final int GAMEREC_OP_ID = 8;
    public static final int GAMEREC_OP_NAME = 24;
    public static final int GAMEREC_MY_SCORE = 40;
    public static final int GAMEREC_OP_SCORE = 56;
    public static final int GAMEREC_GAME_COUNT = 72;
    public static final int GAMEREC_TIMESTAMP = 88;
    public static final int GAMEREC_SAVED_GAME_DATA = 104;
    protected static final int NBR_OF_KEYS = 120;
    protected static final Command OK;
    protected static final Command CANCEL;
    public static int GAME_TYPE_LOCAL;
    public static int GAME_TYPE_REMOTE_SERVER;
    public static int GAME_TYPE_REMOTE_CLIENT;
    protected static int m_gameType;

    protected static void setGameType(int n) {
        m_gameType = n;
    }

    public static int getGameType() {
        return m_gameType;
    }

    public static synchronized void setBackgammonConnection(BackgammonConnection backgammonConnection) {
        m_remoteConnection = backgammonConnection;
    }

    public static boolean hasSavedLocalGame() {
        return RmsFacade.getBoolean(2);
    }

    public static synchronized void startLocalGame() {
        Bluegammon.setGameType(GAME_TYPE_LOCAL);
        Audio.stopSound(0);
        LocalPlayer localPlayer = new LocalPlayer(1, "Whitey".toCharArray(), true, BoardMediator.getCanvas());
        LocalPlayer localPlayer2 = new LocalPlayer(2, "Blackie".toCharArray(), false, BoardMediator.getCanvas());
        Audio.stopSound(0);
        BoardMediator.init(localPlayer, localPlayer2, false);
        Bluegammon.setCanvas(BoardMediator.getCanvas());
    }

    public static void startRemoteGame(boolean bl, char[] cArray) {
        DataInputStream dataInputStream = m_remoteConnection.getInput();
        DataOutputStream dataOutputStream = m_remoteConnection.getOutput();
        if (dataInputStream == null || dataOutputStream == null) {
            return;
        }
        Bluegammon.showPopup(Resources.getChars(Resources.TXT_STARTING_GAME), null, 10, 0, 0, null);
        Bluegammon.setGameType(bl ? GAME_TYPE_REMOTE_SERVER : GAME_TYPE_REMOTE_CLIENT);
        Handshake handshake = new Handshake();
        boolean bl2 = false;
        try {
            if (bl) {
                handshake.serverHandshake(dataInputStream, dataOutputStream, new String(cArray));
            } else {
                handshake.clientHandshake(dataInputStream, dataOutputStream, new String(cArray));
            }
        }
        catch (Throwable throwable) {
            bl2 = true;
            Bluegammon.showPopup(Resources.getChars(Resources.TXT_HANDSHAKE_FAIL), Popup.ALT_OK, 0, 0, 0, null);
            System.err.println("Handshake failed");
            throwable.printStackTrace();
            return;
        }
        if (!bl2) {
            boolean bl3 = handshake.getSavedGame() != null;
            LocalPlayer localPlayer = new LocalPlayer(Device.getDeviceId(), cArray, handshake.isWhite(), BoardMediator.getCanvas());
            PlayerListenerProxy playerListenerProxy = new PlayerListenerProxy(dataOutputStream);
            localPlayer.addListener(playerListenerProxy);
            RemotePlayer remotePlayer = new RemotePlayer(handshake.getRemoteId(), handshake.getRemoteName(), !handshake.isWhite(), dataInputStream);
            BoardMediator.init(localPlayer, remotePlayer, bl3);
            if (bl3) {
                boolean bl4 = handshake.isRemoteResume();
                byte[] byArray = handshake.getSavedGame();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    BoardMediator.loadGame(byteArrayInputStream, bl4);
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                byArray = null;
                byteArrayInputStream = null;
                System.gc();
            }
            Bluegammon.setCanvas(BoardMediator.getCanvas());
            Audio.stopSound(0);
            if (!bl || bl3) {
                Bluegammon.showRules();
            } else {
                Popup popup = Bluegammon.getCurrentPopup();
                if (popup != null) {
                    popup.dispose();
                }
            }
        }
        Bluegammon.getCanvas().repaint();
    }

    public static void resumeSavedLocalGame() {
        LocalPlayer localPlayer = new LocalPlayer(1, "Whitey".toCharArray(), true, BoardMediator.getCanvas());
        LocalPlayer localPlayer2 = new LocalPlayer(2, "Blackey".toCharArray(), false, BoardMediator.getCanvas());
        BoardMediator.init(localPlayer, localPlayer2, true);
        Bluegammon.setGameType(GAME_TYPE_LOCAL);
        byte[] byArray = RmsFacade.get(3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            BoardMediator.loadGame(byteArrayInputStream, false);
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = null;
        byteArrayInputStream = null;
        System.gc();
        Audio.stopSound(0);
        Bluegammon.setCanvas(BoardMediator.getCanvas());
        Bluegammon.showRules();
    }

    public static synchronized void exitGame() {
        if (Bluegammon.getGameType() == GAME_TYPE_LOCAL) {
            if (!BoardMediator.isGameFinished()) {
                try {
                    if (BoardMediator.getCurrentPlayer() != null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        BoardMediator.saveGame(byteArrayOutputStream);
                        byteArrayOutputStream.close();
                        RmsFacade.set(3, byteArrayOutputStream.toByteArray());
                        RmsFacade.setBoolean(2, true);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                RmsFacade.set(3, null);
                RmsFacade.setBoolean(2, false);
            }
        } else if (Bluegammon.getGameType() == GAME_TYPE_REMOTE_CLIENT || Bluegammon.getGameType() == GAME_TYPE_REMOTE_SERVER) {
            Player player = BoardMediator.getOpponentPlayer();
            if (!BoardMediator.isGameFinished()) {
                try {
                    if (BoardMediator.getCurrentPlayer() != null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        BoardMediator.saveGame(byteArrayOutputStream);
                        byteArrayOutputStream.close();
                        GameRecord.saveGame(player, byteArrayOutputStream.toByteArray());
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                GameRecord.saveGame(player, null);
            }
            BoardMediator.forceGameFinished();
            if (m_remoteConnection != null) {
                try {
                    m_remoteConnection.close();
                    m_remoteConnection = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Rules.setRuleFlags(RmsFacade.getInt(7));
        MenuCanvas.getInstance().initShow();
        Bluegammon.setCanvas(MenuCanvas.getInstance());
    }

    public static synchronized void shutdown() {
        BoardMediator.shutdown();
        RmsFacade.shutdown();
        Audio.shutdown();
        if (m_popupCache != null) {
            m_popupCache.dispose();
            m_popupCache = null;
        }
        m_inst = null;
        if (m_remoteConnection != null) {
            try {
                m_remoteConnection.close();
                m_remoteConnection = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.gc();
        Device.getMidlet().notifyDestroyed();
    }

    public static void showRules() {
        String string = Resources.getString(Resources.TXT_T_RULES) + "\n\n";
        if (Rules.isAnyRuleSet()) {
            if (Rules.isSet(2)) {
                string = string + Resources.getString(Resources.TXT_I_R_EVENOUT) + "\n";
            }
            if (Rules.isSet(1)) {
                string = string + Resources.getString(Resources.TXT_I_R_MAXFIVE) + "\n";
            }
        } else {
            string = string + Resources.getString(Resources.TXT_NO_RULES);
        }
        string = string + "\n";
        Bluegammon.showPopup(string.toCharArray(), null, 10, 0, 0, null);
    }

    public static void getStringInput(String string, char[] cArray, int n, int n2, StringInputHandler stringInputHandler) {
        m_textBox.setString("");
        m_textBox.setMaxSize(n);
        m_textBox.setTitle(string);
        if (cArray != null) {
            try {
                m_textBox.insert(cArray, 0, cArray.length, 0);
                m_textBox.setConstraints(n2);
            }
            catch (Throwable throwable) {
                try {
                    m_textBox.setChars(null, 0, 0);
                    m_textBox.setConstraints(n2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        Device.getDisplay().setCurrent((Displayable)m_textBox);
        m_inputHandler = stringInputHandler;
    }

    protected static Object getInputLock() {
        return m_textBox;
    }

    public static synchronized void setCanvas(PopupCanvas popupCanvas) {
        m_currentCanvas = popupCanvas;
        Device.getDisplay().setCurrent((Displayable)popupCanvas);
        popupCanvas.repaint();
    }

    public static synchronized PopupCanvas getCanvas() {
        return m_currentCanvas;
    }

    public static synchronized boolean isShowingPopup() {
        return Bluegammon.getCanvas() != null && Bluegammon.getCanvas().getPopup() != null && Bluegammon.getCanvas().getPopup().isActive();
    }

    public static synchronized Popup getCurrentPopup() {
        if (!Bluegammon.isShowingPopup()) {
            return null;
        }
        return Bluegammon.getCanvas().getPopup();
    }

    public static synchronized Popup showPopup(char[] cArray, char[][] cArray2, int n, int n2, int n3, PopupListener popupListener) {
        Popup popup;
        if (Bluegammon.getCanvas() == null) {
            return null;
        }
        if (Bluegammon.getCanvas().getPopup() != null && Bluegammon.getCanvas().getPopup().isActive()) {
            popup = Bluegammon.getCanvas().getPopup();
            Bluegammon.getPopupListener().selectedChoice(popup.getTimeOutChoice(), true);
            popup.dispose();
            m_popupCache = popup;
        }
        popup = Bluegammon.getPopupInstance();
        popup.init(cArray, cArray2, (byte)n, (byte)n2, (byte)n3, Bluegammon.getPopupListener(), Bluegammon.getCanvas().getWidth(), Bluegammon.getCanvas().getHeight());
        m_popupListener = popupListener;
        Bluegammon.getCanvas().setPopup(popup);
        Bluegammon.getCanvas().repaint();
        return popup;
    }

    protected static synchronized Popup getPopupInstance() {
        if (m_popupCache == null) {
            m_popupCache = new Popup();
        }
        return m_popupCache;
    }

    protected static synchronized PopupListener getPopupListener() {
        return Bluegammon.getInstance();
    }

    protected static synchronized CommandListener getInputCommandListener() {
        return Bluegammon.getInstance();
    }

    private static Bluegammon getInstance() {
        return m_inst;
    }

    public static synchronized void init(BluegammonMIDlet bluegammonMIDlet, Display display) {
        if (m_inst == null) {
            m_inst = new Bluegammon();
        }
        Device.init(bluegammonMIDlet, display);
        RmsFacade.init(120);
        Rules.setRuleFlags(RmsFacade.getInt(7));
        MenuCanvas.getInstance().initShow();
        Bluegammon.setCanvas(MenuCanvas.getInstance());
        BoardMediator.startup();
        m_textBox = new TextBox(null, null, 1, 0);
        m_textBox.addCommand(OK);
        m_textBox.addCommand(CANCEL);
        m_textBox.setCommandListener(Bluegammon.getInputCommandListener());
    }

    public void selectedChoice(byte by, boolean bl) {
        if (m_popupListener != null) {
            m_popupListener.selectedChoice(by, bl);
        }
        if (Bluegammon.getCanvas() != null) {
            Bluegammon.getCanvas().repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (displayable == m_textBox) {
            Object object = Bluegammon.getInputLock();
            synchronized (object) {
                if (command != CANCEL && m_textBox.getString().length() > 0 && m_inputHandler != null) {
                    final String string = m_textBox.getString();
                    new Thread(new Runnable(){

                        public void run() {
                            m_inputHandler.handleStringInput(string);
                        }
                    }, "InputHandler").start();
                }
                Bluegammon.setCanvas(Bluegammon.getCanvas());
            }
        }
    }

    private Bluegammon() {
    }

    static {
        OK = new Command(Resources.getString(Resources.TXT_C_OK), 4, 1);
        CANCEL = new Command(Resources.getString(Resources.TXT_C_CANCEL), 3, 1);
        GAME_TYPE_LOCAL = 0;
        GAME_TYPE_REMOTE_SERVER = 1;
        GAME_TYPE_REMOTE_CLIENT = 2;
    }
}

