/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import bluegammon.Resources;
import bluegammon.gui.BluetoothClientWorkflow;
import bluegammon.gui.FocusablePage;
import bluegammon.gui.PopupCanvas;
import bluegammon.gui.SoftButtonControl;
import bluegammon.gui.menu.Menu;
import bluegammon.gui.menu.MenuPage;
import bluegammon.gui.menu.PageItem;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class BluetoothDevicePage
extends MenuPage
implements FocusablePage,
CommandListener,
Runnable {
    protected static final Command REFRESH = new Command(Resources.getString(Resources.TXT_C_REFRESH), 4, 1);
    protected PopupCanvas m_canvas;
    protected SoftButtonControl m_softButtons;
    protected Menu m_menu;
    protected Command m_oldCommand;
    protected CommandListener m_oldListener;
    protected boolean m_searching = false;
    protected int m_btImage = 0;
    protected Image[] m_images;
    protected BluetoothClientWorkflow m_clientWorkflow;

    public BluetoothDevicePage(char[] cArray, Menu menu, PopupCanvas popupCanvas, SoftButtonControl softButtonControl) {
        super(cArray, null);
        this.m_canvas = popupCanvas;
        this.m_softButtons = softButtonControl;
        this.m_menu = menu;
        this.m_images = new Image[2];
        this.m_images[0] = Resources.getImage(111);
        this.m_images[1] = Resources.getImage(112);
        new Thread((Runnable)this, "BTAnim").start();
    }

    public void addItem(PageItem pageItem) {
        super.addItem(pageItem);
        this.m_canvas.repaint();
    }

    public void setClientWorkflow(BluetoothClientWorkflow bluetoothClientWorkflow) {
        this.m_clientWorkflow = bluetoothClientWorkflow;
    }

    public synchronized boolean isSearching() {
        return this.m_searching;
    }

    public synchronized void setSearching(boolean bl) {
        this.m_softButtons.enable(REFRESH, !bl);
        this.m_searching = bl;
        this.m_canvas.repaint();
        this.notifyAll();
    }

    public void onEnter() {
        this.m_oldListener = this.m_softButtons.getCommandListener();
        this.m_oldCommand = this.m_softButtons.getRightCommand();
        this.m_softButtons.setCommandListener(this);
        this.m_softButtons.setRightCommand(REFRESH);
        this.m_softButtons.enable(REFRESH, !this.m_searching);
    }

    public void onLeave() {
        this.m_softButtons.setRightCommand(this.m_oldCommand);
        this.m_softButtons.setCommandListener(this.m_oldListener);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == REFRESH) {
            this.m_clientWorkflow.refresh();
        } else {
            this.m_menu.goBack();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = this;
        synchronized (var1_1) {
            block7: while (true) {
                if (!this.m_searching) {
                    this.setTitleImage(null);
                    this.m_canvas.repaint();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_3) {}
                    continue;
                }
                while (true) {
                    if (this.m_searching) ** break;
                    continue block7;
                    this.setTitleImage(this.m_images[this.m_btImage++]);
                    this.m_btImage %= this.m_images.length;
                    this.m_canvas.repaint();
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException var2_4) {}
                }
                break;
            }
        }
    }
}

