/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import bluegammon.Audio;
import bluegammon.Bluegammon;
import bluegammon.Device;
import bluegammon.Resources;
import bluegammon.RmsFacade;
import bluegammon.gui.BluetoothClientWorkflow;
import bluegammon.gui.BluetoothDevicePage;
import bluegammon.gui.BluetoothServerWorkflow;
import bluegammon.gui.FocusablePage;
import bluegammon.gui.PopupCanvas;
import bluegammon.gui.SoftButtonControl;
import bluegammon.gui.menu.BinaryPageItem;
import bluegammon.gui.menu.DefaultMenuPainter;
import bluegammon.gui.menu.ItemAction;
import bluegammon.gui.menu.Menu;
import bluegammon.gui.menu.MenuListener;
import bluegammon.gui.menu.MenuPage;
import bluegammon.gui.menu.PageItem;
import bluegammon.gui.popup.Popup;
import bluegammon.logic.GameRecord;
import bluegammon.logic.Rules;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuCanvas
extends PopupCanvas
implements MenuListener,
ItemAction,
CommandListener {
    protected static final int ITEM_HELP = 0;
    protected static final int ACTION_LOCAL_START = 1;
    protected static final int ACTION_LOCAL_RESUME = 2;
    protected static final int ACTION_QUIT = 3;
    protected static final int ACTION_SCORE = 4;
    protected static final int ACTION_AUDIO = 100;
    protected static final int ACTION_VIBRA = 101;
    protected static final int ACTION_ABOUT = 200;
    protected static final Command CMD_BACK = new Command(Resources.getString(Resources.TXT_C_BACK), 2, 1);
    protected static final Command CMD_HELP = new Command(Resources.getString(Resources.TXT_C_HELP), 8, 1);
    protected Menu m_menu;
    protected SoftButtonControl m_softButtons;
    protected Image m_background = Resources.getImage(100);
    protected MenuPage m_scorePage;
    protected PageItem m_resumeGameItem;
    protected PageItem m_scoresItem;
    protected RuleFlagItem m_max5Item;
    protected RuleFlagItem m_evenOutItem;
    protected static MenuCanvas m_inst = null;

    public static MenuCanvas getInstance() {
        if (m_inst == null) {
            m_inst = new MenuCanvas();
        }
        return m_inst;
    }

    protected MenuCanvas() {
        this.m_softButtons = new SoftButtonControl();
        MenuPage menuPage = new MenuPage(Resources.getChars(Resources.TXT_T_BLUEGAMMON), null);
        this.m_menu = new Menu(menuPage, this, new BackgammonMenuPainter(this.getWidth()));
        MenuPage menuPage2 = new MenuPage(Resources.getChars(Resources.TXT_T_BLUETOOTH), null);
        MenuPage menuPage3 = new MenuPage(Resources.getChars(Resources.TXT_T_PHONEGAME), null);
        MenuPage menuPage4 = new MenuPage(Resources.getChars(Resources.TXT_T_SETTINGS), null);
        MenuPage menuPage5 = new MenuPage(Resources.getChars(Resources.TXT_T_RULES), null);
        this.m_scorePage = new MenuPage(Resources.getChars(Resources.TXT_T_SCORES), null);
        PageItem pageItem = new PageItem(Resources.getChars(Resources.TXT_I_BTGAME), null, null, menuPage2);
        pageItem.setEnabled(Device.canBluetooth());
        pageItem.setProperty(0, Resources.getChars(Resources.TXT_H_BT_GAME));
        PageItem pageItem2 = new PageItem(Resources.getChars(Resources.TXT_I_PHONE_GAME), null, null, menuPage3);
        pageItem2.setProperty(0, Resources.getChars(Resources.TXT_H_PHONE_GAME));
        this.m_scoresItem = new PageItem(Resources.getChars(Resources.TXT_I_BT_SCORES), null, this, this.m_scorePage);
        this.m_scoresItem.setProperty(0, Resources.getChars(Resources.TXT_H_SCORES));
        PageItem pageItem3 = new PageItem(Resources.getChars(Resources.TXT_I_SETTINGS), null, null, menuPage4);
        pageItem3.setProperty(0, Resources.getChars(Resources.TXT_H_SETTINGS));
        menuPage.addItem(pageItem);
        menuPage.addItem(pageItem2);
        menuPage.addItem(this.m_scoresItem);
        menuPage.addItem(pageItem3);
        menuPage.addItem(new PageItem(Resources.getChars(Resources.TXT_I_ABOUT), null, this, null, 200));
        menuPage.addItem(new PageItem(Resources.getChars(Resources.TXT_I_EXIT), null, this, null, 3));
        PageItem pageItem4 = new PageItem(Resources.getChars(Resources.TXT_I_BT_SERVER), null, new BluetoothServerWorkflow(), null);
        pageItem4.setProperty(0, Resources.getChars(Resources.TXT_H_BT_SERVER));
        BluetoothDevicePage bluetoothDevicePage = new BluetoothDevicePage(Resources.getChars(Resources.TXT_T_DEVICES), this.m_menu, this, this.m_softButtons);
        BluetoothClientWorkflow bluetoothClientWorkflow = new BluetoothClientWorkflow(bluetoothDevicePage);
        bluetoothDevicePage.setClientWorkflow(bluetoothClientWorkflow);
        PageItem pageItem5 = new PageItem(Resources.getChars(Resources.TXT_I_BT_CLIENT), null, bluetoothClientWorkflow, bluetoothDevicePage);
        pageItem5.setProperty(0, Resources.getChars(Resources.TXT_H_BT_CLIENT));
        menuPage2.addItem(pageItem4);
        menuPage2.addItem(pageItem5);
        this.m_resumeGameItem = new PageItem(Resources.getChars(Resources.TXT_I_PG_RESUME), null, this, null, 2);
        this.m_resumeGameItem.setProperty(0, Resources.getChars(Resources.TXT_H_PG_RESUME));
        PageItem pageItem6 = new PageItem(Resources.getChars(Resources.TXT_I_PG_NEW_GAME), null, this, null, 1);
        pageItem6.setProperty(0, Resources.getChars(Resources.TXT_H_PG_NEW_GAME));
        menuPage3.addItem(this.m_resumeGameItem);
        menuPage3.addItem(pageItem6);
        this.m_max5Item = new RuleFlagItem(1, Resources.getChars(Resources.TXT_I_R_MAXFIVE), Resources.getImage(109), Resources.getImage(110), Integer.MIN_VALUE);
        this.m_max5Item.setProperty(0, Resources.getChars(Resources.TXT_H_R_MAX_FIVE));
        this.m_evenOutItem = new RuleFlagItem(2, Resources.getChars(Resources.TXT_I_R_EVENOUT), Resources.getImage(109), Resources.getImage(110), Integer.MIN_VALUE);
        this.m_evenOutItem.setProperty(0, Resources.getChars(Resources.TXT_H_R_EVEN_OUT));
        menuPage5.addItem(this.m_max5Item);
        menuPage5.addItem(this.m_evenOutItem);
        PersistenceFlagItem persistenceFlagItem = new PersistenceFlagItem(4, Resources.getChars(Resources.TXT_I_S_COLOR), Resources.getImage(104), Resources.getImage(103), Integer.MIN_VALUE);
        persistenceFlagItem.setProperty(0, Resources.getChars(Resources.TXT_H_S_COLOR));
        PersistenceFlagItem persistenceFlagItem2 = new PersistenceFlagItem(5, Resources.getChars(Resources.TXT_I_S_AUDIO), Resources.getImage(106), Resources.getImage(105), 100);
        persistenceFlagItem2.setProperty(0, Resources.getChars(Resources.TXT_H_S_AUDIO));
        PersistenceFlagItem persistenceFlagItem3 = new PersistenceFlagItem(6, Resources.getChars(Resources.TXT_I_S_VIBRA), Resources.getImage(108), Resources.getImage(107), 101);
        persistenceFlagItem3.setEnabled(Device.canVibrate());
        persistenceFlagItem3.setProperty(0, Resources.getChars(Resources.TXT_H_S_VIBRA));
        PageItem pageItem7 = new PageItem(Resources.getChars(Resources.TXT_I_PG_RULES), null, null, menuPage5);
        pageItem7.setLayout(3);
        pageItem7.setProperty(0, Resources.getChars(Resources.TXT_H_S_RULES));
        menuPage4.addItem(persistenceFlagItem);
        menuPage4.addItem(persistenceFlagItem2);
        menuPage4.addItem(persistenceFlagItem3);
        menuPage4.addItem(pageItem7);
        this.setFullScreenMode(true);
        this.m_softButtons.init((Displayable)this, Font.getFont((int)64, (int)1, (int)8), CMD_BACK, CMD_HELP);
        this.m_softButtons.setCommandListener(this);
        this.m_softButtons.enable(CMD_HELP, false);
        int n = 16;
        this.m_menu.setLocation(0, n);
        this.m_menu.setDimensions(this.getWidth(), this.getHeight() - n * 2);
        this.m_menu.setFrameData(10, 20L);
        this.m_menu.setListener(this);
        this.m_menu.start();
    }

    public void initShow() {
        Object object;
        this.m_max5Item.setBoolean(Rules.isSet(1));
        this.m_evenOutItem.setBoolean(Rules.isSet(2));
        this.m_resumeGameItem.setEnabled(Bluegammon.hasSavedLocalGame());
        this.m_scoresItem.setEnabled(GameRecord.countRecords() > 0);
        this.m_scorePage.removeAllItems();
        Vector vector = GameRecord.getAllRecords();
        for (int i = 0; i < vector.size(); ++i) {
            object = (GameRecord)vector.elementAt(i);
            if (((GameRecord)object).getGameCount() <= 0) continue;
            this.m_scorePage.addItem(new GameRecordPageItem((GameRecord)object));
        }
        PageItem pageItem = this.m_menu.getSelectedItem();
        if (pageItem != null) {
            object = pageItem.getProperty(0);
            this.m_softButtons.enable(CMD_HELP, object != null);
        }
        Audio.playSound(0);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0x888833);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.m_background, this.getWidth() / 2, this.getHeight() / 2, 3);
        this.m_menu.paint(graphics);
        this.m_softButtons.paint(graphics);
        if (this.getPopup() != null && this.getPopup().isActive()) {
            this.getPopup().paint(graphics);
        }
    }

    protected void keyPressed(int n) {
        if (this.getPopup() != null && this.getPopup().isActive()) {
            this.getPopup().keyPressed(n, this.getGameAction(n));
            this.repaint();
        } else {
            this.m_menu.keyPressed(n);
            this.m_softButtons.keyPressed(n);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        char[] cArray;
        PageItem pageItem;
        if (command == CMD_BACK) {
            this.m_menu.goBack();
        } else if (command == CMD_HELP && (pageItem = this.m_menu.getSelectedItem()) != null && (cArray = (char[])pageItem.getProperty(0)) != null) {
            Bluegammon.showPopup(cArray, Popup.ALT_OK, 0, 0, 0, null);
        }
    }

    public void itemAction(MenuPage menuPage, PageItem pageItem) {
        int n = pageItem.getId();
        switch (n) {
            case 1: {
                Bluegammon.startLocalGame();
                break;
            }
            case 2: {
                Bluegammon.resumeSavedLocalGame();
                break;
            }
            case 3: {
                Bluegammon.shutdown();
                break;
            }
            case 4: {
                GameRecordPageItem gameRecordPageItem = (GameRecordPageItem)pageItem;
                String string = new String(gameRecordPageItem.getOpponentNameChars()) + "\n\n" + Resources.getString(Resources.TXT_SCORE_PLAYER) + ": " + new String(gameRecordPageItem.getPlayerScoreChars()) + "\n" + Resources.getString(Resources.TXT_SCORE_OPPONENT) + ": " + new String(gameRecordPageItem.getOpponentScoreChars()) + "\n" + Resources.getString(Resources.TXT_SCORE_GAMES) + ": " + new String(gameRecordPageItem.getGamesChars()) + "\n" + Resources.getString(Resources.TXT_SCORE_DATE) + ": " + new String(gameRecordPageItem.getLastDateChars()) + "\n\n";
                char[] cArray = string.toCharArray();
                Bluegammon.showPopup(cArray, Popup.ALT_OK, 0, 0, 0, null);
                break;
            }
            case 100: {
                if (RmsFacade.getBoolean(5)) {
                    Audio.stopSound(0);
                    break;
                }
                Audio.playSound(0);
                break;
            }
            case 101: {
                if (RmsFacade.getBoolean(6)) break;
                Device.vibrate(100, 100, 3);
                break;
            }
            case 200: {
                Bluegammon.showPopup(Resources.getChars(Resources.TXT_ABOUT), Popup.ALT_OK, 0, 0, 0, null);
            }
        }
    }

    public void newPage(MenuPage menuPage, MenuPage menuPage2, boolean bl) {
        this.m_softButtons.enable(CMD_BACK, menuPage2 != this.m_menu.getStartPage());
        if (menuPage instanceof FocusablePage) {
            ((FocusablePage)((Object)menuPage)).onLeave();
        }
        if (menuPage2 instanceof FocusablePage) {
            ((FocusablePage)((Object)menuPage2)).onEnter();
        }
    }

    public void itemSelected(MenuPage menuPage, PageItem pageItem, PageItem pageItem2) {
        if (pageItem2 != null) {
            Object object = pageItem2.getProperty(0);
            this.m_softButtons.enable(CMD_HELP, object != null);
        }
    }

    public void actionCalled(MenuPage menuPage, PageItem pageItem, ItemAction itemAction) {
    }

    public void transitionStarted(MenuPage menuPage, MenuPage menuPage2, long l, int n, boolean bl) {
    }

    public void transitionStopped(MenuPage menuPage, MenuPage menuPage2) {
    }

    static class BackgammonMenuPainter
    extends DefaultMenuPainter {
        protected static final char[] SCORE_TXT = "9999".toCharArray();
        protected int m_scoreWidth;
        protected int[] m_rgbData;
        protected int m_canvasWidth;

        public BackgammonMenuPainter(int n) {
            this.m_canvasWidth = n;
            this.m_rgbData = new int[this.m_canvasWidth * 4];
            int n2 = 0x880000;
            for (int i = 0; i < this.m_canvasWidth; ++i) {
                int n3;
                double d = (double)Math.abs(i - this.m_canvasWidth / 2) / (double)this.m_canvasWidth;
                this.m_rgbData[i] = n3 = n2 | 128 - (int)(255.0 * d) << 24;
                this.m_rgbData[i + this.m_canvasWidth] = n3;
                this.m_rgbData[i + this.m_canvasWidth * 2] = n3;
                this.m_rgbData[i + this.m_canvasWidth * 3] = n3;
            }
            this.m_scoreWidth = this.m_itemFont.charsWidth(SCORE_TXT, 0, SCORE_TXT.length);
        }

        protected void paintItem(Graphics graphics, PageItem pageItem, boolean bl, int n, int n2, int n3, int n4, boolean bl2, boolean bl3) {
            if (bl) {
                int n5 = this.getItemHeight(pageItem);
                for (int i = n2; i < n2 + n5; i += 4) {
                    graphics.drawRGB(this.m_rgbData, 0, this.m_canvasWidth, n - this.m_canvasWidth / 2, i, this.m_canvasWidth, Math.min(4, n2 + n5 - (i - n2)), true);
                }
            }
            if (pageItem instanceof GameRecordPageItem) {
                graphics.setFont(this.m_itemFont);
                GameRecordPageItem gameRecordPageItem = (GameRecordPageItem)pageItem;
                char[] cArray = gameRecordPageItem.getOpponentNameChars();
                char[] cArray2 = gameRecordPageItem.getPlayerScoreChars();
                char[] cArray3 = gameRecordPageItem.getOpponentScoreChars();
                if (!bl) {
                    graphics.setColor(gameRecordPageItem.isEnabled() ? this.m_itemColor : this.m_itemColorDisabled);
                } else {
                    graphics.setColor(this.m_selItemColor);
                }
                graphics.drawChars(cArray, 0, cArray.length, n - n4 / 2, n2, 20);
                graphics.drawChars(cArray2, 0, cArray2.length, n - n4 / 2 + n4 - this.m_scoreWidth - this.m_imgPadding, n2, 24);
                graphics.drawChars(cArray3, 0, cArray3.length, n - n4 / 2 + n4, n2, 24);
            } else {
                super.paintItem(graphics, pageItem, bl, n, n2, n3, n4, bl2, bl3);
            }
        }

        protected int getItemWidth(PageItem pageItem) {
            if (pageItem instanceof GameRecordPageItem) {
                GameRecordPageItem gameRecordPageItem = (GameRecordPageItem)pageItem;
                int n = this.m_itemFont.charsWidth(gameRecordPageItem.getOpponentNameChars(), 0, gameRecordPageItem.getOpponentNameChars().length);
                n += this.m_scoreWidth * 2;
                return n += this.m_imgPadding * 2;
            }
            return super.getItemWidth(pageItem);
        }
    }

    class GameRecordPageItem
    extends PageItem {
        protected GameRecord m_record = null;
        protected char[] m_opponentNameChars;
        protected char[] m_playerScoreChars;
        protected char[] m_opponentScoreChars;
        protected char[] m_gamesChars;
        protected char[] m_lastDateChars;

        public GameRecordPageItem(GameRecord gameRecord) {
            super(null, null, MenuCanvas.this, null, 4);
            this.m_record = gameRecord;
            this.m_opponentNameChars = gameRecord.getOpponentName();
            this.m_playerScoreChars = Integer.toString(gameRecord.getPlayerScore()).toCharArray();
            this.m_opponentScoreChars = Integer.toString(gameRecord.getOpponentScore()).toCharArray();
            this.m_gamesChars = Integer.toString(gameRecord.getGameCount()).toCharArray();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(gameRecord.getTimestamp()));
            String string = calendar.get(5) + " ";
            int n = calendar.get(2);
            switch (n) {
                case 0: {
                    string = string + "Jan";
                    break;
                }
                case 1: {
                    string = string + "Feb";
                    break;
                }
                case 2: {
                    string = string + "Mar";
                    break;
                }
                case 3: {
                    string = string + "Apr";
                    break;
                }
                case 4: {
                    string = string + "May";
                    break;
                }
                case 5: {
                    string = string + "Jun";
                    break;
                }
                case 6: {
                    string = string + "Jul";
                    break;
                }
                case 7: {
                    string = string + "Aug";
                    break;
                }
                case 8: {
                    string = string + "Sep";
                    break;
                }
                case 9: {
                    string = string + "Oct";
                    break;
                }
                case 10: {
                    string = string + "Nov";
                    break;
                }
                case 11: {
                    string = string + "Dec";
                }
            }
            int n2 = calendar.get(11);
            string = string + (n2 < 10 ? " 0" : " ") + n2;
            int n3 = calendar.get(12);
            string = string + (n3 < 10 ? ":0" : ":") + n3;
            this.m_lastDateChars = string.toCharArray();
            this.setLayout(2);
        }

        public char[] getGamesChars() {
            return this.m_gamesChars;
        }

        public char[] getLastDateChars() {
            return this.m_lastDateChars;
        }

        public char[] getOpponentNameChars() {
            return this.m_opponentNameChars;
        }

        public char[] getOpponentScoreChars() {
            return this.m_opponentScoreChars;
        }

        public char[] getPlayerScoreChars() {
            return this.m_playerScoreChars;
        }

        public GameRecord getRecord() {
            return this.m_record;
        }
    }

    class RuleFlagItem
    extends BinaryPageItem {
        protected int m_rule;

        public RuleFlagItem(int n, char[] cArray, Image image, Image image2, int n2) {
            super(cArray, image, image2, null, MenuCanvas.this, n2);
            this.m_rule = n;
        }

        public boolean getBoolean() {
            return Rules.isSet(this.m_rule);
        }

        public void setBoolean(boolean bl) {
            Rules.set(this.m_rule, bl);
            RmsFacade.setInt(7, Rules.getRuleFlags());
        }
    }

    class PersistenceFlagItem
    extends BinaryPageItem {
        protected int m_key;

        public PersistenceFlagItem(int n, char[] cArray, Image image, Image image2, int n2) {
            super(cArray, image, image2, null, MenuCanvas.this, n2);
            this.m_key = n;
        }

        public boolean getBoolean() {
            return RmsFacade.getBoolean(this.m_key);
        }

        public void setBoolean(boolean bl) {
            RmsFacade.setBoolean(this.m_key, bl);
        }
    }
}

