/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.Audio;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.Context3D;
import bluegammon.gui.animation.Animation;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Graphics;

public class PieceMoveAnim
extends Animation {
    protected static int SIZE = 7;
    protected int m_frames;
    protected boolean m_white;
    protected int m_source;
    protected int m_dest;
    protected int m_x0;
    protected int m_y0;
    protected int m_x1;
    protected int m_y1;
    protected float m_angleSign = 1.0f;
    protected int m_frame = 0;
    protected float m_x;
    protected float m_y;
    protected boolean m_vertSin = false;
    protected float m_sinFact = 0.0f;
    protected float m_sinStep;
    protected float m_sinAngle;
    protected static int[] m_shadow;

    public static void init(int n) {
        SIZE = n;
        m_shadow = Context3D.createShadowRGB(SIZE, 0);
    }

    public PieceMoveAnim(boolean bl, int n, int n2, int n3, int n4) {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        this.m_white = bl;
        this.m_source = n;
        this.m_dest = n2;
        this.m_angleSign = n < 13 ? 1.0f : -1.0f;
        this.m_x0 = boardCanvas.getPieceX(n, n3, bl);
        this.m_y0 = boardCanvas.getPieceY(n, n3, bl);
        this.m_x1 = boardCanvas.getPieceX(n2, n4, bl);
        this.m_y1 = boardCanvas.getPieceY(n2, n4, bl);
        this.m_x = this.m_x0;
        this.m_y = this.m_y0;
        int n5 = Math.abs(this.m_x1 - this.m_x0);
        int n6 = Math.abs(this.m_y1 - this.m_y0);
        this.m_frames = Math.max(n5, n6);
        this.m_frames = 4 * this.m_frames / boardCanvas.getHeight();
        this.m_frames = Math.max(10, this.m_frames);
        this.m_frames = Math.min(30, this.m_frames);
        if (this.m_dest == 25) {
            this.m_frames = 30;
        }
        this.m_vertSin = n < 12 && n2 < 12 || n > 11 && n2 > 11 || n2 == 24 ? false : n6 < n5;
        this.m_sinFact = this.m_vertSin ? (float)boardCanvas.getBoardHeight() / 8.0f : (float)boardCanvas.getWidth() / 8.0f;
        if (n2 < 12 || n2 == 24 && !bl) {
            this.m_sinFact = -this.m_sinFact;
        }
        this.m_sinStep = (float)Math.PI / (float)(this.m_frames - 1);
        this.m_sinAngle = this.m_sinStep / 2.0f;
    }

    public void onStart() {
        BoardCanvas.getInstance().removePiece(this.m_white, this.m_source);
    }

    public void paint(Graphics graphics) {
        if (this.m_frame <= this.m_frames) {
            float f = (float)this.m_frame / (float)this.m_frames;
            float f2 = 0.0f;
            float f3 = 0.0f;
            f2 = (float)Math.sin(Math.PI * (double)f);
            if (this.m_dest == 25) {
                f3 = 540.0f * f;
                f2 *= 25.0f;
            } else if (this.m_dest == 24) {
                f3 = (float)(this.m_white ? -1 : 1) * 60.0f * f;
                f2 *= 10.0f;
            } else {
                f3 = this.m_angleSign * 75.0f * (float)Math.sin(Math.PI * (double)f);
                f2 *= 10.0f;
            }
            Context3D context3D = Context3D.getInstance();
            graphics.drawRGB(m_shadow, 0, SIZE, (int)(this.m_x - context3D.toScreenCoordinateX(context3D.getShadowProjectionDeltaX(f2), -55.0f)), (int)this.m_y, SIZE, SIZE, true);
            BoardCanvas.getInstance().drawPiece((int)this.m_x, (int)this.m_y, f3, false, f2, this.m_white, graphics);
        }
    }

    public void next() {
        if (this.m_frame < this.m_frames) {
            BoardCanvas boardCanvas = BoardCanvas.getInstance();
            this.m_x = (float)(this.m_x1 - this.m_x0) * (float)this.m_frame / (float)this.m_frames + (float)this.m_x0;
            this.m_y = (float)(this.m_y1 - this.m_y0) * (float)this.m_frame / (float)this.m_frames + (float)this.m_y0;
            if (this.m_vertSin) {
                this.m_y = (float)((double)this.m_y - (double)this.m_sinFact * Math.sin(this.m_sinAngle));
            } else {
                this.m_x = (float)((double)this.m_x - (double)this.m_sinFact * Math.sin(this.m_sinAngle));
            }
            this.m_sinAngle += this.m_sinStep;
            boardCanvas.requestRepaint();
        }
        ++this.m_frame;
    }

    public boolean isFinished() {
        return this.m_frame >= this.m_frames;
    }

    public void onExit() {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        boardCanvas.addPiece(this.m_white, this.m_dest);
        boardCanvas.requestRepaint();
        if (!BoardMediator.isGameFinished()) {
            Audio.playSound(3);
        }
    }

    public long getInterval() {
        return 20L;
    }
}

