/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.logic.Board;
import bluegammon.logic.BoardStateListener;
import bluegammon.logic.Player;
import bluegammon.logic.Rules;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BoardState
extends Board {
    protected boolean m_chooseTurns = true;
    protected boolean m_diceThrown = false;
    protected static Player m_player1;
    protected static Player m_player2;
    protected static Player m_currentPlayer;
    protected boolean m_gameFinished = true;
    protected int[] m_dice = new int[4];
    protected int m_diceVals = 2;
    protected boolean m_possibleMovesCalculated = false;
    protected int[][] m_possibleMoves = new int[256][3];
    public static final int PM_SOUR = 0;
    public static final int PM_DEST = 1;
    public static final int PM_DICE = 2;
    protected int m_possibleMoveCount = 0;
    protected int[][] m_undoableMoves = new int[5][4];
    protected static final int UNDO_SOURCE = 0;
    protected static final int UNDO_DEST = 1;
    protected static final int UNDO_GUARD = 2;
    protected static final int UNDO_DICEVALUE = 3;
    protected int m_undoableMoveCount = 0;
    protected BoardStateListener m_listener;
    protected static BoardState m_instance;

    public void setGameListener(BoardStateListener boardStateListener) {
        this.m_listener = boardStateListener;
    }

    public void setPlayers(Player player, Player player2) {
        m_player1 = player;
        m_player2 = player2;
    }

    public boolean isGameFinished() {
        return this.m_gameFinished;
    }

    public void setGameFinished(boolean bl) {
        this.m_gameFinished = bl;
        this.m_possibleMovesCalculated = false;
    }

    public boolean isCurrentPlayerWhite() {
        return m_currentPlayer.isWhite();
    }

    public Player getCurrentPlayer() {
        return m_currentPlayer;
    }

    public Player getWaitingPlayer() {
        if (m_player1 == m_currentPlayer) {
            return m_player2;
        }
        return m_player1;
    }

    public void setCurrentPlayer(boolean bl) {
        Player player = m_player1;
        if (bl && !m_player1.isWhite() || !bl && m_player1.isWhite()) {
            player = m_player2;
        }
        m_currentPlayer = player;
    }

    public void setTurn(boolean bl) {
        this.setCurrentPlayer(bl);
        if (this.m_listener != null) {
            this.m_listener.turnChange(bl);
        }
    }

    public synchronized void makeMove(int n, int n2, boolean bl) {
        int[] nArray = this.WHITE;
        int[] nArray2 = this.BLACK;
        if (!bl) {
            nArray = this.BLACK;
            nArray2 = this.WHITE;
        }
        int n3 = n;
        nArray[n3] = nArray[n3] - 1;
        int n4 = n2;
        nArray[n4] = nArray[n4] + 1;
        this.m_undoableMoves[this.m_undoableMoveCount][0] = n2;
        this.m_undoableMoves[this.m_undoableMoveCount][1] = n;
        this.m_undoableMoves[this.m_undoableMoveCount][2] = -1;
        if (this.m_listener != null) {
            this.m_listener.pieceMoved(bl, n, n2);
        }
        if (n2 != 24 && nArray2[n2] == 1) {
            this.m_undoableMoves[this.m_undoableMoveCount][2] = n2;
            nArray2[n2] = 0;
            nArray2[25] = nArray2[25] + 1;
            if (this.m_listener != null) {
                this.m_listener.pieceMoved(!bl, n2, 25);
            }
        }
        if (nArray[24] == 15) {
            this.setGameFinished(true);
            if (this.m_listener != null) {
                this.m_listener.gameFinished(bl, this.calculatePiecesLeft(!bl), this.calculatePoints(!bl));
            }
        }
    }

    public synchronized void consumeDice(int n) {
        this.m_undoableMoves[this.m_undoableMoveCount][3] = this.m_dice[n];
        for (int i = n; i < this.m_dice.length - 1; ++i) {
            this.m_dice[i] = this.m_dice[i + 1];
        }
        --this.m_diceVals;
        this.m_possibleMovesCalculated = false;
    }

    public synchronized void commitMove(boolean bl, int n) {
        int[] nArray = this.WHITE;
        int[] nArray2 = this.BLACK;
        if (!bl) {
            nArray = this.BLACK;
            nArray2 = this.WHITE;
        }
        ++this.m_undoableMoveCount;
        if (this.m_listener != null) {
            this.m_listener.undoAdded(this.m_undoableMoveCount, n);
        }
    }

    public synchronized int undoLastMove(boolean bl) {
        int n = -1;
        if (this.m_undoableMoveCount > 0) {
            int[] nArray = this.WHITE;
            int[] nArray2 = this.BLACK;
            if (!bl) {
                nArray = this.BLACK;
                nArray2 = this.WHITE;
            }
            --this.m_undoableMoveCount;
            int n2 = this.m_undoableMoves[this.m_undoableMoveCount][0];
            int n3 = this.m_undoableMoves[this.m_undoableMoveCount][1];
            int n4 = this.m_undoableMoves[this.m_undoableMoveCount][2];
            int n5 = this.m_undoableMoves[this.m_undoableMoveCount][3];
            n = n3;
            int n6 = n2;
            nArray[n6] = nArray[n6] - 1;
            int n7 = n3;
            nArray[n7] = nArray[n7] + 1;
            if (this.m_listener != null) {
                this.m_listener.pieceMoved(bl, n2, n3);
            }
            if (n4 >= 0) {
                nArray2[25] = nArray2[25] - 1;
                int n8 = n4;
                nArray2[n8] = nArray2[n8] + 1;
                if (this.m_listener != null) {
                    this.m_listener.pieceMoved(!bl, 25, n4);
                }
            }
            this.m_dice[this.m_diceVals++] = n5;
            this.m_possibleMovesCalculated = false;
            if (this.m_listener != null) {
                this.m_listener.undoPerformed(this.m_undoableMoveCount, n5);
            }
        }
        return n;
    }

    public int[][] getPossibleMoves(boolean bl) {
        if (!this.m_possibleMovesCalculated) {
            this.calcPossibleMoves(bl);
        }
        return this.m_possibleMoves;
    }

    public int countPossibleMoves(boolean bl) {
        if (!this.m_possibleMovesCalculated) {
            this.calcPossibleMoves(bl);
        }
        return this.m_possibleMoveCount;
    }

    public synchronized void newDiceValues(int n, int n2) {
        this.m_possibleMovesCalculated = false;
        this.m_undoableMoveCount = 0;
        this.m_dice[0] = n;
        this.m_dice[1] = n2;
        this.m_diceVals = 2;
        if (n == n2) {
            this.m_dice[2] = n;
            this.m_dice[3] = n;
            this.m_diceVals = 4;
        } else if (n > n2) {
            this.m_dice[0] = n2;
            this.m_dice[1] = n;
        }
    }

    public int getDiceValue(int n) {
        return this.m_dice[n];
    }

    public synchronized int countUndoableMoves() {
        return this.m_undoableMoveCount;
    }

    protected void calcPossibleMoves(boolean bl) {
        int n;
        this.m_possibleMoveCount = 0;
        int[] nArray = this.WHITE;
        int[] nArray2 = this.BLACK;
        if (!bl) {
            nArray = this.BLACK;
            nArray2 = this.WHITE;
        }
        int n2 = n = this.m_diceVals > 2 ? 1 : this.m_diceVals;
        if (n == 2 && this.m_dice[0] == this.m_dice[1]) {
            n = 1;
        }
        if (nArray[25] > 0) {
            for (int i = 0; i < n; ++i) {
                int n3 = bl ? this.m_dice[i] - 1 : 23 - this.m_dice[i] + 1;
                if (!Rules.isValidFromGuard(this, n3, nArray, nArray2)) continue;
                this.m_possibleMoves[this.m_possibleMoveCount][0] = 25;
                this.m_possibleMoves[this.m_possibleMoveCount][1] = n3;
                this.m_possibleMoves[this.m_possibleMoveCount++][2] = i;
            }
        } else {
            boolean bl2 = false;
            for (int i = 0; i <= 23; ++i) {
                int n4 = i < 12 ? i : 23 - (i - 12);
                if (nArray[n4] <= 0) continue;
                if (n > 0) {
                    bl2 = bl & n4 + this.m_dice[0] > 11 | !bl & n4 - this.m_dice[0] < 12;
                }
                for (int j = 0; j < n; ++j) {
                    int n5 = bl2 ? n - j - 1 : j;
                    int n6 = n4;
                    if (bl) {
                        n6 += this.m_dice[n5];
                    } else if ((n6 -= this.m_dice[n5]) < 0) {
                        n6 = -n6 + 23;
                    }
                    if (!Rules.isValidMove(this, n4, n6, bl, nArray, nArray2)) continue;
                    this.m_possibleMoves[this.m_possibleMoveCount][0] = n4;
                    this.m_possibleMoves[this.m_possibleMoveCount][1] = n6 > 23 ? 24 : n6;
                    this.m_possibleMoves[this.m_possibleMoveCount++][2] = n5;
                }
            }
        }
        this.m_possibleMovesCalculated = true;
    }

    public boolean isNoneBefore(boolean bl, int n) {
        boolean bl2 = true;
        int n2 = -1;
        int[] nArray = this.WHITE;
        if (!bl) {
            nArray = this.BLACK;
            n2 = 1;
        }
        n += n2;
        while (bl2 && n > 0 && n <= 23) {
            bl2 = nArray[n] == 0;
            n += n2;
        }
        return bl2;
    }

    public boolean areAllPiecesHome(boolean bl) {
        boolean bl2 = true;
        int[] nArray = this.WHITE;
        if (!bl) {
            nArray = this.BLACK;
        }
        for (int i = 0; bl2 && i <= 17; ++i) {
            int n = this.getPlayerIndex(bl, i, 0);
            bl2 = nArray[n] == 0;
        }
        return bl2;
    }

    public int loadState(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = 0;
        this.m_chooseTurns = dataInputStream.readBoolean();
        ++n2;
        this.m_diceThrown = dataInputStream.readBoolean();
        ++n2;
        boolean bl = dataInputStream.readBoolean();
        ++n2;
        this.m_undoableMoveCount = dataInputStream.readInt();
        n2 += 4;
        for (n = 0; n < 5; ++n) {
            for (int i = 0; i < 4; ++i) {
                this.m_undoableMoves[n][i] = dataInputStream.readInt();
                n2 += 4;
            }
        }
        this.m_diceVals = dataInputStream.readInt();
        n2 += 4;
        for (n = 0; n < 4; ++n) {
            this.m_dice[n] = dataInputStream.readInt();
            n2 += 4;
        }
        this.m_possibleMovesCalculated = false;
        this.setCurrentPlayer(bl);
        return n2 += this.loadBoard(dataInputStream);
    }

    public int saveState(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        dataOutputStream.writeBoolean(this.m_chooseTurns);
        ++n2;
        dataOutputStream.writeBoolean(this.m_diceThrown);
        ++n2;
        dataOutputStream.writeBoolean(m_currentPlayer.isWhite());
        ++n2;
        dataOutputStream.writeInt(this.m_undoableMoveCount);
        n2 += 4;
        for (n = 0; n < 5; ++n) {
            for (int i = 0; i < 4; ++i) {
                dataOutputStream.writeInt(this.m_undoableMoves[n][i]);
                n2 += 4;
            }
        }
        dataOutputStream.writeInt(this.m_diceVals);
        n2 += 4;
        for (n = 0; n < 4; ++n) {
            dataOutputStream.writeInt(this.m_dice[n]);
            n2 += 4;
        }
        return n2 += this.saveBoard(dataOutputStream);
    }

    private BoardState() {
    }

    public static BoardState getInstance() {
        if (m_instance == null) {
            m_instance = new BoardState();
        }
        return m_instance;
    }
}

