/*
 * Decompiled with CFR 0.152.
 */
package bluegammon;

import bluegammon.RmsFacade;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public final class Device {
    public static final int KEYCODE_LEFT_SOFT = -6;
    public static final int KEYCODE_RIGHT_SOFT = -7;
    public static final int KEYCODE_BACK = -11;
    protected static Display m_display;
    protected static MIDlet m_midlet;
    private static int m_bluetoothSupport;

    public static void init(MIDlet mIDlet, Display display) {
        m_midlet = mIDlet;
        m_display = display;
    }

    public static MIDlet getMidlet() {
        return m_midlet;
    }

    public static Display getDisplay() {
        return m_display;
    }

    public static boolean canBluetooth() {
        if (m_bluetoothSupport == 0) {
            try {
                Class.forName("javax.bluetooth.LocalDevice");
                m_bluetoothSupport = 1;
            }
            catch (Throwable throwable) {
                m_bluetoothSupport = -1;
            }
        }
        return m_bluetoothSupport == 1;
    }

    public static boolean canVibrate() {
        return true;
    }

    public static void vibrate(final int n, final int n2, final int n3) {
        if (RmsFacade.getBoolean(6)) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < n3; ++i) {
                    Device.getDisplay().vibrate(n);
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (i >= n3 - 1) continue;
                    Device.getDisplay().vibrate(0);
                    try {
                        Thread.sleep(n2);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Device.getDisplay().vibrate(0);
            }
        }, "Bzzzer").start();
    }

    public static int getDeviceId() {
        int n = RmsFacade.getInt(0);
        if (n == 0) {
            String string = System.getProperty("com.sonyericsson.imei");
            if (string == null) {
                string = Long.toString(System.currentTimeMillis());
            }
            n = Device.calcIdFromString(string);
            RmsFacade.setInt(0, n);
        }
        return n;
    }

    protected static int calcIdFromString(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            n = n << 1 ^ string.charAt(i) ^ ((n & Integer.MIN_VALUE) != 0 ? 1 : 0);
        }
        return n;
    }

    private Device() {
    }

    static {
        m_bluetoothSupport = 0;
    }
}

