/*
 * Decompiled with CFR 0.152.
 */
package bluegammon;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RmsFacade {
    protected static RecordStore m_rs = null;
    protected static final String RS_NAME = "bg";
    protected static byte[] m_keyCache;
    protected static int m_nbrOfKeys;
    protected static final byte[] TRUE;
    protected static final byte[] FALSE;
    protected static final byte[] DUMMY;

    private RmsFacade() {
    }

    public static void shutdown() {
        try {
            m_rs.closeRecordStore();
            m_rs = null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean init(int n) {
        m_nbrOfKeys = n;
        boolean bl = false;
        try {
            if (RmsFacade.getStore().getNumRecords() == 0) {
                bl = true;
            } else {
                try {
                    m_keyCache = RmsFacade.getStore().getRecord(1);
                    if (m_keyCache.length != n * 2) {
                        if (m_rs != null) {
                            m_rs.closeRecordStore();
                        }
                        m_rs = null;
                        RecordStore.deleteRecordStore((String)RS_NAME);
                        bl = true;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    bl = true;
                    if (m_rs != null) {
                        m_rs.closeRecordStore();
                    }
                    m_rs = null;
                    RecordStore.deleteRecordStore((String)RS_NAME);
                }
            }
            if (bl) {
                m_keyCache = new byte[n * 2];
                RmsFacade.getStore().addRecord(m_keyCache, 0, n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static char[] getChars(int n) {
        byte[] byArray = RmsFacade.get(n);
        if (byArray == null) {
            return null;
        }
        if ((byArray.length & 1) > 0) {
            throw new IllegalArgumentException("RmsFacade key " + n + " does not point to char array");
        }
        char[] cArray = new char[byArray.length >> 1];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((byArray[i << 1] & 0xFF) << 8 | byArray[(i << 1) + 1] & 0xFF);
        }
        return cArray;
    }

    public static void setChars(int n, char[] cArray) {
        byte[] byArray = null;
        if (cArray != null) {
            byArray = new byte[cArray.length << 1];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i << 1] = (byte)((cArray[i] & 0xFF00) >> 8);
                byArray[(i << 1) + 1] = (byte)(cArray[i] & 0xFF);
            }
        }
        RmsFacade.set(n, byArray);
    }

    public static boolean getBoolean(int n) {
        byte[] byArray = RmsFacade.get(n);
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        return byArray[0] > 0;
    }

    public static void setBoolean(int n, boolean bl) {
        RmsFacade.set(n, bl ? TRUE : FALSE);
    }

    public static long getLong(int n) {
        byte[] byArray = RmsFacade.get(n);
        if (byArray == null || byArray.length != 8) {
            return 0L;
        }
        int n2 = (byArray[0] & 0xFF) << 56 | (byArray[1] & 0xFF) << 48 | (byArray[2] & 0xFF) << 40 | (byArray[3] & 0xFF) << 32 | (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        return n2;
    }

    public static void setLong(int n, long l) {
        byte[] byArray = new byte[]{(byte)((l & 0xFF00000000000000L) >> 58), (byte)((l & 0xFF000000000000L) >> 48), (byte)((l & 0xFF0000000000L) >> 40), (byte)((l & 0xFF00000000L) >> 32), (byte)((l & 0xFF000000L) >> 24), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF00L) >> 8), (byte)(l & 0xFFL)};
        RmsFacade.set(n, byArray);
    }

    public static int getInt(int n) {
        byte[] byArray = RmsFacade.get(n);
        if (byArray == null || byArray.length != 4) {
            return 0;
        }
        int n2 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n2;
    }

    public static void setInt(int n, int n2) {
        byte[] byArray = new byte[]{(byte)((n2 & 0xFF000000) >> 24), (byte)((n2 & 0xFF0000) >> 16), (byte)((n2 & 0xFF00) >> 8), (byte)(n2 & 0xFF)};
        RmsFacade.set(n, byArray);
    }

    public static byte[] get(int n) {
        byte[] byArray = null;
        try {
            byArray = RmsFacade.getStore().getRecord(RmsFacade.getKeyIndex(n));
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return byArray == null || byArray.length == 0 ? null : byArray;
    }

    public static void set(int n, byte[] byArray) {
        try {
            if (byArray == null) {
                RmsFacade.getStore().setRecord(RmsFacade.getKeyIndex(n), DUMMY, 0, 0);
            } else {
                RmsFacade.getStore().setRecord(RmsFacade.getKeyIndex(n), byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    protected static RecordStore getStore() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        if (m_rs == null) {
            m_rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
        }
        return m_rs;
    }

    protected static synchronized int getKeyIndex(int n) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        int n2 = (m_keyCache[n = (n & 0xFFFF) << 1] & 0xFF) << 8 | m_keyCache[n + 1] & 0xFF;
        if (n2 == 0) {
            n2 = RmsFacade.getStore().addRecord(DUMMY, 0, 0);
            RmsFacade.m_keyCache[n] = (byte)((n2 & 0xFF00) >> 8);
            RmsFacade.m_keyCache[n + 1] = (byte)(n2 & 0xFF);
            RmsFacade.getStore().setRecord(1, m_keyCache, 0, m_keyCache.length);
        }
        return n2;
    }

    static {
        TRUE = new byte[]{1};
        FALSE = new byte[]{0};
        DUMMY = new byte[0];
    }
}

