/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.menu;

import bluegammon.gui.menu.MenuPage;
import bluegammon.gui.menu.MenuPainter;
import bluegammon.gui.menu.PageItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DefaultMenuPainter
implements MenuPainter {
    protected Font m_titleFont = Font.getFont((int)64, (int)1, (int)16);
    protected Font m_itemFont = Font.getFont((int)64, (int)1, (int)0);
    protected int m_titleColor = 0xFFFFFF;
    protected int m_titleBackColor = 0x880000;
    protected int m_itemColor = 65535;
    protected int m_itemColorDisabled = 0x888888;
    protected int m_selItemColor = 0xFFFFFF;
    protected int m_imgPadding = 4;

    public void paintMenu(Graphics graphics, MenuPage menuPage, int n, int n2, int n3, int n4) {
        this.paintMenu(graphics, menuPage, n, n2, n3, n4, false, false);
    }

    protected void paintMenu(Graphics graphics, MenuPage menuPage, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (menuPage == null) {
            return;
        }
        int n5 = this.m_titleFont.getHeight();
        int n6 = this.m_itemFont.getHeight();
        this.paintTitle(graphics, menuPage, n + n3 / 2, n2, n3);
        this.paintItems(graphics, menuPage, n, n2 + this.getTitleHeight(menuPage) + 8, n3, n4, bl, bl2);
    }

    public void paintTransition(Graphics graphics, MenuPage menuPage, MenuPage menuPage2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        double d = (double)n5 / (double)n6;
        int n7 = (int)((double)n3 * Math.sin(1.5707963267948966 * d));
        int n8 = bl ? -1 : 1;
        this.paintMenu(graphics, menuPage, -n7 * n8, n2, n3, n4, false, true);
        this.paintMenu(graphics, menuPage2, n8 * (n3 - n7), n2, n3, n4, true, false);
    }

    protected void paintTitle(Graphics graphics, MenuPage menuPage, int n, int n2, int n3) {
        int n4;
        boolean bl;
        char[] cArray = menuPage.getTitle();
        Image image = menuPage.getTitleImage();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.m_itemFont.getHeight();
        int n9 = menuPage.getLayout();
        boolean bl2 = bl = n9 == 0;
        if (cArray != null) {
            n7 = this.m_itemFont.charsWidth(cArray, 0, cArray.length);
        }
        if (image != null) {
            n5 = image.getWidth();
            n6 = image.getHeight();
        }
        int n10 = n5 + n7 + (n5 == 0 || n7 == 0 ? 0 : this.m_imgPadding);
        int n11 = Math.max(n6, n8);
        if (image != null) {
            n4 = bl ? -n10 / 2 - n5 : n7 / 2;
            graphics.drawImage(image, n + n4, n2 + (n11 - n6) / 2, 20);
            n5 += this.m_imgPadding;
        }
        if (cArray != null) {
            n4 = bl ? n5 / 2 : -n5 / 2;
            graphics.setFont(this.m_titleFont);
            graphics.setColor(this.m_titleBackColor);
            graphics.drawChars(cArray, 0, cArray.length, n + n4 + 1, n2 + (n11 - n8) / 2 + 1, 17);
            graphics.setColor(this.m_titleColor);
            graphics.drawChars(cArray, 0, cArray.length, n + n4, n2 + (n11 - n8) / 2, 17);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void paintItems(Graphics graphics, MenuPage menuPage, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6;
        int n7 = menuPage.getSelectedIndex();
        PageItem pageItem = menuPage.itemAt(n7);
        PageItem pageItem2 = menuPage.itemAt(n7 + 1);
        pageItem2 = pageItem2 == null ? pageItem : pageItem2;
        int n8 = n7 < 0 ? 0 : n7;
        int n9 = menuPage.size();
        if (pageItem != null) {
            void var16_17;
            n6 = n7;
            n5 = n7;
            int bl3 = n4 - n2 - this.getItemHeight(pageItem) - this.getItemHeight(pageItem2);
            do {
                if (n5 < n9 - 1) {
                    var16_17 -= this.getItemHeight(menuPage.itemAt(++n5));
                }
                if (var16_17 <= 0 || n6 <= 0) continue;
                var16_17 -= this.getItemHeight(menuPage.itemAt(--n6));
            } while (var16_17 > 0 && (n6 > 0 || n5 < n9 - 1));
            n8 = n6;
        }
        n6 = 0;
        int n10 = n5 = n8 < 0 ? 0 : n8;
        while (n5 < n9) {
            n6 = Math.max(n6, this.getItemWidth(menuPage.itemAt(n5)));
            ++n5;
        }
        int n11 = n5 = n8 < 0 ? 0 : n8;
        while (n5 < n9) {
            boolean bl3 = n5 == n7;
            PageItem pageItem3 = menuPage.itemAt(n5);
            this.paintItem(graphics, pageItem3, bl3, n + n3 / 2, n2, n3, n6, bl, bl2);
            if ((n2 += this.getItemHeight(pageItem3)) >= n4) break;
            ++n5;
        }
    }

    protected void paintItem(Graphics graphics, PageItem pageItem, boolean bl, int n, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        int n5;
        char[] cArray = pageItem.getLabel();
        boolean bl4 = pageItem.isEnabled();
        Image image = pageItem.getImage();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.m_itemFont.getHeight();
        int n10 = pageItem.getLayout();
        boolean bl5 = n10 == 2 | n10 == 3;
        boolean bl6 = n10 == 0 | n10 == 2;
        if (cArray != null) {
            n8 = this.m_itemFont.charsWidth(cArray, 0, cArray.length);
        }
        if (image != null) {
            n6 = image.getWidth();
            n7 = image.getHeight();
        }
        int n11 = n6 + n8 + (n6 == 0 || n8 == 0 ? 0 : this.m_imgPadding);
        int n12 = Math.max(n7, n9);
        if (image != null) {
            n5 = 0;
            n5 = bl5 ? (bl6 ? -n4 / 2 : n4 / 2 - n6) : (bl6 ? -n11 / 2 - n6 : n8 / 2);
            graphics.drawImage(image, n + n5, n2 + (n12 - n7) / 2, 20);
            n6 += this.m_imgPadding;
        }
        if (cArray != null) {
            if (!bl) {
                graphics.setColor(bl4 ? this.m_itemColor : this.m_itemColorDisabled);
            } else {
                graphics.setColor(this.m_selItemColor);
            }
            n5 = 0;
            n5 = bl5 ? (bl6 ? (n4 - n8) / 2 : -(n4 - n8) / 2) : (bl6 ? n6 / 2 : -n6 / 2);
            graphics.setFont(this.m_itemFont);
            graphics.drawChars(cArray, 0, cArray.length, n + n5, n2 + (n12 - n9) / 2, 17);
        }
    }

    protected int getTitleHeight(MenuPage menuPage) {
        return this.m_titleFont.getHeight();
    }

    protected int getItemHeight(PageItem pageItem) {
        int n = this.m_itemFont.getHeight();
        Image image = pageItem.getImage();
        int n2 = image == null ? 0 : image.getHeight();
        return Math.max(n, n2);
    }

    protected int getItemWidth(PageItem pageItem) {
        Image image = pageItem.getImage();
        char[] cArray = pageItem.getLabel();
        int n = image == null ? 0 : image.getWidth();
        n += cArray == null ? 0 : this.m_itemFont.charsWidth(cArray, 0, cArray.length);
        return n += image == null || cArray == null ? 0 : this.m_imgPadding;
    }
}

