/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Board {
    public static final int POS_BOARD = 23;
    public static final int POS_OUT = 24;
    public static final int POS_GUARD = 25;
    public static final int MAX_POS = 26;
    protected int[] BLACK = new int[26];
    protected int[] WHITE = new int[26];

    public void setStartPositions() {
        for (int i = 0; i < 26; ++i) {
            this.BLACK[i] = 0;
            this.WHITE[i] = 0;
        }
        this.WHITE[0] = 2;
        this.WHITE[11] = 5;
        this.WHITE[16] = 3;
        this.WHITE[18] = 5;
        this.BLACK[23] = 2;
        this.BLACK[12] = 5;
        this.BLACK[7] = 3;
        this.BLACK[5] = 5;
    }

    public boolean isWhite(int n) {
        return this.WHITE[n] > 0;
    }

    public int countPieces(int n) {
        if (this.isWhite(n)) {
            return this.WHITE[n];
        }
        return this.BLACK[n];
    }

    public int countPieces(boolean bl, int n) {
        if (bl) {
            return this.WHITE[n];
        }
        return this.BLACK[n];
    }

    public void setPieces(boolean bl, int n, int n2) {
        if (bl) {
            this.WHITE[n] = (byte)(n2 & 0xFF);
        } else {
            this.BLACK[n] = (byte)(n2 & 0xFF);
        }
    }

    public void addPiece(boolean bl, int n) {
        if (bl) {
            int n2 = n;
            this.WHITE[n2] = this.WHITE[n2] + 1;
        } else {
            int n3 = n;
            this.BLACK[n3] = this.BLACK[n3] + 1;
        }
    }

    public void removePiece(boolean bl, int n) {
        if (bl) {
            int n2 = n;
            this.WHITE[n2] = this.WHITE[n2] - 1;
        } else {
            int n3 = n;
            this.BLACK[n3] = this.BLACK[n3] - 1;
        }
    }

    public int getPlayerIndex(boolean bl, int n, int n2) {
        n = bl ? (n += n2) : (n -= n2);
        if (bl) {
            return n;
        }
        return 23 - n;
    }

    public int getOpponentIndex(boolean bl, int n, int n2) {
        n = bl ? (n -= n2) : (n += n2);
        if (!bl) {
            return n;
        }
        return 23 - n;
    }

    public int calculatePiecesLeft(boolean bl) {
        int[] nArray = this.WHITE;
        if (!bl) {
            nArray = this.BLACK;
        }
        int n = 0;
        for (int i = 0; i <= 23; ++i) {
            n += nArray[i];
        }
        return n += nArray[25];
    }

    public int calculatePoints(boolean bl) {
        int n = 1;
        int[] nArray = this.WHITE;
        if (!bl) {
            nArray = this.BLACK;
        }
        if (nArray[24] == 0) {
            boolean bl2 = nArray[25] > 0;
            for (int i = 0; !bl2 && i <= 11; ++i) {
                bl2 = nArray[this.getPlayerIndex(bl, i, 0)] > 0;
            }
            n = bl2 ? 3 : 2;
        }
        return n;
    }

    public int saveBoard(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < 26; ++n) {
            dataOutputStream.writeInt(this.BLACK[n]);
            n2 += 4;
        }
        for (n = 0; n < 26; ++n) {
            dataOutputStream.writeInt(this.WHITE[n]);
            n2 += 4;
        }
        return n2;
    }

    public int loadBoard(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < 26; ++n) {
            this.BLACK[n] = dataInputStream.readInt();
            n2 += 4;
        }
        for (n = 0; n < 26; ++n) {
            this.WHITE[n] = dataInputStream.readInt();
            n2 += 4;
        }
        return n2;
    }
}

