/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Launcher
extends Form
implements CommandListener {
    PCalc calc;
    Displayable parent;
    Program prog;
    TextField[] inputParams;

    Launcher(PCalc pCalc, Displayable displayable, Program program, boolean bl) {
        super(bl ? "Debug program" : "Start program");
        this.calc = pCalc;
        this.parent = displayable;
        this.prog = program;
        this.inputParams = new TextField[program.inputParams.length];
        for (int i = 0; i < this.inputParams.length; ++i) {
            this.inputParams[i] = new TextField(program.inputParamNames[i], VirtualMachine.printNumber(program.inputParams[i]), 32, 0);
            this.append((Item)this.inputParams[i]);
        }
        this.setCommandListener(this);
        if (bl) {
            this.addCommand(PCalc.STEP_CMD);
        } else {
            this.addCommand(PCalc.START_CMD);
        }
        this.addCommand(PCalc.CANCEL_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == PCalc.CANCEL_CMD) {
            Display.getDisplay((MIDlet)this.calc).setCurrent(this.parent);
        } else {
            for (int i = 0; i < this.inputParams.length; ++i) {
                try {
                    this.prog.inputParams[i] = VirtualMachine.inputNumber(this.inputParams[i].getString());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.calc.showError("Invalid value for parameter " + this.prog.inputParamNames[i], (Displayable)this);
                    return;
                }
            }
            this.calc.saveProgram(this.prog);
            if (command == PCalc.STEP_CMD) {
                new Debugger(this.calc, this, this.prog);
            } else {
                new Monitor(this.calc, this, new VirtualMachine(this.prog));
            }
        }
    }
}

