/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class PCalc
extends MIDlet
implements CommandListener {
    static Command NEW_CMD = new Command("New", 2, 1);
    static Command ADD_CMD = new Command("Add", 2, 1);
    static Command INSERT_CMD = new Command("Insert", 2, 1);
    static Command SAVE_CMD = new Command("Save", 1, 2);
    static Command CANCEL_CMD = new Command("Cancel", 2, 2);
    static Command OK_CMD = new Command("Ok", 2, 1);
    static Command DONE_CMD = new Command("Done", 8, 2);
    static Command BACK_CMD = new Command("Back", 2, 1);
    static Command EDIT_CODE_CMD = new Command("Code", 2, 1);
    static Command RUN_CMD = new Command("Run", 8, 2);
    static Command DEBUG_CMD = new Command("Debug", 8, 2);
    static Command EDIT_CMD = new Command("Edit", 8, 2);
    static Command RENAME_CMD = new Command("Rename", 8, 2);
    static Command DELETE_CMD = new Command("Delete", 8, 2);
    static Command UNDELETE_CMD = new Command("Undelete", 8, 2);
    static Command EXIT_CMD = new Command("Exit", 8, 2);
    static Command STEP_CMD = new Command("Step", 2, 1);
    static Command RESTART_CMD = new Command("Restart", 1, 2);
    static Command START_CMD = new Command("Run", 2, 1);
    static Command STOP_CMD = new Command("Stop", 2, 1);
    static Command CONTINUE_CMD = new Command("Continue", 1, 2);
    static Command FUNCTIONS_CMD = new Command("Functions", 1, 2);
    static Command VARIABLES_CMD = new Command("Variables", 1, 2);
    static Command PARAMETERS_CMD = new Command("Parameters", 1, 2);
    static Command STACK_CMD = new Command("Stack", 1, 2);
    static Command TRACE_CMD = new Command("Back trace", 1, 2);
    static Command MOVE_CMD = new Command("Move label", 1, 2);
    static final String STORE_NAME = "PCALC.002";
    List progList = new List("Programs", 3);
    RecordStore store;
    Program deleted;
    Program edited;
    Vector programs;

    public PCalc() {
        this.progList.addCommand(NEW_CMD);
        this.progList.addCommand(RUN_CMD);
        this.progList.addCommand(DEBUG_CMD);
        this.progList.addCommand(EDIT_CMD);
        this.progList.addCommand(DELETE_CMD);
        this.progList.addCommand(UNDELETE_CMD);
        this.progList.addCommand(EXIT_CMD);
    }

    protected void destroyApp(boolean bl) {
        if (this.edited != null) {
            this.saveProgram(this.edited);
        }
        this.progList = null;
        this.closeStore();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display display = Display.getDisplay((MIDlet)this);
        this.progList.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.progList);
        if (this.store == null) {
            this.openStore();
        }
    }

    private void openStore() {
        try {
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadPrograms();
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void loadPrograms() {
        this.programs = new Vector();
        try {
            int n = this.store.getNextRecordID();
            while (--n > 0) {
                byte[] byArray = null;
                try {
                    byArray = this.store.getRecord(n);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (byArray == null) continue;
                Program program = new Program(n, byArray);
                this.programs.addElement(program);
                this.progList.append(program.name, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError("Failed to load programs: " + exception, (Displayable)this.progList);
        }
    }

    void saveProgram(Program program) {
        try {
            byte[] byArray = program.pack();
            if (program.recordId == 0) {
                program.recordId = this.store.addRecord(byArray, 0, byArray.length);
            } else {
                this.store.setRecord(program.recordId, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edited = null;
    }

    void removeProgram(Program program, int n) {
        try {
            this.store.deleteRecord(program.recordId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.progList.delete(n);
        this.programs.removeElementAt(n);
        program.recordId = 0;
        this.edited = null;
    }

    void showError(String string, Displayable displayable) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = this.progList.getSelectedIndex();
        if (command == NEW_CMD) {
            this.edited = new Program("Program " + (this.programs.size() + 1));
            this.programs.insertElementAt(this.edited, 0);
            this.progList.insert(0, this.edited.name, null);
            new EditProcedure(this, (Displayable)this.progList, this.edited.main);
        } else if (command == RUN_CMD) {
            if (n >= 0) {
                new Launcher(this, (Displayable)this.progList, (Program)this.programs.elementAt(n), false);
            }
        } else if (command == DEBUG_CMD) {
            if (n >= 0) {
                new Launcher(this, (Displayable)this.progList, (Program)this.programs.elementAt(n), true);
            }
        } else if (command == DELETE_CMD) {
            if (n >= 0) {
                this.deleted = (Program)this.programs.elementAt(n);
                this.removeProgram(this.deleted, n);
            }
        } else if (command == UNDELETE_CMD) {
            if (this.deleted == null) {
                this.showError("No program was deleted", (Displayable)this.progList);
            } else {
                this.programs.insertElementAt(this.deleted, 0);
                this.progList.insert(0, this.deleted.name, null);
                this.saveProgram(this.deleted);
                this.deleted = null;
            }
        } else if (command == EXIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (n >= 0) {
            this.edited = (Program)this.programs.elementAt(n);
            new EditProgram(this, this.progList, n, this.edited);
        }
    }
}

