/*
 * Decompiled with CFR 0.152.
 */
public class Procedure {
    Program prog;
    Procedure top;
    String name;
    String[] vars;
    int level;
    byte[] code;
    Procedure[] subprocs;
    transient int nLabels;
    static final int MAX_VARIABLES = 256;
    static final int MAX_SUBPROCS = 256;

    Procedure(Program program, Procedure procedure) {
        this.prog = program;
        this.top = procedure;
    }

    Procedure(Program program, Procedure procedure, String string, int n) {
        this(program, procedure);
        this.name = string;
        this.level = n;
        this.code = new byte[1];
        this.code[0] = 42;
        this.vars = new String[0];
        this.subprocs = new Procedure[0];
    }

    boolean findProcedureCall(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.code.length; n3 += VirtualMachine.insnSize[this.code[n3]]) {
            if (this.code[n3] != 41 || this.code[n3 + 1] != n || (this.code[n3 + 2] & 0xFF) != n2) continue;
            return true;
        }
        for (n3 = 0; n3 < this.subprocs.length; ++n3) {
            if (!this.subprocs[n3].findProcedureCall(n, n2)) continue;
            return true;
        }
        return false;
    }

    void adjustProcedureCall(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.code.length; n3 += VirtualMachine.insnSize[this.code[n3]]) {
            if (this.code[n3] != 41 || this.code[n3 + 1] != n || (this.code[n3 + 2] & 0xFF) <= n2) continue;
            int n4 = n3 + 2;
            this.code[n4] = (byte)(this.code[n4] - 1);
        }
        for (n3 = 0; n3 < this.subprocs.length; ++n3) {
            this.subprocs[n3].adjustProcedureCall(n, n2);
        }
    }

    int findSubproc(String string) {
        for (int i = 0; i < this.subprocs.length; ++i) {
            if (!this.subprocs[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    int addSubproc(String string) {
        if (this.findSubproc(string) >= 0) {
            return -1;
        }
        int n = this.subprocs.length;
        Procedure[] procedureArray = new Procedure[n + 1];
        System.arraycopy(this.subprocs, 0, procedureArray, 0, n);
        this.subprocs = procedureArray;
        this.subprocs[n] = new Procedure(this.prog, this, string, this.level + 1);
        return n;
    }

    boolean removeSubproc(int n) {
        if (this.findProcedureCall(this.level, n)) {
            return false;
        }
        int n2 = this.subprocs.length;
        Procedure[] procedureArray = new Procedure[n2 - 1];
        System.arraycopy(this.subprocs, 0, procedureArray, 0, n);
        System.arraycopy(this.subprocs, n + 1, procedureArray, n, n2 - n - 1);
        this.subprocs = procedureArray;
        this.adjustProcedureCall(this.level, n);
        return true;
    }

    int findVariable(String string) {
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    int addVariable(String string) {
        if (this.findVariable(string) >= 0) {
            return -1;
        }
        int n = this.vars.length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(this.vars, 0, stringArray, 0, n);
        this.vars = stringArray;
        this.vars[n] = string;
        return n;
    }

    boolean findVariableAccess(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.code.length; n3 += VirtualMachine.insnSize[this.code[n3]]) {
            if (this.code[n3] != 1 && this.code[n3] != 3 || this.code[n3 + 1] != n || (this.code[n3 + 2] & 0xFF) != n2) continue;
            return true;
        }
        for (n3 = 0; n3 < this.subprocs.length; ++n3) {
            if (!this.subprocs[n3].findVariableAccess(n, n2)) continue;
            return true;
        }
        return false;
    }

    void adjustVariableAccess(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.code.length; n3 += VirtualMachine.insnSize[this.code[n3]]) {
            if (this.code[n3] != 1 && this.code[n3] != 3 || this.code[n3 + 1] != n || (this.code[n3 + 2] & 0xFF) <= n2) continue;
            int n4 = n3 + 2;
            this.code[n4] = (byte)(this.code[n4] - 1);
        }
        for (n3 = 0; n3 < this.subprocs.length; ++n3) {
            this.subprocs[n3].adjustVariableAccess(n, n2);
        }
    }

    boolean findParameterAccess(int n) {
        int n2;
        for (n2 = 0; n2 < this.code.length; n2 += VirtualMachine.insnSize[this.code[n2]]) {
            if (this.code[n2] != 2 || (this.code[n2 + 1] & 0xFF) != n) continue;
            return true;
        }
        for (n2 = 0; n2 < this.subprocs.length; ++n2) {
            if (!this.subprocs[n2].findParameterAccess(n)) continue;
            return true;
        }
        return false;
    }

    void adjustParameterAccess(int n) {
        int n2;
        for (n2 = 0; n2 < this.code.length; n2 += VirtualMachine.insnSize[this.code[n2]]) {
            if (this.code[n2] != 2 || (this.code[n2 + 1] & 0xFF) <= n) continue;
            int n3 = n2 + 1;
            this.code[n3] = (byte)(this.code[n3] - 1);
        }
        for (n2 = 0; n2 < this.subprocs.length; ++n2) {
            this.subprocs[n2].adjustParameterAccess(n);
        }
    }

    boolean removeVariable(int n) {
        if (this.findVariableAccess(this.level, n)) {
            return false;
        }
        int n2 = this.vars.length;
        String[] stringArray = new String[n2 - 1];
        System.arraycopy(this.vars, 0, stringArray, n, n);
        System.arraycopy(this.vars, n + 1, stringArray, n, n2 - n - 1);
        this.vars = stringArray;
        this.adjustVariableAccess(this.level, n);
        return true;
    }

    void removeInstruction(int n) {
        int n2 = VirtualMachine.insnSize[this.code[n]];
        byte[] byArray = new byte[this.code.length - n2];
        System.arraycopy(this.code, 0, byArray, 0, n);
        System.arraycopy(this.code, n + n2, byArray, n, byArray.length - n);
        this.code = byArray;
        this.adjustLabels(n, -n2);
    }

    void addInstruction(int n, int n2) {
        int n3 = VirtualMachine.insnSize[n2];
        this.adjustLabels(n, n3);
        byte[] byArray = new byte[this.code.length + n3];
        System.arraycopy(this.code, 0, byArray, 0, n);
        System.arraycopy(this.code, n, byArray, n + n3, this.code.length - n);
        this.code = byArray;
        byArray[n] = (byte)n2;
    }

    void adjustLabels(int n, int n2) {
        for (int i = 0; i < this.code.length; i += VirtualMachine.insnSize[this.code[i]]) {
            int n3;
            if (this.code[i] != 40 && this.code[i] != 43 || (n3 = Converter.unpackInt(this.code, i + 1)) <= n && (n3 != n || n2 <= 0)) continue;
            Converter.packInt(this.code, i + 1, n3 + n2);
        }
    }

    int pack(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray = Converter.packString(this.name);
        byteBuffer.extend(n + 1 + byArray.length);
        byteBuffer.arr[n++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byteBuffer.arr, n, byArray.length);
        byteBuffer.extend((n += byArray.length) + 1);
        byteBuffer.arr[n++] = (byte)this.vars.length;
        for (n2 = 0; n2 < this.vars.length; ++n2) {
            byArray = Converter.packString(this.vars[n2]);
            byteBuffer.extend(n + 1 + byArray.length);
            byteBuffer.arr[n++] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byteBuffer.arr, n, byArray.length);
            n += byArray.length;
        }
        byteBuffer.extend(n + 1);
        byteBuffer.arr[n++] = (byte)this.level;
        byteBuffer.extend(n + 4 + this.code.length);
        Converter.packInt(byteBuffer.arr, n, this.code.length);
        System.arraycopy(this.code, 0, byteBuffer.arr, n += 4, this.code.length);
        byteBuffer.extend((n += this.code.length) + 1);
        byteBuffer.arr[n++] = (byte)this.subprocs.length;
        for (n2 = 0; n2 < this.subprocs.length; ++n2) {
            n = this.subprocs[n2].pack(byteBuffer, n);
        }
        return n;
    }

    int unpack(byte[] byArray, int n) {
        int n2;
        this.name = Converter.unpackString(byArray, n + 1, byArray[n] & 0xFF);
        n += 1 + (byArray[n] & 0xFF);
        this.vars = new String[byArray[n++] & 0xFF];
        for (n2 = 0; n2 < this.vars.length; ++n2) {
            this.vars[n2] = Converter.unpackString(byArray, n + 1, byArray[n] & 0xFF);
            n += 1 + (byArray[n] & 0xFF);
        }
        this.level = byArray[n++] & 0xFF;
        this.code = new byte[Converter.unpackInt(byArray, n)];
        System.arraycopy(byArray, n += 4, this.code, 0, this.code.length);
        n += this.code.length;
        this.subprocs = new Procedure[byArray[n++] & 0xFF];
        for (n2 = 0; n2 < this.subprocs.length; ++n2) {
            this.subprocs[n2] = new Procedure(this.prog, this);
            n = this.subprocs[n2].unpack(byArray, n);
        }
        return n;
    }
}

